/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanMaterialAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
 * InspPlanMaterialAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class InspPlanMaterialAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<InspPlanMaterialAssgmtByKeyFluentHelper, InspPlanMaterialAssgmt, InspPlanMaterialAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InspPlanMaterialAssgmt}
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param inspPlanMatlAssignment
     *            Counter for Additional Criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param inspPlanMatlAssgmtIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code InspPlanMaterialAssgmt}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public InspPlanMaterialAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String material,
        final String plant,
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspPlanMatlAssignment,
        final String inspPlanMatlAssgmtIntVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("Material", material);
        this.key.put("Plant", plant);
        this.key.put("InspectionPlanGroup", inspectionPlanGroup);
        this.key.put("InspectionPlan", inspectionPlan);
        this.key.put("InspPlanMatlAssignment", inspPlanMatlAssignment);
        this.key.put("InspPlanMatlAssgmtIntVersion", inspPlanMatlAssgmtIntVersion);
    }

    @Override
    @Nonnull
    protected Class<InspPlanMaterialAssgmt> getEntityClass()
    {
        return InspPlanMaterialAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
