/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanOpCharacteristicField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanOpCharacteristicSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Characteristic Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspPlanOpCharacteristicType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspPlanOpCharacteristic extends VdmEntity<InspPlanOpCharacteristic>
{

    /**
     * Selector for all available fields of InspPlanOpCharacteristic.
     *
     */
    public final static InspPlanOpCharacteristicSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Boolean> DELETE_MC =
        new InspPlanOpCharacteristicField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Boolean> UPDATE_MC =
        new InspPlanOpCharacteristicField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "InspectionPlanGroup" )
    @JsonProperty( "InspectionPlanGroup" )
    @Nullable
    @ODataField( odataName = "InspectionPlanGroup" )
    private String inspectionPlanGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanGroup</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_PLAN_GROUP =
        new InspPlanOpCharacteristicField<String>("InspectionPlanGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "BOOOperationInternalID" )
    @JsonProperty( "BOOOperationInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationInternalID" )
    private String bOOOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BOO_OPERATION_INTERNAL_ID =
        new InspPlanOpCharacteristicField<String>("BOOOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristic</b>
     * </p>
     *
     * @return Inspection Characteristic Number
     */
    @Key
    @SerializedName( "BOOCharacteristic" )
    @JsonProperty( "BOOCharacteristic" )
    @Nullable
    @ODataField( odataName = "BOOCharacteristic" )
    private String bOOCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>BOOCharacteristic</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BOO_CHARACTERISTIC =
        new InspPlanOpCharacteristicField<String>("BOOCharacteristic");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristicVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOCharacteristicVersion" )
    @JsonProperty( "BOOCharacteristicVersion" )
    @Nullable
    @ODataField( odataName = "BOOCharacteristicVersion" )
    private String bOOCharacteristicVersion;
    /**
     * Use with available fluent helpers to apply the <b>BOOCharacteristicVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BOO_CHARACTERISTIC_VERSION =
        new InspPlanOpCharacteristicField<String>("BOOCharacteristicVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOOpInternalVersionCounter" )
    @JsonProperty( "BOOOpInternalVersionCounter" )
    @Nullable
    @ODataField( odataName = "BOOOpInternalVersionCounter" )
    private String bOOOpInternalVersionCounter;
    /**
     * Use with available fluent helpers to apply the <b>BOOOpInternalVersionCounter</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BOO_OP_INTERNAL_VERSION_COUNTER =
        new InspPlanOpCharacteristicField<String>("BOOOpInternalVersionCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "InspectionPlanInternalVersion" )
    @JsonProperty( "InspectionPlanInternalVersion" )
    @Nullable
    @ODataField( odataName = "InspectionPlanInternalVersion" )
    private String inspectionPlanInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanInternalVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_PLAN_INTERNAL_VERSION =
        new InspPlanOpCharacteristicField<String>("InspectionPlanInternalVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "InspectionPlan" )
    @JsonProperty( "InspectionPlan" )
    @Nullable
    @ODataField( odataName = "InspectionPlan" )
    private String inspectionPlan;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlan</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_PLAN =
        new InspPlanOpCharacteristicField<String>("InspectionPlan");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<LocalDateTime> VALIDITY_START_DATE =
        new InspPlanOpCharacteristicField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<LocalDateTime> VALIDITY_END_DATE =
        new InspPlanOpCharacteristicField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> CHANGE_NUMBER =
        new InspPlanOpCharacteristicField<String>("ChangeNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Boolean> IS_DELETED =
        new InspPlanOpCharacteristicField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @return Assigned Test Equipment
     */
    @SerializedName( "BOOOperationPRTInternalID" )
    @JsonProperty( "BOOOperationPRTInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationPRTInternalID" )
    private String bOOOperationPRTInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationPRTInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BOO_OPERATION_PRT_INTERNAL_ID =
        new InspPlanOpCharacteristicField<String>("BOOOperationPRTInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @return Inspection Method
     */
    @SerializedName( "InspectionMethod" )
    @JsonProperty( "InspectionMethod" )
    @Nullable
    @ODataField( odataName = "InspectionMethod" )
    private String inspectionMethod;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethod</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_METHOD =
        new InspPlanOpCharacteristicField<String>("InspectionMethod");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @return Version Number of Inspection Method
     */
    @SerializedName( "InspectionMethodVersion" )
    @JsonProperty( "InspectionMethodVersion" )
    @Nullable
    @ODataField( odataName = "InspectionMethodVersion" )
    private String inspectionMethodVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_METHOD_VERSION =
        new InspPlanOpCharacteristicField<String>("InspectionMethodVersion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @return Plant for Inspection Method
     */
    @SerializedName( "InspectionMethodPlant" )
    @JsonProperty( "InspectionMethodPlant" )
    @Nullable
    @ODataField( odataName = "InspectionMethodPlant" )
    private String inspectionMethodPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionMethodPlant</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_METHOD_PLANT =
        new InspPlanOpCharacteristicField<String>("InspectionMethodPlant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecImportanceCode</b>
     * </p>
     *
     * @return Weighting of Characteristic
     */
    @SerializedName( "InspSpecImportanceCode" )
    @JsonProperty( "InspSpecImportanceCode" )
    @Nullable
    @ODataField( odataName = "InspSpecImportanceCode" )
    private String inspSpecImportanceCode;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecImportanceCode</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IMPORTANCE_CODE =
        new InspPlanOpCharacteristicField<String>("InspSpecImportanceCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @return Inspector Qualification
     */
    @SerializedName( "InspectorQualification" )
    @JsonProperty( "InspectorQualification" )
    @Nullable
    @ODataField( odataName = "InspectorQualification" )
    private String inspectorQualification;
    /**
     * Use with available fluent helpers to apply the <b>InspectorQualification</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTOR_QUALIFICATION =
        new InspPlanOpCharacteristicField<String>("InspectorQualification");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @return Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecification" )
    @JsonProperty( "InspectionSpecification" )
    @Nullable
    @ODataField( odataName = "InspectionSpecification" )
    private String inspectionSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecification</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_SPECIFICATION =
        new InspPlanOpCharacteristicField<String>("InspectionSpecification");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @return Version Number of Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationVersion" )
    @JsonProperty( "InspectionSpecificationVersion" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationVersion" )
    private String inspectionSpecificationVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_SPECIFICATION_VERSION =
        new InspPlanOpCharacteristicField<String>("InspectionSpecificationVersion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @return Plant for Master Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationPlant" )
    @JsonProperty( "InspectionSpecificationPlant" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationPlant" )
    private String inspectionSpecificationPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationPlant</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_SPECIFICATION_PLANT =
        new InspPlanOpCharacteristicField<String>("InspectionSpecificationPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharcHasInspSpecReference</b>
     * </p>
     *
     * @return Reference to Master Insp. Characteristic in Task List
     */
    @SerializedName( "BOOCharcHasInspSpecReference" )
    @JsonProperty( "BOOCharcHasInspSpecReference" )
    @Nullable
    @ODataField( odataName = "BOOCharcHasInspSpecReference" )
    private String bOOCharcHasInspSpecReference;
    /**
     * Use with available fluent helpers to apply the <b>BOOCharcHasInspSpecReference</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BOO_CHARC_HAS_INSP_SPEC_REFERENCE =
        new InspPlanOpCharacteristicField<String>("BOOCharcHasInspSpecReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @return Item Number for Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolItemNumber" )
    @JsonProperty( "ProdnRsceToolItemNumber" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolItemNumber" )
    private String prodnRsceToolItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolItemNumber</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> PRODN_RSCE_TOOL_ITEM_NUMBER =
        new InspPlanOpCharacteristicField<String>("ProdnRsceToolItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecControlIndicators</b>
     * </p>
     *
     * @return Cntrl Indicator String for Insp. Char./Master Insp. Char.
     */
    @SerializedName( "InspSpecControlIndicators" )
    @JsonProperty( "InspSpecControlIndicators" )
    @Nullable
    @ODataField( odataName = "InspSpecControlIndicators" )
    private String inspSpecControlIndicators;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecControlIndicators</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_CONTROL_INDICATORS =
        new InspPlanOpCharacteristicField<String>("InspSpecControlIndicators");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @return Quantitative Characteristic
     */
    @SerializedName( "InspSpecIsQuantitative" )
    @JsonProperty( "InspSpecIsQuantitative" )
    @Nullable
    @ODataField( odataName = "InspSpecIsQuantitative" )
    private String inspSpecIsQuantitative;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsQuantitative</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_QUANTITATIVE =
        new InspPlanOpCharacteristicField<String>("InspSpecIsQuantitative");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsMeasuredValueRqd</b>
     * </p>
     *
     * @return Measured Values Must Be Recorded
     */
    @SerializedName( "InspSpecIsMeasuredValueRqd" )
    @JsonProperty( "InspSpecIsMeasuredValueRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsMeasuredValueRqd" )
    private String inspSpecIsMeasuredValueRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsMeasuredValueRqd</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_MEASURED_VALUE_RQD =
        new InspPlanOpCharacteristicField<String>("InspSpecIsMeasuredValueRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @return Reference to Characteristic Attribute Required
     */
    @SerializedName( "InspSpecIsSelectedSetRequired" )
    @JsonProperty( "InspSpecIsSelectedSetRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSelectedSetRequired" )
    private String inspSpecIsSelectedSetRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSelectedSetRequired</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_SELECTED_SET_REQUIRED =
        new InspPlanOpCharacteristicField<String>("InspSpecIsSelectedSetRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsUpperLimitRequired</b>
     * </p>
     *
     * @return Upper Specification Limit
     */
    @SerializedName( "InspSpecIsUpperLimitRequired" )
    @JsonProperty( "InspSpecIsUpperLimitRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsUpperLimitRequired" )
    private String inspSpecIsUpperLimitRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsUpperLimitRequired</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_UPPER_LIMIT_REQUIRED =
        new InspPlanOpCharacteristicField<String>("InspSpecIsUpperLimitRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLowerLimitRequired</b>
     * </p>
     *
     * @return Lower Specification Limit
     */
    @SerializedName( "InspSpecIsLowerLimitRequired" )
    @JsonProperty( "InspSpecIsLowerLimitRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsLowerLimitRequired" )
    private String inspSpecIsLowerLimitRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsLowerLimitRequired</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_LOWER_LIMIT_REQUIRED =
        new InspPlanOpCharacteristicField<String>("InspSpecIsLowerLimitRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTargetValueInLimit</b>
     * </p>
     *
     * @return Check Target Value
     */
    @SerializedName( "InspSpecIsTargetValueInLimit" )
    @JsonProperty( "InspSpecIsTargetValueInLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecIsTargetValueInLimit" )
    private String inspSpecIsTargetValueInLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsTargetValueInLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecIsTargetValueInLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionScope</b>
     * </p>
     *
     * @return Inspection Scope
     */
    @SerializedName( "InspectionScope" )
    @JsonProperty( "InspectionScope" )
    @Nullable
    @ODataField( odataName = "InspectionScope" )
    private String inspectionScope;
    /**
     * Use with available fluent helpers to apply the <b>InspectionScope</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_SCOPE =
        new InspPlanOpCharacteristicField<String>("InspectionScope");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLongTermInspection</b>
     * </p>
     *
     * @return Long-Term Inspection
     */
    @SerializedName( "InspSpecIsLongTermInspection" )
    @JsonProperty( "InspSpecIsLongTermInspection" )
    @Nullable
    @ODataField( odataName = "InspSpecIsLongTermInspection" )
    private String inspSpecIsLongTermInspection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsLongTermInspection</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_LONG_TERM_INSPECTION =
        new InspPlanOpCharacteristicField<String>("InspSpecIsLongTermInspection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecRecordingType</b>
     * </p>
     *
     * @return Recording Type
     */
    @SerializedName( "InspSpecRecordingType" )
    @JsonProperty( "InspSpecRecordingType" )
    @Nullable
    @ODataField( odataName = "InspSpecRecordingType" )
    private String inspSpecRecordingType;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecRecordingType</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_RECORDING_TYPE =
        new InspPlanOpCharacteristicField<String>("InspSpecRecordingType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultIsDocumentationRqd</b>
     * </p>
     *
     * @return Documentation Required for Inspection Result
     */
    @SerializedName( "InspResultIsDocumentationRqd" )
    @JsonProperty( "InspResultIsDocumentationRqd" )
    @Nullable
    @ODataField( odataName = "InspResultIsDocumentationRqd" )
    private String inspResultIsDocumentationRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspResultIsDocumentationRqd</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_RESULT_IS_DOCUMENTATION_RQD =
        new InspPlanOpCharacteristicField<String>("InspResultIsDocumentationRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharcCategory</b>
     * </p>
     *
     * @return Characteristic Category
     */
    @SerializedName( "InspSpecCharcCategory" )
    @JsonProperty( "InspSpecCharcCategory" )
    @Nullable
    @ODataField( odataName = "InspSpecCharcCategory" )
    private String inspSpecCharcCategory;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecCharcCategory</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_CHARC_CATEGORY =
        new InspPlanOpCharacteristicField<String>("InspSpecCharcCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSampleQtyAdditive</b>
     * </p>
     *
     * @return Inspection Sample Quantity Is Added
     */
    @SerializedName( "InspSpecIsSampleQtyAdditive" )
    @JsonProperty( "InspSpecIsSampleQtyAdditive" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSampleQtyAdditive" )
    private String inspSpecIsSampleQtyAdditive;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSampleQtyAdditive</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE =
        new InspPlanOpCharacteristicField<String>("InspSpecIsSampleQtyAdditive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDestructive</b>
     * </p>
     *
     * @return Destructive Inspection
     */
    @SerializedName( "InspSpecIsDestructive" )
    @JsonProperty( "InspSpecIsDestructive" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDestructive" )
    private String inspSpecIsDestructive;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDestructive</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_DESTRUCTIVE =
        new InspPlanOpCharacteristicField<String>("InspSpecIsDestructive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecResultCalculation</b>
     * </p>
     *
     * @return Characteristic Result Calculation
     */
    @SerializedName( "InspSpecResultCalculation" )
    @JsonProperty( "InspSpecResultCalculation" )
    @Nullable
    @ODataField( odataName = "InspSpecResultCalculation" )
    private String inspSpecResultCalculation;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecResultCalculation</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_RESULT_CALCULATION =
        new InspPlanOpCharacteristicField<String>("InspSpecResultCalculation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSamplingProcedRqd</b>
     * </p>
     *
     * @return Sampling Procedure Is Required
     */
    @SerializedName( "InspSpecIsSamplingProcedRqd" )
    @JsonProperty( "InspSpecIsSamplingProcedRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSamplingProcedRqd" )
    private String inspSpecIsSamplingProcedRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSamplingProcedRqd</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_SAMPLING_PROCED_RQD =
        new InspPlanOpCharacteristicField<String>("InspSpecIsSamplingProcedRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsScrapRelevant</b>
     * </p>
     *
     * @return Characteristic Relevant for Quality Score and Scrap Share
     */
    @SerializedName( "InspSpecIsScrapRelevant" )
    @JsonProperty( "InspSpecIsScrapRelevant" )
    @Nullable
    @ODataField( odataName = "InspSpecIsScrapRelevant" )
    private String inspSpecIsScrapRelevant;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsScrapRelevant</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_SCRAP_RELEVANT =
        new InspPlanOpCharacteristicField<String>("InspSpecIsScrapRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFixedCtrlIndicators</b>
     * </p>
     *
     * @return Default Control Indicators Cannot Be Changed
     */
    @SerializedName( "InspSpecHasFixedCtrlIndicators" )
    @JsonProperty( "InspSpecHasFixedCtrlIndicators" )
    @Nullable
    @ODataField( odataName = "InspSpecHasFixedCtrlIndicators" )
    private String inspSpecHasFixedCtrlIndicators;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasFixedCtrlIndicators</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_FIXED_CTRL_INDICATORS =
        new InspPlanOpCharacteristicField<String>("InspSpecHasFixedCtrlIndicators");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTestEquipmentRqd</b>
     * </p>
     *
     * @return Assignment of Test Equipment Required
     */
    @SerializedName( "InspSpecIsTestEquipmentRqd" )
    @JsonProperty( "InspSpecIsTestEquipmentRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsTestEquipmentRqd" )
    private String inspSpecIsTestEquipmentRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsTestEquipmentRqd</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_TEST_EQUIPMENT_RQD =
        new InspPlanOpCharacteristicField<String>("InspSpecIsTestEquipmentRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectRecordingRqd</b>
     * </p>
     *
     * @return Recording the Number of Defects
     */
    @SerializedName( "InspSpecIsDefectRecordingRqd" )
    @JsonProperty( "InspSpecIsDefectRecordingRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDefectRecordingRqd" )
    private String inspSpecIsDefectRecordingRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDefectRecordingRqd</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_DEFECT_RECORDING_RQD =
        new InspPlanOpCharacteristicField<String>("InspSpecIsDefectRecordingRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectsRecgAutomatic</b>
     * </p>
     *
     * @return Defects Recording Automatically Called Up
     */
    @SerializedName( "InspSpecIsDefectsRecgAutomatic" )
    @JsonProperty( "InspSpecIsDefectsRecgAutomatic" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDefectsRecgAutomatic" )
    private String inspSpecIsDefectsRecgAutomatic;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDefectsRecgAutomatic</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC =
        new InspPlanOpCharacteristicField<String>("InspSpecIsDefectsRecgAutomatic");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsChgDocRequired</b>
     * </p>
     *
     * @return Create Change Documents During Results Recording
     */
    @SerializedName( "InspSpecIsChgDocRequired" )
    @JsonProperty( "InspSpecIsChgDocRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsChgDocRequired" )
    private String inspSpecIsChgDocRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsChgDocRequired</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_CHG_DOC_REQUIRED =
        new InspPlanOpCharacteristicField<String>("InspSpecIsChgDocRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsControlChartUsed</b>
     * </p>
     *
     * @return SPC Characteristic
     */
    @SerializedName( "InspSpecIsControlChartUsed" )
    @JsonProperty( "InspSpecIsControlChartUsed" )
    @Nullable
    @ODataField( odataName = "InspSpecIsControlChartUsed" )
    private String inspSpecIsControlChartUsed;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsControlChartUsed</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_IS_CONTROL_CHART_USED =
        new InspPlanOpCharacteristicField<String>("InspSpecIsControlChartUsed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecPrintControl</b>
     * </p>
     *
     * @return Inspection Print Control
     */
    @SerializedName( "InspSpecPrintControl" )
    @JsonProperty( "InspSpecPrintControl" )
    @Nullable
    @ODataField( odataName = "InspSpecPrintControl" )
    private String inspSpecPrintControl;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecPrintControl</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_PRINT_CONTROL =
        new InspPlanOpCharacteristicField<String>("InspSpecPrintControl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstUpperSpecLimit</b>
     * </p>
     *
     * @return First Upper Specification Limit
     */
    @SerializedName( "InspSpecFirstUpperSpecLimit" )
    @JsonProperty( "InspSpecFirstUpperSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecFirstUpperSpecLimit" )
    private Double inspSpecFirstUpperSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFirstUpperSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_FIRST_UPPER_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<Double>("InspSpecFirstUpperSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstUpperSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasFirstUpperSpecLimit" )
    @JsonProperty( "InspSpecHasFirstUpperSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasFirstUpperSpecLimit" )
    private String inspSpecHasFirstUpperSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasFirstUpperSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasFirstUpperSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstLowerSpecLimit</b>
     * </p>
     *
     * @return First Lower Specification Limit
     */
    @SerializedName( "InspSpecFirstLowerSpecLimit" )
    @JsonProperty( "InspSpecFirstLowerSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecFirstLowerSpecLimit" )
    private Double inspSpecFirstLowerSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFirstLowerSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_FIRST_LOWER_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<Double>("InspSpecFirstLowerSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstLowerSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasFirstLowerSpecLimit" )
    @JsonProperty( "InspSpecHasFirstLowerSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasFirstLowerSpecLimit" )
    private String inspSpecHasFirstLowerSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasFirstLowerSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasFirstLowerSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondUpperSpecLimit</b>
     * </p>
     *
     * @return Second Upper Specification Limit
     */
    @SerializedName( "InspSpecSecondUpperSpecLimit" )
    @JsonProperty( "InspSpecSecondUpperSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecSecondUpperSpecLimit" )
    private Double inspSpecSecondUpperSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecSecondUpperSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_SECOND_UPPER_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<Double>("InspSpecSecondUpperSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondUprSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasSecondUprSpecLimit" )
    @JsonProperty( "InspSpecHasSecondUprSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasSecondUprSpecLimit" )
    private String inspSpecHasSecondUprSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasSecondUprSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasSecondUprSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondLowerSpecLimit</b>
     * </p>
     *
     * @return Second Lower Specification Limit
     */
    @SerializedName( "InspSpecSecondLowerSpecLimit" )
    @JsonProperty( "InspSpecSecondLowerSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecSecondLowerSpecLimit" )
    private Double inspSpecSecondLowerSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecSecondLowerSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_SECOND_LOWER_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<Double>("InspSpecSecondLowerSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondLowrSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasSecondLowrSpecLimit" )
    @JsonProperty( "InspSpecHasSecondLowrSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasSecondLowrSpecLimit" )
    private String inspSpecHasSecondLowrSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasSecondLowrSpecLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasSecondLowrSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInputProcedure</b>
     * </p>
     *
     * @return Parameters for Input Processing in QM Results Recording
     */
    @SerializedName( "InspSpecInputProcedure" )
    @JsonProperty( "InspSpecInputProcedure" )
    @Nullable
    @ODataField( odataName = "InspSpecInputProcedure" )
    private String inspSpecInputProcedure;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInputProcedure</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_INPUT_PROCEDURE =
        new InspPlanOpCharacteristicField<String>("InspSpecInputProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFormula</b>
     * </p>
     *
     * @return Check and Calculate Formula in QM
     */
    @SerializedName( "InspSpecHasFormula" )
    @JsonProperty( "InspSpecHasFormula" )
    @Nullable
    @ODataField( odataName = "InspSpecHasFormula" )
    private String inspSpecHasFormula;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasFormula</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_FORMULA =
        new InspPlanOpCharacteristicField<String>("InspSpecHasFormula");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFormula1</b>
     * </p>
     *
     * @return Formula Field
     */
    @SerializedName( "InspSpecFormula1" )
    @JsonProperty( "InspSpecFormula1" )
    @Nullable
    @ODataField( odataName = "InspSpecFormula1" )
    private String inspSpecFormula1;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFormula1</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_FORMULA1 =
        new InspPlanOpCharacteristicField<String>("InspSpecFormula1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFormula2</b>
     * </p>
     *
     * @return Formula Field
     */
    @SerializedName( "InspSpecFormula2" )
    @JsonProperty( "InspSpecFormula2" )
    @Nullable
    @ODataField( odataName = "InspSpecFormula2" )
    private String inspSpecFormula2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFormula2</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_FORMULA2 =
        new InspPlanOpCharacteristicField<String>("InspSpecFormula2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecNumberOfClasses</b>
     * </p>
     *
     * @return Number of Value Classes for Inspection Results
     */
    @SerializedName( "InspSpecNumberOfClasses" )
    @JsonProperty( "InspSpecNumberOfClasses" )
    @Nullable
    @ODataField( odataName = "InspSpecNumberOfClasses" )
    private Short inspSpecNumberOfClasses;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecNumberOfClasses</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Short> INSP_SPEC_NUMBER_OF_CLASSES =
        new InspPlanOpCharacteristicField<Short>("InspSpecNumberOfClasses");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassWidthQty</b>
     * </p>
     *
     * @return Class Width
     */
    @SerializedName( "InspSpecClassWidthQty" )
    @JsonProperty( "InspSpecClassWidthQty" )
    @Nullable
    @ODataField( odataName = "InspSpecClassWidthQty" )
    private Double inspSpecClassWidthQty;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecClassWidthQty</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_CLASS_WIDTH_QTY =
        new InspPlanOpCharacteristicField<Double>("InspSpecClassWidthQty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassWidth</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasClassWidth" )
    @JsonProperty( "InspSpecHasClassWidth" )
    @Nullable
    @ODataField( odataName = "InspSpecHasClassWidth" )
    private String inspSpecHasClassWidth;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasClassWidth</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_CLASS_WIDTH =
        new InspPlanOpCharacteristicField<String>("InspSpecHasClassWidth");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassMidpointQty</b>
     * </p>
     *
     * @return Class Midpoint
     */
    @SerializedName( "InspSpecClassMidpointQty" )
    @JsonProperty( "InspSpecClassMidpointQty" )
    @Nullable
    @ODataField( odataName = "InspSpecClassMidpointQty" )
    private Double inspSpecClassMidpointQty;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecClassMidpointQty</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_CLASS_MIDPOINT_QTY =
        new InspPlanOpCharacteristicField<Double>("InspSpecClassMidpointQty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassMidpoint</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasClassMidpoint" )
    @JsonProperty( "InspSpecHasClassMidpoint" )
    @Nullable
    @ODataField( odataName = "InspSpecHasClassMidpoint" )
    private String inspSpecHasClassMidpoint;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasClassMidpoint</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_CLASS_MIDPOINT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasClassMidpoint");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspToleranceSpecification</b>
     * </p>
     *
     * @return Tolerance Key
     */
    @SerializedName( "InspToleranceSpecification" )
    @JsonProperty( "InspToleranceSpecification" )
    @Nullable
    @ODataField( odataName = "InspToleranceSpecification" )
    private String inspToleranceSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspToleranceSpecification</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_TOLERANCE_SPECIFICATION =
        new InspPlanOpCharacteristicField<String>("InspToleranceSpecification");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @return Number of Places to the Right of a Decimal Point (Accuracy)
     */
    @SerializedName( "InspSpecDecimalPlaces" )
    @JsonProperty( "InspSpecDecimalPlaces" )
    @Nullable
    @ODataField( odataName = "InspSpecDecimalPlaces" )
    private Short inspSpecDecimalPlaces;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDecimalPlaces</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Short> INSP_SPEC_DECIMAL_PLACES =
        new InspPlanOpCharacteristicField<Short>("InspSpecDecimalPlaces");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @return Unit of Measurement in Which Quantitative Data Is Stored
     */
    @SerializedName( "InspectionSpecificationUnit" )
    @JsonProperty( "InspectionSpecificationUnit" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationUnit" )
    private String inspectionSpecificationUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationUnit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_SPECIFICATION_UNIT =
        new InspPlanOpCharacteristicField<String>("InspectionSpecificationUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @return Target Value for a Quantitative Characteristic
     */
    @SerializedName( "InspSpecTargetValue" )
    @JsonProperty( "InspSpecTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecTargetValue" )
    private Double inspSpecTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecTargetValue</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_TARGET_VALUE =
        new InspPlanOpCharacteristicField<Double>("InspSpecTargetValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasTargetValue" )
    @JsonProperty( "InspSpecHasTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecHasTargetValue" )
    private String inspSpecHasTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasTargetValue</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_TARGET_VALUE =
        new InspPlanOpCharacteristicField<String>("InspSpecHasTargetValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @return Upper Specification Limit
     */
    @SerializedName( "InspSpecUpperLimit" )
    @JsonProperty( "InspSpecUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecUpperLimit" )
    private Double inspSpecUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecUpperLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_UPPER_LIMIT =
        new InspPlanOpCharacteristicField<Double>("InspSpecUpperLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @return Lower Specification Limit
     */
    @SerializedName( "InspSpecLowerLimit" )
    @JsonProperty( "InspSpecLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecLowerLimit" )
    private Double inspSpecLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecLowerLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<Double> INSP_SPEC_LOWER_LIMIT =
        new InspPlanOpCharacteristicField<Double>("InspSpecLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasLowerLimit" )
    @JsonProperty( "InspSpecHasLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasLowerLimit" )
    private String inspSpecHasLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasLowerLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_LOWER_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasUpperLimit" )
    @JsonProperty( "InspSpecHasUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasUpperLimit" )
    private String inspSpecHasUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasUpperLimit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_HAS_UPPER_LIMIT =
        new InspPlanOpCharacteristicField<String>("InspSpecHasUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRejection</b>
     * </p>
     *
     * @return Defect Code Group for General Rejection
     */
    @SerializedName( "InspSpecDefectCodeGrpRejection" )
    @JsonProperty( "InspSpecDefectCodeGrpRejection" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeGrpRejection" )
    private String inspSpecDefectCodeGrpRejection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeGrpRejection</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_DEFECT_CODE_GRP_REJECTION =
        new InspPlanOpCharacteristicField<String>("InspSpecDefectCodeGrpRejection");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRejection</b>
     * </p>
     *
     * @return Defect Code for Rejection: General
     */
    @SerializedName( "InspSpecDefectCodeRejection" )
    @JsonProperty( "InspSpecDefectCodeRejection" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeRejection" )
    private String inspSpecDefectCodeRejection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeRejection</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_DEFECT_CODE_REJECTION =
        new InspPlanOpCharacteristicField<String>("InspSpecDefectCodeRejection");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnUpper</b>
     * </p>
     *
     * @return Defect Code Group for Rejection at Upper Tolerance
     */
    @SerializedName( "InspSpecDefectCodeGrpRjcnUpper" )
    @JsonProperty( "InspSpecDefectCodeGrpRjcnUpper" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeGrpRjcnUpper" )
    private String inspSpecDefectCodeGrpRjcnUpper;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeGrpRjcnUpper</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER =
        new InspPlanOpCharacteristicField<String>("InspSpecDefectCodeGrpRjcnUpper");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnUpper</b>
     * </p>
     *
     * @return Defect Code for Rejection at Upper Specification Limit
     */
    @SerializedName( "InspSpecDefectCodeRjcnUpper" )
    @JsonProperty( "InspSpecDefectCodeRjcnUpper" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeRjcnUpper" )
    private String inspSpecDefectCodeRjcnUpper;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeRjcnUpper</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_DEFECT_CODE_RJCN_UPPER =
        new InspPlanOpCharacteristicField<String>("InspSpecDefectCodeRjcnUpper");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnLower</b>
     * </p>
     *
     * @return Defect Code Group for Rejection at Lower Tolerance
     */
    @SerializedName( "InspSpecDefectCodeGrpRjcnLower" )
    @JsonProperty( "InspSpecDefectCodeGrpRjcnLower" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeGrpRjcnLower" )
    private String inspSpecDefectCodeGrpRjcnLower;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeGrpRjcnLower</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER =
        new InspPlanOpCharacteristicField<String>("InspSpecDefectCodeGrpRjcnLower");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnLower</b>
     * </p>
     *
     * @return Defect Code for Rejection at Lower Specification Limit
     */
    @SerializedName( "InspSpecDefectCodeRjcnLower" )
    @JsonProperty( "InspSpecDefectCodeRjcnLower" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeRjcnLower" )
    private String inspSpecDefectCodeRjcnLower;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeRjcnLower</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_DEFECT_CODE_RJCN_LOWER =
        new InspPlanOpCharacteristicField<String>("InspSpecDefectCodeRjcnLower");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "SelectedCodeSet" )
    @JsonProperty( "SelectedCodeSet" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSet" )
    private String selectedCodeSet;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSet</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> SELECTED_CODE_SET =
        new InspPlanOpCharacteristicField<String>("SelectedCodeSet");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "SelectedCodeSetPlant" )
    @JsonProperty( "SelectedCodeSetPlant" )
    @Nullable
    @ODataField( odataName = "SelectedCodeSetPlant" )
    private String selectedCodeSetPlant;
    /**
     * Use with available fluent helpers to apply the <b>SelectedCodeSetPlant</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> SELECTED_CODE_SET_PLANT =
        new InspPlanOpCharacteristicField<String>("SelectedCodeSetPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog2</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog2" )
    @JsonProperty( "InspSpecAdditionalCatalog2" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog2" )
    private String inspSpecAdditionalCatalog2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog2</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CATALOG2 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCatalog2");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet2</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet2" )
    @JsonProperty( "InspSpecAdditionalSelectedSet2" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet2" )
    private String inspSpecAdditionalSelectedSet2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet2</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET2 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalSelectedSet2");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup2</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup2" )
    @JsonProperty( "InspSpecAdditionalCodeGroup2" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup2" )
    private String inspSpecAdditionalCodeGroup2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup2</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP2 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCodeGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant2</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant2" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant2" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant2" )
    private String inspSpecAddlSeldCodeSetPlant2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant2</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT2 =
        new InspPlanOpCharacteristicField<String>("InspSpecAddlSeldCodeSetPlant2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog3</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog3" )
    @JsonProperty( "InspSpecAdditionalCatalog3" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog3" )
    private String inspSpecAdditionalCatalog3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog3</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CATALOG3 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCatalog3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet3</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet3" )
    @JsonProperty( "InspSpecAdditionalSelectedSet3" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet3" )
    private String inspSpecAdditionalSelectedSet3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet3</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET3 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalSelectedSet3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup3</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup3" )
    @JsonProperty( "InspSpecAdditionalCodeGroup3" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup3" )
    private String inspSpecAdditionalCodeGroup3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup3</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP3 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCodeGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant3</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant3" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant3" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant3" )
    private String inspSpecAddlSeldCodeSetPlant3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant3</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT3 =
        new InspPlanOpCharacteristicField<String>("InspSpecAddlSeldCodeSetPlant3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog4</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog4" )
    @JsonProperty( "InspSpecAdditionalCatalog4" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog4" )
    private String inspSpecAdditionalCatalog4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog4</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CATALOG4 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCatalog4");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet4</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet4" )
    @JsonProperty( "InspSpecAdditionalSelectedSet4" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet4" )
    private String inspSpecAdditionalSelectedSet4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet4</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET4 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalSelectedSet4");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup4</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup4" )
    @JsonProperty( "InspSpecAdditionalCodeGroup4" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup4" )
    private String inspSpecAdditionalCodeGroup4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup4</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP4 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCodeGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant4</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant4" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant4" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant4" )
    private String inspSpecAddlSeldCodeSetPlant4;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant4</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT4 =
        new InspPlanOpCharacteristicField<String>("InspSpecAddlSeldCodeSetPlant4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog5</b>
     * </p>
     *
     * @return Catalog Type of Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCatalog5" )
    @JsonProperty( "InspSpecAdditionalCatalog5" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCatalog5" )
    private String inspSpecAdditionalCatalog5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCatalog5</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CATALOG5 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCatalog5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet5</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalSelectedSet5" )
    @JsonProperty( "InspSpecAdditionalSelectedSet5" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalSelectedSet5" )
    private String inspSpecAdditionalSelectedSet5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalSelectedSet5</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_SELECTED_SET5 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalSelectedSet5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup5</b>
     * </p>
     *
     * @return Assigned Code Group or Selected Set
     */
    @SerializedName( "InspSpecAdditionalCodeGroup5" )
    @JsonProperty( "InspSpecAdditionalCodeGroup5" )
    @Nullable
    @ODataField( odataName = "InspSpecAdditionalCodeGroup5" )
    private String inspSpecAdditionalCodeGroup5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAdditionalCodeGroup5</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDITIONAL_CODE_GROUP5 =
        new InspPlanOpCharacteristicField<String>("InspSpecAdditionalCodeGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant5</b>
     * </p>
     *
     * @return Plant of the Assigned Selected Set
     */
    @SerializedName( "InspSpecAddlSeldCodeSetPlant5" )
    @JsonProperty( "InspSpecAddlSeldCodeSetPlant5" )
    @Nullable
    @ODataField( odataName = "InspSpecAddlSeldCodeSetPlant5" )
    private String inspSpecAddlSeldCodeSetPlant5;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecAddlSeldCodeSetPlant5</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_ADDL_SELD_CODE_SET_PLANT5 =
        new InspPlanOpCharacteristicField<String>("InspSpecAddlSeldCodeSetPlant5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SamplingProcedure</b>
     * </p>
     *
     * @return Sampling Procedure in Inspection Characteristic
     */
    @SerializedName( "SamplingProcedure" )
    @JsonProperty( "SamplingProcedure" )
    @Nullable
    @ODataField( odataName = "SamplingProcedure" )
    private String samplingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>SamplingProcedure</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> SAMPLING_PROCEDURE =
        new InspPlanOpCharacteristicField<String>("SamplingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspCharacteristicSampleUnit</b>
     * </p>
     *
     * @return Sample Unit of Measure
     */
    @SerializedName( "InspCharacteristicSampleUnit" )
    @JsonProperty( "InspCharacteristicSampleUnit" )
    @Nullable
    @ODataField( odataName = "InspCharacteristicSampleUnit" )
    private String inspCharacteristicSampleUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspCharacteristicSampleUnit</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_CHARACTERISTIC_SAMPLE_UNIT =
        new InspPlanOpCharacteristicField<String>("InspCharacteristicSampleUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharcSampleQuantity</b>
     * </p>
     *
     * @return Sample Quantity Factor for Sample(Mult. Sample Unit of Msr.)
     */
    @SerializedName( "BOOCharcSampleQuantity" )
    @JsonProperty( "BOOCharcSampleQuantity" )
    @Nullable
    @ODataField( odataName = "BOOCharcSampleQuantity" )
    private BigDecimal bOOCharcSampleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BOOCharcSampleQuantity</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<BigDecimal> BOO_CHARC_SAMPLE_QUANTITY =
        new InspPlanOpCharacteristicField<BigDecimal>("BOOCharcSampleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField1</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField1" )
    @JsonProperty( "InspSpecInformationField1" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField1" )
    private String inspSpecInformationField1;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField1</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_INFORMATION_FIELD1 =
        new InspPlanOpCharacteristicField<String>("InspSpecInformationField1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField2</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField2" )
    @JsonProperty( "InspSpecInformationField2" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField2" )
    private String inspSpecInformationField2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField2</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_INFORMATION_FIELD2 =
        new InspPlanOpCharacteristicField<String>("InspSpecInformationField2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField3</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField3" )
    @JsonProperty( "InspSpecInformationField3" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField3" )
    private String inspSpecInformationField3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField3</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSP_SPEC_INFORMATION_FIELD3 =
        new InspPlanOpCharacteristicField<String>("InspSpecInformationField3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @return Short Text for Inspection Characteristic
     */
    @SerializedName( "InspectionSpecificationText" )
    @JsonProperty( "InspectionSpecificationText" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationText" )
    private String inspectionSpecificationText;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationText</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> INSPECTION_SPECIFICATION_TEXT =
        new InspPlanOpCharacteristicField<String>("InspectionSpecificationText");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> CREATED_BY_USER =
        new InspPlanOpCharacteristicField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<LocalDateTime> CREATION_DATE =
        new InspPlanOpCharacteristicField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> LAST_CHANGED_BY_USER =
        new InspPlanOpCharacteristicField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<LocalDateTime> LAST_CHANGE_DATE =
        new InspPlanOpCharacteristicField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVersion</b>
     * </p>
     *
     * @return Routing Version
     */
    @SerializedName( "BillOfOperationsVersion" )
    @JsonProperty( "BillOfOperationsVersion" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsVersion" )
    private String billOfOperationsVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<String> BILL_OF_OPERATIONS_VERSION =
        new InspPlanOpCharacteristicField<String>("BillOfOperationsVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspPlanOpCharacteristicField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspPlanOpCharacteristicField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspPlanOpCharacteristic> getType()
    {
        return InspPlanOpCharacteristic.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @param inspectionPlanGroup
     *            Key for Task List Group
     */
    public void setInspectionPlanGroup( @Nullable final String inspectionPlanGroup )
    {
        rememberChangedField("InspectionPlanGroup", this.inspectionPlanGroup);
        this.inspectionPlanGroup = inspectionPlanGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     */
    public void setBOOOperationInternalID( @Nullable final String bOOOperationInternalID )
    {
        rememberChangedField("BOOOperationInternalID", this.bOOOperationInternalID);
        this.bOOOperationInternalID = bOOOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristic</b>
     * </p>
     *
     * @param bOOCharacteristic
     *            Inspection Characteristic Number
     */
    public void setBOOCharacteristic( @Nullable final String bOOCharacteristic )
    {
        rememberChangedField("BOOCharacteristic", this.bOOCharacteristic);
        this.bOOCharacteristic = bOOCharacteristic;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharacteristicVersion</b>
     * </p>
     *
     * @param bOOCharacteristicVersion
     *            Internal counter
     */
    public void setBOOCharacteristicVersion( @Nullable final String bOOCharacteristicVersion )
    {
        rememberChangedField("BOOCharacteristicVersion", this.bOOCharacteristicVersion);
        this.bOOCharacteristicVersion = bOOCharacteristicVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     */
    public void setBOOOpInternalVersionCounter( @Nullable final String bOOOpInternalVersionCounter )
    {
        rememberChangedField("BOOOpInternalVersionCounter", this.bOOOpInternalVersionCounter);
        this.bOOOpInternalVersionCounter = bOOOpInternalVersionCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @param inspectionPlanInternalVersion
     *            Internal counter
     */
    public void setInspectionPlanInternalVersion( @Nullable final String inspectionPlanInternalVersion )
    {
        rememberChangedField("InspectionPlanInternalVersion", this.inspectionPlanInternalVersion);
        this.inspectionPlanInternalVersion = inspectionPlanInternalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @param inspectionPlan
     *            Group Counter
     */
    public void setInspectionPlan( @Nullable final String inspectionPlan )
    {
        rememberChangedField("InspectionPlan", this.inspectionPlan);
        this.inspectionPlan = inspectionPlan;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @param bOOOperationPRTInternalID
     *            Assigned Test Equipment
     */
    public void setBOOOperationPRTInternalID( @Nullable final String bOOOperationPRTInternalID )
    {
        rememberChangedField("BOOOperationPRTInternalID", this.bOOOperationPRTInternalID);
        this.bOOOperationPRTInternalID = bOOOperationPRTInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethod</b>
     * </p>
     *
     * @param inspectionMethod
     *            Inspection Method
     */
    public void setInspectionMethod( @Nullable final String inspectionMethod )
    {
        rememberChangedField("InspectionMethod", this.inspectionMethod);
        this.inspectionMethod = inspectionMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodVersion</b>
     * </p>
     *
     * @param inspectionMethodVersion
     *            Version Number of Inspection Method
     */
    public void setInspectionMethodVersion( @Nullable final String inspectionMethodVersion )
    {
        rememberChangedField("InspectionMethodVersion", this.inspectionMethodVersion);
        this.inspectionMethodVersion = inspectionMethodVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionMethodPlant</b>
     * </p>
     *
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     */
    public void setInspectionMethodPlant( @Nullable final String inspectionMethodPlant )
    {
        rememberChangedField("InspectionMethodPlant", this.inspectionMethodPlant);
        this.inspectionMethodPlant = inspectionMethodPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecImportanceCode</b>
     * </p>
     *
     * @param inspSpecImportanceCode
     *            Weighting of Characteristic
     */
    public void setInspSpecImportanceCode( @Nullable final String inspSpecImportanceCode )
    {
        rememberChangedField("InspSpecImportanceCode", this.inspSpecImportanceCode);
        this.inspSpecImportanceCode = inspSpecImportanceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @param inspectorQualification
     *            Inspector Qualification
     */
    public void setInspectorQualification( @Nullable final String inspectorQualification )
    {
        rememberChangedField("InspectorQualification", this.inspectorQualification);
        this.inspectorQualification = inspectorQualification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @param inspectionSpecification
     *            Master Inspection Characteristic
     */
    public void setInspectionSpecification( @Nullable final String inspectionSpecification )
    {
        rememberChangedField("InspectionSpecification", this.inspectionSpecification);
        this.inspectionSpecification = inspectionSpecification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @param inspectionSpecificationVersion
     *            Version Number of Master Inspection Characteristic
     */
    public void setInspectionSpecificationVersion( @Nullable final String inspectionSpecificationVersion )
    {
        rememberChangedField("InspectionSpecificationVersion", this.inspectionSpecificationVersion);
        this.inspectionSpecificationVersion = inspectionSpecificationVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @param inspectionSpecificationPlant
     *            Plant for Master Inspection Characteristic
     */
    public void setInspectionSpecificationPlant( @Nullable final String inspectionSpecificationPlant )
    {
        rememberChangedField("InspectionSpecificationPlant", this.inspectionSpecificationPlant);
        this.inspectionSpecificationPlant = inspectionSpecificationPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharcHasInspSpecReference</b>
     * </p>
     *
     * @param bOOCharcHasInspSpecReference
     *            Reference to Master Insp. Characteristic in Task List
     */
    public void setBOOCharcHasInspSpecReference( @Nullable final String bOOCharcHasInspSpecReference )
    {
        rememberChangedField("BOOCharcHasInspSpecReference", this.bOOCharcHasInspSpecReference);
        this.bOOCharcHasInspSpecReference = bOOCharcHasInspSpecReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     */
    public void setProdnRsceToolItemNumber( @Nullable final String prodnRsceToolItemNumber )
    {
        rememberChangedField("ProdnRsceToolItemNumber", this.prodnRsceToolItemNumber);
        this.prodnRsceToolItemNumber = prodnRsceToolItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecControlIndicators</b>
     * </p>
     *
     * @param inspSpecControlIndicators
     *            Cntrl Indicator String for Insp. Char./Master Insp. Char.
     */
    public void setInspSpecControlIndicators( @Nullable final String inspSpecControlIndicators )
    {
        rememberChangedField("InspSpecControlIndicators", this.inspSpecControlIndicators);
        this.inspSpecControlIndicators = inspSpecControlIndicators;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @param inspSpecIsQuantitative
     *            Quantitative Characteristic
     */
    public void setInspSpecIsQuantitative( @Nullable final String inspSpecIsQuantitative )
    {
        rememberChangedField("InspSpecIsQuantitative", this.inspSpecIsQuantitative);
        this.inspSpecIsQuantitative = inspSpecIsQuantitative;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsMeasuredValueRqd</b>
     * </p>
     *
     * @param inspSpecIsMeasuredValueRqd
     *            Measured Values Must Be Recorded
     */
    public void setInspSpecIsMeasuredValueRqd( @Nullable final String inspSpecIsMeasuredValueRqd )
    {
        rememberChangedField("InspSpecIsMeasuredValueRqd", this.inspSpecIsMeasuredValueRqd);
        this.inspSpecIsMeasuredValueRqd = inspSpecIsMeasuredValueRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @param inspSpecIsSelectedSetRequired
     *            Reference to Characteristic Attribute Required
     */
    public void setInspSpecIsSelectedSetRequired( @Nullable final String inspSpecIsSelectedSetRequired )
    {
        rememberChangedField("InspSpecIsSelectedSetRequired", this.inspSpecIsSelectedSetRequired);
        this.inspSpecIsSelectedSetRequired = inspSpecIsSelectedSetRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsUpperLimitRequired</b>
     * </p>
     *
     * @param inspSpecIsUpperLimitRequired
     *            Upper Specification Limit
     */
    public void setInspSpecIsUpperLimitRequired( @Nullable final String inspSpecIsUpperLimitRequired )
    {
        rememberChangedField("InspSpecIsUpperLimitRequired", this.inspSpecIsUpperLimitRequired);
        this.inspSpecIsUpperLimitRequired = inspSpecIsUpperLimitRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLowerLimitRequired</b>
     * </p>
     *
     * @param inspSpecIsLowerLimitRequired
     *            Lower Specification Limit
     */
    public void setInspSpecIsLowerLimitRequired( @Nullable final String inspSpecIsLowerLimitRequired )
    {
        rememberChangedField("InspSpecIsLowerLimitRequired", this.inspSpecIsLowerLimitRequired);
        this.inspSpecIsLowerLimitRequired = inspSpecIsLowerLimitRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTargetValueInLimit</b>
     * </p>
     *
     * @param inspSpecIsTargetValueInLimit
     *            Check Target Value
     */
    public void setInspSpecIsTargetValueInLimit( @Nullable final String inspSpecIsTargetValueInLimit )
    {
        rememberChangedField("InspSpecIsTargetValueInLimit", this.inspSpecIsTargetValueInLimit);
        this.inspSpecIsTargetValueInLimit = inspSpecIsTargetValueInLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionScope</b>
     * </p>
     *
     * @param inspectionScope
     *            Inspection Scope
     */
    public void setInspectionScope( @Nullable final String inspectionScope )
    {
        rememberChangedField("InspectionScope", this.inspectionScope);
        this.inspectionScope = inspectionScope;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLongTermInspection</b>
     * </p>
     *
     * @param inspSpecIsLongTermInspection
     *            Long-Term Inspection
     */
    public void setInspSpecIsLongTermInspection( @Nullable final String inspSpecIsLongTermInspection )
    {
        rememberChangedField("InspSpecIsLongTermInspection", this.inspSpecIsLongTermInspection);
        this.inspSpecIsLongTermInspection = inspSpecIsLongTermInspection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecRecordingType</b>
     * </p>
     *
     * @param inspSpecRecordingType
     *            Recording Type
     */
    public void setInspSpecRecordingType( @Nullable final String inspSpecRecordingType )
    {
        rememberChangedField("InspSpecRecordingType", this.inspSpecRecordingType);
        this.inspSpecRecordingType = inspSpecRecordingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultIsDocumentationRqd</b>
     * </p>
     *
     * @param inspResultIsDocumentationRqd
     *            Documentation Required for Inspection Result
     */
    public void setInspResultIsDocumentationRqd( @Nullable final String inspResultIsDocumentationRqd )
    {
        rememberChangedField("InspResultIsDocumentationRqd", this.inspResultIsDocumentationRqd);
        this.inspResultIsDocumentationRqd = inspResultIsDocumentationRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharcCategory</b>
     * </p>
     *
     * @param inspSpecCharcCategory
     *            Characteristic Category
     */
    public void setInspSpecCharcCategory( @Nullable final String inspSpecCharcCategory )
    {
        rememberChangedField("InspSpecCharcCategory", this.inspSpecCharcCategory);
        this.inspSpecCharcCategory = inspSpecCharcCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSampleQtyAdditive</b>
     * </p>
     *
     * @param inspSpecIsSampleQtyAdditive
     *            Inspection Sample Quantity Is Added
     */
    public void setInspSpecIsSampleQtyAdditive( @Nullable final String inspSpecIsSampleQtyAdditive )
    {
        rememberChangedField("InspSpecIsSampleQtyAdditive", this.inspSpecIsSampleQtyAdditive);
        this.inspSpecIsSampleQtyAdditive = inspSpecIsSampleQtyAdditive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDestructive</b>
     * </p>
     *
     * @param inspSpecIsDestructive
     *            Destructive Inspection
     */
    public void setInspSpecIsDestructive( @Nullable final String inspSpecIsDestructive )
    {
        rememberChangedField("InspSpecIsDestructive", this.inspSpecIsDestructive);
        this.inspSpecIsDestructive = inspSpecIsDestructive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecResultCalculation</b>
     * </p>
     *
     * @param inspSpecResultCalculation
     *            Characteristic Result Calculation
     */
    public void setInspSpecResultCalculation( @Nullable final String inspSpecResultCalculation )
    {
        rememberChangedField("InspSpecResultCalculation", this.inspSpecResultCalculation);
        this.inspSpecResultCalculation = inspSpecResultCalculation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSamplingProcedRqd</b>
     * </p>
     *
     * @param inspSpecIsSamplingProcedRqd
     *            Sampling Procedure Is Required
     */
    public void setInspSpecIsSamplingProcedRqd( @Nullable final String inspSpecIsSamplingProcedRqd )
    {
        rememberChangedField("InspSpecIsSamplingProcedRqd", this.inspSpecIsSamplingProcedRqd);
        this.inspSpecIsSamplingProcedRqd = inspSpecIsSamplingProcedRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsScrapRelevant</b>
     * </p>
     *
     * @param inspSpecIsScrapRelevant
     *            Characteristic Relevant for Quality Score and Scrap Share
     */
    public void setInspSpecIsScrapRelevant( @Nullable final String inspSpecIsScrapRelevant )
    {
        rememberChangedField("InspSpecIsScrapRelevant", this.inspSpecIsScrapRelevant);
        this.inspSpecIsScrapRelevant = inspSpecIsScrapRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFixedCtrlIndicators</b>
     * </p>
     *
     * @param inspSpecHasFixedCtrlIndicators
     *            Default Control Indicators Cannot Be Changed
     */
    public void setInspSpecHasFixedCtrlIndicators( @Nullable final String inspSpecHasFixedCtrlIndicators )
    {
        rememberChangedField("InspSpecHasFixedCtrlIndicators", this.inspSpecHasFixedCtrlIndicators);
        this.inspSpecHasFixedCtrlIndicators = inspSpecHasFixedCtrlIndicators;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTestEquipmentRqd</b>
     * </p>
     *
     * @param inspSpecIsTestEquipmentRqd
     *            Assignment of Test Equipment Required
     */
    public void setInspSpecIsTestEquipmentRqd( @Nullable final String inspSpecIsTestEquipmentRqd )
    {
        rememberChangedField("InspSpecIsTestEquipmentRqd", this.inspSpecIsTestEquipmentRqd);
        this.inspSpecIsTestEquipmentRqd = inspSpecIsTestEquipmentRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectRecordingRqd</b>
     * </p>
     *
     * @param inspSpecIsDefectRecordingRqd
     *            Recording the Number of Defects
     */
    public void setInspSpecIsDefectRecordingRqd( @Nullable final String inspSpecIsDefectRecordingRqd )
    {
        rememberChangedField("InspSpecIsDefectRecordingRqd", this.inspSpecIsDefectRecordingRqd);
        this.inspSpecIsDefectRecordingRqd = inspSpecIsDefectRecordingRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectsRecgAutomatic</b>
     * </p>
     *
     * @param inspSpecIsDefectsRecgAutomatic
     *            Defects Recording Automatically Called Up
     */
    public void setInspSpecIsDefectsRecgAutomatic( @Nullable final String inspSpecIsDefectsRecgAutomatic )
    {
        rememberChangedField("InspSpecIsDefectsRecgAutomatic", this.inspSpecIsDefectsRecgAutomatic);
        this.inspSpecIsDefectsRecgAutomatic = inspSpecIsDefectsRecgAutomatic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsChgDocRequired</b>
     * </p>
     *
     * @param inspSpecIsChgDocRequired
     *            Create Change Documents During Results Recording
     */
    public void setInspSpecIsChgDocRequired( @Nullable final String inspSpecIsChgDocRequired )
    {
        rememberChangedField("InspSpecIsChgDocRequired", this.inspSpecIsChgDocRequired);
        this.inspSpecIsChgDocRequired = inspSpecIsChgDocRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsControlChartUsed</b>
     * </p>
     *
     * @param inspSpecIsControlChartUsed
     *            SPC Characteristic
     */
    public void setInspSpecIsControlChartUsed( @Nullable final String inspSpecIsControlChartUsed )
    {
        rememberChangedField("InspSpecIsControlChartUsed", this.inspSpecIsControlChartUsed);
        this.inspSpecIsControlChartUsed = inspSpecIsControlChartUsed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecPrintControl</b>
     * </p>
     *
     * @param inspSpecPrintControl
     *            Inspection Print Control
     */
    public void setInspSpecPrintControl( @Nullable final String inspSpecPrintControl )
    {
        rememberChangedField("InspSpecPrintControl", this.inspSpecPrintControl);
        this.inspSpecPrintControl = inspSpecPrintControl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstUpperSpecLimit</b>
     * </p>
     *
     * @param inspSpecFirstUpperSpecLimit
     *            First Upper Specification Limit
     */
    public void setInspSpecFirstUpperSpecLimit( @Nullable final Double inspSpecFirstUpperSpecLimit )
    {
        rememberChangedField("InspSpecFirstUpperSpecLimit", this.inspSpecFirstUpperSpecLimit);
        this.inspSpecFirstUpperSpecLimit = inspSpecFirstUpperSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstUpperSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasFirstUpperSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasFirstUpperSpecLimit( @Nullable final String inspSpecHasFirstUpperSpecLimit )
    {
        rememberChangedField("InspSpecHasFirstUpperSpecLimit", this.inspSpecHasFirstUpperSpecLimit);
        this.inspSpecHasFirstUpperSpecLimit = inspSpecHasFirstUpperSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstLowerSpecLimit</b>
     * </p>
     *
     * @param inspSpecFirstLowerSpecLimit
     *            First Lower Specification Limit
     */
    public void setInspSpecFirstLowerSpecLimit( @Nullable final Double inspSpecFirstLowerSpecLimit )
    {
        rememberChangedField("InspSpecFirstLowerSpecLimit", this.inspSpecFirstLowerSpecLimit);
        this.inspSpecFirstLowerSpecLimit = inspSpecFirstLowerSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstLowerSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasFirstLowerSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasFirstLowerSpecLimit( @Nullable final String inspSpecHasFirstLowerSpecLimit )
    {
        rememberChangedField("InspSpecHasFirstLowerSpecLimit", this.inspSpecHasFirstLowerSpecLimit);
        this.inspSpecHasFirstLowerSpecLimit = inspSpecHasFirstLowerSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondUpperSpecLimit</b>
     * </p>
     *
     * @param inspSpecSecondUpperSpecLimit
     *            Second Upper Specification Limit
     */
    public void setInspSpecSecondUpperSpecLimit( @Nullable final Double inspSpecSecondUpperSpecLimit )
    {
        rememberChangedField("InspSpecSecondUpperSpecLimit", this.inspSpecSecondUpperSpecLimit);
        this.inspSpecSecondUpperSpecLimit = inspSpecSecondUpperSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondUprSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasSecondUprSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasSecondUprSpecLimit( @Nullable final String inspSpecHasSecondUprSpecLimit )
    {
        rememberChangedField("InspSpecHasSecondUprSpecLimit", this.inspSpecHasSecondUprSpecLimit);
        this.inspSpecHasSecondUprSpecLimit = inspSpecHasSecondUprSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondLowerSpecLimit</b>
     * </p>
     *
     * @param inspSpecSecondLowerSpecLimit
     *            Second Lower Specification Limit
     */
    public void setInspSpecSecondLowerSpecLimit( @Nullable final Double inspSpecSecondLowerSpecLimit )
    {
        rememberChangedField("InspSpecSecondLowerSpecLimit", this.inspSpecSecondLowerSpecLimit);
        this.inspSpecSecondLowerSpecLimit = inspSpecSecondLowerSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondLowrSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasSecondLowrSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasSecondLowrSpecLimit( @Nullable final String inspSpecHasSecondLowrSpecLimit )
    {
        rememberChangedField("InspSpecHasSecondLowrSpecLimit", this.inspSpecHasSecondLowrSpecLimit);
        this.inspSpecHasSecondLowrSpecLimit = inspSpecHasSecondLowrSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInputProcedure</b>
     * </p>
     *
     * @param inspSpecInputProcedure
     *            Parameters for Input Processing in QM Results Recording
     */
    public void setInspSpecInputProcedure( @Nullable final String inspSpecInputProcedure )
    {
        rememberChangedField("InspSpecInputProcedure", this.inspSpecInputProcedure);
        this.inspSpecInputProcedure = inspSpecInputProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFormula</b>
     * </p>
     *
     * @param inspSpecHasFormula
     *            Check and Calculate Formula in QM
     */
    public void setInspSpecHasFormula( @Nullable final String inspSpecHasFormula )
    {
        rememberChangedField("InspSpecHasFormula", this.inspSpecHasFormula);
        this.inspSpecHasFormula = inspSpecHasFormula;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFormula1</b>
     * </p>
     *
     * @param inspSpecFormula1
     *            Formula Field
     */
    public void setInspSpecFormula1( @Nullable final String inspSpecFormula1 )
    {
        rememberChangedField("InspSpecFormula1", this.inspSpecFormula1);
        this.inspSpecFormula1 = inspSpecFormula1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFormula2</b>
     * </p>
     *
     * @param inspSpecFormula2
     *            Formula Field
     */
    public void setInspSpecFormula2( @Nullable final String inspSpecFormula2 )
    {
        rememberChangedField("InspSpecFormula2", this.inspSpecFormula2);
        this.inspSpecFormula2 = inspSpecFormula2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecNumberOfClasses</b>
     * </p>
     *
     * @param inspSpecNumberOfClasses
     *            Number of Value Classes for Inspection Results
     */
    public void setInspSpecNumberOfClasses( @Nullable final Short inspSpecNumberOfClasses )
    {
        rememberChangedField("InspSpecNumberOfClasses", this.inspSpecNumberOfClasses);
        this.inspSpecNumberOfClasses = inspSpecNumberOfClasses;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassWidthQty</b>
     * </p>
     *
     * @param inspSpecClassWidthQty
     *            Class Width
     */
    public void setInspSpecClassWidthQty( @Nullable final Double inspSpecClassWidthQty )
    {
        rememberChangedField("InspSpecClassWidthQty", this.inspSpecClassWidthQty);
        this.inspSpecClassWidthQty = inspSpecClassWidthQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassWidth</b>
     * </p>
     *
     * @param inspSpecHasClassWidth
     *            Value Not Initial If Set
     */
    public void setInspSpecHasClassWidth( @Nullable final String inspSpecHasClassWidth )
    {
        rememberChangedField("InspSpecHasClassWidth", this.inspSpecHasClassWidth);
        this.inspSpecHasClassWidth = inspSpecHasClassWidth;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecClassMidpointQty</b>
     * </p>
     *
     * @param inspSpecClassMidpointQty
     *            Class Midpoint
     */
    public void setInspSpecClassMidpointQty( @Nullable final Double inspSpecClassMidpointQty )
    {
        rememberChangedField("InspSpecClassMidpointQty", this.inspSpecClassMidpointQty);
        this.inspSpecClassMidpointQty = inspSpecClassMidpointQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasClassMidpoint</b>
     * </p>
     *
     * @param inspSpecHasClassMidpoint
     *            Value Not Initial If Set
     */
    public void setInspSpecHasClassMidpoint( @Nullable final String inspSpecHasClassMidpoint )
    {
        rememberChangedField("InspSpecHasClassMidpoint", this.inspSpecHasClassMidpoint);
        this.inspSpecHasClassMidpoint = inspSpecHasClassMidpoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspToleranceSpecification</b>
     * </p>
     *
     * @param inspToleranceSpecification
     *            Tolerance Key
     */
    public void setInspToleranceSpecification( @Nullable final String inspToleranceSpecification )
    {
        rememberChangedField("InspToleranceSpecification", this.inspToleranceSpecification);
        this.inspToleranceSpecification = inspToleranceSpecification;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @param inspSpecDecimalPlaces
     *            Number of Places to the Right of a Decimal Point (Accuracy)
     */
    public void setInspSpecDecimalPlaces( @Nullable final Short inspSpecDecimalPlaces )
    {
        rememberChangedField("InspSpecDecimalPlaces", this.inspSpecDecimalPlaces);
        this.inspSpecDecimalPlaces = inspSpecDecimalPlaces;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @param inspectionSpecificationUnit
     *            Unit of Measurement in Which Quantitative Data Is Stored
     */
    public void setInspectionSpecificationUnit( @Nullable final String inspectionSpecificationUnit )
    {
        rememberChangedField("InspectionSpecificationUnit", this.inspectionSpecificationUnit);
        this.inspectionSpecificationUnit = inspectionSpecificationUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @param inspSpecTargetValue
     *            Target Value for a Quantitative Characteristic
     */
    public void setInspSpecTargetValue( @Nullable final Double inspSpecTargetValue )
    {
        rememberChangedField("InspSpecTargetValue", this.inspSpecTargetValue);
        this.inspSpecTargetValue = inspSpecTargetValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @param inspSpecHasTargetValue
     *            Value Not Initial If Set
     */
    public void setInspSpecHasTargetValue( @Nullable final String inspSpecHasTargetValue )
    {
        rememberChangedField("InspSpecHasTargetValue", this.inspSpecHasTargetValue);
        this.inspSpecHasTargetValue = inspSpecHasTargetValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @param inspSpecUpperLimit
     *            Upper Specification Limit
     */
    public void setInspSpecUpperLimit( @Nullable final Double inspSpecUpperLimit )
    {
        rememberChangedField("InspSpecUpperLimit", this.inspSpecUpperLimit);
        this.inspSpecUpperLimit = inspSpecUpperLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @param inspSpecLowerLimit
     *            Lower Specification Limit
     */
    public void setInspSpecLowerLimit( @Nullable final Double inspSpecLowerLimit )
    {
        rememberChangedField("InspSpecLowerLimit", this.inspSpecLowerLimit);
        this.inspSpecLowerLimit = inspSpecLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @param inspSpecHasLowerLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasLowerLimit( @Nullable final String inspSpecHasLowerLimit )
    {
        rememberChangedField("InspSpecHasLowerLimit", this.inspSpecHasLowerLimit);
        this.inspSpecHasLowerLimit = inspSpecHasLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @param inspSpecHasUpperLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasUpperLimit( @Nullable final String inspSpecHasUpperLimit )
    {
        rememberChangedField("InspSpecHasUpperLimit", this.inspSpecHasUpperLimit);
        this.inspSpecHasUpperLimit = inspSpecHasUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRejection</b>
     * </p>
     *
     * @param inspSpecDefectCodeGrpRejection
     *            Defect Code Group for General Rejection
     */
    public void setInspSpecDefectCodeGrpRejection( @Nullable final String inspSpecDefectCodeGrpRejection )
    {
        rememberChangedField("InspSpecDefectCodeGrpRejection", this.inspSpecDefectCodeGrpRejection);
        this.inspSpecDefectCodeGrpRejection = inspSpecDefectCodeGrpRejection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRejection</b>
     * </p>
     *
     * @param inspSpecDefectCodeRejection
     *            Defect Code for Rejection: General
     */
    public void setInspSpecDefectCodeRejection( @Nullable final String inspSpecDefectCodeRejection )
    {
        rememberChangedField("InspSpecDefectCodeRejection", this.inspSpecDefectCodeRejection);
        this.inspSpecDefectCodeRejection = inspSpecDefectCodeRejection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnUpper</b>
     * </p>
     *
     * @param inspSpecDefectCodeGrpRjcnUpper
     *            Defect Code Group for Rejection at Upper Tolerance
     */
    public void setInspSpecDefectCodeGrpRjcnUpper( @Nullable final String inspSpecDefectCodeGrpRjcnUpper )
    {
        rememberChangedField("InspSpecDefectCodeGrpRjcnUpper", this.inspSpecDefectCodeGrpRjcnUpper);
        this.inspSpecDefectCodeGrpRjcnUpper = inspSpecDefectCodeGrpRjcnUpper;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnUpper</b>
     * </p>
     *
     * @param inspSpecDefectCodeRjcnUpper
     *            Defect Code for Rejection at Upper Specification Limit
     */
    public void setInspSpecDefectCodeRjcnUpper( @Nullable final String inspSpecDefectCodeRjcnUpper )
    {
        rememberChangedField("InspSpecDefectCodeRjcnUpper", this.inspSpecDefectCodeRjcnUpper);
        this.inspSpecDefectCodeRjcnUpper = inspSpecDefectCodeRjcnUpper;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnLower</b>
     * </p>
     *
     * @param inspSpecDefectCodeGrpRjcnLower
     *            Defect Code Group for Rejection at Lower Tolerance
     */
    public void setInspSpecDefectCodeGrpRjcnLower( @Nullable final String inspSpecDefectCodeGrpRjcnLower )
    {
        rememberChangedField("InspSpecDefectCodeGrpRjcnLower", this.inspSpecDefectCodeGrpRjcnLower);
        this.inspSpecDefectCodeGrpRjcnLower = inspSpecDefectCodeGrpRjcnLower;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnLower</b>
     * </p>
     *
     * @param inspSpecDefectCodeRjcnLower
     *            Defect Code for Rejection at Lower Specification Limit
     */
    public void setInspSpecDefectCodeRjcnLower( @Nullable final String inspSpecDefectCodeRjcnLower )
    {
        rememberChangedField("InspSpecDefectCodeRjcnLower", this.inspSpecDefectCodeRjcnLower);
        this.inspSpecDefectCodeRjcnLower = inspSpecDefectCodeRjcnLower;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSet</b>
     * </p>
     *
     * @param selectedCodeSet
     *            Assigned Code Group or Selected Set
     */
    public void setSelectedCodeSet( @Nullable final String selectedCodeSet )
    {
        rememberChangedField("SelectedCodeSet", this.selectedCodeSet);
        this.selectedCodeSet = selectedCodeSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedCodeSetPlant</b>
     * </p>
     *
     * @param selectedCodeSetPlant
     *            Plant of the Assigned Selected Set
     */
    public void setSelectedCodeSetPlant( @Nullable final String selectedCodeSetPlant )
    {
        rememberChangedField("SelectedCodeSetPlant", this.selectedCodeSetPlant);
        this.selectedCodeSetPlant = selectedCodeSetPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog2</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog2
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog2( @Nullable final String inspSpecAdditionalCatalog2 )
    {
        rememberChangedField("InspSpecAdditionalCatalog2", this.inspSpecAdditionalCatalog2);
        this.inspSpecAdditionalCatalog2 = inspSpecAdditionalCatalog2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet2</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet2
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet2( @Nullable final String inspSpecAdditionalSelectedSet2 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet2", this.inspSpecAdditionalSelectedSet2);
        this.inspSpecAdditionalSelectedSet2 = inspSpecAdditionalSelectedSet2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup2</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup2
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup2( @Nullable final String inspSpecAdditionalCodeGroup2 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup2", this.inspSpecAdditionalCodeGroup2);
        this.inspSpecAdditionalCodeGroup2 = inspSpecAdditionalCodeGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant2</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant2
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant2( @Nullable final String inspSpecAddlSeldCodeSetPlant2 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant2", this.inspSpecAddlSeldCodeSetPlant2);
        this.inspSpecAddlSeldCodeSetPlant2 = inspSpecAddlSeldCodeSetPlant2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog3</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog3
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog3( @Nullable final String inspSpecAdditionalCatalog3 )
    {
        rememberChangedField("InspSpecAdditionalCatalog3", this.inspSpecAdditionalCatalog3);
        this.inspSpecAdditionalCatalog3 = inspSpecAdditionalCatalog3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet3</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet3
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet3( @Nullable final String inspSpecAdditionalSelectedSet3 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet3", this.inspSpecAdditionalSelectedSet3);
        this.inspSpecAdditionalSelectedSet3 = inspSpecAdditionalSelectedSet3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup3</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup3
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup3( @Nullable final String inspSpecAdditionalCodeGroup3 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup3", this.inspSpecAdditionalCodeGroup3);
        this.inspSpecAdditionalCodeGroup3 = inspSpecAdditionalCodeGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant3</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant3
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant3( @Nullable final String inspSpecAddlSeldCodeSetPlant3 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant3", this.inspSpecAddlSeldCodeSetPlant3);
        this.inspSpecAddlSeldCodeSetPlant3 = inspSpecAddlSeldCodeSetPlant3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog4</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog4
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog4( @Nullable final String inspSpecAdditionalCatalog4 )
    {
        rememberChangedField("InspSpecAdditionalCatalog4", this.inspSpecAdditionalCatalog4);
        this.inspSpecAdditionalCatalog4 = inspSpecAdditionalCatalog4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet4</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet4
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet4( @Nullable final String inspSpecAdditionalSelectedSet4 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet4", this.inspSpecAdditionalSelectedSet4);
        this.inspSpecAdditionalSelectedSet4 = inspSpecAdditionalSelectedSet4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup4</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup4
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup4( @Nullable final String inspSpecAdditionalCodeGroup4 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup4", this.inspSpecAdditionalCodeGroup4);
        this.inspSpecAdditionalCodeGroup4 = inspSpecAdditionalCodeGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant4</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant4
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant4( @Nullable final String inspSpecAddlSeldCodeSetPlant4 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant4", this.inspSpecAddlSeldCodeSetPlant4);
        this.inspSpecAddlSeldCodeSetPlant4 = inspSpecAddlSeldCodeSetPlant4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCatalog5</b>
     * </p>
     *
     * @param inspSpecAdditionalCatalog5
     *            Catalog Type of Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCatalog5( @Nullable final String inspSpecAdditionalCatalog5 )
    {
        rememberChangedField("InspSpecAdditionalCatalog5", this.inspSpecAdditionalCatalog5);
        this.inspSpecAdditionalCatalog5 = inspSpecAdditionalCatalog5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalSelectedSet5</b>
     * </p>
     *
     * @param inspSpecAdditionalSelectedSet5
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalSelectedSet5( @Nullable final String inspSpecAdditionalSelectedSet5 )
    {
        rememberChangedField("InspSpecAdditionalSelectedSet5", this.inspSpecAdditionalSelectedSet5);
        this.inspSpecAdditionalSelectedSet5 = inspSpecAdditionalSelectedSet5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAdditionalCodeGroup5</b>
     * </p>
     *
     * @param inspSpecAdditionalCodeGroup5
     *            Assigned Code Group or Selected Set
     */
    public void setInspSpecAdditionalCodeGroup5( @Nullable final String inspSpecAdditionalCodeGroup5 )
    {
        rememberChangedField("InspSpecAdditionalCodeGroup5", this.inspSpecAdditionalCodeGroup5);
        this.inspSpecAdditionalCodeGroup5 = inspSpecAdditionalCodeGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecAddlSeldCodeSetPlant5</b>
     * </p>
     *
     * @param inspSpecAddlSeldCodeSetPlant5
     *            Plant of the Assigned Selected Set
     */
    public void setInspSpecAddlSeldCodeSetPlant5( @Nullable final String inspSpecAddlSeldCodeSetPlant5 )
    {
        rememberChangedField("InspSpecAddlSeldCodeSetPlant5", this.inspSpecAddlSeldCodeSetPlant5);
        this.inspSpecAddlSeldCodeSetPlant5 = inspSpecAddlSeldCodeSetPlant5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SamplingProcedure</b>
     * </p>
     *
     * @param samplingProcedure
     *            Sampling Procedure in Inspection Characteristic
     */
    public void setSamplingProcedure( @Nullable final String samplingProcedure )
    {
        rememberChangedField("SamplingProcedure", this.samplingProcedure);
        this.samplingProcedure = samplingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspCharacteristicSampleUnit</b>
     * </p>
     *
     * @param inspCharacteristicSampleUnit
     *            Sample Unit of Measure
     */
    public void setInspCharacteristicSampleUnit( @Nullable final String inspCharacteristicSampleUnit )
    {
        rememberChangedField("InspCharacteristicSampleUnit", this.inspCharacteristicSampleUnit);
        this.inspCharacteristicSampleUnit = inspCharacteristicSampleUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOOCharcSampleQuantity</b>
     * </p>
     *
     * @param bOOCharcSampleQuantity
     *            Sample Quantity Factor for Sample(Mult. Sample Unit of Msr.)
     */
    public void setBOOCharcSampleQuantity( @Nullable final BigDecimal bOOCharcSampleQuantity )
    {
        rememberChangedField("BOOCharcSampleQuantity", this.bOOCharcSampleQuantity);
        this.bOOCharcSampleQuantity = bOOCharcSampleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField1</b>
     * </p>
     *
     * @param inspSpecInformationField1
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField1( @Nullable final String inspSpecInformationField1 )
    {
        rememberChangedField("InspSpecInformationField1", this.inspSpecInformationField1);
        this.inspSpecInformationField1 = inspSpecInformationField1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField2</b>
     * </p>
     *
     * @param inspSpecInformationField2
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField2( @Nullable final String inspSpecInformationField2 )
    {
        rememberChangedField("InspSpecInformationField2", this.inspSpecInformationField2);
        this.inspSpecInformationField2 = inspSpecInformationField2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField3</b>
     * </p>
     *
     * @param inspSpecInformationField3
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField3( @Nullable final String inspSpecInformationField3 )
    {
        rememberChangedField("InspSpecInformationField3", this.inspSpecInformationField3);
        this.inspSpecInformationField3 = inspSpecInformationField3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationText</b>
     * </p>
     *
     * @param inspectionSpecificationText
     *            Short Text for Inspection Characteristic
     */
    public void setInspectionSpecificationText( @Nullable final String inspectionSpecificationText )
    {
        rememberChangedField("InspectionSpecificationText", this.inspectionSpecificationText);
        this.inspectionSpecificationText = inspectionSpecificationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Who Created Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            System Date on Which Data Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of User Who Last Changed Data Record
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVersion</b>
     * </p>
     *
     * @param billOfOperationsVersion
     *            Routing Version
     */
    public void setBillOfOperationsVersion( @Nullable final String billOfOperationsVersion )
    {
        rememberChangedField("BillOfOperationsVersion", this.billOfOperationsVersion);
        this.billOfOperationsVersion = billOfOperationsVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspPlanOpCharacteristic";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionPlanGroup", getInspectionPlanGroup());
        result.put("BOOOperationInternalID", getBOOOperationInternalID());
        result.put("BOOCharacteristic", getBOOCharacteristic());
        result.put("BOOCharacteristicVersion", getBOOCharacteristicVersion());
        result.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        result.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        result.put("InspectionPlan", getInspectionPlan());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("InspectionPlanGroup", getInspectionPlanGroup());
        values.put("BOOOperationInternalID", getBOOOperationInternalID());
        values.put("BOOCharacteristic", getBOOCharacteristic());
        values.put("BOOCharacteristicVersion", getBOOCharacteristicVersion());
        values.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        values.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        values.put("InspectionPlan", getInspectionPlan());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("IsDeleted", getIsDeleted());
        values.put("BOOOperationPRTInternalID", getBOOOperationPRTInternalID());
        values.put("InspectionMethod", getInspectionMethod());
        values.put("InspectionMethodVersion", getInspectionMethodVersion());
        values.put("InspectionMethodPlant", getInspectionMethodPlant());
        values.put("InspSpecImportanceCode", getInspSpecImportanceCode());
        values.put("InspectorQualification", getInspectorQualification());
        values.put("InspectionSpecification", getInspectionSpecification());
        values.put("InspectionSpecificationVersion", getInspectionSpecificationVersion());
        values.put("InspectionSpecificationPlant", getInspectionSpecificationPlant());
        values.put("BOOCharcHasInspSpecReference", getBOOCharcHasInspSpecReference());
        values.put("ProdnRsceToolItemNumber", getProdnRsceToolItemNumber());
        values.put("InspSpecControlIndicators", getInspSpecControlIndicators());
        values.put("InspSpecIsQuantitative", getInspSpecIsQuantitative());
        values.put("InspSpecIsMeasuredValueRqd", getInspSpecIsMeasuredValueRqd());
        values.put("InspSpecIsSelectedSetRequired", getInspSpecIsSelectedSetRequired());
        values.put("InspSpecIsUpperLimitRequired", getInspSpecIsUpperLimitRequired());
        values.put("InspSpecIsLowerLimitRequired", getInspSpecIsLowerLimitRequired());
        values.put("InspSpecIsTargetValueInLimit", getInspSpecIsTargetValueInLimit());
        values.put("InspectionScope", getInspectionScope());
        values.put("InspSpecIsLongTermInspection", getInspSpecIsLongTermInspection());
        values.put("InspSpecRecordingType", getInspSpecRecordingType());
        values.put("InspResultIsDocumentationRqd", getInspResultIsDocumentationRqd());
        values.put("InspSpecCharcCategory", getInspSpecCharcCategory());
        values.put("InspSpecIsSampleQtyAdditive", getInspSpecIsSampleQtyAdditive());
        values.put("InspSpecIsDestructive", getInspSpecIsDestructive());
        values.put("InspSpecResultCalculation", getInspSpecResultCalculation());
        values.put("InspSpecIsSamplingProcedRqd", getInspSpecIsSamplingProcedRqd());
        values.put("InspSpecIsScrapRelevant", getInspSpecIsScrapRelevant());
        values.put("InspSpecHasFixedCtrlIndicators", getInspSpecHasFixedCtrlIndicators());
        values.put("InspSpecIsTestEquipmentRqd", getInspSpecIsTestEquipmentRqd());
        values.put("InspSpecIsDefectRecordingRqd", getInspSpecIsDefectRecordingRqd());
        values.put("InspSpecIsDefectsRecgAutomatic", getInspSpecIsDefectsRecgAutomatic());
        values.put("InspSpecIsChgDocRequired", getInspSpecIsChgDocRequired());
        values.put("InspSpecIsControlChartUsed", getInspSpecIsControlChartUsed());
        values.put("InspSpecPrintControl", getInspSpecPrintControl());
        values.put("InspSpecFirstUpperSpecLimit", getInspSpecFirstUpperSpecLimit());
        values.put("InspSpecHasFirstUpperSpecLimit", getInspSpecHasFirstUpperSpecLimit());
        values.put("InspSpecFirstLowerSpecLimit", getInspSpecFirstLowerSpecLimit());
        values.put("InspSpecHasFirstLowerSpecLimit", getInspSpecHasFirstLowerSpecLimit());
        values.put("InspSpecSecondUpperSpecLimit", getInspSpecSecondUpperSpecLimit());
        values.put("InspSpecHasSecondUprSpecLimit", getInspSpecHasSecondUprSpecLimit());
        values.put("InspSpecSecondLowerSpecLimit", getInspSpecSecondLowerSpecLimit());
        values.put("InspSpecHasSecondLowrSpecLimit", getInspSpecHasSecondLowrSpecLimit());
        values.put("InspSpecInputProcedure", getInspSpecInputProcedure());
        values.put("InspSpecHasFormula", getInspSpecHasFormula());
        values.put("InspSpecFormula1", getInspSpecFormula1());
        values.put("InspSpecFormula2", getInspSpecFormula2());
        values.put("InspSpecNumberOfClasses", getInspSpecNumberOfClasses());
        values.put("InspSpecClassWidthQty", getInspSpecClassWidthQty());
        values.put("InspSpecHasClassWidth", getInspSpecHasClassWidth());
        values.put("InspSpecClassMidpointQty", getInspSpecClassMidpointQty());
        values.put("InspSpecHasClassMidpoint", getInspSpecHasClassMidpoint());
        values.put("InspToleranceSpecification", getInspToleranceSpecification());
        values.put("InspSpecDecimalPlaces", getInspSpecDecimalPlaces());
        values.put("InspectionSpecificationUnit", getInspectionSpecificationUnit());
        values.put("InspSpecTargetValue", getInspSpecTargetValue());
        values.put("InspSpecHasTargetValue", getInspSpecHasTargetValue());
        values.put("InspSpecUpperLimit", getInspSpecUpperLimit());
        values.put("InspSpecLowerLimit", getInspSpecLowerLimit());
        values.put("InspSpecHasLowerLimit", getInspSpecHasLowerLimit());
        values.put("InspSpecHasUpperLimit", getInspSpecHasUpperLimit());
        values.put("InspSpecDefectCodeGrpRejection", getInspSpecDefectCodeGrpRejection());
        values.put("InspSpecDefectCodeRejection", getInspSpecDefectCodeRejection());
        values.put("InspSpecDefectCodeGrpRjcnUpper", getInspSpecDefectCodeGrpRjcnUpper());
        values.put("InspSpecDefectCodeRjcnUpper", getInspSpecDefectCodeRjcnUpper());
        values.put("InspSpecDefectCodeGrpRjcnLower", getInspSpecDefectCodeGrpRjcnLower());
        values.put("InspSpecDefectCodeRjcnLower", getInspSpecDefectCodeRjcnLower());
        values.put("SelectedCodeSet", getSelectedCodeSet());
        values.put("SelectedCodeSetPlant", getSelectedCodeSetPlant());
        values.put("InspSpecAdditionalCatalog2", getInspSpecAdditionalCatalog2());
        values.put("InspSpecAdditionalSelectedSet2", getInspSpecAdditionalSelectedSet2());
        values.put("InspSpecAdditionalCodeGroup2", getInspSpecAdditionalCodeGroup2());
        values.put("InspSpecAddlSeldCodeSetPlant2", getInspSpecAddlSeldCodeSetPlant2());
        values.put("InspSpecAdditionalCatalog3", getInspSpecAdditionalCatalog3());
        values.put("InspSpecAdditionalSelectedSet3", getInspSpecAdditionalSelectedSet3());
        values.put("InspSpecAdditionalCodeGroup3", getInspSpecAdditionalCodeGroup3());
        values.put("InspSpecAddlSeldCodeSetPlant3", getInspSpecAddlSeldCodeSetPlant3());
        values.put("InspSpecAdditionalCatalog4", getInspSpecAdditionalCatalog4());
        values.put("InspSpecAdditionalSelectedSet4", getInspSpecAdditionalSelectedSet4());
        values.put("InspSpecAdditionalCodeGroup4", getInspSpecAdditionalCodeGroup4());
        values.put("InspSpecAddlSeldCodeSetPlant4", getInspSpecAddlSeldCodeSetPlant4());
        values.put("InspSpecAdditionalCatalog5", getInspSpecAdditionalCatalog5());
        values.put("InspSpecAdditionalSelectedSet5", getInspSpecAdditionalSelectedSet5());
        values.put("InspSpecAdditionalCodeGroup5", getInspSpecAdditionalCodeGroup5());
        values.put("InspSpecAddlSeldCodeSetPlant5", getInspSpecAddlSeldCodeSetPlant5());
        values.put("SamplingProcedure", getSamplingProcedure());
        values.put("InspCharacteristicSampleUnit", getInspCharacteristicSampleUnit());
        values.put("BOOCharcSampleQuantity", getBOOCharcSampleQuantity());
        values.put("InspSpecInformationField1", getInspSpecInformationField1());
        values.put("InspSpecInformationField2", getInspSpecInformationField2());
        values.put("InspSpecInformationField3", getInspSpecInformationField3());
        values.put("InspectionSpecificationText", getInspectionSpecificationText());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("BillOfOperationsVersion", getBillOfOperationsVersion());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionPlanGroup") ) {
                final Object value = values.remove("InspectionPlanGroup");
                if( (value == null) || (!value.equals(getInspectionPlanGroup())) ) {
                    setInspectionPlanGroup(((String) value));
                }
            }
            if( values.containsKey("BOOOperationInternalID") ) {
                final Object value = values.remove("BOOOperationInternalID");
                if( (value == null) || (!value.equals(getBOOOperationInternalID())) ) {
                    setBOOOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("BOOCharacteristic") ) {
                final Object value = values.remove("BOOCharacteristic");
                if( (value == null) || (!value.equals(getBOOCharacteristic())) ) {
                    setBOOCharacteristic(((String) value));
                }
            }
            if( values.containsKey("BOOCharacteristicVersion") ) {
                final Object value = values.remove("BOOCharacteristicVersion");
                if( (value == null) || (!value.equals(getBOOCharacteristicVersion())) ) {
                    setBOOCharacteristicVersion(((String) value));
                }
            }
            if( values.containsKey("BOOOpInternalVersionCounter") ) {
                final Object value = values.remove("BOOOpInternalVersionCounter");
                if( (value == null) || (!value.equals(getBOOOpInternalVersionCounter())) ) {
                    setBOOOpInternalVersionCounter(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanInternalVersion") ) {
                final Object value = values.remove("InspectionPlanInternalVersion");
                if( (value == null) || (!value.equals(getInspectionPlanInternalVersion())) ) {
                    setInspectionPlanInternalVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionPlan") ) {
                final Object value = values.remove("InspectionPlan");
                if( (value == null) || (!value.equals(getInspectionPlan())) ) {
                    setInspectionPlan(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("BOOOperationPRTInternalID") ) {
                final Object value = values.remove("BOOOperationPRTInternalID");
                if( (value == null) || (!value.equals(getBOOOperationPRTInternalID())) ) {
                    setBOOOperationPRTInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionMethod") ) {
                final Object value = values.remove("InspectionMethod");
                if( (value == null) || (!value.equals(getInspectionMethod())) ) {
                    setInspectionMethod(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodVersion") ) {
                final Object value = values.remove("InspectionMethodVersion");
                if( (value == null) || (!value.equals(getInspectionMethodVersion())) ) {
                    setInspectionMethodVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionMethodPlant") ) {
                final Object value = values.remove("InspectionMethodPlant");
                if( (value == null) || (!value.equals(getInspectionMethodPlant())) ) {
                    setInspectionMethodPlant(((String) value));
                }
            }
            if( values.containsKey("InspSpecImportanceCode") ) {
                final Object value = values.remove("InspSpecImportanceCode");
                if( (value == null) || (!value.equals(getInspSpecImportanceCode())) ) {
                    setInspSpecImportanceCode(((String) value));
                }
            }
            if( values.containsKey("InspectorQualification") ) {
                final Object value = values.remove("InspectorQualification");
                if( (value == null) || (!value.equals(getInspectorQualification())) ) {
                    setInspectorQualification(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecification") ) {
                final Object value = values.remove("InspectionSpecification");
                if( (value == null) || (!value.equals(getInspectionSpecification())) ) {
                    setInspectionSpecification(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationVersion") ) {
                final Object value = values.remove("InspectionSpecificationVersion");
                if( (value == null) || (!value.equals(getInspectionSpecificationVersion())) ) {
                    setInspectionSpecificationVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationPlant") ) {
                final Object value = values.remove("InspectionSpecificationPlant");
                if( (value == null) || (!value.equals(getInspectionSpecificationPlant())) ) {
                    setInspectionSpecificationPlant(((String) value));
                }
            }
            if( values.containsKey("BOOCharcHasInspSpecReference") ) {
                final Object value = values.remove("BOOCharcHasInspSpecReference");
                if( (value == null) || (!value.equals(getBOOCharcHasInspSpecReference())) ) {
                    setBOOCharcHasInspSpecReference(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolItemNumber") ) {
                final Object value = values.remove("ProdnRsceToolItemNumber");
                if( (value == null) || (!value.equals(getProdnRsceToolItemNumber())) ) {
                    setProdnRsceToolItemNumber(((String) value));
                }
            }
            if( values.containsKey("InspSpecControlIndicators") ) {
                final Object value = values.remove("InspSpecControlIndicators");
                if( (value == null) || (!value.equals(getInspSpecControlIndicators())) ) {
                    setInspSpecControlIndicators(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsQuantitative") ) {
                final Object value = values.remove("InspSpecIsQuantitative");
                if( (value == null) || (!value.equals(getInspSpecIsQuantitative())) ) {
                    setInspSpecIsQuantitative(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsMeasuredValueRqd") ) {
                final Object value = values.remove("InspSpecIsMeasuredValueRqd");
                if( (value == null) || (!value.equals(getInspSpecIsMeasuredValueRqd())) ) {
                    setInspSpecIsMeasuredValueRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSelectedSetRequired") ) {
                final Object value = values.remove("InspSpecIsSelectedSetRequired");
                if( (value == null) || (!value.equals(getInspSpecIsSelectedSetRequired())) ) {
                    setInspSpecIsSelectedSetRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsUpperLimitRequired") ) {
                final Object value = values.remove("InspSpecIsUpperLimitRequired");
                if( (value == null) || (!value.equals(getInspSpecIsUpperLimitRequired())) ) {
                    setInspSpecIsUpperLimitRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsLowerLimitRequired") ) {
                final Object value = values.remove("InspSpecIsLowerLimitRequired");
                if( (value == null) || (!value.equals(getInspSpecIsLowerLimitRequired())) ) {
                    setInspSpecIsLowerLimitRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsTargetValueInLimit") ) {
                final Object value = values.remove("InspSpecIsTargetValueInLimit");
                if( (value == null) || (!value.equals(getInspSpecIsTargetValueInLimit())) ) {
                    setInspSpecIsTargetValueInLimit(((String) value));
                }
            }
            if( values.containsKey("InspectionScope") ) {
                final Object value = values.remove("InspectionScope");
                if( (value == null) || (!value.equals(getInspectionScope())) ) {
                    setInspectionScope(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsLongTermInspection") ) {
                final Object value = values.remove("InspSpecIsLongTermInspection");
                if( (value == null) || (!value.equals(getInspSpecIsLongTermInspection())) ) {
                    setInspSpecIsLongTermInspection(((String) value));
                }
            }
            if( values.containsKey("InspSpecRecordingType") ) {
                final Object value = values.remove("InspSpecRecordingType");
                if( (value == null) || (!value.equals(getInspSpecRecordingType())) ) {
                    setInspSpecRecordingType(((String) value));
                }
            }
            if( values.containsKey("InspResultIsDocumentationRqd") ) {
                final Object value = values.remove("InspResultIsDocumentationRqd");
                if( (value == null) || (!value.equals(getInspResultIsDocumentationRqd())) ) {
                    setInspResultIsDocumentationRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecCharcCategory") ) {
                final Object value = values.remove("InspSpecCharcCategory");
                if( (value == null) || (!value.equals(getInspSpecCharcCategory())) ) {
                    setInspSpecCharcCategory(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSampleQtyAdditive") ) {
                final Object value = values.remove("InspSpecIsSampleQtyAdditive");
                if( (value == null) || (!value.equals(getInspSpecIsSampleQtyAdditive())) ) {
                    setInspSpecIsSampleQtyAdditive(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDestructive") ) {
                final Object value = values.remove("InspSpecIsDestructive");
                if( (value == null) || (!value.equals(getInspSpecIsDestructive())) ) {
                    setInspSpecIsDestructive(((String) value));
                }
            }
            if( values.containsKey("InspSpecResultCalculation") ) {
                final Object value = values.remove("InspSpecResultCalculation");
                if( (value == null) || (!value.equals(getInspSpecResultCalculation())) ) {
                    setInspSpecResultCalculation(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSamplingProcedRqd") ) {
                final Object value = values.remove("InspSpecIsSamplingProcedRqd");
                if( (value == null) || (!value.equals(getInspSpecIsSamplingProcedRqd())) ) {
                    setInspSpecIsSamplingProcedRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsScrapRelevant") ) {
                final Object value = values.remove("InspSpecIsScrapRelevant");
                if( (value == null) || (!value.equals(getInspSpecIsScrapRelevant())) ) {
                    setInspSpecIsScrapRelevant(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasFixedCtrlIndicators") ) {
                final Object value = values.remove("InspSpecHasFixedCtrlIndicators");
                if( (value == null) || (!value.equals(getInspSpecHasFixedCtrlIndicators())) ) {
                    setInspSpecHasFixedCtrlIndicators(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsTestEquipmentRqd") ) {
                final Object value = values.remove("InspSpecIsTestEquipmentRqd");
                if( (value == null) || (!value.equals(getInspSpecIsTestEquipmentRqd())) ) {
                    setInspSpecIsTestEquipmentRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDefectRecordingRqd") ) {
                final Object value = values.remove("InspSpecIsDefectRecordingRqd");
                if( (value == null) || (!value.equals(getInspSpecIsDefectRecordingRqd())) ) {
                    setInspSpecIsDefectRecordingRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDefectsRecgAutomatic") ) {
                final Object value = values.remove("InspSpecIsDefectsRecgAutomatic");
                if( (value == null) || (!value.equals(getInspSpecIsDefectsRecgAutomatic())) ) {
                    setInspSpecIsDefectsRecgAutomatic(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsChgDocRequired") ) {
                final Object value = values.remove("InspSpecIsChgDocRequired");
                if( (value == null) || (!value.equals(getInspSpecIsChgDocRequired())) ) {
                    setInspSpecIsChgDocRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsControlChartUsed") ) {
                final Object value = values.remove("InspSpecIsControlChartUsed");
                if( (value == null) || (!value.equals(getInspSpecIsControlChartUsed())) ) {
                    setInspSpecIsControlChartUsed(((String) value));
                }
            }
            if( values.containsKey("InspSpecPrintControl") ) {
                final Object value = values.remove("InspSpecPrintControl");
                if( (value == null) || (!value.equals(getInspSpecPrintControl())) ) {
                    setInspSpecPrintControl(((String) value));
                }
            }
            if( values.containsKey("InspSpecFirstUpperSpecLimit") ) {
                final Object value = values.remove("InspSpecFirstUpperSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecFirstUpperSpecLimit())) ) {
                    setInspSpecFirstUpperSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasFirstUpperSpecLimit") ) {
                final Object value = values.remove("InspSpecHasFirstUpperSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasFirstUpperSpecLimit())) ) {
                    setInspSpecHasFirstUpperSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecFirstLowerSpecLimit") ) {
                final Object value = values.remove("InspSpecFirstLowerSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecFirstLowerSpecLimit())) ) {
                    setInspSpecFirstLowerSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasFirstLowerSpecLimit") ) {
                final Object value = values.remove("InspSpecHasFirstLowerSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasFirstLowerSpecLimit())) ) {
                    setInspSpecHasFirstLowerSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecSecondUpperSpecLimit") ) {
                final Object value = values.remove("InspSpecSecondUpperSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecSecondUpperSpecLimit())) ) {
                    setInspSpecSecondUpperSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasSecondUprSpecLimit") ) {
                final Object value = values.remove("InspSpecHasSecondUprSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasSecondUprSpecLimit())) ) {
                    setInspSpecHasSecondUprSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecSecondLowerSpecLimit") ) {
                final Object value = values.remove("InspSpecSecondLowerSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecSecondLowerSpecLimit())) ) {
                    setInspSpecSecondLowerSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasSecondLowrSpecLimit") ) {
                final Object value = values.remove("InspSpecHasSecondLowrSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasSecondLowrSpecLimit())) ) {
                    setInspSpecHasSecondLowrSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecInputProcedure") ) {
                final Object value = values.remove("InspSpecInputProcedure");
                if( (value == null) || (!value.equals(getInspSpecInputProcedure())) ) {
                    setInspSpecInputProcedure(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasFormula") ) {
                final Object value = values.remove("InspSpecHasFormula");
                if( (value == null) || (!value.equals(getInspSpecHasFormula())) ) {
                    setInspSpecHasFormula(((String) value));
                }
            }
            if( values.containsKey("InspSpecFormula1") ) {
                final Object value = values.remove("InspSpecFormula1");
                if( (value == null) || (!value.equals(getInspSpecFormula1())) ) {
                    setInspSpecFormula1(((String) value));
                }
            }
            if( values.containsKey("InspSpecFormula2") ) {
                final Object value = values.remove("InspSpecFormula2");
                if( (value == null) || (!value.equals(getInspSpecFormula2())) ) {
                    setInspSpecFormula2(((String) value));
                }
            }
            if( values.containsKey("InspSpecNumberOfClasses") ) {
                final Object value = values.remove("InspSpecNumberOfClasses");
                if( (value == null) || (!value.equals(getInspSpecNumberOfClasses())) ) {
                    setInspSpecNumberOfClasses(((Short) value));
                }
            }
            if( values.containsKey("InspSpecClassWidthQty") ) {
                final Object value = values.remove("InspSpecClassWidthQty");
                if( (value == null) || (!value.equals(getInspSpecClassWidthQty())) ) {
                    setInspSpecClassWidthQty(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasClassWidth") ) {
                final Object value = values.remove("InspSpecHasClassWidth");
                if( (value == null) || (!value.equals(getInspSpecHasClassWidth())) ) {
                    setInspSpecHasClassWidth(((String) value));
                }
            }
            if( values.containsKey("InspSpecClassMidpointQty") ) {
                final Object value = values.remove("InspSpecClassMidpointQty");
                if( (value == null) || (!value.equals(getInspSpecClassMidpointQty())) ) {
                    setInspSpecClassMidpointQty(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasClassMidpoint") ) {
                final Object value = values.remove("InspSpecHasClassMidpoint");
                if( (value == null) || (!value.equals(getInspSpecHasClassMidpoint())) ) {
                    setInspSpecHasClassMidpoint(((String) value));
                }
            }
            if( values.containsKey("InspToleranceSpecification") ) {
                final Object value = values.remove("InspToleranceSpecification");
                if( (value == null) || (!value.equals(getInspToleranceSpecification())) ) {
                    setInspToleranceSpecification(((String) value));
                }
            }
            if( values.containsKey("InspSpecDecimalPlaces") ) {
                final Object value = values.remove("InspSpecDecimalPlaces");
                if( (value == null) || (!value.equals(getInspSpecDecimalPlaces())) ) {
                    setInspSpecDecimalPlaces(((Short) value));
                }
            }
            if( values.containsKey("InspectionSpecificationUnit") ) {
                final Object value = values.remove("InspectionSpecificationUnit");
                if( (value == null) || (!value.equals(getInspectionSpecificationUnit())) ) {
                    setInspectionSpecificationUnit(((String) value));
                }
            }
            if( values.containsKey("InspSpecTargetValue") ) {
                final Object value = values.remove("InspSpecTargetValue");
                if( (value == null) || (!value.equals(getInspSpecTargetValue())) ) {
                    setInspSpecTargetValue(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasTargetValue") ) {
                final Object value = values.remove("InspSpecHasTargetValue");
                if( (value == null) || (!value.equals(getInspSpecHasTargetValue())) ) {
                    setInspSpecHasTargetValue(((String) value));
                }
            }
            if( values.containsKey("InspSpecUpperLimit") ) {
                final Object value = values.remove("InspSpecUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecUpperLimit())) ) {
                    setInspSpecUpperLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecLowerLimit") ) {
                final Object value = values.remove("InspSpecLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecLowerLimit())) ) {
                    setInspSpecLowerLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasLowerLimit") ) {
                final Object value = values.remove("InspSpecHasLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecHasLowerLimit())) ) {
                    setInspSpecHasLowerLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecHasUpperLimit") ) {
                final Object value = values.remove("InspSpecHasUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecHasUpperLimit())) ) {
                    setInspSpecHasUpperLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeGrpRejection") ) {
                final Object value = values.remove("InspSpecDefectCodeGrpRejection");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeGrpRejection())) ) {
                    setInspSpecDefectCodeGrpRejection(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeRejection") ) {
                final Object value = values.remove("InspSpecDefectCodeRejection");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeRejection())) ) {
                    setInspSpecDefectCodeRejection(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeGrpRjcnUpper") ) {
                final Object value = values.remove("InspSpecDefectCodeGrpRjcnUpper");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeGrpRjcnUpper())) ) {
                    setInspSpecDefectCodeGrpRjcnUpper(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeRjcnUpper") ) {
                final Object value = values.remove("InspSpecDefectCodeRjcnUpper");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeRjcnUpper())) ) {
                    setInspSpecDefectCodeRjcnUpper(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeGrpRjcnLower") ) {
                final Object value = values.remove("InspSpecDefectCodeGrpRjcnLower");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeGrpRjcnLower())) ) {
                    setInspSpecDefectCodeGrpRjcnLower(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeRjcnLower") ) {
                final Object value = values.remove("InspSpecDefectCodeRjcnLower");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeRjcnLower())) ) {
                    setInspSpecDefectCodeRjcnLower(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSet") ) {
                final Object value = values.remove("SelectedCodeSet");
                if( (value == null) || (!value.equals(getSelectedCodeSet())) ) {
                    setSelectedCodeSet(((String) value));
                }
            }
            if( values.containsKey("SelectedCodeSetPlant") ) {
                final Object value = values.remove("SelectedCodeSetPlant");
                if( (value == null) || (!value.equals(getSelectedCodeSetPlant())) ) {
                    setSelectedCodeSetPlant(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog2") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog2");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog2())) ) {
                    setInspSpecAdditionalCatalog2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet2") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet2");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet2())) ) {
                    setInspSpecAdditionalSelectedSet2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup2") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup2");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup2())) ) {
                    setInspSpecAdditionalCodeGroup2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant2") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant2");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant2())) ) {
                    setInspSpecAddlSeldCodeSetPlant2(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog3") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog3");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog3())) ) {
                    setInspSpecAdditionalCatalog3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet3") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet3");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet3())) ) {
                    setInspSpecAdditionalSelectedSet3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup3") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup3");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup3())) ) {
                    setInspSpecAdditionalCodeGroup3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant3") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant3");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant3())) ) {
                    setInspSpecAddlSeldCodeSetPlant3(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog4") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog4");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog4())) ) {
                    setInspSpecAdditionalCatalog4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet4") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet4");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet4())) ) {
                    setInspSpecAdditionalSelectedSet4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup4") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup4");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup4())) ) {
                    setInspSpecAdditionalCodeGroup4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant4") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant4");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant4())) ) {
                    setInspSpecAddlSeldCodeSetPlant4(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCatalog5") ) {
                final Object value = values.remove("InspSpecAdditionalCatalog5");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCatalog5())) ) {
                    setInspSpecAdditionalCatalog5(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalSelectedSet5") ) {
                final Object value = values.remove("InspSpecAdditionalSelectedSet5");
                if( (value == null) || (!value.equals(getInspSpecAdditionalSelectedSet5())) ) {
                    setInspSpecAdditionalSelectedSet5(((String) value));
                }
            }
            if( values.containsKey("InspSpecAdditionalCodeGroup5") ) {
                final Object value = values.remove("InspSpecAdditionalCodeGroup5");
                if( (value == null) || (!value.equals(getInspSpecAdditionalCodeGroup5())) ) {
                    setInspSpecAdditionalCodeGroup5(((String) value));
                }
            }
            if( values.containsKey("InspSpecAddlSeldCodeSetPlant5") ) {
                final Object value = values.remove("InspSpecAddlSeldCodeSetPlant5");
                if( (value == null) || (!value.equals(getInspSpecAddlSeldCodeSetPlant5())) ) {
                    setInspSpecAddlSeldCodeSetPlant5(((String) value));
                }
            }
            if( values.containsKey("SamplingProcedure") ) {
                final Object value = values.remove("SamplingProcedure");
                if( (value == null) || (!value.equals(getSamplingProcedure())) ) {
                    setSamplingProcedure(((String) value));
                }
            }
            if( values.containsKey("InspCharacteristicSampleUnit") ) {
                final Object value = values.remove("InspCharacteristicSampleUnit");
                if( (value == null) || (!value.equals(getInspCharacteristicSampleUnit())) ) {
                    setInspCharacteristicSampleUnit(((String) value));
                }
            }
            if( values.containsKey("BOOCharcSampleQuantity") ) {
                final Object value = values.remove("BOOCharcSampleQuantity");
                if( (value == null) || (!value.equals(getBOOCharcSampleQuantity())) ) {
                    setBOOCharcSampleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InspSpecInformationField1") ) {
                final Object value = values.remove("InspSpecInformationField1");
                if( (value == null) || (!value.equals(getInspSpecInformationField1())) ) {
                    setInspSpecInformationField1(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField2") ) {
                final Object value = values.remove("InspSpecInformationField2");
                if( (value == null) || (!value.equals(getInspSpecInformationField2())) ) {
                    setInspSpecInformationField2(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField3") ) {
                final Object value = values.remove("InspSpecInformationField3");
                if( (value == null) || (!value.equals(getInspSpecInformationField3())) ) {
                    setInspSpecInformationField3(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationText") ) {
                final Object value = values.remove("InspectionSpecificationText");
                if( (value == null) || (!value.equals(getInspectionSpecificationText())) ) {
                    setInspectionSpecificationText(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillOfOperationsVersion") ) {
                final Object value = values.remove("BillOfOperationsVersion");
                if( (value == null) || (!value.equals(getBillOfOperationsVersion())) ) {
                    setBillOfOperationsVersion(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspPlanOpCharacteristicField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspPlanOpCharacteristicField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspPlanOpCharacteristicField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspPlanOpCharacteristicField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

}
