/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanOpCharacteristicSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
 * InspPlanOpCharacteristic} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class InspPlanOpCharacteristicByKeyFluentHelper
    extends
    FluentHelperByKey<InspPlanOpCharacteristicByKeyFluentHelper, InspPlanOpCharacteristic, InspPlanOpCharacteristicSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InspPlanOpCharacteristic}
     * @param bOOCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bOOCharacteristicVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code InspPlanOpCharacteristic}
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public InspPlanOpCharacteristicByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inspectionPlanGroup,
        final String bOOOperationInternalID,
        final String bOOCharacteristic,
        final String bOOCharacteristicVersion,
        final String bOOOpInternalVersionCounter,
        final String inspectionPlanInternalVersion,
        final String inspectionPlan )
    {
        super(servicePath, entityCollection);
        this.key.put("InspectionPlanGroup", inspectionPlanGroup);
        this.key.put("BOOOperationInternalID", bOOOperationInternalID);
        this.key.put("BOOCharacteristic", bOOCharacteristic);
        this.key.put("BOOCharacteristicVersion", bOOCharacteristicVersion);
        this.key.put("BOOOpInternalVersionCounter", bOOOpInternalVersionCounter);
        this.key.put("InspectionPlanInternalVersion", inspectionPlanInternalVersion);
        this.key.put("InspectionPlan", inspectionPlan);
    }

    @Override
    @Nonnull
    protected Class<InspPlanOpCharacteristic> getEntityClass()
    {
        return InspPlanOpCharacteristic.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
