/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanOpPRTField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanOpPRTSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * PRT Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspPlanOpPRTType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspPlanOpPRT extends VdmEntity<InspPlanOpPRT>
{

    /**
     * Selector for all available fields of InspPlanOpPRT.
     *
     */
    public final static InspPlanOpPRTSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<Boolean> DELETE_MC = new InspPlanOpPRTField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<Boolean> UPDATE_MC = new InspPlanOpPRTField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "InspectionPlanGroup" )
    @JsonProperty( "InspectionPlanGroup" )
    @Nullable
    @ODataField( odataName = "InspectionPlanGroup" )
    private String inspectionPlanGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanGroup</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> INSPECTION_PLAN_GROUP =
        new InspPlanOpPRTField<String>("InspectionPlanGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "InspectionPlan" )
    @JsonProperty( "InspectionPlan" )
    @Nullable
    @ODataField( odataName = "InspectionPlan" )
    private String inspectionPlan;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlan</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> INSPECTION_PLAN = new InspPlanOpPRTField<String>("InspectionPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "InspectionPlanInternalVersion" )
    @JsonProperty( "InspectionPlanInternalVersion" )
    @Nullable
    @ODataField( odataName = "InspectionPlanInternalVersion" )
    private String inspectionPlanInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanInternalVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> INSPECTION_PLAN_INTERNAL_VERSION =
        new InspPlanOpPRTField<String>("InspectionPlanInternalVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOOpInternalVersionCounter" )
    @JsonProperty( "BOOOpInternalVersionCounter" )
    @Nullable
    @ODataField( odataName = "BOOOpInternalVersionCounter" )
    private String bOOOpInternalVersionCounter;
    /**
     * Use with available fluent helpers to apply the <b>BOOOpInternalVersionCounter</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> BOO_OP_INTERNAL_VERSION_COUNTER =
        new InspPlanOpPRTField<String>("BOOOpInternalVersionCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "BOOOperationInternalID" )
    @JsonProperty( "BOOOperationInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationInternalID" )
    private String bOOOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> BOO_OPERATION_INTERNAL_ID =
        new InspPlanOpPRTField<String>("BOOOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @return Item Counter for Production Resources/Tools
     */
    @Key
    @SerializedName( "BOOOperationPRTInternalID" )
    @JsonProperty( "BOOOperationPRTInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationPRTInternalID" )
    private String bOOOperationPRTInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationPRTInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> BOO_OPERATION_PRT_INTERNAL_ID =
        new InspPlanOpPRTField<String>("BOOOperationPRTInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @SerializedName( "BillOfOperationsSequence" )
    @JsonProperty( "BillOfOperationsSequence" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsSequence" )
    private String billOfOperationsSequence;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsSequence</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> BILL_OF_OPERATIONS_SEQUENCE =
        new InspPlanOpPRTField<String>("BillOfOperationsSequence");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "BillOfOperationsType" )
    @JsonProperty( "BillOfOperationsType" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsType" )
    private String billOfOperationsType;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsType</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> BILL_OF_OPERATIONS_TYPE =
        new InspPlanOpPRTField<String>("BillOfOperationsType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<LocalDateTime> VALIDITY_START_DATE =
        new InspPlanOpPRTField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<LocalDateTime> VALIDITY_END_DATE =
        new InspPlanOpPRTField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceType</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "ProductionResourceType" )
    @JsonProperty( "ProductionResourceType" )
    @Nullable
    @ODataField( odataName = "ProductionResourceType" )
    private String productionResourceType;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceType</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODUCTION_RESOURCE_TYPE =
        new InspPlanOpPRTField<String>("ProductionResourceType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "ProductionResourceInternalID" )
    @JsonProperty( "ProductionResourceInternalID" )
    @Nullable
    @ODataField( odataName = "ProductionResourceInternalID" )
    private String productionResourceInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODUCTION_RESOURCE_INTERNAL_ID =
        new InspPlanOpPRTField<String>("ProductionResourceInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @return Language-dependent description of the PRT category
     */
    @SerializedName( "ProdnRsceToolCategoryName" )
    @JsonProperty( "ProdnRsceToolCategoryName" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategoryName" )
    private String prodnRsceToolCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategoryName</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_CATEGORY_NAME =
        new InspPlanOpPRTField<String>("ProdnRsceToolCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceTool</b>
     * </p>
     *
     * @return Production Resource/Tool Number
     */
    @SerializedName( "ProductionResourceTool" )
    @JsonProperty( "ProductionResourceTool" )
    @Nullable
    @ODataField( odataName = "ProductionResourceTool" )
    private String productionResourceTool;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceTool</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODUCTION_RESOURCE_TOOL =
        new InspPlanOpPRTField<String>("ProductionResourceTool");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceToolDesc</b>
     * </p>
     *
     * @return Description of the Production Resource/Tool
     */
    @SerializedName( "ProductionResourceToolDesc" )
    @JsonProperty( "ProductionResourceToolDesc" )
    @Nullable
    @ODataField( odataName = "ProductionResourceToolDesc" )
    private String productionResourceToolDesc;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceToolDesc</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODUCTION_RESOURCE_TOOL_DESC =
        new InspPlanOpPRTField<String>("ProductionResourceToolDesc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @return Production Resources/Tools Category
     */
    @SerializedName( "ProdnRsceToolCategory" )
    @JsonProperty( "ProdnRsceToolCategory" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategory" )
    private String prodnRsceToolCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategory</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_CATEGORY =
        new InspPlanOpPRTField<String>("ProdnRsceToolCategory");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> EQUIPMENT = new InspPlanOpPRTField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentName</b>
     * </p>
     *
     * @return Description of technical object
     */
    @SerializedName( "EquipmentName" )
    @JsonProperty( "EquipmentName" )
    @Nullable
    @ODataField( odataName = "EquipmentName" )
    private String equipmentName;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentName</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> EQUIPMENT_NAME = new InspPlanOpPRTField<String>("EquipmentName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> CHANGE_NUMBER = new InspPlanOpPRTField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @return Item Number for Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolItemNumber" )
    @JsonProperty( "ProdnRsceToolItemNumber" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolItemNumber" )
    private String prodnRsceToolItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolItemNumber</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_ITEM_NUMBER =
        new InspPlanOpPRTField<String>("ProdnRsceToolItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @return Control Profile for Management of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolControlProfile" )
    @JsonProperty( "ProdnRsceToolControlProfile" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolControlProfile" )
    private String prodnRsceToolControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolControlProfile</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_CONTROL_PROFILE =
        new InspPlanOpPRTField<String>("ProdnRsceToolControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardTextCode</b>
     * </p>
     *
     * @return Standard Text Key for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStandardTextCode" )
    @JsonProperty( "ProdnRsceToolStandardTextCode" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStandardTextCode" )
    private String prodnRsceToolStandardTextCode;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStandardTextCode</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_STANDARD_TEXT_CODE =
        new InspPlanOpPRTField<String>("ProdnRsceToolStandardTextCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolText</b>
     * </p>
     *
     * @return First Line of Text for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolText" )
    @JsonProperty( "ProdnRsceToolText" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolText" )
    private String prodnRsceToolText;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolText</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_TEXT =
        new InspPlanOpPRTField<String>("ProdnRsceToolText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<LocalDateTime> CREATION_DATE =
        new InspPlanOpPRTField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> CREATED_BY_USER = new InspPlanOpPRTField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<LocalDateTime> LAST_CHANGE_DATE =
        new InspPlanOpPRTField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> LAST_CHANGED_BY_USER =
        new InspPlanOpPRTField<String>("LastChangedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<Boolean> IS_DELETED = new InspPlanOpPRTField<Boolean>("IsDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsImplicitlyDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsImplicitlyDeleted" )
    @JsonProperty( "IsImplicitlyDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsImplicitlyDeleted" )
    private Boolean isImplicitlyDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsImplicitlyDeleted</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<Boolean> IS_IMPLICITLY_DELETED =
        new InspPlanOpPRTField<Boolean>("IsImplicitlyDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @return Unit for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStdWorkQtyUnit" )
    @JsonProperty( "ProdnRsceToolStdWorkQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStdWorkQtyUnit" )
    private String prodnRsceToolStdWorkQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStdWorkQtyUnit</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT =
        new InspPlanOpPRTField<String>("ProdnRsceToolStdWorkQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @return Standard Value for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStandardWorkQty" )
    @JsonProperty( "ProdnRsceToolStandardWorkQty" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStandardWorkQty" )
    private BigDecimal prodnRsceToolStandardWorkQty;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStandardWorkQty</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<BigDecimal> PRODN_RSCE_TOOL_STANDARD_WORK_QTY =
        new InspPlanOpPRTField<BigDecimal>("ProdnRsceToolStandardWorkQty");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolTotQtyCalcFormula</b>
     * </p>
     *
     * @return Formula for Calculating the Total Quantity of PRT
     */
    @SerializedName( "ProdnRsceToolTotQtyCalcFormula" )
    @JsonProperty( "ProdnRsceToolTotQtyCalcFormula" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolTotQtyCalcFormula" )
    private String prodnRsceToolTotQtyCalcFormula;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolTotQtyCalcFormula</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA =
        new InspPlanOpPRTField<String>("ProdnRsceToolTotQtyCalcFormula");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @return Usage Value Unit of the Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolUsageQuantityUnit" )
    @JsonProperty( "ProdnRsceToolUsageQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantityUnit" )
    private String prodnRsceToolUsageQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantityUnit</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT =
        new InspPlanOpPRTField<String>("ProdnRsceToolUsageQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @return Standard Usage Value for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolUsageQuantity" )
    @JsonProperty( "ProdnRsceToolUsageQuantity" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantity" )
    private BigDecimal prodnRsceToolUsageQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantity</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<BigDecimal> PRODN_RSCE_TOOL_USAGE_QUANTITY =
        new InspPlanOpPRTField<BigDecimal>("ProdnRsceToolUsageQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQtyCalcFmla</b>
     * </p>
     *
     * @return Formula for Calculating the Total Usage Value of PRT
     */
    @SerializedName( "ProdnRsceToolUsageQtyCalcFmla" )
    @JsonProperty( "ProdnRsceToolUsageQtyCalcFmla" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQtyCalcFmla" )
    private String prodnRsceToolUsageQtyCalcFmla;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQtyCalcFmla</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA =
        new InspPlanOpPRTField<String>("ProdnRsceToolUsageQtyCalcFmla");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartDateOffsetReferenceCode</b>
     * </p>
     *
     * @return Reference Date for Start of Production Resource/Tool Usage
     */
    @SerializedName( "StartDateOffsetReferenceCode" )
    @JsonProperty( "StartDateOffsetReferenceCode" )
    @Nullable
    @ODataField( odataName = "StartDateOffsetReferenceCode" )
    private String startDateOffsetReferenceCode;
    /**
     * Use with available fluent helpers to apply the <b>StartDateOffsetReferenceCode</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> START_DATE_OFFSET_REFERENCE_CODE =
        new InspPlanOpPRTField<String>("StartDateOffsetReferenceCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StartDateOffsetDurationUnit</b>
     * </p>
     *
     * @return Offset Unit for Start of Prodn Resource/Tool Usage
     */
    @SerializedName( "StartDateOffsetDurationUnit" )
    @JsonProperty( "StartDateOffsetDurationUnit" )
    @Nullable
    @ODataField( odataName = "StartDateOffsetDurationUnit" )
    private String startDateOffsetDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>StartDateOffsetDurationUnit</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> START_DATE_OFFSET_DURATION_UNIT =
        new InspPlanOpPRTField<String>("StartDateOffsetDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>StartDateOffsetDuration</b>
     * </p>
     *
     * @return Offset to start of production resource/tool usage
     */
    @SerializedName( "StartDateOffsetDuration" )
    @JsonProperty( "StartDateOffsetDuration" )
    @Nullable
    @ODataField( odataName = "StartDateOffsetDuration" )
    private BigDecimal startDateOffsetDuration;
    /**
     * Use with available fluent helpers to apply the <b>StartDateOffsetDuration</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<BigDecimal> START_DATE_OFFSET_DURATION =
        new InspPlanOpPRTField<BigDecimal>("StartDateOffsetDuration");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndDateOffsetReferenceCode</b>
     * </p>
     *
     * @return Reference date for end of production resource/tool usage
     */
    @SerializedName( "EndDateOffsetReferenceCode" )
    @JsonProperty( "EndDateOffsetReferenceCode" )
    @Nullable
    @ODataField( odataName = "EndDateOffsetReferenceCode" )
    private String endDateOffsetReferenceCode;
    /**
     * Use with available fluent helpers to apply the <b>EndDateOffsetReferenceCode</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> END_DATE_OFFSET_REFERENCE_CODE =
        new InspPlanOpPRTField<String>("EndDateOffsetReferenceCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EndDateOffsetDurationUnit</b>
     * </p>
     *
     * @return Offset Unit for End of Production Resource/Tool Usage
     */
    @SerializedName( "EndDateOffsetDurationUnit" )
    @JsonProperty( "EndDateOffsetDurationUnit" )
    @Nullable
    @ODataField( odataName = "EndDateOffsetDurationUnit" )
    private String endDateOffsetDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>EndDateOffsetDurationUnit</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> END_DATE_OFFSET_DURATION_UNIT =
        new InspPlanOpPRTField<String>("EndDateOffsetDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>EndDateOffsetDuration</b>
     * </p>
     *
     * @return Offset to finish of production resource/tool usage
     */
    @SerializedName( "EndDateOffsetDuration" )
    @JsonProperty( "EndDateOffsetDuration" )
    @Nullable
    @ODataField( odataName = "EndDateOffsetDuration" )
    private BigDecimal endDateOffsetDuration;
    /**
     * Use with available fluent helpers to apply the <b>EndDateOffsetDuration</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<BigDecimal> END_DATE_OFFSET_DURATION =
        new InspPlanOpPRTField<BigDecimal>("EndDateOffsetDuration");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVersion</b>
     * </p>
     *
     * @return Routing Version
     */
    @SerializedName( "BillOfOperationsVersion" )
    @JsonProperty( "BillOfOperationsVersion" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsVersion" )
    private String billOfOperationsVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> BILL_OF_OPERATIONS_VERSION =
        new InspPlanOpPRTField<String>("BillOfOperationsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> PLANT = new InspPlanOpPRTField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @return Document number
     */
    @SerializedName( "DocumentInfoRecord" )
    @JsonProperty( "DocumentInfoRecord" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecord" )
    private String documentInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecord</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> DOCUMENT_INFO_RECORD =
        new InspPlanOpPRTField<String>("DocumentInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentType</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> DOCUMENT_TYPE = new InspPlanOpPRTField<String>("DocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentPart</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> DOCUMENT_PART = new InspPlanOpPRTField<String>("DocumentPart");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentVersion</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<String> DOCUMENT_VERSION = new InspPlanOpPRTField<String>("DocumentVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspPlanOpPRTField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspPlanOpPRTField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspPlanOpPRT> getType()
    {
        return InspPlanOpPRT.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @param inspectionPlanGroup
     *            Key for Task List Group
     */
    public void setInspectionPlanGroup( @Nullable final String inspectionPlanGroup )
    {
        rememberChangedField("InspectionPlanGroup", this.inspectionPlanGroup);
        this.inspectionPlanGroup = inspectionPlanGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @param inspectionPlan
     *            Group Counter
     */
    public void setInspectionPlan( @Nullable final String inspectionPlan )
    {
        rememberChangedField("InspectionPlan", this.inspectionPlan);
        this.inspectionPlan = inspectionPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @param inspectionPlanInternalVersion
     *            Internal counter
     */
    public void setInspectionPlanInternalVersion( @Nullable final String inspectionPlanInternalVersion )
    {
        rememberChangedField("InspectionPlanInternalVersion", this.inspectionPlanInternalVersion);
        this.inspectionPlanInternalVersion = inspectionPlanInternalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     */
    public void setBOOOpInternalVersionCounter( @Nullable final String bOOOpInternalVersionCounter )
    {
        rememberChangedField("BOOOpInternalVersionCounter", this.bOOOpInternalVersionCounter);
        this.bOOOpInternalVersionCounter = bOOOpInternalVersionCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     */
    public void setBOOOperationInternalID( @Nullable final String bOOOperationInternalID )
    {
        rememberChangedField("BOOOperationInternalID", this.bOOOperationInternalID);
        this.bOOOperationInternalID = bOOOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationPRTInternalID</b>
     * </p>
     *
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     */
    public void setBOOOperationPRTInternalID( @Nullable final String bOOOperationPRTInternalID )
    {
        rememberChangedField("BOOOperationPRTInternalID", this.bOOOperationPRTInternalID);
        this.bOOOperationPRTInternalID = bOOOperationPRTInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsSequence</b>
     * </p>
     *
     * @param billOfOperationsSequence
     *            Sequence
     */
    public void setBillOfOperationsSequence( @Nullable final String billOfOperationsSequence )
    {
        rememberChangedField("BillOfOperationsSequence", this.billOfOperationsSequence);
        this.billOfOperationsSequence = billOfOperationsSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @param billOfOperationsType
     *            Task List Type
     */
    public void setBillOfOperationsType( @Nullable final String billOfOperationsType )
    {
        rememberChangedField("BillOfOperationsType", this.billOfOperationsType);
        this.billOfOperationsType = billOfOperationsType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceType</b>
     * </p>
     *
     * @param productionResourceType
     *            Object types of the CIM resource
     */
    public void setProductionResourceType( @Nullable final String productionResourceType )
    {
        rememberChangedField("ProductionResourceType", this.productionResourceType);
        this.productionResourceType = productionResourceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceInternalID</b>
     * </p>
     *
     * @param productionResourceInternalID
     *            Object ID of the resource
     */
    public void setProductionResourceInternalID( @Nullable final String productionResourceInternalID )
    {
        rememberChangedField("ProductionResourceInternalID", this.productionResourceInternalID);
        this.productionResourceInternalID = productionResourceInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @param prodnRsceToolCategoryName
     *            Language-dependent description of the PRT category
     */
    public void setProdnRsceToolCategoryName( @Nullable final String prodnRsceToolCategoryName )
    {
        rememberChangedField("ProdnRsceToolCategoryName", this.prodnRsceToolCategoryName);
        this.prodnRsceToolCategoryName = prodnRsceToolCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceTool</b>
     * </p>
     *
     * @param productionResourceTool
     *            Production Resource/Tool Number
     */
    public void setProductionResourceTool( @Nullable final String productionResourceTool )
    {
        rememberChangedField("ProductionResourceTool", this.productionResourceTool);
        this.productionResourceTool = productionResourceTool;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceToolDesc</b>
     * </p>
     *
     * @param productionResourceToolDesc
     *            Description of the Production Resource/Tool
     */
    public void setProductionResourceToolDesc( @Nullable final String productionResourceToolDesc )
    {
        rememberChangedField("ProductionResourceToolDesc", this.productionResourceToolDesc);
        this.productionResourceToolDesc = productionResourceToolDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @param prodnRsceToolCategory
     *            Production Resources/Tools Category
     */
    public void setProdnRsceToolCategory( @Nullable final String prodnRsceToolCategory )
    {
        rememberChangedField("ProdnRsceToolCategory", this.prodnRsceToolCategory);
        this.prodnRsceToolCategory = prodnRsceToolCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentName</b>
     * </p>
     *
     * @param equipmentName
     *            Description of technical object
     */
    public void setEquipmentName( @Nullable final String equipmentName )
    {
        rememberChangedField("EquipmentName", this.equipmentName);
        this.equipmentName = equipmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolItemNumber</b>
     * </p>
     *
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     */
    public void setProdnRsceToolItemNumber( @Nullable final String prodnRsceToolItemNumber )
    {
        rememberChangedField("ProdnRsceToolItemNumber", this.prodnRsceToolItemNumber);
        this.prodnRsceToolItemNumber = prodnRsceToolItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @param prodnRsceToolControlProfile
     *            Control Profile for Management of Production Resources/Tools
     */
    public void setProdnRsceToolControlProfile( @Nullable final String prodnRsceToolControlProfile )
    {
        rememberChangedField("ProdnRsceToolControlProfile", this.prodnRsceToolControlProfile);
        this.prodnRsceToolControlProfile = prodnRsceToolControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardTextCode</b>
     * </p>
     *
     * @param prodnRsceToolStandardTextCode
     *            Standard Text Key for Production Resources/Tools
     */
    public void setProdnRsceToolStandardTextCode( @Nullable final String prodnRsceToolStandardTextCode )
    {
        rememberChangedField("ProdnRsceToolStandardTextCode", this.prodnRsceToolStandardTextCode);
        this.prodnRsceToolStandardTextCode = prodnRsceToolStandardTextCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolText</b>
     * </p>
     *
     * @param prodnRsceToolText
     *            First Line of Text for Production Resources/Tools
     */
    public void setProdnRsceToolText( @Nullable final String prodnRsceToolText )
    {
        rememberChangedField("ProdnRsceToolText", this.prodnRsceToolText);
        this.prodnRsceToolText = prodnRsceToolText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsImplicitlyDeleted</b>
     * </p>
     *
     * @param isImplicitlyDeleted
     *            Deletion Indicator
     */
    public void setIsImplicitlyDeleted( @Nullable final Boolean isImplicitlyDeleted )
    {
        rememberChangedField("IsImplicitlyDeleted", this.isImplicitlyDeleted);
        this.isImplicitlyDeleted = isImplicitlyDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @param prodnRsceToolStdWorkQtyUnit
     *            Unit for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStdWorkQtyUnit( @Nullable final String prodnRsceToolStdWorkQtyUnit )
    {
        rememberChangedField("ProdnRsceToolStdWorkQtyUnit", this.prodnRsceToolStdWorkQtyUnit);
        this.prodnRsceToolStdWorkQtyUnit = prodnRsceToolStdWorkQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @param prodnRsceToolStandardWorkQty
     *            Standard Value for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStandardWorkQty( @Nullable final BigDecimal prodnRsceToolStandardWorkQty )
    {
        rememberChangedField("ProdnRsceToolStandardWorkQty", this.prodnRsceToolStandardWorkQty);
        this.prodnRsceToolStandardWorkQty = prodnRsceToolStandardWorkQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolTotQtyCalcFormula</b>
     * </p>
     *
     * @param prodnRsceToolTotQtyCalcFormula
     *            Formula for Calculating the Total Quantity of PRT
     */
    public void setProdnRsceToolTotQtyCalcFormula( @Nullable final String prodnRsceToolTotQtyCalcFormula )
    {
        rememberChangedField("ProdnRsceToolTotQtyCalcFormula", this.prodnRsceToolTotQtyCalcFormula);
        this.prodnRsceToolTotQtyCalcFormula = prodnRsceToolTotQtyCalcFormula;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantityUnit
     *            Usage Value Unit of the Production Resource/Tool
     */
    public void setProdnRsceToolUsageQuantityUnit( @Nullable final String prodnRsceToolUsageQuantityUnit )
    {
        rememberChangedField("ProdnRsceToolUsageQuantityUnit", this.prodnRsceToolUsageQuantityUnit);
        this.prodnRsceToolUsageQuantityUnit = prodnRsceToolUsageQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantity
     *            Standard Usage Value for Production Resources/Tools
     */
    public void setProdnRsceToolUsageQuantity( @Nullable final BigDecimal prodnRsceToolUsageQuantity )
    {
        rememberChangedField("ProdnRsceToolUsageQuantity", this.prodnRsceToolUsageQuantity);
        this.prodnRsceToolUsageQuantity = prodnRsceToolUsageQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQtyCalcFmla</b>
     * </p>
     *
     * @param prodnRsceToolUsageQtyCalcFmla
     *            Formula for Calculating the Total Usage Value of PRT
     */
    public void setProdnRsceToolUsageQtyCalcFmla( @Nullable final String prodnRsceToolUsageQtyCalcFmla )
    {
        rememberChangedField("ProdnRsceToolUsageQtyCalcFmla", this.prodnRsceToolUsageQtyCalcFmla);
        this.prodnRsceToolUsageQtyCalcFmla = prodnRsceToolUsageQtyCalcFmla;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartDateOffsetReferenceCode</b>
     * </p>
     *
     * @param startDateOffsetReferenceCode
     *            Reference Date for Start of Production Resource/Tool Usage
     */
    public void setStartDateOffsetReferenceCode( @Nullable final String startDateOffsetReferenceCode )
    {
        rememberChangedField("StartDateOffsetReferenceCode", this.startDateOffsetReferenceCode);
        this.startDateOffsetReferenceCode = startDateOffsetReferenceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StartDateOffsetDurationUnit</b>
     * </p>
     *
     * @param startDateOffsetDurationUnit
     *            Offset Unit for Start of Prodn Resource/Tool Usage
     */
    public void setStartDateOffsetDurationUnit( @Nullable final String startDateOffsetDurationUnit )
    {
        rememberChangedField("StartDateOffsetDurationUnit", this.startDateOffsetDurationUnit);
        this.startDateOffsetDurationUnit = startDateOffsetDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>StartDateOffsetDuration</b>
     * </p>
     *
     * @param startDateOffsetDuration
     *            Offset to start of production resource/tool usage
     */
    public void setStartDateOffsetDuration( @Nullable final BigDecimal startDateOffsetDuration )
    {
        rememberChangedField("StartDateOffsetDuration", this.startDateOffsetDuration);
        this.startDateOffsetDuration = startDateOffsetDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndDateOffsetReferenceCode</b>
     * </p>
     *
     * @param endDateOffsetReferenceCode
     *            Reference date for end of production resource/tool usage
     */
    public void setEndDateOffsetReferenceCode( @Nullable final String endDateOffsetReferenceCode )
    {
        rememberChangedField("EndDateOffsetReferenceCode", this.endDateOffsetReferenceCode);
        this.endDateOffsetReferenceCode = endDateOffsetReferenceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EndDateOffsetDurationUnit</b>
     * </p>
     *
     * @param endDateOffsetDurationUnit
     *            Offset Unit for End of Production Resource/Tool Usage
     */
    public void setEndDateOffsetDurationUnit( @Nullable final String endDateOffsetDurationUnit )
    {
        rememberChangedField("EndDateOffsetDurationUnit", this.endDateOffsetDurationUnit);
        this.endDateOffsetDurationUnit = endDateOffsetDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>EndDateOffsetDuration</b>
     * </p>
     *
     * @param endDateOffsetDuration
     *            Offset to finish of production resource/tool usage
     */
    public void setEndDateOffsetDuration( @Nullable final BigDecimal endDateOffsetDuration )
    {
        rememberChangedField("EndDateOffsetDuration", this.endDateOffsetDuration);
        this.endDateOffsetDuration = endDateOffsetDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsVersion</b>
     * </p>
     *
     * @param billOfOperationsVersion
     *            Routing Version
     */
    public void setBillOfOperationsVersion( @Nullable final String billOfOperationsVersion )
    {
        rememberChangedField("BillOfOperationsVersion", this.billOfOperationsVersion);
        this.billOfOperationsVersion = billOfOperationsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @param documentInfoRecord
     *            Document number
     */
    public void setDocumentInfoRecord( @Nullable final String documentInfoRecord )
    {
        rememberChangedField("DocumentInfoRecord", this.documentInfoRecord);
        this.documentInfoRecord = documentInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspPlanOpPRT";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionPlanGroup", getInspectionPlanGroup());
        result.put("InspectionPlan", getInspectionPlan());
        result.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        result.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        result.put("BOOOperationInternalID", getBOOOperationInternalID());
        result.put("BOOOperationPRTInternalID", getBOOOperationPRTInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("InspectionPlanGroup", getInspectionPlanGroup());
        values.put("InspectionPlan", getInspectionPlan());
        values.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        values.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        values.put("BOOOperationInternalID", getBOOOperationInternalID());
        values.put("BOOOperationPRTInternalID", getBOOOperationPRTInternalID());
        values.put("BillOfOperationsSequence", getBillOfOperationsSequence());
        values.put("BillOfOperationsType", getBillOfOperationsType());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ProductionResourceType", getProductionResourceType());
        values.put("ProductionResourceInternalID", getProductionResourceInternalID());
        values.put("ProdnRsceToolCategoryName", getProdnRsceToolCategoryName());
        values.put("ProductionResourceTool", getProductionResourceTool());
        values.put("ProductionResourceToolDesc", getProductionResourceToolDesc());
        values.put("ProdnRsceToolCategory", getProdnRsceToolCategory());
        values.put("Equipment", getEquipment());
        values.put("EquipmentName", getEquipmentName());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ProdnRsceToolItemNumber", getProdnRsceToolItemNumber());
        values.put("ProdnRsceToolControlProfile", getProdnRsceToolControlProfile());
        values.put("ProdnRsceToolStandardTextCode", getProdnRsceToolStandardTextCode());
        values.put("ProdnRsceToolText", getProdnRsceToolText());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("IsDeleted", getIsDeleted());
        values.put("IsImplicitlyDeleted", getIsImplicitlyDeleted());
        values.put("ProdnRsceToolStdWorkQtyUnit", getProdnRsceToolStdWorkQtyUnit());
        values.put("ProdnRsceToolStandardWorkQty", getProdnRsceToolStandardWorkQty());
        values.put("ProdnRsceToolTotQtyCalcFormula", getProdnRsceToolTotQtyCalcFormula());
        values.put("ProdnRsceToolUsageQuantityUnit", getProdnRsceToolUsageQuantityUnit());
        values.put("ProdnRsceToolUsageQuantity", getProdnRsceToolUsageQuantity());
        values.put("ProdnRsceToolUsageQtyCalcFmla", getProdnRsceToolUsageQtyCalcFmla());
        values.put("StartDateOffsetReferenceCode", getStartDateOffsetReferenceCode());
        values.put("StartDateOffsetDurationUnit", getStartDateOffsetDurationUnit());
        values.put("StartDateOffsetDuration", getStartDateOffsetDuration());
        values.put("EndDateOffsetReferenceCode", getEndDateOffsetReferenceCode());
        values.put("EndDateOffsetDurationUnit", getEndDateOffsetDurationUnit());
        values.put("EndDateOffsetDuration", getEndDateOffsetDuration());
        values.put("BillOfOperationsVersion", getBillOfOperationsVersion());
        values.put("Plant", getPlant());
        values.put("DocumentInfoRecord", getDocumentInfoRecord());
        values.put("DocumentType", getDocumentType());
        values.put("DocumentPart", getDocumentPart());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionPlanGroup") ) {
                final Object value = values.remove("InspectionPlanGroup");
                if( (value == null) || (!value.equals(getInspectionPlanGroup())) ) {
                    setInspectionPlanGroup(((String) value));
                }
            }
            if( values.containsKey("InspectionPlan") ) {
                final Object value = values.remove("InspectionPlan");
                if( (value == null) || (!value.equals(getInspectionPlan())) ) {
                    setInspectionPlan(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanInternalVersion") ) {
                final Object value = values.remove("InspectionPlanInternalVersion");
                if( (value == null) || (!value.equals(getInspectionPlanInternalVersion())) ) {
                    setInspectionPlanInternalVersion(((String) value));
                }
            }
            if( values.containsKey("BOOOpInternalVersionCounter") ) {
                final Object value = values.remove("BOOOpInternalVersionCounter");
                if( (value == null) || (!value.equals(getBOOOpInternalVersionCounter())) ) {
                    setBOOOpInternalVersionCounter(((String) value));
                }
            }
            if( values.containsKey("BOOOperationInternalID") ) {
                final Object value = values.remove("BOOOperationInternalID");
                if( (value == null) || (!value.equals(getBOOOperationInternalID())) ) {
                    setBOOOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("BOOOperationPRTInternalID") ) {
                final Object value = values.remove("BOOOperationPRTInternalID");
                if( (value == null) || (!value.equals(getBOOOperationPRTInternalID())) ) {
                    setBOOOperationPRTInternalID(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsSequence") ) {
                final Object value = values.remove("BillOfOperationsSequence");
                if( (value == null) || (!value.equals(getBillOfOperationsSequence())) ) {
                    setBillOfOperationsSequence(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsType") ) {
                final Object value = values.remove("BillOfOperationsType");
                if( (value == null) || (!value.equals(getBillOfOperationsType())) ) {
                    setBillOfOperationsType(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductionResourceType") ) {
                final Object value = values.remove("ProductionResourceType");
                if( (value == null) || (!value.equals(getProductionResourceType())) ) {
                    setProductionResourceType(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceInternalID") ) {
                final Object value = values.remove("ProductionResourceInternalID");
                if( (value == null) || (!value.equals(getProductionResourceInternalID())) ) {
                    setProductionResourceInternalID(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategoryName") ) {
                final Object value = values.remove("ProdnRsceToolCategoryName");
                if( (value == null) || (!value.equals(getProdnRsceToolCategoryName())) ) {
                    setProdnRsceToolCategoryName(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceTool") ) {
                final Object value = values.remove("ProductionResourceTool");
                if( (value == null) || (!value.equals(getProductionResourceTool())) ) {
                    setProductionResourceTool(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceToolDesc") ) {
                final Object value = values.remove("ProductionResourceToolDesc");
                if( (value == null) || (!value.equals(getProductionResourceToolDesc())) ) {
                    setProductionResourceToolDesc(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategory") ) {
                final Object value = values.remove("ProdnRsceToolCategory");
                if( (value == null) || (!value.equals(getProdnRsceToolCategory())) ) {
                    setProdnRsceToolCategory(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("EquipmentName") ) {
                final Object value = values.remove("EquipmentName");
                if( (value == null) || (!value.equals(getEquipmentName())) ) {
                    setEquipmentName(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolItemNumber") ) {
                final Object value = values.remove("ProdnRsceToolItemNumber");
                if( (value == null) || (!value.equals(getProdnRsceToolItemNumber())) ) {
                    setProdnRsceToolItemNumber(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolControlProfile") ) {
                final Object value = values.remove("ProdnRsceToolControlProfile");
                if( (value == null) || (!value.equals(getProdnRsceToolControlProfile())) ) {
                    setProdnRsceToolControlProfile(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStandardTextCode") ) {
                final Object value = values.remove("ProdnRsceToolStandardTextCode");
                if( (value == null) || (!value.equals(getProdnRsceToolStandardTextCode())) ) {
                    setProdnRsceToolStandardTextCode(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolText") ) {
                final Object value = values.remove("ProdnRsceToolText");
                if( (value == null) || (!value.equals(getProdnRsceToolText())) ) {
                    setProdnRsceToolText(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("IsImplicitlyDeleted") ) {
                final Object value = values.remove("IsImplicitlyDeleted");
                if( (value == null) || (!value.equals(getIsImplicitlyDeleted())) ) {
                    setIsImplicitlyDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStdWorkQtyUnit") ) {
                final Object value = values.remove("ProdnRsceToolStdWorkQtyUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolStdWorkQtyUnit())) ) {
                    setProdnRsceToolStdWorkQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStandardWorkQty") ) {
                final Object value = values.remove("ProdnRsceToolStandardWorkQty");
                if( (value == null) || (!value.equals(getProdnRsceToolStandardWorkQty())) ) {
                    setProdnRsceToolStandardWorkQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProdnRsceToolTotQtyCalcFormula") ) {
                final Object value = values.remove("ProdnRsceToolTotQtyCalcFormula");
                if( (value == null) || (!value.equals(getProdnRsceToolTotQtyCalcFormula())) ) {
                    setProdnRsceToolTotQtyCalcFormula(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantityUnit") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantityUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantityUnit())) ) {
                    setProdnRsceToolUsageQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantity") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantity");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantity())) ) {
                    setProdnRsceToolUsageQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQtyCalcFmla") ) {
                final Object value = values.remove("ProdnRsceToolUsageQtyCalcFmla");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQtyCalcFmla())) ) {
                    setProdnRsceToolUsageQtyCalcFmla(((String) value));
                }
            }
            if( values.containsKey("StartDateOffsetReferenceCode") ) {
                final Object value = values.remove("StartDateOffsetReferenceCode");
                if( (value == null) || (!value.equals(getStartDateOffsetReferenceCode())) ) {
                    setStartDateOffsetReferenceCode(((String) value));
                }
            }
            if( values.containsKey("StartDateOffsetDurationUnit") ) {
                final Object value = values.remove("StartDateOffsetDurationUnit");
                if( (value == null) || (!value.equals(getStartDateOffsetDurationUnit())) ) {
                    setStartDateOffsetDurationUnit(((String) value));
                }
            }
            if( values.containsKey("StartDateOffsetDuration") ) {
                final Object value = values.remove("StartDateOffsetDuration");
                if( (value == null) || (!value.equals(getStartDateOffsetDuration())) ) {
                    setStartDateOffsetDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndDateOffsetReferenceCode") ) {
                final Object value = values.remove("EndDateOffsetReferenceCode");
                if( (value == null) || (!value.equals(getEndDateOffsetReferenceCode())) ) {
                    setEndDateOffsetReferenceCode(((String) value));
                }
            }
            if( values.containsKey("EndDateOffsetDurationUnit") ) {
                final Object value = values.remove("EndDateOffsetDurationUnit");
                if( (value == null) || (!value.equals(getEndDateOffsetDurationUnit())) ) {
                    setEndDateOffsetDurationUnit(((String) value));
                }
            }
            if( values.containsKey("EndDateOffsetDuration") ) {
                final Object value = values.remove("EndDateOffsetDuration");
                if( (value == null) || (!value.equals(getEndDateOffsetDuration())) ) {
                    setEndDateOffsetDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfOperationsVersion") ) {
                final Object value = values.remove("BillOfOperationsVersion");
                if( (value == null) || (!value.equals(getBillOfOperationsVersion())) ) {
                    setBillOfOperationsVersion(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecord") ) {
                final Object value = values.remove("DocumentInfoRecord");
                if( (value == null) || (!value.equals(getDocumentInfoRecord())) ) {
                    setDocumentInfoRecord(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InspPlanOpPRTField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspPlanOpPRTField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspPlanOpPRTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspPlanOpPRTField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

}
