/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspPlanOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inspection Plan Operations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspPlanOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspPlanOperation extends VdmEntity<InspPlanOperation>
{

    /**
     * Selector for all available fields of InspPlanOperation.
     *
     */
    public final static InspPlanOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<Boolean> DELETE_MC = new InspPlanOperationField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<Boolean> UPDATE_MC = new InspPlanOperationField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "InspectionPlanGroup" )
    @JsonProperty( "InspectionPlanGroup" )
    @Nullable
    @ODataField( odataName = "InspectionPlanGroup" )
    private String inspectionPlanGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanGroup</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> INSPECTION_PLAN_GROUP =
        new InspPlanOperationField<String>("InspectionPlanGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @return Number of the Task List Node
     */
    @Key
    @SerializedName( "BOOOperationInternalID" )
    @JsonProperty( "BOOOperationInternalID" )
    @Nullable
    @ODataField( odataName = "BOOOperationInternalID" )
    private String bOOOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BOOOperationInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> BOO_OPERATION_INTERNAL_ID =
        new InspPlanOperationField<String>("BOOOperationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "InspectionPlanInternalVersion" )
    @JsonProperty( "InspectionPlanInternalVersion" )
    @Nullable
    @ODataField( odataName = "InspectionPlanInternalVersion" )
    private String inspectionPlanInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanInternalVersion</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> INSPECTION_PLAN_INTERNAL_VERSION =
        new InspPlanOperationField<String>("InspectionPlanInternalVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOOOpInternalVersionCounter" )
    @JsonProperty( "BOOOpInternalVersionCounter" )
    @Nullable
    @ODataField( odataName = "BOOOpInternalVersionCounter" )
    private String bOOOpInternalVersionCounter;
    /**
     * Use with available fluent helpers to apply the <b>BOOOpInternalVersionCounter</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> BOO_OP_INTERNAL_VERSION_COUNTER =
        new InspPlanOperationField<String>("BOOOpInternalVersionCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "InspectionPlan" )
    @JsonProperty( "InspectionPlan" )
    @Nullable
    @ODataField( odataName = "InspectionPlan" )
    private String inspectionPlan;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlan</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> INSPECTION_PLAN =
        new InspPlanOperationField<String>("InspectionPlan");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> WORK_CENTER_INTERNAL_ID =
        new InspPlanOperationField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> WORK_CENTER_TYPE_CODE =
        new InspPlanOperationField<String>("WorkCenterTypeCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<Boolean> IS_DELETED = new InspPlanOperationField<Boolean>("IsDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsImplicitlyDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsImplicitlyDeleted" )
    @JsonProperty( "IsImplicitlyDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsImplicitlyDeleted" )
    private Boolean isImplicitlyDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsImplicitlyDeleted</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<Boolean> IS_IMPLICITLY_DELETED =
        new InspPlanOperationField<Boolean>("IsImplicitlyDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationExternalID</b>
     * </p>
     *
     * @return External Operation ID
     */
    @SerializedName( "OperationExternalID" )
    @JsonProperty( "OperationExternalID" )
    @Nullable
    @ODataField( odataName = "OperationExternalID" )
    private String operationExternalID;
    /**
     * Use with available fluent helpers to apply the <b>OperationExternalID</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> OPERATION_EXTERNAL_ID =
        new InspPlanOperationField<String>("OperationExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Use with available fluent helpers to apply the <b>Operation</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> OPERATION = new InspPlanOperationField<String>("Operation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @return Operation Short Text
     */
    @SerializedName( "OperationText" )
    @JsonProperty( "OperationText" )
    @Nullable
    @ODataField( odataName = "OperationText" )
    private String operationText;
    /**
     * Use with available fluent helpers to apply the <b>OperationText</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> OPERATION_TEXT =
        new InspPlanOperationField<String>("OperationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> PLANT = new InspPlanOperationField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> OPERATION_CONTROL_PROFILE =
        new InspPlanOperationField<String>("OperationControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @return Standard Text Key
     */
    @SerializedName( "OperationStandardTextCode" )
    @JsonProperty( "OperationStandardTextCode" )
    @Nullable
    @ODataField( odataName = "OperationStandardTextCode" )
    private String operationStandardTextCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationStandardTextCode</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> OPERATION_STANDARD_TEXT_CODE =
        new InspPlanOperationField<String>("OperationStandardTextCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefType</b>
     * </p>
     *
     * @return Type of the referenced task list
     */
    @SerializedName( "BillOfOperationsRefType" )
    @JsonProperty( "BillOfOperationsRefType" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsRefType" )
    private String billOfOperationsRefType;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsRefType</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> BILL_OF_OPERATIONS_REF_TYPE =
        new InspPlanOperationField<String>("BillOfOperationsRefType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefGroup</b>
     * </p>
     *
     * @return Referenced Bill of Operations Group
     */
    @SerializedName( "BillOfOperationsRefGroup" )
    @JsonProperty( "BillOfOperationsRefGroup" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsRefGroup" )
    private String billOfOperationsRefGroup;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsRefGroup</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> BILL_OF_OPERATIONS_REF_GROUP =
        new InspPlanOperationField<String>("BillOfOperationsRefGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefVariant</b>
     * </p>
     *
     * @return Referenced Bill of Operations Variant
     */
    @SerializedName( "BillOfOperationsRefVariant" )
    @JsonProperty( "BillOfOperationsRefVariant" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsRefVariant" )
    private String billOfOperationsRefVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsRefVariant</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> BILL_OF_OPERATIONS_REF_VARIANT =
        new InspPlanOperationField<String>("BillOfOperationsRefVariant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspResultRecordingView</b>
     * </p>
     *
     * @return Recording View
     */
    @SerializedName( "InspResultRecordingView" )
    @JsonProperty( "InspResultRecordingView" )
    @Nullable
    @ODataField( odataName = "InspResultRecordingView" )
    private String inspResultRecordingView;
    /**
     * Use with available fluent helpers to apply the <b>InspResultRecordingView</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> INSP_RESULT_RECORDING_VIEW =
        new InspPlanOperationField<String>("InspResultRecordingView");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstCompletionConfirmation</b>
     * </p>
     *
     * @return Flow Variants for Inspection Point Completion
     */
    @SerializedName( "InspSbstCompletionConfirmation" )
    @JsonProperty( "InspSbstCompletionConfirmation" )
    @Nullable
    @ODataField( odataName = "InspSbstCompletionConfirmation" )
    private String inspSbstCompletionConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstCompletionConfirmation</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> INSP_SBST_COMPLETION_CONFIRMATION =
        new InspPlanOperationField<String>("InspSbstCompletionConfirmation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstHasNoTimeOrQuantity</b>
     * </p>
     *
     * @return Interval Without Reference to Time or Quantity
     */
    @SerializedName( "InspSbstHasNoTimeOrQuantity" )
    @JsonProperty( "InspSbstHasNoTimeOrQuantity" )
    @Nullable
    @ODataField( odataName = "InspSbstHasNoTimeOrQuantity" )
    private String inspSbstHasNoTimeOrQuantity;
    /**
     * Use with available fluent helpers to apply the <b>InspSbstHasNoTimeOrQuantity</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> INSP_SBST_HAS_NO_TIME_OR_QUANTITY =
        new InspPlanOperationField<String>("InspSbstHasNoTimeOrQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @return Base Quantity
     */
    @SerializedName( "OperationReferenceQuantity" )
    @JsonProperty( "OperationReferenceQuantity" )
    @Nullable
    @ODataField( odataName = "OperationReferenceQuantity" )
    private BigDecimal operationReferenceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OperationReferenceQuantity</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<BigDecimal> OPERATION_REFERENCE_QUANTITY =
        new InspPlanOperationField<BigDecimal>("OperationReferenceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Unit of Measure for Activity/Operation
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> OPERATION_UNIT =
        new InspPlanOperationField<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyDnmntr" )
    @JsonProperty( "OpQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyDnmntr" )
    private BigDecimal opQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<BigDecimal> OP_QTY_TO_BASE_QTY_DNMNTR =
        new InspPlanOperationField<BigDecimal>("OpQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Converting Routing and Operation UoM
     */
    @SerializedName( "OpQtyToBaseQtyNmrtr" )
    @JsonProperty( "OpQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OpQtyToBaseQtyNmrtr" )
    private BigDecimal opQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OpQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<BigDecimal> OP_QTY_TO_BASE_QTY_NMRTR =
        new InspPlanOperationField<BigDecimal>("OpQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<LocalDateTime> CREATION_DATE =
        new InspPlanOperationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> CREATED_BY_USER =
        new InspPlanOperationField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<LocalDateTime> LAST_CHANGE_DATE =
        new InspPlanOperationField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> LAST_CHANGED_BY_USER =
        new InspPlanOperationField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspPlanOperationField<ZonedDateTime>("ChangedDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<String> CHANGE_NUMBER =
        new InspPlanOperationField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<LocalDateTime> VALIDITY_START_DATE =
        new InspPlanOperationField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static InspPlanOperationField<LocalDateTime> VALIDITY_END_DATE =
        new InspPlanOperationField<LocalDateTime>("ValidityEndDate");

    @Nonnull
    @Override
    public Class<InspPlanOperation> getType()
    {
        return InspPlanOperation.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @param inspectionPlanGroup
     *            Key for Task List Group
     */
    public void setInspectionPlanGroup( @Nullable final String inspectionPlanGroup )
    {
        rememberChangedField("InspectionPlanGroup", this.inspectionPlanGroup);
        this.inspectionPlanGroup = inspectionPlanGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOperationInternalID</b>
     * </p>
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     */
    public void setBOOOperationInternalID( @Nullable final String bOOOperationInternalID )
    {
        rememberChangedField("BOOOperationInternalID", this.bOOOperationInternalID);
        this.bOOOperationInternalID = bOOOperationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @param inspectionPlanInternalVersion
     *            Internal counter
     */
    public void setInspectionPlanInternalVersion( @Nullable final String inspectionPlanInternalVersion )
    {
        rememberChangedField("InspectionPlanInternalVersion", this.inspectionPlanInternalVersion);
        this.inspectionPlanInternalVersion = inspectionPlanInternalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOOOpInternalVersionCounter</b>
     * </p>
     *
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     */
    public void setBOOOpInternalVersionCounter( @Nullable final String bOOOpInternalVersionCounter )
    {
        rememberChangedField("BOOOpInternalVersionCounter", this.bOOOpInternalVersionCounter);
        this.bOOOpInternalVersionCounter = bOOOpInternalVersionCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @param inspectionPlan
     *            Group Counter
     */
    public void setInspectionPlan( @Nullable final String inspectionPlan )
    {
        rememberChangedField("InspectionPlan", this.inspectionPlan);
        this.inspectionPlan = inspectionPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsImplicitlyDeleted</b>
     * </p>
     *
     * @param isImplicitlyDeleted
     *            Deletion Indicator
     */
    public void setIsImplicitlyDeleted( @Nullable final Boolean isImplicitlyDeleted )
    {
        rememberChangedField("IsImplicitlyDeleted", this.isImplicitlyDeleted);
        this.isImplicitlyDeleted = isImplicitlyDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationExternalID</b>
     * </p>
     *
     * @param operationExternalID
     *            External Operation ID
     */
    public void setOperationExternalID( @Nullable final String operationExternalID )
    {
        rememberChangedField("OperationExternalID", this.operationExternalID);
        this.operationExternalID = operationExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Operation/Activity Number
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Control Key
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardTextCode</b>
     * </p>
     *
     * @param operationStandardTextCode
     *            Standard Text Key
     */
    public void setOperationStandardTextCode( @Nullable final String operationStandardTextCode )
    {
        rememberChangedField("OperationStandardTextCode", this.operationStandardTextCode);
        this.operationStandardTextCode = operationStandardTextCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefType</b>
     * </p>
     *
     * @param billOfOperationsRefType
     *            Type of the referenced task list
     */
    public void setBillOfOperationsRefType( @Nullable final String billOfOperationsRefType )
    {
        rememberChangedField("BillOfOperationsRefType", this.billOfOperationsRefType);
        this.billOfOperationsRefType = billOfOperationsRefType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefGroup</b>
     * </p>
     *
     * @param billOfOperationsRefGroup
     *            Referenced Bill of Operations Group
     */
    public void setBillOfOperationsRefGroup( @Nullable final String billOfOperationsRefGroup )
    {
        rememberChangedField("BillOfOperationsRefGroup", this.billOfOperationsRefGroup);
        this.billOfOperationsRefGroup = billOfOperationsRefGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsRefVariant</b>
     * </p>
     *
     * @param billOfOperationsRefVariant
     *            Referenced Bill of Operations Variant
     */
    public void setBillOfOperationsRefVariant( @Nullable final String billOfOperationsRefVariant )
    {
        rememberChangedField("BillOfOperationsRefVariant", this.billOfOperationsRefVariant);
        this.billOfOperationsRefVariant = billOfOperationsRefVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspResultRecordingView</b>
     * </p>
     *
     * @param inspResultRecordingView
     *            Recording View
     */
    public void setInspResultRecordingView( @Nullable final String inspResultRecordingView )
    {
        rememberChangedField("InspResultRecordingView", this.inspResultRecordingView);
        this.inspResultRecordingView = inspResultRecordingView;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstCompletionConfirmation</b>
     * </p>
     *
     * @param inspSbstCompletionConfirmation
     *            Flow Variants for Inspection Point Completion
     */
    public void setInspSbstCompletionConfirmation( @Nullable final String inspSbstCompletionConfirmation )
    {
        rememberChangedField("InspSbstCompletionConfirmation", this.inspSbstCompletionConfirmation);
        this.inspSbstCompletionConfirmation = inspSbstCompletionConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSbstHasNoTimeOrQuantity</b>
     * </p>
     *
     * @param inspSbstHasNoTimeOrQuantity
     *            Interval Without Reference to Time or Quantity
     */
    public void setInspSbstHasNoTimeOrQuantity( @Nullable final String inspSbstHasNoTimeOrQuantity )
    {
        rememberChangedField("InspSbstHasNoTimeOrQuantity", this.inspSbstHasNoTimeOrQuantity);
        this.inspSbstHasNoTimeOrQuantity = inspSbstHasNoTimeOrQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationReferenceQuantity</b>
     * </p>
     *
     * @param operationReferenceQuantity
     *            Base Quantity
     */
    public void setOperationReferenceQuantity( @Nullable final BigDecimal operationReferenceQuantity )
    {
        rememberChangedField("OperationReferenceQuantity", this.operationReferenceQuantity);
        this.operationReferenceQuantity = operationReferenceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Unit of Measure for Activity/Operation
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param opQtyToBaseQtyDnmntr
     *            Denominator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyDnmntr( @Nullable final BigDecimal opQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OpQtyToBaseQtyDnmntr", this.opQtyToBaseQtyDnmntr);
        this.opQtyToBaseQtyDnmntr = opQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param opQtyToBaseQtyNmrtr
     *            Numerator for Converting Routing and Operation UoM
     */
    public void setOpQtyToBaseQtyNmrtr( @Nullable final BigDecimal opQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OpQtyToBaseQtyNmrtr", this.opQtyToBaseQtyNmrtr);
        this.opQtyToBaseQtyNmrtr = opQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspPlanOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionPlanGroup", getInspectionPlanGroup());
        result.put("BOOOperationInternalID", getBOOOperationInternalID());
        result.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        result.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        result.put("InspectionPlan", getInspectionPlan());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("InspectionPlanGroup", getInspectionPlanGroup());
        values.put("BOOOperationInternalID", getBOOOperationInternalID());
        values.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        values.put("BOOOpInternalVersionCounter", getBOOOpInternalVersionCounter());
        values.put("InspectionPlan", getInspectionPlan());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("IsDeleted", getIsDeleted());
        values.put("IsImplicitlyDeleted", getIsImplicitlyDeleted());
        values.put("OperationExternalID", getOperationExternalID());
        values.put("Operation", getOperation());
        values.put("OperationText", getOperationText());
        values.put("Plant", getPlant());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("OperationStandardTextCode", getOperationStandardTextCode());
        values.put("BillOfOperationsRefType", getBillOfOperationsRefType());
        values.put("BillOfOperationsRefGroup", getBillOfOperationsRefGroup());
        values.put("BillOfOperationsRefVariant", getBillOfOperationsRefVariant());
        values.put("InspResultRecordingView", getInspResultRecordingView());
        values.put("InspSbstCompletionConfirmation", getInspSbstCompletionConfirmation());
        values.put("InspSbstHasNoTimeOrQuantity", getInspSbstHasNoTimeOrQuantity());
        values.put("OperationReferenceQuantity", getOperationReferenceQuantity());
        values.put("OperationUnit", getOperationUnit());
        values.put("OpQtyToBaseQtyDnmntr", getOpQtyToBaseQtyDnmntr());
        values.put("OpQtyToBaseQtyNmrtr", getOpQtyToBaseQtyNmrtr());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionPlanGroup") ) {
                final Object value = values.remove("InspectionPlanGroup");
                if( (value == null) || (!value.equals(getInspectionPlanGroup())) ) {
                    setInspectionPlanGroup(((String) value));
                }
            }
            if( values.containsKey("BOOOperationInternalID") ) {
                final Object value = values.remove("BOOOperationInternalID");
                if( (value == null) || (!value.equals(getBOOOperationInternalID())) ) {
                    setBOOOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanInternalVersion") ) {
                final Object value = values.remove("InspectionPlanInternalVersion");
                if( (value == null) || (!value.equals(getInspectionPlanInternalVersion())) ) {
                    setInspectionPlanInternalVersion(((String) value));
                }
            }
            if( values.containsKey("BOOOpInternalVersionCounter") ) {
                final Object value = values.remove("BOOOpInternalVersionCounter");
                if( (value == null) || (!value.equals(getBOOOpInternalVersionCounter())) ) {
                    setBOOOpInternalVersionCounter(((String) value));
                }
            }
            if( values.containsKey("InspectionPlan") ) {
                final Object value = values.remove("InspectionPlan");
                if( (value == null) || (!value.equals(getInspectionPlan())) ) {
                    setInspectionPlan(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("IsImplicitlyDeleted") ) {
                final Object value = values.remove("IsImplicitlyDeleted");
                if( (value == null) || (!value.equals(getIsImplicitlyDeleted())) ) {
                    setIsImplicitlyDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("OperationExternalID") ) {
                final Object value = values.remove("OperationExternalID");
                if( (value == null) || (!value.equals(getOperationExternalID())) ) {
                    setOperationExternalID(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
            if( values.containsKey("OperationStandardTextCode") ) {
                final Object value = values.remove("OperationStandardTextCode");
                if( (value == null) || (!value.equals(getOperationStandardTextCode())) ) {
                    setOperationStandardTextCode(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsRefType") ) {
                final Object value = values.remove("BillOfOperationsRefType");
                if( (value == null) || (!value.equals(getBillOfOperationsRefType())) ) {
                    setBillOfOperationsRefType(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsRefGroup") ) {
                final Object value = values.remove("BillOfOperationsRefGroup");
                if( (value == null) || (!value.equals(getBillOfOperationsRefGroup())) ) {
                    setBillOfOperationsRefGroup(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsRefVariant") ) {
                final Object value = values.remove("BillOfOperationsRefVariant");
                if( (value == null) || (!value.equals(getBillOfOperationsRefVariant())) ) {
                    setBillOfOperationsRefVariant(((String) value));
                }
            }
            if( values.containsKey("InspResultRecordingView") ) {
                final Object value = values.remove("InspResultRecordingView");
                if( (value == null) || (!value.equals(getInspResultRecordingView())) ) {
                    setInspResultRecordingView(((String) value));
                }
            }
            if( values.containsKey("InspSbstCompletionConfirmation") ) {
                final Object value = values.remove("InspSbstCompletionConfirmation");
                if( (value == null) || (!value.equals(getInspSbstCompletionConfirmation())) ) {
                    setInspSbstCompletionConfirmation(((String) value));
                }
            }
            if( values.containsKey("InspSbstHasNoTimeOrQuantity") ) {
                final Object value = values.remove("InspSbstHasNoTimeOrQuantity");
                if( (value == null) || (!value.equals(getInspSbstHasNoTimeOrQuantity())) ) {
                    setInspSbstHasNoTimeOrQuantity(((String) value));
                }
            }
            if( values.containsKey("OperationReferenceQuantity") ) {
                final Object value = values.remove("OperationReferenceQuantity");
                if( (value == null) || (!value.equals(getOperationReferenceQuantity())) ) {
                    setOperationReferenceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OpQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyDnmntr())) ) {
                    setOpQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OpQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOpQtyToBaseQtyNmrtr())) ) {
                    setOpQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspPlanOperationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspPlanOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspPlanOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspPlanOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

}
