/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspectionPlanField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspectionPlanSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inspection Plan Headers
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionPlanType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionPlan extends VdmEntity<InspectionPlan>
{

    /**
     * Selector for all available fields of InspectionPlan.
     *
     */
    public final static InspectionPlanSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static InspectionPlanField<Boolean> DELETE_MC = new InspectionPlanField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static InspectionPlanField<Boolean> UPDATE_MC = new InspectionPlanField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @Key
    @SerializedName( "InspectionPlanGroup" )
    @JsonProperty( "InspectionPlanGroup" )
    @Nullable
    @ODataField( odataName = "InspectionPlanGroup" )
    private String inspectionPlanGroup;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanGroup</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSPECTION_PLAN_GROUP =
        new InspectionPlanField<String>("InspectionPlanGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @return Group Counter
     */
    @Key
    @SerializedName( "InspectionPlan" )
    @JsonProperty( "InspectionPlan" )
    @Nullable
    @ODataField( odataName = "InspectionPlan" )
    private String inspectionPlan;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlan</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSPECTION_PLAN = new InspectionPlanField<String>("InspectionPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "InspectionPlanInternalVersion" )
    @JsonProperty( "InspectionPlanInternalVersion" )
    @Nullable
    @ODataField( odataName = "InspectionPlanInternalVersion" )
    private String inspectionPlanInternalVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPlanInternalVersion</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSPECTION_PLAN_INTERNAL_VERSION =
        new InspectionPlanField<String>("InspectionPlanInternalVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static InspectionPlanField<Boolean> IS_DELETED = new InspectionPlanField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsDesc</b>
     * </p>
     *
     * @return Routing Description
     */
    @SerializedName( "BillOfOperationsDesc" )
    @JsonProperty( "BillOfOperationsDesc" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsDesc" )
    private String billOfOperationsDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsDesc</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> BILL_OF_OPERATIONS_DESC =
        new InspectionPlanField<String>("BillOfOperationsDesc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> PLANT = new InspectionPlanField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @return Task List Usage
     */
    @SerializedName( "BillOfOperationsUsage" )
    @JsonProperty( "BillOfOperationsUsage" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUsage" )
    private String billOfOperationsUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUsage</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> BILL_OF_OPERATIONS_USAGE =
        new InspectionPlanField<String>("BillOfOperationsUsage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsStatus</b>
     * </p>
     *
     * @return Status
     */
    @SerializedName( "BillOfOperationsStatus" )
    @JsonProperty( "BillOfOperationsStatus" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsStatus" )
    private String billOfOperationsStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsStatus</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> BILL_OF_OPERATIONS_STATUS =
        new InspectionPlanField<String>("BillOfOperationsStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     *
     * @return Responsible Planner Group or Department
     */
    @SerializedName( "ResponsiblePlannerGroup" )
    @JsonProperty( "ResponsiblePlannerGroup" )
    @Nullable
    @ODataField( odataName = "ResponsiblePlannerGroup" )
    private String responsiblePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePlannerGroup</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> RESPONSIBLE_PLANNER_GROUP =
        new InspectionPlanField<String>("ResponsiblePlannerGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static InspectionPlanField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new InspectionPlanField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static InspectionPlanField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new InspectionPlanField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @return Task List Unit of Measure
     */
    @SerializedName( "BillOfOperationsUnit" )
    @JsonProperty( "BillOfOperationsUnit" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsUnit" )
    private String billOfOperationsUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsUnit</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> BILL_OF_OPERATIONS_UNIT =
        new InspectionPlanField<String>("BillOfOperationsUnit");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReplacedBillOfOperations</b>
     * </p>
     *
     * @return Old Number
     */
    @SerializedName( "ReplacedBillOfOperations" )
    @JsonProperty( "ReplacedBillOfOperations" )
    @Nullable
    @ODataField( odataName = "ReplacedBillOfOperations" )
    private String replacedBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>ReplacedBillOfOperations</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> REPLACED_BILL_OF_OPERATIONS =
        new InspectionPlanField<String>("ReplacedBillOfOperations");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Indicator: Delete completely in reorganization run
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static InspectionPlanField<Boolean> IS_MARKED_FOR_DELETION =
        new InspectionPlanField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanHasMultipleSpec</b>
     * </p>
     *
     * @return Indicator: Multiple Specifications
     */
    @SerializedName( "InspPlanHasMultipleSpec" )
    @JsonProperty( "InspPlanHasMultipleSpec" )
    @Nullable
    @ODataField( odataName = "InspPlanHasMultipleSpec" )
    private String inspPlanHasMultipleSpec;
    /**
     * Use with available fluent helpers to apply the <b>InspPlanHasMultipleSpec</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSP_PLAN_HAS_MULTIPLE_SPEC =
        new InspectionPlanField<String>("InspPlanHasMultipleSpec");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetFieldCombination</b>
     * </p>
     *
     * @return Identification for the Inspection Point Field Combination
     */
    @SerializedName( "InspSubsetFieldCombination" )
    @JsonProperty( "InspSubsetFieldCombination" )
    @Nullable
    @ODataField( odataName = "InspSubsetFieldCombination" )
    private String inspSubsetFieldCombination;
    /**
     * Use with available fluent helpers to apply the <b>InspSubsetFieldCombination</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSP_SUBSET_FIELD_COMBINATION =
        new InspectionPlanField<String>("InspSubsetFieldCombination");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialLotAssignment</b>
     * </p>
     *
     * @return Partial Lot Assignment in an Inspection During Production
     */
    @SerializedName( "InspectionPartialLotAssignment" )
    @JsonProperty( "InspectionPartialLotAssignment" )
    @Nullable
    @ODataField( odataName = "InspectionPartialLotAssignment" )
    private String inspectionPartialLotAssignment;
    /**
     * Use with available fluent helpers to apply the <b>InspectionPartialLotAssignment</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSPECTION_PARTIAL_LOT_ASSIGNMENT =
        new InspectionPlanField<String>("InspectionPartialLotAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedure</b>
     * </p>
     *
     * @return Sample-Drawing Procedure
     */
    @SerializedName( "SmplDrawingProcedure" )
    @JsonProperty( "SmplDrawingProcedure" )
    @Nullable
    @ODataField( odataName = "SmplDrawingProcedure" )
    private String smplDrawingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>SmplDrawingProcedure</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> SMPL_DRAWING_PROCEDURE =
        new InspectionPlanField<String>("SmplDrawingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedureVersion</b>
     * </p>
     *
     * @return Version No. of the Sample-Drawing Procedure
     */
    @SerializedName( "SmplDrawingProcedureVersion" )
    @JsonProperty( "SmplDrawingProcedureVersion" )
    @Nullable
    @ODataField( odataName = "SmplDrawingProcedureVersion" )
    private String smplDrawingProcedureVersion;
    /**
     * Use with available fluent helpers to apply the <b>SmplDrawingProcedureVersion</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> SMPL_DRAWING_PROCEDURE_VERSION =
        new InspectionPlanField<String>("SmplDrawingProcedureVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotDynamicLevel</b>
     * </p>
     *
     * @return Level at Which Dynamic Modification Parameters Are Defined
     */
    @SerializedName( "InspectionLotDynamicLevel" )
    @JsonProperty( "InspectionLotDynamicLevel" )
    @Nullable
    @ODataField( odataName = "InspectionLotDynamicLevel" )
    private String inspectionLotDynamicLevel;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotDynamicLevel</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSPECTION_LOT_DYNAMIC_LEVEL =
        new InspectionPlanField<String>("InspectionLotDynamicLevel");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicRule</b>
     * </p>
     *
     * @return Dynamic Modification Rule
     */
    @SerializedName( "InspLotDynamicRule" )
    @JsonProperty( "InspLotDynamicRule" )
    @Nullable
    @ODataField( odataName = "InspLotDynamicRule" )
    private String inspLotDynamicRule;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDynamicRule</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSP_LOT_DYNAMIC_RULE =
        new InspectionPlanField<String>("InspLotDynamicRule");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspExternalNumberingOfValues</b>
     * </p>
     *
     * @return External Numbering of Units to Be Inspected
     */
    @SerializedName( "InspExternalNumberingOfValues" )
    @JsonProperty( "InspExternalNumberingOfValues" )
    @Nullable
    @ODataField( odataName = "InspExternalNumberingOfValues" )
    private String inspExternalNumberingOfValues;
    /**
     * Use with available fluent helpers to apply the <b>InspExternalNumberingOfValues</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> INSP_EXTERNAL_NUMBERING_OF_VALUES =
        new InspectionPlanField<String>("InspExternalNumberingOfValues");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static InspectionPlanField<LocalDateTime> CREATION_DATE =
        new InspectionPlanField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> CREATED_BY_USER = new InspectionPlanField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static InspectionPlanField<LocalDateTime> LAST_CHANGE_DATE =
        new InspectionPlanField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> LAST_CHANGED_BY_USER =
        new InspectionPlanField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static InspectionPlanField<String> CHANGE_NUMBER = new InspectionPlanField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspectionPlanField<LocalDateTime> VALIDITY_START_DATE =
        new InspectionPlanField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static InspectionPlanField<LocalDateTime> VALIDITY_END_DATE =
        new InspectionPlanField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static InspectionPlanField<ZonedDateTime> CHANGED_DATE_TIME =
        new InspectionPlanField<ZonedDateTime>("ChangedDateTime");

    @Nonnull
    @Override
    public Class<InspectionPlan> getType()
    {
        return InspectionPlan.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanGroup</b>
     * </p>
     *
     * @param inspectionPlanGroup
     *            Key for Task List Group
     */
    public void setInspectionPlanGroup( @Nullable final String inspectionPlanGroup )
    {
        rememberChangedField("InspectionPlanGroup", this.inspectionPlanGroup);
        this.inspectionPlanGroup = inspectionPlanGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlan</b>
     * </p>
     *
     * @param inspectionPlan
     *            Group Counter
     */
    public void setInspectionPlan( @Nullable final String inspectionPlan )
    {
        rememberChangedField("InspectionPlan", this.inspectionPlan);
        this.inspectionPlan = inspectionPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPlanInternalVersion</b>
     * </p>
     *
     * @param inspectionPlanInternalVersion
     *            Internal counter
     */
    public void setInspectionPlanInternalVersion( @Nullable final String inspectionPlanInternalVersion )
    {
        rememberChangedField("InspectionPlanInternalVersion", this.inspectionPlanInternalVersion);
        this.inspectionPlanInternalVersion = inspectionPlanInternalVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsDesc</b>
     * </p>
     *
     * @param billOfOperationsDesc
     *            Routing Description
     */
    public void setBillOfOperationsDesc( @Nullable final String billOfOperationsDesc )
    {
        rememberChangedField("BillOfOperationsDesc", this.billOfOperationsDesc);
        this.billOfOperationsDesc = billOfOperationsDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUsage</b>
     * </p>
     *
     * @param billOfOperationsUsage
     *            Task List Usage
     */
    public void setBillOfOperationsUsage( @Nullable final String billOfOperationsUsage )
    {
        rememberChangedField("BillOfOperationsUsage", this.billOfOperationsUsage);
        this.billOfOperationsUsage = billOfOperationsUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsStatus</b>
     * </p>
     *
     * @param billOfOperationsStatus
     *            Status
     */
    public void setBillOfOperationsStatus( @Nullable final String billOfOperationsStatus )
    {
        rememberChangedField("BillOfOperationsStatus", this.billOfOperationsStatus);
        this.billOfOperationsStatus = billOfOperationsStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     *
     * @param responsiblePlannerGroup
     *            Responsible Planner Group or Department
     */
    public void setResponsiblePlannerGroup( @Nullable final String responsiblePlannerGroup )
    {
        rememberChangedField("ResponsiblePlannerGroup", this.responsiblePlannerGroup);
        this.responsiblePlannerGroup = responsiblePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsUnit</b>
     * </p>
     *
     * @param billOfOperationsUnit
     *            Task List Unit of Measure
     */
    public void setBillOfOperationsUnit( @Nullable final String billOfOperationsUnit )
    {
        rememberChangedField("BillOfOperationsUnit", this.billOfOperationsUnit);
        this.billOfOperationsUnit = billOfOperationsUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReplacedBillOfOperations</b>
     * </p>
     *
     * @param replacedBillOfOperations
     *            Old Number
     */
    public void setReplacedBillOfOperations( @Nullable final String replacedBillOfOperations )
    {
        rememberChangedField("ReplacedBillOfOperations", this.replacedBillOfOperations);
        this.replacedBillOfOperations = replacedBillOfOperations;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Indicator: Delete completely in reorganization run
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspPlanHasMultipleSpec</b>
     * </p>
     *
     * @param inspPlanHasMultipleSpec
     *            Indicator: Multiple Specifications
     */
    public void setInspPlanHasMultipleSpec( @Nullable final String inspPlanHasMultipleSpec )
    {
        rememberChangedField("InspPlanHasMultipleSpec", this.inspPlanHasMultipleSpec);
        this.inspPlanHasMultipleSpec = inspPlanHasMultipleSpec;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSubsetFieldCombination</b>
     * </p>
     *
     * @param inspSubsetFieldCombination
     *            Identification for the Inspection Point Field Combination
     */
    public void setInspSubsetFieldCombination( @Nullable final String inspSubsetFieldCombination )
    {
        rememberChangedField("InspSubsetFieldCombination", this.inspSubsetFieldCombination);
        this.inspSubsetFieldCombination = inspSubsetFieldCombination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionPartialLotAssignment</b>
     * </p>
     *
     * @param inspectionPartialLotAssignment
     *            Partial Lot Assignment in an Inspection During Production
     */
    public void setInspectionPartialLotAssignment( @Nullable final String inspectionPartialLotAssignment )
    {
        rememberChangedField("InspectionPartialLotAssignment", this.inspectionPartialLotAssignment);
        this.inspectionPartialLotAssignment = inspectionPartialLotAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedure</b>
     * </p>
     *
     * @param smplDrawingProcedure
     *            Sample-Drawing Procedure
     */
    public void setSmplDrawingProcedure( @Nullable final String smplDrawingProcedure )
    {
        rememberChangedField("SmplDrawingProcedure", this.smplDrawingProcedure);
        this.smplDrawingProcedure = smplDrawingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SmplDrawingProcedureVersion</b>
     * </p>
     *
     * @param smplDrawingProcedureVersion
     *            Version No. of the Sample-Drawing Procedure
     */
    public void setSmplDrawingProcedureVersion( @Nullable final String smplDrawingProcedureVersion )
    {
        rememberChangedField("SmplDrawingProcedureVersion", this.smplDrawingProcedureVersion);
        this.smplDrawingProcedureVersion = smplDrawingProcedureVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotDynamicLevel</b>
     * </p>
     *
     * @param inspectionLotDynamicLevel
     *            Level at Which Dynamic Modification Parameters Are Defined
     */
    public void setInspectionLotDynamicLevel( @Nullable final String inspectionLotDynamicLevel )
    {
        rememberChangedField("InspectionLotDynamicLevel", this.inspectionLotDynamicLevel);
        this.inspectionLotDynamicLevel = inspectionLotDynamicLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDynamicRule</b>
     * </p>
     *
     * @param inspLotDynamicRule
     *            Dynamic Modification Rule
     */
    public void setInspLotDynamicRule( @Nullable final String inspLotDynamicRule )
    {
        rememberChangedField("InspLotDynamicRule", this.inspLotDynamicRule);
        this.inspLotDynamicRule = inspLotDynamicRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspExternalNumberingOfValues</b>
     * </p>
     *
     * @param inspExternalNumberingOfValues
     *            External Numbering of Units to Be Inspected
     */
    public void setInspExternalNumberingOfValues( @Nullable final String inspExternalNumberingOfValues )
    {
        rememberChangedField("InspExternalNumberingOfValues", this.inspExternalNumberingOfValues);
        this.inspExternalNumberingOfValues = inspExternalNumberingOfValues;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionPlan";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionPlanGroup", getInspectionPlanGroup());
        result.put("InspectionPlan", getInspectionPlan());
        result.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("InspectionPlanGroup", getInspectionPlanGroup());
        values.put("InspectionPlan", getInspectionPlan());
        values.put("InspectionPlanInternalVersion", getInspectionPlanInternalVersion());
        values.put("IsDeleted", getIsDeleted());
        values.put("BillOfOperationsDesc", getBillOfOperationsDesc());
        values.put("Plant", getPlant());
        values.put("BillOfOperationsUsage", getBillOfOperationsUsage());
        values.put("BillOfOperationsStatus", getBillOfOperationsStatus());
        values.put("ResponsiblePlannerGroup", getResponsiblePlannerGroup());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("BillOfOperationsUnit", getBillOfOperationsUnit());
        values.put("ReplacedBillOfOperations", getReplacedBillOfOperations());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("InspPlanHasMultipleSpec", getInspPlanHasMultipleSpec());
        values.put("InspSubsetFieldCombination", getInspSubsetFieldCombination());
        values.put("InspectionPartialLotAssignment", getInspectionPartialLotAssignment());
        values.put("SmplDrawingProcedure", getSmplDrawingProcedure());
        values.put("SmplDrawingProcedureVersion", getSmplDrawingProcedureVersion());
        values.put("InspectionLotDynamicLevel", getInspectionLotDynamicLevel());
        values.put("InspLotDynamicRule", getInspLotDynamicRule());
        values.put("InspExternalNumberingOfValues", getInspExternalNumberingOfValues());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("InspectionPlanGroup") ) {
                final Object value = values.remove("InspectionPlanGroup");
                if( (value == null) || (!value.equals(getInspectionPlanGroup())) ) {
                    setInspectionPlanGroup(((String) value));
                }
            }
            if( values.containsKey("InspectionPlan") ) {
                final Object value = values.remove("InspectionPlan");
                if( (value == null) || (!value.equals(getInspectionPlan())) ) {
                    setInspectionPlan(((String) value));
                }
            }
            if( values.containsKey("InspectionPlanInternalVersion") ) {
                final Object value = values.remove("InspectionPlanInternalVersion");
                if( (value == null) || (!value.equals(getInspectionPlanInternalVersion())) ) {
                    setInspectionPlanInternalVersion(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("BillOfOperationsDesc") ) {
                final Object value = values.remove("BillOfOperationsDesc");
                if( (value == null) || (!value.equals(getBillOfOperationsDesc())) ) {
                    setBillOfOperationsDesc(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsUsage") ) {
                final Object value = values.remove("BillOfOperationsUsage");
                if( (value == null) || (!value.equals(getBillOfOperationsUsage())) ) {
                    setBillOfOperationsUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsStatus") ) {
                final Object value = values.remove("BillOfOperationsStatus");
                if( (value == null) || (!value.equals(getBillOfOperationsStatus())) ) {
                    setBillOfOperationsStatus(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePlannerGroup") ) {
                final Object value = values.remove("ResponsiblePlannerGroup");
                if( (value == null) || (!value.equals(getResponsiblePlannerGroup())) ) {
                    setResponsiblePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfOperationsUnit") ) {
                final Object value = values.remove("BillOfOperationsUnit");
                if( (value == null) || (!value.equals(getBillOfOperationsUnit())) ) {
                    setBillOfOperationsUnit(((String) value));
                }
            }
            if( values.containsKey("ReplacedBillOfOperations") ) {
                final Object value = values.remove("ReplacedBillOfOperations");
                if( (value == null) || (!value.equals(getReplacedBillOfOperations())) ) {
                    setReplacedBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("InspPlanHasMultipleSpec") ) {
                final Object value = values.remove("InspPlanHasMultipleSpec");
                if( (value == null) || (!value.equals(getInspPlanHasMultipleSpec())) ) {
                    setInspPlanHasMultipleSpec(((String) value));
                }
            }
            if( values.containsKey("InspSubsetFieldCombination") ) {
                final Object value = values.remove("InspSubsetFieldCombination");
                if( (value == null) || (!value.equals(getInspSubsetFieldCombination())) ) {
                    setInspSubsetFieldCombination(((String) value));
                }
            }
            if( values.containsKey("InspectionPartialLotAssignment") ) {
                final Object value = values.remove("InspectionPartialLotAssignment");
                if( (value == null) || (!value.equals(getInspectionPartialLotAssignment())) ) {
                    setInspectionPartialLotAssignment(((String) value));
                }
            }
            if( values.containsKey("SmplDrawingProcedure") ) {
                final Object value = values.remove("SmplDrawingProcedure");
                if( (value == null) || (!value.equals(getSmplDrawingProcedure())) ) {
                    setSmplDrawingProcedure(((String) value));
                }
            }
            if( values.containsKey("SmplDrawingProcedureVersion") ) {
                final Object value = values.remove("SmplDrawingProcedureVersion");
                if( (value == null) || (!value.equals(getSmplDrawingProcedureVersion())) ) {
                    setSmplDrawingProcedureVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionLotDynamicLevel") ) {
                final Object value = values.remove("InspectionLotDynamicLevel");
                if( (value == null) || (!value.equals(getInspectionLotDynamicLevel())) ) {
                    setInspectionLotDynamicLevel(((String) value));
                }
            }
            if( values.containsKey("InspLotDynamicRule") ) {
                final Object value = values.remove("InspLotDynamicRule");
                if( (value == null) || (!value.equals(getInspLotDynamicRule())) ) {
                    setInspLotDynamicRule(((String) value));
                }
            }
            if( values.containsKey("InspExternalNumberingOfValues") ) {
                final Object value = values.remove("InspExternalNumberingOfValues");
                if( (value == null) || (!value.equals(getInspExternalNumberingOfValues())) ) {
                    setInspExternalNumberingOfValues(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InspectionPlanField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionPlanField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionPlanField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionPlanField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

}
