/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable.InspectionPlanSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class InspectionPlanByKeyFluentHelper
    extends
    FluentHelperByKey<InspectionPlanByKeyFluentHelper, InspectionPlan, InspectionPlanSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InspectionPlan}
     * @param servicePath
     *            Service path to be used to fetch a single {@code InspectionPlan}
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public InspectionPlanByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("InspectionPlanGroup", inspectionPlanGroup);
        this.key.put("InspectionPlan", inspectionPlan);
        this.key.put("InspectionPlanInternalVersion", inspectionPlanInternalVersion);
    }

    @Override
    @Nonnull
    protected Class<InspectionPlan> getEntityClass()
    {
        return InspectionPlan.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
