/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link InspectionPlanServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService InspectionPlanService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultInspectionPlanServiceBatch
    extends
    BatchFluentHelperBasic<InspectionPlanServiceBatch, InspectionPlanServiceBatchChangeSet>
    implements
    InspectionPlanServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultInspectionPlanServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultInspectionPlanServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultInspectionPlanServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultInspectionPlanServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultInspectionPlanServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultInspectionPlanServiceBatchChangeSet(this, service);
    }

}
