/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan;

/**
 * Implementation of the {@link InspectionPlanServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService InspectionPlanService}.
 *
 */
public class DefaultInspectionPlanServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<InspectionPlanServiceBatch, InspectionPlanServiceBatchChangeSet>
    implements
    InspectionPlanServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService service;

    @SuppressWarnings( "deprecation" )
    DefaultInspectionPlanServiceBatchChangeSet(
        @Nonnull final DefaultInspectionPlanServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultInspectionPlanServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet createInspectionPlan( @Nonnull final InspectionPlan inspectionPlan )
    {
        return addRequestCreate(service::createInspectionPlan, inspectionPlan);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet updateInspectionPlan( @Nonnull final InspectionPlan inspectionPlan )
    {
        return addRequestUpdate(service::updateInspectionPlan, inspectionPlan);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet deleteInspectionPlan( @Nonnull final InspectionPlan inspectionPlan )
    {
        return addRequestDelete(service::deleteInspectionPlan, inspectionPlan);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet createInspPlanDepdntCharc(
        @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc )
    {
        return addRequestCreate(service::createInspPlanDepdntCharc, inspPlanDepdntCharc);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet updateInspPlanDepdntCharc(
        @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc )
    {
        return addRequestUpdate(service::updateInspPlanDepdntCharc, inspPlanDepdntCharc);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet deleteInspPlanDepdntCharc(
        @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc )
    {
        return addRequestDelete(service::deleteInspPlanDepdntCharc, inspPlanDepdntCharc);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet createInspPlanMaterialAssgmt(
        @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt )
    {
        return addRequestCreate(service::createInspPlanMaterialAssgmt, inspPlanMaterialAssgmt);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet updateInspPlanMaterialAssgmt(
        @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt )
    {
        return addRequestUpdate(service::updateInspPlanMaterialAssgmt, inspPlanMaterialAssgmt);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet deleteInspPlanMaterialAssgmt(
        @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt )
    {
        return addRequestDelete(service::deleteInspPlanMaterialAssgmt, inspPlanMaterialAssgmt);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet createInspPlanOpCharacteristic(
        @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic )
    {
        return addRequestCreate(service::createInspPlanOpCharacteristic, inspPlanOpCharacteristic);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet updateInspPlanOpCharacteristic(
        @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic )
    {
        return addRequestUpdate(service::updateInspPlanOpCharacteristic, inspPlanOpCharacteristic);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet deleteInspPlanOpCharacteristic(
        @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic )
    {
        return addRequestDelete(service::deleteInspPlanOpCharacteristic, inspPlanOpCharacteristic);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet createInspPlanOperation(
        @Nonnull final InspPlanOperation inspPlanOperation )
    {
        return addRequestCreate(service::createInspPlanOperation, inspPlanOperation);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet updateInspPlanOperation(
        @Nonnull final InspPlanOperation inspPlanOperation )
    {
        return addRequestUpdate(service::updateInspPlanOperation, inspPlanOperation);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet deleteInspPlanOperation(
        @Nonnull final InspPlanOperation inspPlanOperation )
    {
        return addRequestDelete(service::deleteInspPlanOperation, inspPlanOperation);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet createInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT )
    {
        return addRequestCreate(service::createInspPlanOpPRT, inspPlanOpPRT);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet updateInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT )
    {
        return addRequestUpdate(service::updateInspPlanOpPRT, inspPlanOpPRT);
    }

    @Nonnull
    @Override
    public InspectionPlanServiceBatchChangeSet deleteInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT )
    {
        return addRequestDelete(service::deleteInspPlanOpPRT, inspPlanOpPRT);
    }

}
