/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.InspectionPlanService InspectionPlanService}.
 *
 */
public interface InspectionPlanServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<InspectionPlanServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<InspectionPlanServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity and save it to the S/4HANA system.
     *
     * @param inspectionPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     *            InspectionPlan} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet createInspectionPlan( @Nonnull final InspectionPlan inspectionPlan );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity and save it to the S/4HANA system.
     *
     * @param inspectionPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     *            InspectionPlan} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet updateInspectionPlan( @Nonnull final InspectionPlan inspectionPlan );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity in the S/4HANA system.
     *
     * @param inspectionPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     *            InspectionPlan} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet deleteInspectionPlan( @Nonnull final InspectionPlan inspectionPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity and save it to the S/4HANA system.
     *
     * @param inspPlanDepdntCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *            InspPlanDepdntCharc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        createInspPlanDepdntCharc( @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity and save it to the S/4HANA system.
     *
     * @param inspPlanDepdntCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *            InspPlanDepdntCharc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        updateInspPlanDepdntCharc( @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity in the S/4HANA system.
     *
     * @param inspPlanDepdntCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *            InspPlanDepdntCharc} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        deleteInspPlanDepdntCharc( @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity and save it to the S/4HANA system.
     *
     * @param inspPlanMaterialAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *            InspPlanMaterialAssgmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        createInspPlanMaterialAssgmt( @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity and save it to the S/4HANA system.
     *
     * @param inspPlanMaterialAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *            InspPlanMaterialAssgmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        updateInspPlanMaterialAssgmt( @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity in the S/4HANA system.
     *
     * @param inspPlanMaterialAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *            InspPlanMaterialAssgmt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        deleteInspPlanMaterialAssgmt( @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *            InspPlanOpCharacteristic} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        createInspPlanOpCharacteristic( @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *            InspPlanOpCharacteristic} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        updateInspPlanOpCharacteristic( @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity in the S/4HANA system.
     *
     * @param inspPlanOpCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *            InspPlanOpCharacteristic} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet
        deleteInspPlanOpCharacteristic( @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *            InspPlanOperation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet createInspPlanOperation( @Nonnull final InspPlanOperation inspPlanOperation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *            InspPlanOperation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet updateInspPlanOperation( @Nonnull final InspPlanOperation inspPlanOperation );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity in the S/4HANA system.
     *
     * @param inspPlanOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *            InspPlanOperation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet deleteInspPlanOperation( @Nonnull final InspPlanOperation inspPlanOperation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpPRT
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet createInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpPRT
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet updateInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity in the S/4HANA system.
     *
     * @param inspPlanOpPRT
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    InspectionPlanServiceBatchChangeSet deleteInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT );

}
