/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc InspPlanDepdntCharc}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanDepdntCharcField
 * InspPlanDepdntCharcField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.link.InspPlanDepdntCharcLink
 * InspPlanDepdntCharcLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSPECTION_PLAN_GROUP
 * INSPECTION_PLAN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSPECTION_PLAN
 * INSPECTION_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSPECTION_PLAN_INTERNAL_VERSION
 * INSPECTION_PLAN_INTERNAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_OPERATION_INTERNAL_ID
 * BOO_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_OP_INTERNAL_VERSION_COUNTER
 * BOO_OP_INTERNAL_VERSION_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_CHARACTERISTIC
 * BOO_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_CHARACTERISTIC_VERSION
 * BOO_CHARACTERISTIC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_DPNDANT_CHARC_SPEC
 * BOO_DPNDANT_CHARC_SPEC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_DPNDANT_CHARC_SPEC_VERS
 * BOO_DPNDANT_CHARC_SPEC_VERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_IS_QUANTITATIVE
 * INSP_SPEC_IS_QUANTITATIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC
 * INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_IS_SELECTED_SET_REQUIRED
 * INSP_SPEC_IS_SELECTED_SET_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSPECTION_SPECIFICATION_TEXT
 * INSPECTION_SPECIFICATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_IS_DEFECT_RECORDING_RQD
 * INSP_SPEC_IS_DEFECT_RECORDING_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#PRODN_RSCE_TOOL_ITEM_NUMBER
 * PRODN_RSCE_TOOL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_SEARCH_TEXT
 * BOO_SEARCH_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#MULTIPLE_SPECIFICATION_OBJECT
 * MULTIPLE_SPECIFICATION_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#MULTIPLE_SPECIFICATION_OBJ_TYPE
 * MULTIPLE_SPECIFICATION_OBJ_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_OPERATION_PRT_INTERNAL_ID
 * BOO_OPERATION_PRT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BILL_OF_OPERATIONS_VARIANT
 * BILL_OF_OPERATIONS_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BOO_TO_MATERIAL_INTERNAL_ID
 * BOO_TO_MATERIAL_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_DECIMAL_PLACES
 * INSP_SPEC_DECIMAL_PLACES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSPECTION_SPECIFICATION_UNIT
 * INSPECTION_SPECIFICATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_TARGET_VALUE
 * INSP_SPEC_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_HAS_TARGET_VALUE
 * INSP_SPEC_HAS_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_UPPER_LIMIT
 * INSP_SPEC_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_LOWER_LIMIT
 * INSP_SPEC_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_HAS_UPPER_LIMIT
 * INSP_SPEC_HAS_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_HAS_LOWER_LIMIT
 * INSP_SPEC_HAS_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_NUMBER_OF_CLASSES
 * INSP_SPEC_NUMBER_OF_CLASSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_CLASS_WIDTH_QTY
 * INSP_SPEC_CLASS_WIDTH_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_HAS_CLASS_WIDTH
 * INSP_SPEC_HAS_CLASS_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_CLASS_MIDPOINT_QTY
 * INSP_SPEC_CLASS_MIDPOINT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_HAS_CLASS_MIDPOINT
 * INSP_SPEC_HAS_CLASS_MIDPOINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CATALOG2
 * INSP_SPEC_ADDITIONAL_CATALOG2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_SELECTED_SET2
 * INSP_SPEC_ADDITIONAL_SELECTED_SET2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CODE_GROUP2
 * INSP_SPEC_ADDITIONAL_CODE_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT2
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CATALOG3
 * INSP_SPEC_ADDITIONAL_CATALOG3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_SELECTED_SET3
 * INSP_SPEC_ADDITIONAL_SELECTED_SET3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CODE_GROUP3
 * INSP_SPEC_ADDITIONAL_CODE_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT3
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CATALOG4
 * INSP_SPEC_ADDITIONAL_CATALOG4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_SELECTED_SET4
 * INSP_SPEC_ADDITIONAL_SELECTED_SET4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CODE_GROUP4
 * INSP_SPEC_ADDITIONAL_CODE_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT4
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CATALOG5
 * INSP_SPEC_ADDITIONAL_CATALOG5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_SELECTED_SET5
 * INSP_SPEC_ADDITIONAL_SELECTED_SET5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDITIONAL_CODE_GROUP5
 * INSP_SPEC_ADDITIONAL_CODE_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT5
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#BILL_OF_OPERATIONS_VERSION
 * BILL_OF_OPERATIONS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspPlanDepdntCharcSelectable extends EntitySelectable<InspPlanDepdntCharc>
{

}
