/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
 * InspPlanMaterialAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanMaterialAssgmtField
 * InspPlanMaterialAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.link.InspPlanMaterialAssgmtLink
 * InspPlanMaterialAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#INSPECTION_PLAN_GROUP
 * INSPECTION_PLAN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#INSPECTION_PLAN
 * INSPECTION_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#INSP_PLAN_MATL_ASSIGNMENT
 * INSP_PLAN_MATL_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#INSP_PLAN_MATL_ASSGMT_INT_VERSION
 * INSP_PLAN_MATL_ASSGMT_INT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#INSPECTION_PLAN_INTERNAL_VERSION
 * INSPECTION_PLAN_INTERNAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#MULTIPLE_SPECIFICATION_OBJECT
 * MULTIPLE_SPECIFICATION_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#MULTIPLE_SPECIFICATION_OBJ_TYPE
 * MULTIPLE_SPECIFICATION_OBJ_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#BOO_SEARCH_TEXT
 * BOO_SEARCH_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspPlanMaterialAssgmtSelectable extends EntitySelectable<InspPlanMaterialAssgmt>
{

}
