/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
 * InspPlanOpCharacteristic}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanOpCharacteristicField
 * InspPlanOpCharacteristicField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.link.InspPlanOpCharacteristicLink
 * InspPlanOpCharacteristicLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_PLAN_GROUP
 * INSPECTION_PLAN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_OPERATION_INTERNAL_ID
 * BOO_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_CHARACTERISTIC
 * BOO_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_CHARACTERISTIC_VERSION
 * BOO_CHARACTERISTIC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_OP_INTERNAL_VERSION_COUNTER
 * BOO_OP_INTERNAL_VERSION_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_PLAN_INTERNAL_VERSION
 * INSPECTION_PLAN_INTERNAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_PLAN
 * INSPECTION_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_OPERATION_PRT_INTERNAL_ID
 * BOO_OPERATION_PRT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_METHOD
 * INSPECTION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_METHOD_VERSION
 * INSPECTION_METHOD_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_METHOD_PLANT
 * INSPECTION_METHOD_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IMPORTANCE_CODE
 * INSP_SPEC_IMPORTANCE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTOR_QUALIFICATION
 * INSPECTOR_QUALIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_SPECIFICATION
 * INSPECTION_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_SPECIFICATION_VERSION
 * INSPECTION_SPECIFICATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_SPECIFICATION_PLANT
 * INSPECTION_SPECIFICATION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_CHARC_HAS_INSP_SPEC_REFERENCE
 * BOO_CHARC_HAS_INSP_SPEC_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#PRODN_RSCE_TOOL_ITEM_NUMBER
 * PRODN_RSCE_TOOL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_CONTROL_INDICATORS
 * INSP_SPEC_CONTROL_INDICATORS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_QUANTITATIVE
 * INSP_SPEC_IS_QUANTITATIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_MEASURED_VALUE_RQD
 * INSP_SPEC_IS_MEASURED_VALUE_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_SELECTED_SET_REQUIRED
 * INSP_SPEC_IS_SELECTED_SET_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_UPPER_LIMIT_REQUIRED
 * INSP_SPEC_IS_UPPER_LIMIT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_LOWER_LIMIT_REQUIRED
 * INSP_SPEC_IS_LOWER_LIMIT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT
 * INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_SCOPE
 * INSPECTION_SCOPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_LONG_TERM_INSPECTION
 * INSP_SPEC_IS_LONG_TERM_INSPECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_RECORDING_TYPE
 * INSP_SPEC_RECORDING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_RESULT_IS_DOCUMENTATION_RQD
 * INSP_RESULT_IS_DOCUMENTATION_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_CHARC_CATEGORY
 * INSP_SPEC_CHARC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE
 * INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_DESTRUCTIVE
 * INSP_SPEC_IS_DESTRUCTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_RESULT_CALCULATION
 * INSP_SPEC_RESULT_CALCULATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_SAMPLING_PROCED_RQD
 * INSP_SPEC_IS_SAMPLING_PROCED_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_SCRAP_RELEVANT
 * INSP_SPEC_IS_SCRAP_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_FIXED_CTRL_INDICATORS
 * INSP_SPEC_HAS_FIXED_CTRL_INDICATORS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_TEST_EQUIPMENT_RQD
 * INSP_SPEC_IS_TEST_EQUIPMENT_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_DEFECT_RECORDING_RQD
 * INSP_SPEC_IS_DEFECT_RECORDING_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC
 * INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_CHG_DOC_REQUIRED
 * INSP_SPEC_IS_CHG_DOC_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_IS_CONTROL_CHART_USED
 * INSP_SPEC_IS_CONTROL_CHART_USED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_PRINT_CONTROL
 * INSP_SPEC_PRINT_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_FIRST_UPPER_SPEC_LIMIT
 * INSP_SPEC_FIRST_UPPER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT
 * INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_FIRST_LOWER_SPEC_LIMIT
 * INSP_SPEC_FIRST_LOWER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT
 * INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_SECOND_UPPER_SPEC_LIMIT
 * INSP_SPEC_SECOND_UPPER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT
 * INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_SECOND_LOWER_SPEC_LIMIT
 * INSP_SPEC_SECOND_LOWER_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT
 * INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_INPUT_PROCEDURE
 * INSP_SPEC_INPUT_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_FORMULA
 * INSP_SPEC_HAS_FORMULA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_FORMULA1
 * INSP_SPEC_FORMULA1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_FORMULA2
 * INSP_SPEC_FORMULA2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_NUMBER_OF_CLASSES
 * INSP_SPEC_NUMBER_OF_CLASSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_CLASS_WIDTH_QTY
 * INSP_SPEC_CLASS_WIDTH_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_CLASS_WIDTH
 * INSP_SPEC_HAS_CLASS_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_CLASS_MIDPOINT_QTY
 * INSP_SPEC_CLASS_MIDPOINT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_CLASS_MIDPOINT
 * INSP_SPEC_HAS_CLASS_MIDPOINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_TOLERANCE_SPECIFICATION
 * INSP_TOLERANCE_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DECIMAL_PLACES
 * INSP_SPEC_DECIMAL_PLACES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_SPECIFICATION_UNIT
 * INSPECTION_SPECIFICATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_TARGET_VALUE
 * INSP_SPEC_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_TARGET_VALUE
 * INSP_SPEC_HAS_TARGET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_UPPER_LIMIT
 * INSP_SPEC_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_LOWER_LIMIT
 * INSP_SPEC_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_LOWER_LIMIT
 * INSP_SPEC_HAS_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_HAS_UPPER_LIMIT
 * INSP_SPEC_HAS_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DEFECT_CODE_GRP_REJECTION
 * INSP_SPEC_DEFECT_CODE_GRP_REJECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DEFECT_CODE_REJECTION
 * INSP_SPEC_DEFECT_CODE_REJECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER
 * INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DEFECT_CODE_RJCN_UPPER
 * INSP_SPEC_DEFECT_CODE_RJCN_UPPER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER
 * INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_DEFECT_CODE_RJCN_LOWER
 * INSP_SPEC_DEFECT_CODE_RJCN_LOWER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#SELECTED_CODE_SET
 * SELECTED_CODE_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#SELECTED_CODE_SET_PLANT
 * SELECTED_CODE_SET_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CATALOG2
 * INSP_SPEC_ADDITIONAL_CATALOG2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_SELECTED_SET2
 * INSP_SPEC_ADDITIONAL_SELECTED_SET2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CODE_GROUP2
 * INSP_SPEC_ADDITIONAL_CODE_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT2
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CATALOG3
 * INSP_SPEC_ADDITIONAL_CATALOG3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_SELECTED_SET3
 * INSP_SPEC_ADDITIONAL_SELECTED_SET3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CODE_GROUP3
 * INSP_SPEC_ADDITIONAL_CODE_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT3
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CATALOG4
 * INSP_SPEC_ADDITIONAL_CATALOG4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_SELECTED_SET4
 * INSP_SPEC_ADDITIONAL_SELECTED_SET4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CODE_GROUP4
 * INSP_SPEC_ADDITIONAL_CODE_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT4
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CATALOG5
 * INSP_SPEC_ADDITIONAL_CATALOG5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_SELECTED_SET5
 * INSP_SPEC_ADDITIONAL_SELECTED_SET5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDITIONAL_CODE_GROUP5
 * INSP_SPEC_ADDITIONAL_CODE_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_ADDL_SELD_CODE_SET_PLANT5
 * INSP_SPEC_ADDL_SELD_CODE_SET_PLANT5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#SAMPLING_PROCEDURE
 * SAMPLING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_CHARACTERISTIC_SAMPLE_UNIT
 * INSP_CHARACTERISTIC_SAMPLE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BOO_CHARC_SAMPLE_QUANTITY
 * BOO_CHARC_SAMPLE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_INFORMATION_FIELD1
 * INSP_SPEC_INFORMATION_FIELD1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_INFORMATION_FIELD2
 * INSP_SPEC_INFORMATION_FIELD2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSP_SPEC_INFORMATION_FIELD3
 * INSP_SPEC_INFORMATION_FIELD3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#INSPECTION_SPECIFICATION_TEXT
 * INSPECTION_SPECIFICATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#BILL_OF_OPERATIONS_VERSION
 * BILL_OF_OPERATIONS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspPlanOpCharacteristicSelectable extends EntitySelectable<InspPlanOpCharacteristic>
{

}
