/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspPlanOpPRTField
 * InspPlanOpPRTField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.link.InspPlanOpPRTLink InspPlanOpPRTLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#DELETE_MC DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#UPDATE_MC UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#INSPECTION_PLAN_GROUP
 * INSPECTION_PLAN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#INSPECTION_PLAN
 * INSPECTION_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#INSPECTION_PLAN_INTERNAL_VERSION
 * INSPECTION_PLAN_INTERNAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#BOO_OP_INTERNAL_VERSION_COUNTER
 * BOO_OP_INTERNAL_VERSION_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#BOO_OPERATION_INTERNAL_ID
 * BOO_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#BOO_OPERATION_PRT_INTERNAL_ID
 * BOO_OPERATION_PRT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#BILL_OF_OPERATIONS_SEQUENCE
 * BILL_OF_OPERATIONS_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#BILL_OF_OPERATIONS_TYPE
 * BILL_OF_OPERATIONS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODUCTION_RESOURCE_TYPE
 * PRODUCTION_RESOURCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODUCTION_RESOURCE_INTERNAL_ID
 * PRODUCTION_RESOURCE_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_CATEGORY_NAME
 * PRODN_RSCE_TOOL_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODUCTION_RESOURCE_TOOL
 * PRODUCTION_RESOURCE_TOOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODUCTION_RESOURCE_TOOL_DESC
 * PRODUCTION_RESOURCE_TOOL_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_CATEGORY
 * PRODN_RSCE_TOOL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#EQUIPMENT_NAME
 * EQUIPMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_ITEM_NUMBER
 * PRODN_RSCE_TOOL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_CONTROL_PROFILE
 * PRODN_RSCE_TOOL_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_STANDARD_TEXT_CODE
 * PRODN_RSCE_TOOL_STANDARD_TEXT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_TEXT
 * PRODN_RSCE_TOOL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#IS_IMPLICITLY_DELETED
 * IS_IMPLICITLY_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT
 * PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_STANDARD_WORK_QTY
 * PRODN_RSCE_TOOL_STANDARD_WORK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA
 * PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT
 * PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_USAGE_QUANTITY
 * PRODN_RSCE_TOOL_USAGE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA
 * PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#START_DATE_OFFSET_REFERENCE_CODE
 * START_DATE_OFFSET_REFERENCE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#START_DATE_OFFSET_DURATION_UNIT
 * START_DATE_OFFSET_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#START_DATE_OFFSET_DURATION
 * START_DATE_OFFSET_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#END_DATE_OFFSET_REFERENCE_CODE
 * END_DATE_OFFSET_REFERENCE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#END_DATE_OFFSET_DURATION_UNIT
 * END_DATE_OFFSET_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#END_DATE_OFFSET_DURATION
 * END_DATE_OFFSET_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#BILL_OF_OPERATIONS_VERSION
 * BILL_OF_OPERATIONS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#DOCUMENT_INFO_RECORD
 * DOCUMENT_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#DOCUMENT_TYPE
 * DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#DOCUMENT_PART
 * DOCUMENT_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#DOCUMENT_VERSION
 * DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspPlanOpPRTSelectable extends EntitySelectable<InspPlanOpPRT>
{

}
