/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.field.InspectionPlanField
 * InspectionPlanField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.link.InspectionPlanLink
 * InspectionPlanLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSPECTION_PLAN_GROUP
 * INSPECTION_PLAN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSPECTION_PLAN
 * INSPECTION_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSPECTION_PLAN_INTERNAL_VERSION
 * INSPECTION_PLAN_INTERNAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#BILL_OF_OPERATIONS_DESC
 * BILL_OF_OPERATIONS_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#BILL_OF_OPERATIONS_USAGE
 * BILL_OF_OPERATIONS_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#BILL_OF_OPERATIONS_STATUS
 * BILL_OF_OPERATIONS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#RESPONSIBLE_PLANNER_GROUP
 * RESPONSIBLE_PLANNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#BILL_OF_OPERATIONS_UNIT
 * BILL_OF_OPERATIONS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#REPLACED_BILL_OF_OPERATIONS
 * REPLACED_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSP_PLAN_HAS_MULTIPLE_SPEC
 * INSP_PLAN_HAS_MULTIPLE_SPEC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSP_SUBSET_FIELD_COMBINATION
 * INSP_SUBSET_FIELD_COMBINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSPECTION_PARTIAL_LOT_ASSIGNMENT
 * INSPECTION_PARTIAL_LOT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#SMPL_DRAWING_PROCEDURE
 * SMPL_DRAWING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#SMPL_DRAWING_PROCEDURE_VERSION
 * SMPL_DRAWING_PROCEDURE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSPECTION_LOT_DYNAMIC_LEVEL
 * INSPECTION_LOT_DYNAMIC_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSP_LOT_DYNAMIC_RULE
 * INSP_LOT_DYNAMIC_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#INSP_EXTERNAL_NUMBERING_OF_VALUES
 * INSP_EXTERNAL_NUMBERING_OF_VALUES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan#CHANGED_DATE_TIME
 * CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface InspectionPlanSelectable extends EntitySelectable<InspectionPlan>
{

}
