/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.selectable.SalesDocumentProposalItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
 * SalesDocumentProposalItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SalesDocumentProposalItemByKeyFluentHelper
    extends
    FluentHelperByKey<SalesDocumentProposalItemByKeyFluentHelper, SalesDocumentProposalItem, SalesDocumentProposalItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
     * SalesDocumentProposalItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesDocumentProposalItem}
     * @param organizationDivision
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param soldToParty
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesOffice
     *            Sales Office
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesDocumentProposalItem}
     * @param salesGroup
     *            Sales Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesDocumentType
     *            Sales Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SalesDocumentProposalItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesOrganization,
        final String distributionChannel,
        final String organizationDivision,
        final String salesGroup,
        final String salesOffice,
        final String soldToParty,
        final String salesDocumentType )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesOrganization", salesOrganization);
        this.key.put("DistributionChannel", distributionChannel);
        this.key.put("OrganizationDivision", organizationDivision);
        this.key.put("SalesGroup", salesGroup);
        this.key.put("SalesOffice", salesOffice);
        this.key.put("SoldToParty", soldToParty);
        this.key.put("SalesDocumentType", salesDocumentType);
    }

    @Override
    @Nonnull
    protected Class<SalesDocumentProposalItem> getEntityClass()
    {
        return SalesDocumentProposalItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
