/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link IntelligentProductProposalServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService
 * IntelligentProductProposalService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultIntelligentProductProposalServiceBatch
    extends
    BatchFluentHelperBasic<IntelligentProductProposalServiceBatch, IntelligentProductProposalServiceBatchChangeSet>
    implements
    IntelligentProductProposalServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultIntelligentProductProposalServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultIntelligentProductProposalServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultIntelligentProductProposalServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultIntelligentProductProposalServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultIntelligentProductProposalServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public IntelligentProductProposalServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultIntelligentProductProposalServiceBatchChangeSet(this, service);
    }

}
