/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link IntelligentProductProposalServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService
 * IntelligentProductProposalService}.
 *
 */
public class DefaultIntelligentProductProposalServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<IntelligentProductProposalServiceBatch, IntelligentProductProposalServiceBatchChangeSet>
    implements
    IntelligentProductProposalServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService service;

    @SuppressWarnings( "deprecation" )
    DefaultIntelligentProductProposalServiceBatchChangeSet(
        @Nonnull final DefaultIntelligentProductProposalServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.IntelligentProductProposalService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultIntelligentProductProposalServiceBatchChangeSet getThis()
    {
        return this;
    }

}
