/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
 * SalesDocumentProposalItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.field.SalesDocumentProposalItemField
 * SalesDocumentProposalItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.link.SalesDocumentProposalItemLink
 * SalesDocumentProposalItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#SALES_DOCUMENT_TYPE
 * SALES_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#ORDER_QUANTITY
 * ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * </ul>
 *
 */
public interface SalesDocumentProposalItemSelectable extends EntitySelectable<SalesDocumentProposalItem>
{

}
