/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.field.AttachmentLinkField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.selectable.AttachmentLinkSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Billing File
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AttachmentLink</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AttachmentLink extends VdmEntity<AttachmentLink>
{

    /**
     * Selector for all available fields of AttachmentLink.
     *
     */
    public final static AttachmentLinkSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return The companyCode contained in this entity.
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> COMPANY_CODE = new AttachmentLinkField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return The fiscalYear contained in this entity.
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> FISCAL_YEAR = new AttachmentLinkField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return The fiscalPeriod contained in this entity.
     */
    @Key
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> FISCAL_PERIOD = new AttachmentLinkField<String>("FiscalPeriod");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartner</b>
     * </p>
     *
     * @return The jointVenturePartner contained in this entity.
     */
    @Key
    @SerializedName( "JointVenturePartner" )
    @JsonProperty( "JointVenturePartner" )
    @Nullable
    @ODataField( odataName = "JointVenturePartner" )
    private String jointVenturePartner;
    /**
     * Use with available fluent helpers to apply the <b>JointVenturePartner</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> JOINT_VENTURE_PARTNER =
        new AttachmentLinkField<String>("JointVenturePartner");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return The documentInfoRecordDocType contained in this entity.
     */
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new AttachmentLinkField<String>("DocumentInfoRecordDocType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return The documentInfoRecordDocNumber contained in this entity.
     */
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new AttachmentLinkField<String>("DocumentInfoRecordDocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return The documentInfoRecordDocVersion contained in this entity.
     */
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new AttachmentLinkField<String>("DocumentInfoRecordDocVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return The documentInfoRecordDocPart contained in this entity.
     */
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new AttachmentLinkField<String>("DocumentInfoRecordDocPart");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>LogicalDocument</b>
     * </p>
     *
     * @return The logicalDocument contained in this entity.
     */
    @SerializedName( "LogicalDocument" )
    @JsonProperty( "LogicalDocument" )
    @Nullable
    @ODataField( odataName = "LogicalDocument" )
    private String logicalDocument;
    /**
     * Use with available fluent helpers to apply the <b>LogicalDocument</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> LOGICAL_DOCUMENT =
        new AttachmentLinkField<String>("LogicalDocument");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveDocumentID</b>
     * </p>
     *
     * @return The archiveDocumentID contained in this entity.
     */
    @SerializedName( "ArchiveDocumentID" )
    @JsonProperty( "ArchiveDocumentID" )
    @Nullable
    @ODataField( odataName = "ArchiveDocumentID" )
    private String archiveDocumentID;
    /**
     * Use with available fluent helpers to apply the <b>ArchiveDocumentID</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> ARCHIVE_DOCUMENT_ID =
        new AttachmentLinkField<String>("ArchiveDocumentID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @return The linkedSAPObjectKey contained in this entity.
     */
    @Key
    @SerializedName( "LinkedSAPObjectKey" )
    @JsonProperty( "LinkedSAPObjectKey" )
    @Nullable
    @ODataField( odataName = "LinkedSAPObjectKey" )
    private String linkedSAPObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>LinkedSAPObjectKey</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> LINKED_SAP_OBJECT_KEY =
        new AttachmentLinkField<String>("LinkedSAPObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectTypeName</b>
     * </p>
     *
     * @return The businessObjectTypeName contained in this entity.
     */
    @SerializedName( "BusinessObjectTypeName" )
    @JsonProperty( "BusinessObjectTypeName" )
    @Nullable
    @ODataField( odataName = "BusinessObjectTypeName" )
    private String businessObjectTypeName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessObjectTypeName</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> BUSINESS_OBJECT_TYPE_NAME =
        new AttachmentLinkField<String>("BusinessObjectTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkstationApplication</b>
     * </p>
     *
     * @return The workstationApplication contained in this entity.
     */
    @SerializedName( "WorkstationApplication" )
    @JsonProperty( "WorkstationApplication" )
    @Nullable
    @ODataField( odataName = "WorkstationApplication" )
    private String workstationApplication;
    /**
     * Use with available fluent helpers to apply the <b>WorkstationApplication</b> field to query operations.
     *
     */
    public final static AttachmentLinkField<String> WORKSTATION_APPLICATION =
        new AttachmentLinkField<String>("WorkstationApplication");

    @Nonnull
    @Override
    public Class<AttachmentLink> getType()
    {
        return AttachmentLink.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            The companyCode to set.
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            The fiscalYear to set.
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            The fiscalPeriod to set.
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartner</b>
     * </p>
     *
     * @param jointVenturePartner
     *            The jointVenturePartner to set.
     */
    public void setJointVenturePartner( @Nullable final String jointVenturePartner )
    {
        rememberChangedField("JointVenturePartner", this.jointVenturePartner);
        this.jointVenturePartner = jointVenturePartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            The documentInfoRecordDocType to set.
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            The documentInfoRecordDocNumber to set.
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            The documentInfoRecordDocVersion to set.
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            The documentInfoRecordDocPart to set.
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>LogicalDocument</b>
     * </p>
     *
     * @param logicalDocument
     *            The logicalDocument to set.
     */
    public void setLogicalDocument( @Nullable final String logicalDocument )
    {
        rememberChangedField("LogicalDocument", this.logicalDocument);
        this.logicalDocument = logicalDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveDocumentID</b>
     * </p>
     *
     * @param archiveDocumentID
     *            The archiveDocumentID to set.
     */
    public void setArchiveDocumentID( @Nullable final String archiveDocumentID )
    {
        rememberChangedField("ArchiveDocumentID", this.archiveDocumentID);
        this.archiveDocumentID = archiveDocumentID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @param linkedSAPObjectKey
     *            The linkedSAPObjectKey to set.
     */
    public void setLinkedSAPObjectKey( @Nullable final String linkedSAPObjectKey )
    {
        rememberChangedField("LinkedSAPObjectKey", this.linkedSAPObjectKey);
        this.linkedSAPObjectKey = linkedSAPObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectTypeName</b>
     * </p>
     *
     * @param businessObjectTypeName
     *            The businessObjectTypeName to set.
     */
    public void setBusinessObjectTypeName( @Nullable final String businessObjectTypeName )
    {
        rememberChangedField("BusinessObjectTypeName", this.businessObjectTypeName);
        this.businessObjectTypeName = businessObjectTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkstationApplication</b>
     * </p>
     *
     * @param workstationApplication
     *            The workstationApplication to set.
     */
    public void setWorkstationApplication( @Nullable final String workstationApplication )
    {
        rememberChangedField("WorkstationApplication", this.workstationApplication);
        this.workstationApplication = workstationApplication;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AttachmentLinkSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("FiscalYear", getFiscalYear());
        result.put("FiscalPeriod", getFiscalPeriod());
        result.put("JointVenturePartner", getJointVenturePartner());
        result.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("JointVenturePartner", getJointVenturePartner());
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("LogicalDocument", getLogicalDocument());
        values.put("ArchiveDocumentID", getArchiveDocumentID());
        values.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        values.put("BusinessObjectTypeName", getBusinessObjectTypeName());
        values.put("WorkstationApplication", getWorkstationApplication());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("JointVenturePartner") ) {
                final Object value = values.remove("JointVenturePartner");
                if( (value == null) || (!value.equals(getJointVenturePartner())) ) {
                    setJointVenturePartner(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("LogicalDocument") ) {
                final Object value = values.remove("LogicalDocument");
                if( (value == null) || (!value.equals(getLogicalDocument())) ) {
                    setLogicalDocument(((String) value));
                }
            }
            if( values.containsKey("ArchiveDocumentID") ) {
                final Object value = values.remove("ArchiveDocumentID");
                if( (value == null) || (!value.equals(getArchiveDocumentID())) ) {
                    setArchiveDocumentID(((String) value));
                }
            }
            if( values.containsKey("LinkedSAPObjectKey") ) {
                final Object value = values.remove("LinkedSAPObjectKey");
                if( (value == null) || (!value.equals(getLinkedSAPObjectKey())) ) {
                    setLinkedSAPObjectKey(((String) value));
                }
            }
            if( values.containsKey("BusinessObjectTypeName") ) {
                final Object value = values.remove("BusinessObjectTypeName");
                if( (value == null) || (!value.equals(getBusinessObjectTypeName())) ) {
                    setBusinessObjectTypeName(((String) value));
                }
            }
            if( values.containsKey("WorkstationApplication") ) {
                final Object value = values.remove("WorkstationApplication");
                if( (value == null) || (!value.equals(getWorkstationApplication())) ) {
                    setWorkstationApplication(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> AttachmentLinkField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AttachmentLinkField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AttachmentLinkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AttachmentLinkField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JointVentureBillingService.DEFAULT_SERVICE_PATH);
    }

}
