/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link JointVentureBillingServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.JointVentureBillingService JointVentureBillingService}.
 *
 */
public class DefaultJointVentureBillingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<JointVentureBillingServiceBatch, JointVentureBillingServiceBatchChangeSet>
    implements
    JointVentureBillingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JointVentureBillingService service;

    @SuppressWarnings( "deprecation" )
    DefaultJointVentureBillingServiceBatchChangeSet(
        @Nonnull final DefaultJointVentureBillingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JointVentureBillingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultJointVentureBillingServiceBatchChangeSet getThis()
    {
        return this;
    }

}
