/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink AttachmentLink}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.field.AttachmentLinkField
 * AttachmentLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.link.AttachmentLinkLink
 * AttachmentLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#JOINT_VENTURE_PARTNER
 * JOINT_VENTURE_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#LOGICAL_DOCUMENT
 * LOGICAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#ARCHIVE_DOCUMENT_ID
 * ARCHIVE_DOCUMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#LINKED_SAP_OBJECT_KEY
 * LINKED_SAP_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#BUSINESS_OBJECT_TYPE_NAME
 * BUSINESS_OBJECT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink#WORKSTATION_APPLICATION
 * WORKSTATION_APPLICATION}</li>
 * </ul>
 *
 */
public interface AttachmentLinkSelectable extends EntitySelectable<AttachmentLink>
{

}
