/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.field.CostCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.selectable.CostCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Cost Center Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CostCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenter extends VdmEntity<CostCenter>
{

    /**
     * Selector for all available fields of CostCenter.
     *
     */
    public final static CostCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostCenterField<String> CONTROLLING_AREA = new CostCenterField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @Key
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER = new CostCenterField<String>("CostCenter");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CostCenterField<LocalDateTime> VALIDITY_END_DATE =
        new CostCenterField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CostCenterField<LocalDateTime> VALIDITY_START_DATE =
        new CostCenterField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COMPANY_CODE = new CostCenterField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static CostCenterField<String> BUSINESS_AREA = new CostCenterField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrResponsiblePersonName</b>
     * </p>
     *
     * @return Person Responsible
     */
    @SerializedName( "CostCtrResponsiblePersonName" )
    @JsonProperty( "CostCtrResponsiblePersonName" )
    @Nullable
    @ODataField( odataName = "CostCtrResponsiblePersonName" )
    private String costCtrResponsiblePersonName;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrResponsiblePersonName</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CTR_RESPONSIBLE_PERSON_NAME =
        new CostCenterField<String>("CostCtrResponsiblePersonName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrResponsibleUser</b>
     * </p>
     *
     * @return User Responsible
     */
    @SerializedName( "CostCtrResponsibleUser" )
    @JsonProperty( "CostCtrResponsibleUser" )
    @Nullable
    @ODataField( odataName = "CostCtrResponsibleUser" )
    private String costCtrResponsibleUser;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrResponsibleUser</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CTR_RESPONSIBLE_USER =
        new CostCenterField<String>("CostCtrResponsibleUser");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CostCenterCurrency" )
    @JsonProperty( "CostCenterCurrency" )
    @Nullable
    @ODataField( odataName = "CostCenterCurrency" )
    private String costCenterCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterCurrency</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_CURRENCY =
        new CostCenterField<String>("CostCenterCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static CostCenterField<String> PROFIT_CENTER = new CostCenterField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Department</b>
     * </p>
     *
     * @return Department
     */
    @SerializedName( "Department" )
    @JsonProperty( "Department" )
    @Nullable
    @ODataField( odataName = "Department" )
    private String department;
    /**
     * Use with available fluent helpers to apply the <b>Department</b> field to query operations.
     *
     */
    public final static CostCenterField<String> DEPARTMENT = new CostCenterField<String>("Department");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @return Costing Sheet
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COSTING_SHEET = new CostCenterField<String>("CostingSheet");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static CostCenterField<String> FUNCTIONAL_AREA = new CostCenterField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COUNTRY = new CostCenterField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static CostCenterField<String> REGION = new CostCenterField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static CostCenterField<String> CITY_NAME = new CostCenterField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterStandardHierArea</b>
     * </p>
     *
     * @return Standard Hierarchy Area
     */
    @SerializedName( "CostCenterStandardHierArea" )
    @JsonProperty( "CostCenterStandardHierArea" )
    @Nullable
    @ODataField( odataName = "CostCenterStandardHierArea" )
    private String costCenterStandardHierArea;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterStandardHierArea</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_STANDARD_HIER_AREA =
        new CostCenterField<String>("CostCenterStandardHierArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCategory</b>
     * </p>
     *
     * @return Cost Center Category
     */
    @SerializedName( "CostCenterCategory" )
    @JsonProperty( "CostCenterCategory" )
    @Nullable
    @ODataField( odataName = "CostCenterCategory" )
    private String costCenterCategory;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterCategory</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_CATEGORY =
        new CostCenterField<String>("CostCenterCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlkdForPrimaryCostsPosting</b>
     * </p>
     *
     * @return Lock Indicator for Actual Primary Postings
     */
    @SerializedName( "IsBlkdForPrimaryCostsPosting" )
    @JsonProperty( "IsBlkdForPrimaryCostsPosting" )
    @Nullable
    @ODataField( odataName = "IsBlkdForPrimaryCostsPosting" )
    private String isBlkdForPrimaryCostsPosting;
    /**
     * Use with available fluent helpers to apply the <b>IsBlkdForPrimaryCostsPosting</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLKD_FOR_PRIMARY_COSTS_POSTING =
        new CostCenterField<String>("IsBlkdForPrimaryCostsPosting");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlkdForSecondaryCostsPosting</b>
     * </p>
     *
     * @return Lock Indicator for Actual Secondary Costs
     */
    @SerializedName( "IsBlkdForSecondaryCostsPosting" )
    @JsonProperty( "IsBlkdForSecondaryCostsPosting" )
    @Nullable
    @ODataField( odataName = "IsBlkdForSecondaryCostsPosting" )
    private String isBlkdForSecondaryCostsPosting;
    /**
     * Use with available fluent helpers to apply the <b>IsBlkdForSecondaryCostsPosting</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLKD_FOR_SECONDARY_COSTS_POSTING =
        new CostCenterField<String>("IsBlkdForSecondaryCostsPosting");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForRevenuePosting</b>
     * </p>
     *
     * @return Lock Indicator for Actual Revenue Postings
     */
    @SerializedName( "IsBlockedForRevenuePosting" )
    @JsonProperty( "IsBlockedForRevenuePosting" )
    @Nullable
    @ODataField( odataName = "IsBlockedForRevenuePosting" )
    private String isBlockedForRevenuePosting;
    /**
     * Use with available fluent helpers to apply the <b>IsBlockedForRevenuePosting</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLOCKED_FOR_REVENUE_POSTING =
        new CostCenterField<String>("IsBlockedForRevenuePosting");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForCommitmentPosting</b>
     * </p>
     *
     * @return Lock Indicator for Commitment Update
     */
    @SerializedName( "IsBlockedForCommitmentPosting" )
    @JsonProperty( "IsBlockedForCommitmentPosting" )
    @Nullable
    @ODataField( odataName = "IsBlockedForCommitmentPosting" )
    private String isBlockedForCommitmentPosting;
    /**
     * Use with available fluent helpers to apply the <b>IsBlockedForCommitmentPosting</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLOCKED_FOR_COMMITMENT_POSTING =
        new CostCenterField<String>("IsBlockedForCommitmentPosting");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForPlanPrimaryCosts</b>
     * </p>
     *
     * @return Lock Indicator for Plan Primary Costs
     */
    @SerializedName( "IsBlockedForPlanPrimaryCosts" )
    @JsonProperty( "IsBlockedForPlanPrimaryCosts" )
    @Nullable
    @ODataField( odataName = "IsBlockedForPlanPrimaryCosts" )
    private String isBlockedForPlanPrimaryCosts;
    /**
     * Use with available fluent helpers to apply the <b>IsBlockedForPlanPrimaryCosts</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLOCKED_FOR_PLAN_PRIMARY_COSTS =
        new CostCenterField<String>("IsBlockedForPlanPrimaryCosts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForPlanSecondaryCosts</b>
     * </p>
     *
     * @return Lock Indicator for Plan Secondary Costs
     */
    @SerializedName( "IsBlockedForPlanSecondaryCosts" )
    @JsonProperty( "IsBlockedForPlanSecondaryCosts" )
    @Nullable
    @ODataField( odataName = "IsBlockedForPlanSecondaryCosts" )
    private String isBlockedForPlanSecondaryCosts;
    /**
     * Use with available fluent helpers to apply the <b>IsBlockedForPlanSecondaryCosts</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLOCKED_FOR_PLAN_SECONDARY_COSTS =
        new CostCenterField<String>("IsBlockedForPlanSecondaryCosts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForPlanRevenues</b>
     * </p>
     *
     * @return Lock Indicator for Planning Revenues
     */
    @SerializedName( "IsBlockedForPlanRevenues" )
    @JsonProperty( "IsBlockedForPlanRevenues" )
    @Nullable
    @ODataField( odataName = "IsBlockedForPlanRevenues" )
    private String isBlockedForPlanRevenues;
    /**
     * Use with available fluent helpers to apply the <b>IsBlockedForPlanRevenues</b> field to query operations.
     *
     */
    public final static CostCenterField<String> IS_BLOCKED_FOR_PLAN_REVENUES =
        new CostCenterField<String>("IsBlockedForPlanRevenues");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionQtyIsRecorded</b>
     * </p>
     *
     * @return Indicator for Recording Consumption Quantities
     */
    @SerializedName( "ConsumptionQtyIsRecorded" )
    @JsonProperty( "ConsumptionQtyIsRecorded" )
    @Nullable
    @ODataField( odataName = "ConsumptionQtyIsRecorded" )
    private String consumptionQtyIsRecorded;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionQtyIsRecorded</b> field to query operations.
     *
     */
    public final static CostCenterField<String> CONSUMPTION_QTY_IS_RECORDED =
        new CostCenterField<String>("ConsumptionQtyIsRecorded");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CostCenterField<String> LANGUAGE = new CostCenterField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCreatedByUser</b>
     * </p>
     *
     * @return Entered By
     */
    @SerializedName( "CostCenterCreatedByUser" )
    @JsonProperty( "CostCenterCreatedByUser" )
    @Nullable
    @ODataField( odataName = "CostCenterCreatedByUser" )
    private String costCenterCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterCreatedByUser</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_CREATED_BY_USER =
        new CostCenterField<String>("CostCenterCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCreationDate</b>
     * </p>
     *
     * @return Created on
     */
    @SerializedName( "CostCenterCreationDate" )
    @JsonProperty( "CostCenterCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CostCenterCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime costCenterCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterCreationDate</b> field to query operations.
     *
     */
    public final static CostCenterField<LocalDateTime> COST_CENTER_CREATION_DATE =
        new CostCenterField<LocalDateTime>("CostCenterCreationDate");

    @Nonnull
    @Override
    public Class<CostCenter> getType()
    {
        return CostCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrResponsiblePersonName</b>
     * </p>
     *
     * @param costCtrResponsiblePersonName
     *            Person Responsible
     */
    public void setCostCtrResponsiblePersonName( @Nullable final String costCtrResponsiblePersonName )
    {
        rememberChangedField("CostCtrResponsiblePersonName", this.costCtrResponsiblePersonName);
        this.costCtrResponsiblePersonName = costCtrResponsiblePersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrResponsibleUser</b>
     * </p>
     *
     * @param costCtrResponsibleUser
     *            User Responsible
     */
    public void setCostCtrResponsibleUser( @Nullable final String costCtrResponsibleUser )
    {
        rememberChangedField("CostCtrResponsibleUser", this.costCtrResponsibleUser);
        this.costCtrResponsibleUser = costCtrResponsibleUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCurrency</b>
     * </p>
     *
     * @param costCenterCurrency
     *            Currency Key
     */
    public void setCostCenterCurrency( @Nullable final String costCenterCurrency )
    {
        rememberChangedField("CostCenterCurrency", this.costCenterCurrency);
        this.costCenterCurrency = costCenterCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Department</b>
     * </p>
     *
     * @param department
     *            Department
     */
    public void setDepartment( @Nullable final String department )
    {
        rememberChangedField("Department", this.department);
        this.department = department;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @param costingSheet
     *            Costing Sheet
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterStandardHierArea</b>
     * </p>
     *
     * @param costCenterStandardHierArea
     *            Standard Hierarchy Area
     */
    public void setCostCenterStandardHierArea( @Nullable final String costCenterStandardHierArea )
    {
        rememberChangedField("CostCenterStandardHierArea", this.costCenterStandardHierArea);
        this.costCenterStandardHierArea = costCenterStandardHierArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCategory</b>
     * </p>
     *
     * @param costCenterCategory
     *            Cost Center Category
     */
    public void setCostCenterCategory( @Nullable final String costCenterCategory )
    {
        rememberChangedField("CostCenterCategory", this.costCenterCategory);
        this.costCenterCategory = costCenterCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlkdForPrimaryCostsPosting</b>
     * </p>
     *
     * @param isBlkdForPrimaryCostsPosting
     *            Lock Indicator for Actual Primary Postings
     */
    public void setIsBlkdForPrimaryCostsPosting( @Nullable final String isBlkdForPrimaryCostsPosting )
    {
        rememberChangedField("IsBlkdForPrimaryCostsPosting", this.isBlkdForPrimaryCostsPosting);
        this.isBlkdForPrimaryCostsPosting = isBlkdForPrimaryCostsPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlkdForSecondaryCostsPosting</b>
     * </p>
     *
     * @param isBlkdForSecondaryCostsPosting
     *            Lock Indicator for Actual Secondary Costs
     */
    public void setIsBlkdForSecondaryCostsPosting( @Nullable final String isBlkdForSecondaryCostsPosting )
    {
        rememberChangedField("IsBlkdForSecondaryCostsPosting", this.isBlkdForSecondaryCostsPosting);
        this.isBlkdForSecondaryCostsPosting = isBlkdForSecondaryCostsPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForRevenuePosting</b>
     * </p>
     *
     * @param isBlockedForRevenuePosting
     *            Lock Indicator for Actual Revenue Postings
     */
    public void setIsBlockedForRevenuePosting( @Nullable final String isBlockedForRevenuePosting )
    {
        rememberChangedField("IsBlockedForRevenuePosting", this.isBlockedForRevenuePosting);
        this.isBlockedForRevenuePosting = isBlockedForRevenuePosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForCommitmentPosting</b>
     * </p>
     *
     * @param isBlockedForCommitmentPosting
     *            Lock Indicator for Commitment Update
     */
    public void setIsBlockedForCommitmentPosting( @Nullable final String isBlockedForCommitmentPosting )
    {
        rememberChangedField("IsBlockedForCommitmentPosting", this.isBlockedForCommitmentPosting);
        this.isBlockedForCommitmentPosting = isBlockedForCommitmentPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForPlanPrimaryCosts</b>
     * </p>
     *
     * @param isBlockedForPlanPrimaryCosts
     *            Lock Indicator for Plan Primary Costs
     */
    public void setIsBlockedForPlanPrimaryCosts( @Nullable final String isBlockedForPlanPrimaryCosts )
    {
        rememberChangedField("IsBlockedForPlanPrimaryCosts", this.isBlockedForPlanPrimaryCosts);
        this.isBlockedForPlanPrimaryCosts = isBlockedForPlanPrimaryCosts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForPlanSecondaryCosts</b>
     * </p>
     *
     * @param isBlockedForPlanSecondaryCosts
     *            Lock Indicator for Plan Secondary Costs
     */
    public void setIsBlockedForPlanSecondaryCosts( @Nullable final String isBlockedForPlanSecondaryCosts )
    {
        rememberChangedField("IsBlockedForPlanSecondaryCosts", this.isBlockedForPlanSecondaryCosts);
        this.isBlockedForPlanSecondaryCosts = isBlockedForPlanSecondaryCosts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBlockedForPlanRevenues</b>
     * </p>
     *
     * @param isBlockedForPlanRevenues
     *            Lock Indicator for Planning Revenues
     */
    public void setIsBlockedForPlanRevenues( @Nullable final String isBlockedForPlanRevenues )
    {
        rememberChangedField("IsBlockedForPlanRevenues", this.isBlockedForPlanRevenues);
        this.isBlockedForPlanRevenues = isBlockedForPlanRevenues;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionQtyIsRecorded</b>
     * </p>
     *
     * @param consumptionQtyIsRecorded
     *            Indicator for Recording Consumption Quantities
     */
    public void setConsumptionQtyIsRecorded( @Nullable final String consumptionQtyIsRecorded )
    {
        rememberChangedField("ConsumptionQtyIsRecorded", this.consumptionQtyIsRecorded);
        this.consumptionQtyIsRecorded = consumptionQtyIsRecorded;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCreatedByUser</b>
     * </p>
     *
     * @param costCenterCreatedByUser
     *            Entered By
     */
    public void setCostCenterCreatedByUser( @Nullable final String costCenterCreatedByUser )
    {
        rememberChangedField("CostCenterCreatedByUser", this.costCenterCreatedByUser);
        this.costCenterCreatedByUser = costCenterCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterCreationDate</b>
     * </p>
     *
     * @param costCenterCreationDate
     *            Created on
     */
    public void setCostCenterCreationDate( @Nullable final LocalDateTime costCenterCreationDate )
    {
        rememberChangedField("CostCenterCreationDate", this.costCenterCreationDate);
        this.costCenterCreationDate = costCenterCreationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CostCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea", getControllingArea());
        result.put("CostCenter", getCostCenter());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenter", getCostCenter());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("CostCtrResponsiblePersonName", getCostCtrResponsiblePersonName());
        values.put("CostCtrResponsibleUser", getCostCtrResponsibleUser());
        values.put("CostCenterCurrency", getCostCenterCurrency());
        values.put("ProfitCenter", getProfitCenter());
        values.put("Department", getDepartment());
        values.put("CostingSheet", getCostingSheet());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("Country", getCountry());
        values.put("Region", getRegion());
        values.put("CityName", getCityName());
        values.put("CostCenterStandardHierArea", getCostCenterStandardHierArea());
        values.put("CostCenterCategory", getCostCenterCategory());
        values.put("IsBlkdForPrimaryCostsPosting", getIsBlkdForPrimaryCostsPosting());
        values.put("IsBlkdForSecondaryCostsPosting", getIsBlkdForSecondaryCostsPosting());
        values.put("IsBlockedForRevenuePosting", getIsBlockedForRevenuePosting());
        values.put("IsBlockedForCommitmentPosting", getIsBlockedForCommitmentPosting());
        values.put("IsBlockedForPlanPrimaryCosts", getIsBlockedForPlanPrimaryCosts());
        values.put("IsBlockedForPlanSecondaryCosts", getIsBlockedForPlanSecondaryCosts());
        values.put("IsBlockedForPlanRevenues", getIsBlockedForPlanRevenues());
        values.put("ConsumptionQtyIsRecorded", getConsumptionQtyIsRecorded());
        values.put("Language", getLanguage());
        values.put("CostCenterCreatedByUser", getCostCenterCreatedByUser());
        values.put("CostCenterCreationDate", getCostCenterCreationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CostCtrResponsiblePersonName") ) {
                final Object value = values.remove("CostCtrResponsiblePersonName");
                if( (value == null) || (!value.equals(getCostCtrResponsiblePersonName())) ) {
                    setCostCtrResponsiblePersonName(((String) value));
                }
            }
            if( values.containsKey("CostCtrResponsibleUser") ) {
                final Object value = values.remove("CostCtrResponsibleUser");
                if( (value == null) || (!value.equals(getCostCtrResponsibleUser())) ) {
                    setCostCtrResponsibleUser(((String) value));
                }
            }
            if( values.containsKey("CostCenterCurrency") ) {
                final Object value = values.remove("CostCenterCurrency");
                if( (value == null) || (!value.equals(getCostCenterCurrency())) ) {
                    setCostCenterCurrency(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("Department") ) {
                final Object value = values.remove("Department");
                if( (value == null) || (!value.equals(getDepartment())) ) {
                    setDepartment(((String) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("CostCenterStandardHierArea") ) {
                final Object value = values.remove("CostCenterStandardHierArea");
                if( (value == null) || (!value.equals(getCostCenterStandardHierArea())) ) {
                    setCostCenterStandardHierArea(((String) value));
                }
            }
            if( values.containsKey("CostCenterCategory") ) {
                final Object value = values.remove("CostCenterCategory");
                if( (value == null) || (!value.equals(getCostCenterCategory())) ) {
                    setCostCenterCategory(((String) value));
                }
            }
            if( values.containsKey("IsBlkdForPrimaryCostsPosting") ) {
                final Object value = values.remove("IsBlkdForPrimaryCostsPosting");
                if( (value == null) || (!value.equals(getIsBlkdForPrimaryCostsPosting())) ) {
                    setIsBlkdForPrimaryCostsPosting(((String) value));
                }
            }
            if( values.containsKey("IsBlkdForSecondaryCostsPosting") ) {
                final Object value = values.remove("IsBlkdForSecondaryCostsPosting");
                if( (value == null) || (!value.equals(getIsBlkdForSecondaryCostsPosting())) ) {
                    setIsBlkdForSecondaryCostsPosting(((String) value));
                }
            }
            if( values.containsKey("IsBlockedForRevenuePosting") ) {
                final Object value = values.remove("IsBlockedForRevenuePosting");
                if( (value == null) || (!value.equals(getIsBlockedForRevenuePosting())) ) {
                    setIsBlockedForRevenuePosting(((String) value));
                }
            }
            if( values.containsKey("IsBlockedForCommitmentPosting") ) {
                final Object value = values.remove("IsBlockedForCommitmentPosting");
                if( (value == null) || (!value.equals(getIsBlockedForCommitmentPosting())) ) {
                    setIsBlockedForCommitmentPosting(((String) value));
                }
            }
            if( values.containsKey("IsBlockedForPlanPrimaryCosts") ) {
                final Object value = values.remove("IsBlockedForPlanPrimaryCosts");
                if( (value == null) || (!value.equals(getIsBlockedForPlanPrimaryCosts())) ) {
                    setIsBlockedForPlanPrimaryCosts(((String) value));
                }
            }
            if( values.containsKey("IsBlockedForPlanSecondaryCosts") ) {
                final Object value = values.remove("IsBlockedForPlanSecondaryCosts");
                if( (value == null) || (!value.equals(getIsBlockedForPlanSecondaryCosts())) ) {
                    setIsBlockedForPlanSecondaryCosts(((String) value));
                }
            }
            if( values.containsKey("IsBlockedForPlanRevenues") ) {
                final Object value = values.remove("IsBlockedForPlanRevenues");
                if( (value == null) || (!value.equals(getIsBlockedForPlanRevenues())) ) {
                    setIsBlockedForPlanRevenues(((String) value));
                }
            }
            if( values.containsKey("ConsumptionQtyIsRecorded") ) {
                final Object value = values.remove("ConsumptionQtyIsRecorded");
                if( (value == null) || (!value.equals(getConsumptionQtyIsRecorded())) ) {
                    setConsumptionQtyIsRecorded(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCenterCreatedByUser") ) {
                final Object value = values.remove("CostCenterCreatedByUser");
                if( (value == null) || (!value.equals(getCostCenterCreatedByUser())) ) {
                    setCostCenterCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CostCenterCreationDate") ) {
                final Object value = values.remove("CostCenterCreationDate");
                if( (value == null) || (!value.equals(getCostCenterCreationDate())) ) {
                    setCostCenterCreationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JournalEntryItemService.DEFAULT_SERVICE_PATH);
    }

}
