/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.field.GLAccountInChartOfAccountsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.selectable.GLAccountInChartOfAccountsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * General Ledger Account in Chart of Accounts Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_GLAccountInChartOfAccountsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccountInChartOfAccounts extends VdmEntity<GLAccountInChartOfAccounts>
{

    /**
     * Selector for all available fields of GLAccountInChartOfAccounts.
     *
     */
    public final static GLAccountInChartOfAccountsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> CHART_OF_ACCOUNTS =
        new GLAccountInChartOfAccountsField<String>("ChartOfAccounts");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @Key
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> GL_ACCOUNT =
        new GLAccountInChartOfAccountsField<String>("GLAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @return Indicator: Account is a balance sheet account?
     */
    @SerializedName( "IsBalanceSheetAccount" )
    @JsonProperty( "IsBalanceSheetAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBalanceSheetAccount" )
    private Boolean isBalanceSheetAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccount</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<Boolean> IS_BALANCE_SHEET_ACCOUNT =
        new GLAccountInChartOfAccountsField<Boolean>("IsBalanceSheetAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountGroup</b>
     * </p>
     *
     * @return G/L Account Group
     */
    @SerializedName( "GLAccountGroup" )
    @JsonProperty( "GLAccountGroup" )
    @Nullable
    @ODataField( odataName = "GLAccountGroup" )
    private String gLAccountGroup;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountGroup</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> GL_ACCOUNT_GROUP =
        new GLAccountInChartOfAccountsField<String>("GLAccountGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @return Group Account Number
     */
    @SerializedName( "CorporateGroupAccount" )
    @JsonProperty( "CorporateGroupAccount" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount" )
    private String corporateGroupAccount;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> CORPORATE_GROUP_ACCOUNT =
        new GLAccountInChartOfAccountsField<String>("CorporateGroupAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProfitLossAccountType</b>
     * </p>
     *
     * @return P&L statement account type
     */
    @SerializedName( "ProfitLossAccountType" )
    @JsonProperty( "ProfitLossAccountType" )
    @Nullable
    @ODataField( odataName = "ProfitLossAccountType" )
    private String profitLossAccountType;
    /**
     * Use with available fluent helpers to apply the <b>ProfitLossAccountType</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> PROFIT_LOSS_ACCOUNT_TYPE =
        new GLAccountInChartOfAccountsField<String>("ProfitLossAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SampleGLAccount</b>
     * </p>
     *
     * @return Number of the sample account
     */
    @SerializedName( "SampleGLAccount" )
    @JsonProperty( "SampleGLAccount" )
    @Nullable
    @ODataField( odataName = "SampleGLAccount" )
    private String sampleGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>SampleGLAccount</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> SAMPLE_GL_ACCOUNT =
        new GLAccountInChartOfAccountsField<String>("SampleGLAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsMarkedForDeletion</b>
     * </p>
     *
     * @return Indicator: Account Marked for Deletion?
     */
    @SerializedName( "AccountIsMarkedForDeletion" )
    @JsonProperty( "AccountIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AccountIsMarkedForDeletion" )
    private Boolean accountIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>AccountIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<Boolean> ACCOUNT_IS_MARKED_FOR_DELETION =
        new GLAccountInChartOfAccountsField<Boolean>("AccountIsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsBlockedForCreation</b>
     * </p>
     *
     * @return Indicator: account is blocked for creation ?
     */
    @SerializedName( "AccountIsBlockedForCreation" )
    @JsonProperty( "AccountIsBlockedForCreation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AccountIsBlockedForCreation" )
    private Boolean accountIsBlockedForCreation;
    /**
     * Use with available fluent helpers to apply the <b>AccountIsBlockedForCreation</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<Boolean> ACCOUNT_IS_BLOCKED_FOR_CREATION =
        new GLAccountInChartOfAccountsField<Boolean>("AccountIsBlockedForCreation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsBlockedForPosting</b>
     * </p>
     *
     * @return Indicator: Is Account Blocked for Posting?
     */
    @SerializedName( "AccountIsBlockedForPosting" )
    @JsonProperty( "AccountIsBlockedForPosting" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AccountIsBlockedForPosting" )
    private Boolean accountIsBlockedForPosting;
    /**
     * Use with available fluent helpers to apply the <b>AccountIsBlockedForPosting</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<Boolean> ACCOUNT_IS_BLOCKED_FOR_POSTING =
        new GLAccountInChartOfAccountsField<Boolean>("AccountIsBlockedForPosting");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsBlockedForPlanning</b>
     * </p>
     *
     * @return Indicator: account blocked for planning ?
     */
    @SerializedName( "AccountIsBlockedForPlanning" )
    @JsonProperty( "AccountIsBlockedForPlanning" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AccountIsBlockedForPlanning" )
    private Boolean accountIsBlockedForPlanning;
    /**
     * Use with available fluent helpers to apply the <b>AccountIsBlockedForPlanning</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<Boolean> ACCOUNT_IS_BLOCKED_FOR_PLANNING =
        new GLAccountInChartOfAccountsField<Boolean>("AccountIsBlockedForPlanning");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> PARTNER_COMPANY =
        new GLAccountInChartOfAccountsField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> FUNCTIONAL_AREA =
        new GLAccountInChartOfAccountsField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<LocalDateTime> CREATION_DATE =
        new GLAccountInChartOfAccountsField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person who Created the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> CREATED_BY_USER =
        new GLAccountInChartOfAccountsField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new GLAccountInChartOfAccountsField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @return Type of a General Ledger Account
     */
    @SerializedName( "GLAccountType" )
    @JsonProperty( "GLAccountType" )
    @Nullable
    @ODataField( odataName = "GLAccountType" )
    private String gLAccountType;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountType</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> GL_ACCOUNT_TYPE =
        new GLAccountInChartOfAccountsField<String>("GLAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountExternal</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccountExternal" )
    @JsonProperty( "GLAccountExternal" )
    @Nullable
    @ODataField( odataName = "GLAccountExternal" )
    private String gLAccountExternal;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountExternal</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<String> GL_ACCOUNT_EXTERNAL =
        new GLAccountInChartOfAccountsField<String>("GLAccountExternal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProfitLossAccount</b>
     * </p>
     *
     * @return Indicator: Account is a balance sheet account?
     */
    @SerializedName( "IsProfitLossAccount" )
    @JsonProperty( "IsProfitLossAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProfitLossAccount" )
    private Boolean isProfitLossAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsProfitLossAccount</b> field to query operations.
     *
     */
    public final static GLAccountInChartOfAccountsField<Boolean> IS_PROFIT_LOSS_ACCOUNT =
        new GLAccountInChartOfAccountsField<Boolean>("IsProfitLossAccount");

    @Nonnull
    @Override
    public Class<GLAccountInChartOfAccounts> getType()
    {
        return GLAccountInChartOfAccounts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @param isBalanceSheetAccount
     *            Indicator: Account is a balance sheet account?
     */
    public void setIsBalanceSheetAccount( @Nullable final Boolean isBalanceSheetAccount )
    {
        rememberChangedField("IsBalanceSheetAccount", this.isBalanceSheetAccount);
        this.isBalanceSheetAccount = isBalanceSheetAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountGroup</b>
     * </p>
     *
     * @param gLAccountGroup
     *            G/L Account Group
     */
    public void setGLAccountGroup( @Nullable final String gLAccountGroup )
    {
        rememberChangedField("GLAccountGroup", this.gLAccountGroup);
        this.gLAccountGroup = gLAccountGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @param corporateGroupAccount
     *            Group Account Number
     */
    public void setCorporateGroupAccount( @Nullable final String corporateGroupAccount )
    {
        rememberChangedField("CorporateGroupAccount", this.corporateGroupAccount);
        this.corporateGroupAccount = corporateGroupAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProfitLossAccountType</b>
     * </p>
     *
     * @param profitLossAccountType
     *            P&L statement account type
     */
    public void setProfitLossAccountType( @Nullable final String profitLossAccountType )
    {
        rememberChangedField("ProfitLossAccountType", this.profitLossAccountType);
        this.profitLossAccountType = profitLossAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SampleGLAccount</b>
     * </p>
     *
     * @param sampleGLAccount
     *            Number of the sample account
     */
    public void setSampleGLAccount( @Nullable final String sampleGLAccount )
    {
        rememberChangedField("SampleGLAccount", this.sampleGLAccount);
        this.sampleGLAccount = sampleGLAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsMarkedForDeletion</b>
     * </p>
     *
     * @param accountIsMarkedForDeletion
     *            Indicator: Account Marked for Deletion?
     */
    public void setAccountIsMarkedForDeletion( @Nullable final Boolean accountIsMarkedForDeletion )
    {
        rememberChangedField("AccountIsMarkedForDeletion", this.accountIsMarkedForDeletion);
        this.accountIsMarkedForDeletion = accountIsMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsBlockedForCreation</b>
     * </p>
     *
     * @param accountIsBlockedForCreation
     *            Indicator: account is blocked for creation ?
     */
    public void setAccountIsBlockedForCreation( @Nullable final Boolean accountIsBlockedForCreation )
    {
        rememberChangedField("AccountIsBlockedForCreation", this.accountIsBlockedForCreation);
        this.accountIsBlockedForCreation = accountIsBlockedForCreation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsBlockedForPosting</b>
     * </p>
     *
     * @param accountIsBlockedForPosting
     *            Indicator: Is Account Blocked for Posting?
     */
    public void setAccountIsBlockedForPosting( @Nullable final Boolean accountIsBlockedForPosting )
    {
        rememberChangedField("AccountIsBlockedForPosting", this.accountIsBlockedForPosting);
        this.accountIsBlockedForPosting = accountIsBlockedForPosting;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountIsBlockedForPlanning</b>
     * </p>
     *
     * @param accountIsBlockedForPlanning
     *            Indicator: account blocked for planning ?
     */
    public void setAccountIsBlockedForPlanning( @Nullable final Boolean accountIsBlockedForPlanning )
    {
        rememberChangedField("AccountIsBlockedForPlanning", this.accountIsBlockedForPlanning);
        this.accountIsBlockedForPlanning = accountIsBlockedForPlanning;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person who Created the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @param gLAccountType
     *            Type of a General Ledger Account
     */
    public void setGLAccountType( @Nullable final String gLAccountType )
    {
        rememberChangedField("GLAccountType", this.gLAccountType);
        this.gLAccountType = gLAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountExternal</b>
     * </p>
     *
     * @param gLAccountExternal
     *            G/L Account Number
     */
    public void setGLAccountExternal( @Nullable final String gLAccountExternal )
    {
        rememberChangedField("GLAccountExternal", this.gLAccountExternal);
        this.gLAccountExternal = gLAccountExternal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProfitLossAccount</b>
     * </p>
     *
     * @param isProfitLossAccount
     *            Indicator: Account is a balance sheet account?
     */
    public void setIsProfitLossAccount( @Nullable final Boolean isProfitLossAccount )
    {
        rememberChangedField("IsProfitLossAccount", this.isProfitLossAccount);
        this.isProfitLossAccount = isProfitLossAccount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_GLAccountInChartOfAccounts";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChartOfAccounts", getChartOfAccounts());
        result.put("GLAccount", getGLAccount());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("GLAccount", getGLAccount());
        values.put("IsBalanceSheetAccount", getIsBalanceSheetAccount());
        values.put("GLAccountGroup", getGLAccountGroup());
        values.put("CorporateGroupAccount", getCorporateGroupAccount());
        values.put("ProfitLossAccountType", getProfitLossAccountType());
        values.put("SampleGLAccount", getSampleGLAccount());
        values.put("AccountIsMarkedForDeletion", getAccountIsMarkedForDeletion());
        values.put("AccountIsBlockedForCreation", getAccountIsBlockedForCreation());
        values.put("AccountIsBlockedForPosting", getAccountIsBlockedForPosting());
        values.put("AccountIsBlockedForPlanning", getAccountIsBlockedForPlanning());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("GLAccountType", getGLAccountType());
        values.put("GLAccountExternal", getGLAccountExternal());
        values.put("IsProfitLossAccount", getIsProfitLossAccount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("IsBalanceSheetAccount") ) {
                final Object value = values.remove("IsBalanceSheetAccount");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccount())) ) {
                    setIsBalanceSheetAccount(((Boolean) value));
                }
            }
            if( values.containsKey("GLAccountGroup") ) {
                final Object value = values.remove("GLAccountGroup");
                if( (value == null) || (!value.equals(getGLAccountGroup())) ) {
                    setGLAccountGroup(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccount") ) {
                final Object value = values.remove("CorporateGroupAccount");
                if( (value == null) || (!value.equals(getCorporateGroupAccount())) ) {
                    setCorporateGroupAccount(((String) value));
                }
            }
            if( values.containsKey("ProfitLossAccountType") ) {
                final Object value = values.remove("ProfitLossAccountType");
                if( (value == null) || (!value.equals(getProfitLossAccountType())) ) {
                    setProfitLossAccountType(((String) value));
                }
            }
            if( values.containsKey("SampleGLAccount") ) {
                final Object value = values.remove("SampleGLAccount");
                if( (value == null) || (!value.equals(getSampleGLAccount())) ) {
                    setSampleGLAccount(((String) value));
                }
            }
            if( values.containsKey("AccountIsMarkedForDeletion") ) {
                final Object value = values.remove("AccountIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getAccountIsMarkedForDeletion())) ) {
                    setAccountIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("AccountIsBlockedForCreation") ) {
                final Object value = values.remove("AccountIsBlockedForCreation");
                if( (value == null) || (!value.equals(getAccountIsBlockedForCreation())) ) {
                    setAccountIsBlockedForCreation(((Boolean) value));
                }
            }
            if( values.containsKey("AccountIsBlockedForPosting") ) {
                final Object value = values.remove("AccountIsBlockedForPosting");
                if( (value == null) || (!value.equals(getAccountIsBlockedForPosting())) ) {
                    setAccountIsBlockedForPosting(((Boolean) value));
                }
            }
            if( values.containsKey("AccountIsBlockedForPlanning") ) {
                final Object value = values.remove("AccountIsBlockedForPlanning");
                if( (value == null) || (!value.equals(getAccountIsBlockedForPlanning())) ) {
                    setAccountIsBlockedForPlanning(((Boolean) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("GLAccountType") ) {
                final Object value = values.remove("GLAccountType");
                if( (value == null) || (!value.equals(getGLAccountType())) ) {
                    setGLAccountType(((String) value));
                }
            }
            if( values.containsKey("GLAccountExternal") ) {
                final Object value = values.remove("GLAccountExternal");
                if( (value == null) || (!value.equals(getGLAccountExternal())) ) {
                    setGLAccountExternal(((String) value));
                }
            }
            if( values.containsKey("IsProfitLossAccount") ) {
                final Object value = values.remove("IsProfitLossAccount");
                if( (value == null) || (!value.equals(getIsProfitLossAccount())) ) {
                    setIsProfitLossAccount(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GLAccountInChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new GLAccountInChartOfAccountsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccountInChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccountInChartOfAccountsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JournalEntryItemService.DEFAULT_SERVICE_PATH);
    }

}
