/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.field.ProfitCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.selectable.ProfitCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Profit Center Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProfitCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProfitCenter extends VdmEntity<ProfitCenter>
{

    /**
     * Selector for all available fields of ProfitCenter.
     *
     */
    public final static ProfitCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> CONTROLLING_AREA = new ProfitCenterField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @Key
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER = new ProfitCenterField<String>("ProfitCenter");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ProfitCenterField<LocalDateTime> VALIDITY_END_DATE =
        new ProfitCenterField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCtrResponsiblePersonName</b>
     * </p>
     *
     * @return Person Responsible for Profit Center
     */
    @SerializedName( "ProfitCtrResponsiblePersonName" )
    @JsonProperty( "ProfitCtrResponsiblePersonName" )
    @Nullable
    @ODataField( odataName = "ProfitCtrResponsiblePersonName" )
    private String profitCtrResponsiblePersonName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCtrResponsiblePersonName</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CTR_RESPONSIBLE_PERSON_NAME =
        new ProfitCenterField<String>("ProfitCtrResponsiblePersonName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> COMPANY_CODE = new ProfitCenterField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCtrResponsibleUser</b>
     * </p>
     *
     * @return User Responsible for the Profit Center
     */
    @SerializedName( "ProfitCtrResponsibleUser" )
    @JsonProperty( "ProfitCtrResponsibleUser" )
    @Nullable
    @ODataField( odataName = "ProfitCtrResponsibleUser" )
    private String profitCtrResponsibleUser;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCtrResponsibleUser</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CTR_RESPONSIBLE_USER =
        new ProfitCenterField<String>("ProfitCtrResponsibleUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ProfitCenterField<LocalDateTime> VALIDITY_START_DATE =
        new ProfitCenterField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Department</b>
     * </p>
     *
     * @return Department
     */
    @SerializedName( "Department" )
    @JsonProperty( "Department" )
    @Nullable
    @ODataField( odataName = "Department" )
    private String department;
    /**
     * Use with available fluent helpers to apply the <b>Department</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> DEPARTMENT = new ProfitCenterField<String>("Department");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterStandardHierarchy</b>
     * </p>
     *
     * @return Profit center area
     */
    @SerializedName( "ProfitCenterStandardHierarchy" )
    @JsonProperty( "ProfitCenterStandardHierarchy" )
    @Nullable
    @ODataField( odataName = "ProfitCenterStandardHierarchy" )
    private String profitCenterStandardHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterStandardHierarchy</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_STANDARD_HIERARCHY =
        new ProfitCenterField<String>("ProfitCenterStandardHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> SEGMENT = new ProfitCenterField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterIsBlocked</b>
     * </p>
     *
     * @return Lock indicator
     */
    @SerializedName( "ProfitCenterIsBlocked" )
    @JsonProperty( "ProfitCenterIsBlocked" )
    @Nullable
    @ODataField( odataName = "ProfitCenterIsBlocked" )
    private String profitCenterIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterIsBlocked</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_IS_BLOCKED =
        new ProfitCenterField<String>("ProfitCenterIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FormulaPlanningTemplate</b>
     * </p>
     *
     * @return Template for Formula Planning in Profit Centers
     */
    @SerializedName( "FormulaPlanningTemplate" )
    @JsonProperty( "FormulaPlanningTemplate" )
    @Nullable
    @ODataField( odataName = "FormulaPlanningTemplate" )
    private String formulaPlanningTemplate;
    /**
     * Use with available fluent helpers to apply the <b>FormulaPlanningTemplate</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> FORMULA_PLANNING_TEMPLATE =
        new ProfitCenterField<String>("FormulaPlanningTemplate");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Title
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> FORM_OF_ADDRESS = new ProfitCenterField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>AddressName</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "AddressName" )
    @JsonProperty( "AddressName" )
    @Nullable
    @ODataField( odataName = "AddressName" )
    private String addressName;
    /**
     * Use with available fluent helpers to apply the <b>AddressName</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> ADDRESS_NAME = new ProfitCenterField<String>("AddressName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalName</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "AdditionalName" )
    @JsonProperty( "AdditionalName" )
    @Nullable
    @ODataField( odataName = "AdditionalName" )
    private String additionalName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalName</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> ADDITIONAL_NAME = new ProfitCenterField<String>("AdditionalName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterAddrName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "ProfitCenterAddrName3" )
    @JsonProperty( "ProfitCenterAddrName3" )
    @Nullable
    @ODataField( odataName = "ProfitCenterAddrName3" )
    private String profitCenterAddrName3;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterAddrName3</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_ADDR_NAME3 =
        new ProfitCenterField<String>("ProfitCenterAddrName3");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterAddrName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "ProfitCenterAddrName4" )
    @JsonProperty( "ProfitCenterAddrName4" )
    @Nullable
    @ODataField( odataName = "ProfitCenterAddrName4" )
    private String profitCenterAddrName4;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterAddrName4</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_ADDR_NAME4 =
        new ProfitCenterField<String>("ProfitCenterAddrName4");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetAddressName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "StreetAddressName" )
    @JsonProperty( "StreetAddressName" )
    @Nullable
    @ODataField( odataName = "StreetAddressName" )
    private String streetAddressName;
    /**
     * Use with available fluent helpers to apply the <b>StreetAddressName</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> STREET_ADDRESS_NAME =
        new ProfitCenterField<String>("StreetAddressName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Use with available fluent helpers to apply the <b>POBox</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PO_BOX = new ProfitCenterField<String>("POBox");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> CITY_NAME = new ProfitCenterField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> POSTAL_CODE = new ProfitCenterField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "District" )
    @JsonProperty( "District" )
    @Nullable
    @ODataField( odataName = "District" )
    private String district;
    /**
     * Use with available fluent helpers to apply the <b>District</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> DISTRICT = new ProfitCenterField<String>("District");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> COUNTRY = new ProfitCenterField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> REGION = new ProfitCenterField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> TAX_JURISDICTION = new ProfitCenterField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> LANGUAGE = new ProfitCenterField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber1</b>
     * </p>
     *
     * @return First telephone number
     */
    @SerializedName( "PhoneNumber1" )
    @JsonProperty( "PhoneNumber1" )
    @Nullable
    @ODataField( odataName = "PhoneNumber1" )
    private String phoneNumber1;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber1</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PHONE_NUMBER1 = new ProfitCenterField<String>("PhoneNumber1");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber2</b>
     * </p>
     *
     * @return Second telephone number
     */
    @SerializedName( "PhoneNumber2" )
    @JsonProperty( "PhoneNumber2" )
    @Nullable
    @ODataField( odataName = "PhoneNumber2" )
    private String phoneNumber2;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber2</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PHONE_NUMBER2 = new ProfitCenterField<String>("PhoneNumber2");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TeleboxNumber</b>
     * </p>
     *
     * @return Telebox Number
     */
    @SerializedName( "TeleboxNumber" )
    @JsonProperty( "TeleboxNumber" )
    @Nullable
    @ODataField( odataName = "TeleboxNumber" )
    private String teleboxNumber;
    /**
     * Use with available fluent helpers to apply the <b>TeleboxNumber</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> TELEBOX_NUMBER = new ProfitCenterField<String>("TeleboxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TelexNumber</b>
     * </p>
     *
     * @return Telex Number
     */
    @SerializedName( "TelexNumber" )
    @JsonProperty( "TelexNumber" )
    @Nullable
    @ODataField( odataName = "TelexNumber" )
    private String telexNumber;
    /**
     * Use with available fluent helpers to apply the <b>TelexNumber</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> TELEX_NUMBER = new ProfitCenterField<String>("TelexNumber");
    /**
     * Constraints: Not nullable, Maximum length: 31
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return Fax Number
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> FAX_NUMBER = new ProfitCenterField<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>DataCommunicationPhoneNumber</b>
     * </p>
     *
     * @return Data communication line no.
     */
    @SerializedName( "DataCommunicationPhoneNumber" )
    @JsonProperty( "DataCommunicationPhoneNumber" )
    @Nullable
    @ODataField( odataName = "DataCommunicationPhoneNumber" )
    private String dataCommunicationPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>DataCommunicationPhoneNumber</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> DATA_COMMUNICATION_PHONE_NUMBER =
        new ProfitCenterField<String>("DataCommunicationPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterPrinterName</b>
     * </p>
     *
     * @return Printer name for profit center
     */
    @SerializedName( "ProfitCenterPrinterName" )
    @JsonProperty( "ProfitCenterPrinterName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterPrinterName" )
    private String profitCenterPrinterName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterPrinterName</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_PRINTER_NAME =
        new ProfitCenterField<String>("ProfitCenterPrinterName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterCreatedByUser</b>
     * </p>
     *
     * @return Entered By
     */
    @SerializedName( "ProfitCenterCreatedByUser" )
    @JsonProperty( "ProfitCenterCreatedByUser" )
    @Nullable
    @ODataField( odataName = "ProfitCenterCreatedByUser" )
    private String profitCenterCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterCreatedByUser</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_CREATED_BY_USER =
        new ProfitCenterField<String>("ProfitCenterCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterCreationDate</b>
     * </p>
     *
     * @return Created on
     */
    @SerializedName( "ProfitCenterCreationDate" )
    @JsonProperty( "ProfitCenterCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProfitCenterCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime profitCenterCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterCreationDate</b> field to query operations.
     *
     */
    public final static ProfitCenterField<LocalDateTime> PROFIT_CENTER_CREATION_DATE =
        new ProfitCenterField<LocalDateTime>("ProfitCenterCreationDate");

    @Nonnull
    @Override
    public Class<ProfitCenter> getType()
    {
        return ProfitCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCtrResponsiblePersonName</b>
     * </p>
     *
     * @param profitCtrResponsiblePersonName
     *            Person Responsible for Profit Center
     */
    public void setProfitCtrResponsiblePersonName( @Nullable final String profitCtrResponsiblePersonName )
    {
        rememberChangedField("ProfitCtrResponsiblePersonName", this.profitCtrResponsiblePersonName);
        this.profitCtrResponsiblePersonName = profitCtrResponsiblePersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCtrResponsibleUser</b>
     * </p>
     *
     * @param profitCtrResponsibleUser
     *            User Responsible for the Profit Center
     */
    public void setProfitCtrResponsibleUser( @Nullable final String profitCtrResponsibleUser )
    {
        rememberChangedField("ProfitCtrResponsibleUser", this.profitCtrResponsibleUser);
        this.profitCtrResponsibleUser = profitCtrResponsibleUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Department</b>
     * </p>
     *
     * @param department
     *            Department
     */
    public void setDepartment( @Nullable final String department )
    {
        rememberChangedField("Department", this.department);
        this.department = department;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterStandardHierarchy</b>
     * </p>
     *
     * @param profitCenterStandardHierarchy
     *            Profit center area
     */
    public void setProfitCenterStandardHierarchy( @Nullable final String profitCenterStandardHierarchy )
    {
        rememberChangedField("ProfitCenterStandardHierarchy", this.profitCenterStandardHierarchy);
        this.profitCenterStandardHierarchy = profitCenterStandardHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterIsBlocked</b>
     * </p>
     *
     * @param profitCenterIsBlocked
     *            Lock indicator
     */
    public void setProfitCenterIsBlocked( @Nullable final String profitCenterIsBlocked )
    {
        rememberChangedField("ProfitCenterIsBlocked", this.profitCenterIsBlocked);
        this.profitCenterIsBlocked = profitCenterIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FormulaPlanningTemplate</b>
     * </p>
     *
     * @param formulaPlanningTemplate
     *            Template for Formula Planning in Profit Centers
     */
    public void setFormulaPlanningTemplate( @Nullable final String formulaPlanningTemplate )
    {
        rememberChangedField("FormulaPlanningTemplate", this.formulaPlanningTemplate);
        this.formulaPlanningTemplate = formulaPlanningTemplate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Title
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>AddressName</b>
     * </p>
     *
     * @param addressName
     *            Name 1
     */
    public void setAddressName( @Nullable final String addressName )
    {
        rememberChangedField("AddressName", this.addressName);
        this.addressName = addressName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalName</b>
     * </p>
     *
     * @param additionalName
     *            Name 2
     */
    public void setAdditionalName( @Nullable final String additionalName )
    {
        rememberChangedField("AdditionalName", this.additionalName);
        this.additionalName = additionalName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterAddrName3</b>
     * </p>
     *
     * @param profitCenterAddrName3
     *            Name 3
     */
    public void setProfitCenterAddrName3( @Nullable final String profitCenterAddrName3 )
    {
        rememberChangedField("ProfitCenterAddrName3", this.profitCenterAddrName3);
        this.profitCenterAddrName3 = profitCenterAddrName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterAddrName4</b>
     * </p>
     *
     * @param profitCenterAddrName4
     *            Name 4
     */
    public void setProfitCenterAddrName4( @Nullable final String profitCenterAddrName4 )
    {
        rememberChangedField("ProfitCenterAddrName4", this.profitCenterAddrName4);
        this.profitCenterAddrName4 = profitCenterAddrName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetAddressName</b>
     * </p>
     *
     * @param streetAddressName
     *            Street and House Number
     */
    public void setStreetAddressName( @Nullable final String streetAddressName )
    {
        rememberChangedField("StreetAddressName", this.streetAddressName);
        this.streetAddressName = streetAddressName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @param district
     *            District
     */
    public void setDistrict( @Nullable final String district )
    {
        rememberChangedField("District", this.district);
        this.district = district;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber1</b>
     * </p>
     *
     * @param phoneNumber1
     *            First telephone number
     */
    public void setPhoneNumber1( @Nullable final String phoneNumber1 )
    {
        rememberChangedField("PhoneNumber1", this.phoneNumber1);
        this.phoneNumber1 = phoneNumber1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber2</b>
     * </p>
     *
     * @param phoneNumber2
     *            Second telephone number
     */
    public void setPhoneNumber2( @Nullable final String phoneNumber2 )
    {
        rememberChangedField("PhoneNumber2", this.phoneNumber2);
        this.phoneNumber2 = phoneNumber2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TeleboxNumber</b>
     * </p>
     *
     * @param teleboxNumber
     *            Telebox Number
     */
    public void setTeleboxNumber( @Nullable final String teleboxNumber )
    {
        rememberChangedField("TeleboxNumber", this.teleboxNumber);
        this.teleboxNumber = teleboxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TelexNumber</b>
     * </p>
     *
     * @param telexNumber
     *            Telex Number
     */
    public void setTelexNumber( @Nullable final String telexNumber )
    {
        rememberChangedField("TelexNumber", this.telexNumber);
        this.telexNumber = telexNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 31
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            Fax Number
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>DataCommunicationPhoneNumber</b>
     * </p>
     *
     * @param dataCommunicationPhoneNumber
     *            Data communication line no.
     */
    public void setDataCommunicationPhoneNumber( @Nullable final String dataCommunicationPhoneNumber )
    {
        rememberChangedField("DataCommunicationPhoneNumber", this.dataCommunicationPhoneNumber);
        this.dataCommunicationPhoneNumber = dataCommunicationPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterPrinterName</b>
     * </p>
     *
     * @param profitCenterPrinterName
     *            Printer name for profit center
     */
    public void setProfitCenterPrinterName( @Nullable final String profitCenterPrinterName )
    {
        rememberChangedField("ProfitCenterPrinterName", this.profitCenterPrinterName);
        this.profitCenterPrinterName = profitCenterPrinterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterCreatedByUser</b>
     * </p>
     *
     * @param profitCenterCreatedByUser
     *            Entered By
     */
    public void setProfitCenterCreatedByUser( @Nullable final String profitCenterCreatedByUser )
    {
        rememberChangedField("ProfitCenterCreatedByUser", this.profitCenterCreatedByUser);
        this.profitCenterCreatedByUser = profitCenterCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterCreationDate</b>
     * </p>
     *
     * @param profitCenterCreationDate
     *            Created on
     */
    public void setProfitCenterCreationDate( @Nullable final LocalDateTime profitCenterCreationDate )
    {
        rememberChangedField("ProfitCenterCreationDate", this.profitCenterCreationDate);
        this.profitCenterCreationDate = profitCenterCreationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProfitCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea", getControllingArea());
        result.put("ProfitCenter", getProfitCenter());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ProfitCtrResponsiblePersonName", getProfitCtrResponsiblePersonName());
        values.put("CompanyCode", getCompanyCode());
        values.put("ProfitCtrResponsibleUser", getProfitCtrResponsibleUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("Department", getDepartment());
        values.put("ProfitCenterStandardHierarchy", getProfitCenterStandardHierarchy());
        values.put("Segment", getSegment());
        values.put("ProfitCenterIsBlocked", getProfitCenterIsBlocked());
        values.put("FormulaPlanningTemplate", getFormulaPlanningTemplate());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("AddressName", getAddressName());
        values.put("AdditionalName", getAdditionalName());
        values.put("ProfitCenterAddrName3", getProfitCenterAddrName3());
        values.put("ProfitCenterAddrName4", getProfitCenterAddrName4());
        values.put("StreetAddressName", getStreetAddressName());
        values.put("POBox", getPOBox());
        values.put("CityName", getCityName());
        values.put("PostalCode", getPostalCode());
        values.put("District", getDistrict());
        values.put("Country", getCountry());
        values.put("Region", getRegion());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("Language", getLanguage());
        values.put("PhoneNumber1", getPhoneNumber1());
        values.put("PhoneNumber2", getPhoneNumber2());
        values.put("TeleboxNumber", getTeleboxNumber());
        values.put("TelexNumber", getTelexNumber());
        values.put("FaxNumber", getFaxNumber());
        values.put("DataCommunicationPhoneNumber", getDataCommunicationPhoneNumber());
        values.put("ProfitCenterPrinterName", getProfitCenterPrinterName());
        values.put("ProfitCenterCreatedByUser", getProfitCenterCreatedByUser());
        values.put("ProfitCenterCreationDate", getProfitCenterCreationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProfitCtrResponsiblePersonName") ) {
                final Object value = values.remove("ProfitCtrResponsiblePersonName");
                if( (value == null) || (!value.equals(getProfitCtrResponsiblePersonName())) ) {
                    setProfitCtrResponsiblePersonName(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ProfitCtrResponsibleUser") ) {
                final Object value = values.remove("ProfitCtrResponsibleUser");
                if( (value == null) || (!value.equals(getProfitCtrResponsibleUser())) ) {
                    setProfitCtrResponsibleUser(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Department") ) {
                final Object value = values.remove("Department");
                if( (value == null) || (!value.equals(getDepartment())) ) {
                    setDepartment(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterStandardHierarchy") ) {
                final Object value = values.remove("ProfitCenterStandardHierarchy");
                if( (value == null) || (!value.equals(getProfitCenterStandardHierarchy())) ) {
                    setProfitCenterStandardHierarchy(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterIsBlocked") ) {
                final Object value = values.remove("ProfitCenterIsBlocked");
                if( (value == null) || (!value.equals(getProfitCenterIsBlocked())) ) {
                    setProfitCenterIsBlocked(((String) value));
                }
            }
            if( values.containsKey("FormulaPlanningTemplate") ) {
                final Object value = values.remove("FormulaPlanningTemplate");
                if( (value == null) || (!value.equals(getFormulaPlanningTemplate())) ) {
                    setFormulaPlanningTemplate(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("AddressName") ) {
                final Object value = values.remove("AddressName");
                if( (value == null) || (!value.equals(getAddressName())) ) {
                    setAddressName(((String) value));
                }
            }
            if( values.containsKey("AdditionalName") ) {
                final Object value = values.remove("AdditionalName");
                if( (value == null) || (!value.equals(getAdditionalName())) ) {
                    setAdditionalName(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterAddrName3") ) {
                final Object value = values.remove("ProfitCenterAddrName3");
                if( (value == null) || (!value.equals(getProfitCenterAddrName3())) ) {
                    setProfitCenterAddrName3(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterAddrName4") ) {
                final Object value = values.remove("ProfitCenterAddrName4");
                if( (value == null) || (!value.equals(getProfitCenterAddrName4())) ) {
                    setProfitCenterAddrName4(((String) value));
                }
            }
            if( values.containsKey("StreetAddressName") ) {
                final Object value = values.remove("StreetAddressName");
                if( (value == null) || (!value.equals(getStreetAddressName())) ) {
                    setStreetAddressName(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("District") ) {
                final Object value = values.remove("District");
                if( (value == null) || (!value.equals(getDistrict())) ) {
                    setDistrict(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber1") ) {
                final Object value = values.remove("PhoneNumber1");
                if( (value == null) || (!value.equals(getPhoneNumber1())) ) {
                    setPhoneNumber1(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber2") ) {
                final Object value = values.remove("PhoneNumber2");
                if( (value == null) || (!value.equals(getPhoneNumber2())) ) {
                    setPhoneNumber2(((String) value));
                }
            }
            if( values.containsKey("TeleboxNumber") ) {
                final Object value = values.remove("TeleboxNumber");
                if( (value == null) || (!value.equals(getTeleboxNumber())) ) {
                    setTeleboxNumber(((String) value));
                }
            }
            if( values.containsKey("TelexNumber") ) {
                final Object value = values.remove("TelexNumber");
                if( (value == null) || (!value.equals(getTelexNumber())) ) {
                    setTelexNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("DataCommunicationPhoneNumber") ) {
                final Object value = values.remove("DataCommunicationPhoneNumber");
                if( (value == null) || (!value.equals(getDataCommunicationPhoneNumber())) ) {
                    setDataCommunicationPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterPrinterName") ) {
                final Object value = values.remove("ProfitCenterPrinterName");
                if( (value == null) || (!value.equals(getProfitCenterPrinterName())) ) {
                    setProfitCenterPrinterName(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterCreatedByUser") ) {
                final Object value = values.remove("ProfitCenterCreatedByUser");
                if( (value == null) || (!value.equals(getProfitCenterCreatedByUser())) ) {
                    setProfitCenterCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterCreationDate") ) {
                final Object value = values.remove("ProfitCenterCreationDate");
                if( (value == null) || (!value.equals(getProfitCenterCreationDate())) ) {
                    setProfitCenterCreationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProfitCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProfitCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProfitCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProfitCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JournalEntryItemService.DEFAULT_SERVICE_PATH);
    }

}
