/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link JournalEntryItemServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.JournalEntryItemService JournalEntryItemService}.
 *
 */
public class DefaultJournalEntryItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<JournalEntryItemServiceBatch, JournalEntryItemServiceBatchChangeSet>
    implements
    JournalEntryItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JournalEntryItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultJournalEntryItemServiceBatchChangeSet(
        @Nonnull final DefaultJournalEntryItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JournalEntryItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultJournalEntryItemServiceBatchChangeSet getThis()
    {
        return this;
    }

}
