/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode CompanyCode}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.field.CompanyCodeField
 * CompanyCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.link.CompanyCodeLink CompanyCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#CITY_NAME CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#COMPANY COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#CREDIT_CONTROL_AREA
 * CREDIT_CONTROL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#COUNTRY_CHART_OF_ACCOUNTS
 * COUNTRY_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#TAXABLE_ENTITY
 * TAXABLE_ENTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#VAT_REGISTRATION
 * VAT_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#EXTENDED_WHLDG_TAX_IS_ACTIVE
 * EXTENDED_WHLDG_TAX_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#FIELD_STATUS_VARIANT
 * FIELD_STATUS_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#NON_TAXABLE_TRANSACTION_TAX_CODE
 * NON_TAXABLE_TRANSACTION_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#DOC_DATE_IS_USED_FOR_TAX_DETN
 * DOC_DATE_IS_USED_FOR_TAX_DETN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.CompanyCode#TAX_RPTG_DATE_IS_ACTIVE
 * TAX_RPTG_DATE_IS_ACTIVE}</li>
 * </ul>
 *
 */
public interface CompanyCodeSelectable extends EntitySelectable<CompanyCode>
{

}
