/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic
 * JournalEntryItemBasic}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.field.JournalEntryItemBasicField
 * JournalEntryItemBasicField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.link.JournalEntryItemBasicLink
 * JournalEntryItemBasicLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ID ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#LEDGER_NAME
 * LEDGER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SOURCE_LEDGER
 * SOURCE_LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#LEDGER_FISCAL_YEAR
 * LEDGER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#GL_ACCOUNT_NAME
 * GL_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#BUSINESS_TRANSACTION_CATEGORY
 * BUSINESS_TRANSACTION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#BUSINESS_TRANSACTION_TYPE
 * BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SOURCE_REFERENCE_DOCUMENT_TYPE
 * SOURCE_REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#JRNL_ENTRY_ITEM_OBSOLETE_REASON
 * JRNL_ENTRY_ITEM_OBSOLETE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PROFIT_CENTER_NAME
 * PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FUNCTIONAL_AREA_NAME
 * FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#BUSINESS_AREA_NAME
 * BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SEGMENT_NAME
 * SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COST_CENTER_NAME
 * PARTNER_COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_PROFIT_CENTER_NAME
 * PARTNER_PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_FUNCTIONAL_AREA_NAME
 * PARTNER_FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_BUSINESS_AREA_NAME
 * PARTNER_BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COMPANY_NAME
 * PARTNER_COMPANY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_SEGMENT_NAME
 * PARTNER_SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_GLOBAL_CURRENCY
 * AMOUNT_IN_GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COST_SOURCE_UNIT
 * COST_SOURCE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#VALUATION_QUANTITY
 * VALUATION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY1
 * FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY1
 * AMOUNT_IN_FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY2
 * FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY2
 * AMOUNT_IN_FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY3
 * FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY3
 * AMOUNT_IN_FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY4
 * FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY4
 * AMOUNT_IN_FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY5
 * FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY5
 * AMOUNT_IN_FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY6
 * FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY6
 * AMOUNT_IN_FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY7
 * FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY7
 * AMOUNT_IN_FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FREE_DEFINED_CURRENCY8
 * FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#AMOUNT_IN_FREE_DEFINED_CURRENCY8
 * AMOUNT_IN_FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ADDITIONAL_QUANTITY1_UNIT
 * ADDITIONAL_QUANTITY1_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ADDITIONAL_QUANTITY1
 * ADDITIONAL_QUANTITY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ADDITIONAL_QUANTITY2_UNIT
 * ADDITIONAL_QUANTITY2_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ADDITIONAL_QUANTITY2
 * ADDITIONAL_QUANTITY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ADDITIONAL_QUANTITY3_UNIT
 * ADDITIONAL_QUANTITY3_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ADDITIONAL_QUANTITY3
 * ADDITIONAL_QUANTITY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ACCOUNTING_DOCUMENT_CATEGORY
 * ACCOUNTING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CONTROLLING_DEBIT_CREDIT_CODE
 * CONTROLLING_DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PROJECT
 * PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PROJECT_DESCRIPTION
 * PROJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#WBS_ELEMENT_DESCRIPTION
 * WBS_ELEMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COMPANY_CODE
 * PARTNER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COMPANY_CODE_NAME
 * PARTNER_COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#COST_CTR_ACTIVITY_TYPE_NAME
 * COST_CTR_ACTIVITY_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COST_CTR_ACTIVITY_TYPE
 * PARTNER_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_COST_CTR_ACTIVITY_TYPE_NAME
 * PARTNER_COST_CTR_ACTIVITY_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_PROJECT
 * PARTNER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_PROJECT_DESCRIPTION
 * PARTNER_PROJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_WBS_ELEMENT
 * PARTNER_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#PARTNER_WBS_ELEMENT_DESCRIPTION
 * PARTNER_WBS_ELEMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SALES_ORGANIZATION_NAME
 * SALES_ORGANIZATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#DISTRIBUTION_CHANNEL_NAME
 * DISTRIBUTION_CHANNEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#DIVISION_NAME
 * DIVISION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SOLD_MATERIAL
 * SOLD_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SOLD_MATERIAL_NAME
 * SOLD_MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#MATERIAL_GROUP_NAME
 * MATERIAL_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_GROUP_NAME
 * CUSTOMER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_SUPPLIER_COUNTRY_NAME
 * CUSTOMER_SUPPLIER_COUNTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#CUSTOMER_SUPPLIER_INDUSTRY_NAME
 * CUSTOMER_SUPPLIER_INDUSTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#SALES_DISTRICT_NAME
 * SALES_DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#TO_COMPANY_CODE
 * TO_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#TO_CURRENT_COST_CENTER
 * TO_CURRENT_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#TO_CURRENT_PROFIT_CENTER
 * TO_CURRENT_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.journalentryitem.JournalEntryItemBasic#TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS
 * TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface JournalEntryItemBasicSelectable extends EntitySelectable<JournalEntryItemBasic>
{

}
