/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable.JITCallCompGrpSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class JITCallCompGrpByKeyFluentHelper
    extends
    FluentHelperByKey<JITCallCompGrpByKeyFluentHelper, JITCallCompGrp, JITCallCompGrpSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code JITCallCompGrp}
     * @param compGrpNumber
     *            Component Group Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code JITCallCompGrp}
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public JITCallCompGrpByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String internalJITCallNumber,
        final String compGrpNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("InternalJITCallNumber", internalJITCallNumber);
        this.key.put("CompGrpNumber", compGrpNumber);
    }

    @Override
    @Nonnull
    protected Class<JITCallCompGrp> getEntityClass()
    {
        return JITCallCompGrp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
