/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallCompMatlField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallCompMatlLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable.JITCallCompMatlSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Component Group Material
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JITCallCompMatlType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class JITCallCompMatl extends VdmEntity<JITCallCompMatl>
{

    /**
     * Selector for all available fields of JITCallCompMatl.
     *
     */
    public final static JITCallCompMatlSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @return Call Number
     */
    @Key
    @SerializedName( "InternalJITCallNumber" )
    @JsonProperty( "InternalJITCallNumber" )
    @Nullable
    @ODataField( odataName = "InternalJITCallNumber" )
    private String internalJITCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternalJITCallNumber</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> INTERNAL_JIT_CALL_NUMBER =
        new JITCallCompMatlField<String>("InternalJITCallNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CompGrpNumber</b>
     * </p>
     *
     * @return Component Group Number
     */
    @Key
    @SerializedName( "CompGrpNumber" )
    @JsonProperty( "CompGrpNumber" )
    @Nullable
    @ODataField( odataName = "CompGrpNumber" )
    private String compGrpNumber;
    /**
     * Use with available fluent helpers to apply the <b>CompGrpNumber</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> COMP_GRP_NUMBER =
        new JITCallCompMatlField<String>("CompGrpNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITCallItemNumber</b>
     * </p>
     *
     * @return Call Item Number
     */
    @Key
    @SerializedName( "JITCallItemNumber" )
    @JsonProperty( "JITCallItemNumber" )
    @Nullable
    @ODataField( odataName = "JITCallItemNumber" )
    private String jITCallItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>JITCallItemNumber</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> JIT_CALL_ITEM_NUMBER =
        new JITCallCompMatlField<String>("JITCallItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-to Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> SHIP_TO_PARTY = new JITCallCompMatlField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> MATERIAL = new JITCallCompMatlField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Customer Material
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> MATERIAL_BY_CUSTOMER =
        new JITCallCompMatlField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExtJITCallItemNumber</b>
     * </p>
     *
     * @return External Call Item Number
     */
    @SerializedName( "ExtJITCallItemNumber" )
    @JsonProperty( "ExtJITCallItemNumber" )
    @Nullable
    @ODataField( odataName = "ExtJITCallItemNumber" )
    private String extJITCallItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>ExtJITCallItemNumber</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> EXT_JIT_CALL_ITEM_NUMBER =
        new JITCallCompMatlField<String>("ExtJITCallItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> SALES_ORDER = new JITCallCompMatlField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> SALES_ORDER_ITEM =
        new JITCallCompMatlField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<BigDecimal> REQUESTED_QUANTITY =
        new JITCallCompMatlField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveredQuantity</b>
     * </p>
     *
     * @return Delivered Quantity
     */
    @SerializedName( "ActualDeliveredQuantity" )
    @JsonProperty( "ActualDeliveredQuantity" )
    @Nullable
    @ODataField( odataName = "ActualDeliveredQuantity" )
    private BigDecimal actualDeliveredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ActualDeliveredQuantity</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<BigDecimal> ACTUAL_DELIVERED_QUANTITY =
        new JITCallCompMatlField<BigDecimal>("ActualDeliveredQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> QUANTITY_UNIT = new JITCallCompMatlField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> UNLOADING_POINT_NAME =
        new JITCallCompMatlField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> SHIPPING_POINT = new JITCallCompMatlField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> PLANT = new JITCallCompMatlField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> STORAGE_LOCATION =
        new JITCallCompMatlField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustSupplyArea</b>
     * </p>
     *
     * @return Customer Supply Area
     */
    @SerializedName( "CustSupplyArea" )
    @JsonProperty( "CustSupplyArea" )
    @Nullable
    @ODataField( odataName = "CustSupplyArea" )
    private String custSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>CustSupplyArea</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> CUST_SUPPLY_AREA =
        new JITCallCompMatlField<String>("CustSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplyAreaDesc</b>
     * </p>
     *
     * @return The supplyAreaDesc contained in this entity.
     */
    @SerializedName( "SupplyAreaDesc" )
    @JsonProperty( "SupplyAreaDesc" )
    @Nullable
    @ODataField( odataName = "SupplyAreaDesc" )
    private String supplyAreaDesc;
    /**
     * Use with available fluent helpers to apply the <b>SupplyAreaDesc</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> SUPPLY_AREA_DESC =
        new JITCallCompMatlField<String>("SupplyAreaDesc");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustAssemblyLoc</b>
     * </p>
     *
     * @return Assembly Location at Customer Site
     */
    @SerializedName( "CustAssemblyLoc" )
    @JsonProperty( "CustAssemblyLoc" )
    @Nullable
    @ODataField( odataName = "CustAssemblyLoc" )
    private String custAssemblyLoc;
    /**
     * Use with available fluent helpers to apply the <b>CustAssemblyLoc</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> CUST_ASSEMBLY_LOC =
        new JITCallCompMatlField<String>("CustAssemblyLoc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusAtSupplier</b>
     * </p>
     *
     * @return JIT External Status at Supplier
     */
    @SerializedName( "JITExtStatusAtSupplier" )
    @JsonProperty( "JITExtStatusAtSupplier" )
    @Nullable
    @ODataField( odataName = "JITExtStatusAtSupplier" )
    private String jITExtStatusAtSupplier;
    /**
     * Use with available fluent helpers to apply the <b>JITExtStatusAtSupplier</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> JIT_EXT_STATUS_AT_SUPPLIER =
        new JITCallCompMatlField<String>("JITExtStatusAtSupplier");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusUpdtdOn</b>
     * </p>
     *
     * @return External Status Updated On
     */
    @SerializedName( "JITExtStatusUpdtdOn" )
    @JsonProperty( "JITExtStatusUpdtdOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "JITExtStatusUpdtdOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime jITExtStatusUpdtdOn;
    /**
     * Use with available fluent helpers to apply the <b>JITExtStatusUpdtdOn</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<ZonedDateTime> JIT_EXT_STATUS_UPDTD_ON =
        new JITCallCompMatlField<ZonedDateTime>("JITExtStatusUpdtdOn");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JITIntProcessingStatus</b>
     * </p>
     *
     * @return Internal Processing Status
     */
    @SerializedName( "JITIntProcessingStatus" )
    @JsonProperty( "JITIntProcessingStatus" )
    @Nullable
    @ODataField( odataName = "JITIntProcessingStatus" )
    private String jITIntProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>JITIntProcessingStatus</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> JIT_INT_PROCESSING_STATUS =
        new JITCallCompMatlField<String>("JITIntProcessingStatus");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITIntStatusUpdtdOn</b>
     * </p>
     *
     * @return Internal Processing Status Updated On
     */
    @SerializedName( "JITIntStatusUpdtdOn" )
    @JsonProperty( "JITIntStatusUpdtdOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "JITIntStatusUpdtdOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime jITIntStatusUpdtdOn;
    /**
     * Use with available fluent helpers to apply the <b>JITIntStatusUpdtdOn</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<ZonedDateTime> JIT_INT_STATUS_UPDTD_ON =
        new JITCallCompMatlField<ZonedDateTime>("JITIntStatusUpdtdOn");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStatusByMfr</b>
     * </p>
     *
     * @return Transmitted External Status by Manufacturer
     */
    @SerializedName( "TransmittedExtStatusByMfr" )
    @JsonProperty( "TransmittedExtStatusByMfr" )
    @Nullable
    @ODataField( odataName = "TransmittedExtStatusByMfr" )
    private String transmittedExtStatusByMfr;
    /**
     * Use with available fluent helpers to apply the <b>TransmittedExtStatusByMfr</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> TRANSMITTED_EXT_STATUS_BY_MFR =
        new JITCallCompMatlField<String>("TransmittedExtStatusByMfr");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyControlID</b>
     * </p>
     *
     * @return Supply Control
     */
    @SerializedName( "SupplyControlID" )
    @JsonProperty( "SupplyControlID" )
    @Nullable
    @ODataField( odataName = "SupplyControlID" )
    private String supplyControlID;
    /**
     * Use with available fluent helpers to apply the <b>SupplyControlID</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> SUPPLY_CONTROL_ID =
        new JITCallCompMatlField<String>("SupplyControlID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JITActionCtrl</b>
     * </p>
     *
     * @return Action Control
     */
    @SerializedName( "JITActionCtrl" )
    @JsonProperty( "JITActionCtrl" )
    @Nullable
    @ODataField( odataName = "JITActionCtrl" )
    private String jITActionCtrl;
    /**
     * Use with available fluent helpers to apply the <b>JITActionCtrl</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> JIT_ACTION_CTRL =
        new JITCallCompMatlField<String>("JITActionCtrl");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDateTime</b>
     * </p>
     *
     * @return Requirement Date and Time
     */
    @SerializedName( "RequirementDateTime" )
    @JsonProperty( "RequirementDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequirementDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requirementDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequirementDateTime</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<ZonedDateTime> REQUIREMENT_DATE_TIME =
        new JITCallCompMatlField<ZonedDateTime>("RequirementDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlannedShippingDateTime</b>
     * </p>
     *
     * @return Planned Shipping Date Time
     */
    @SerializedName( "PlannedShippingDateTime" )
    @JsonProperty( "PlannedShippingDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedShippingDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedShippingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedShippingDateTime</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<ZonedDateTime> PLANNED_SHIPPING_DATE_TIME =
        new JITCallCompMatlField<ZonedDateTime>("PlannedShippingDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCreationDate</b>
     * </p>
     *
     * @return Delivery Creation Date
     */
    @SerializedName( "DeliveryCreationDate" )
    @JsonProperty( "DeliveryCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCreationDate</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<LocalDateTime> DELIVERY_CREATION_DATE =
        new JITCallCompMatlField<LocalDateTime>("DeliveryCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAvailabilityDate</b>
     * </p>
     *
     * @return Material Staging/Availability Date
     */
    @SerializedName( "MaterialAvailabilityDate" )
    @JsonProperty( "MaterialAvailabilityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialAvailabilityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialAvailabilityDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialAvailabilityDate</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<LocalDateTime> MATERIAL_AVAILABILITY_DATE =
        new JITCallCompMatlField<LocalDateTime>("MaterialAvailabilityDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustCompGrpMatl</b>
     * </p>
     *
     * @return Customer Components Group Material
     */
    @SerializedName( "CustCompGrpMatl" )
    @JsonProperty( "CustCompGrpMatl" )
    @Nullable
    @ODataField( odataName = "CustCompGrpMatl" )
    private String custCompGrpMatl;
    /**
     * Use with available fluent helpers to apply the <b>CustCompGrpMatl</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> CUST_COMP_GRP_MATL =
        new JITCallCompMatlField<String>("CustCompGrpMatl");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JITExtSequenceNumber</b>
     * </p>
     *
     * @return External Sequence Number
     */
    @SerializedName( "JITExtSequenceNumber" )
    @JsonProperty( "JITExtSequenceNumber" )
    @Nullable
    @ODataField( odataName = "JITExtSequenceNumber" )
    private String jITExtSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>JITExtSequenceNumber</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> JIT_EXT_SEQUENCE_NUMBER =
        new JITCallCompMatlField<String>("JITExtSequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CompGrpMatl</b>
     * </p>
     *
     * @return Components Group Material
     */
    @SerializedName( "CompGrpMatl" )
    @JsonProperty( "CompGrpMatl" )
    @Nullable
    @ODataField( odataName = "CompGrpMatl" )
    private String compGrpMatl;
    /**
     * Use with available fluent helpers to apply the <b>CompGrpMatl</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> COMP_GRP_MATL = new JITCallCompMatlField<String>("CompGrpMatl");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested delivery date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new JITCallCompMatlField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryTime</b>
     * </p>
     *
     * @return Requested delivery time
     */
    @SerializedName( "RequestedDeliveryTime" )
    @JsonProperty( "RequestedDeliveryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime requestedDeliveryTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryTime</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<LocalTime> REQUESTED_DELIVERY_TIME =
        new JITCallCompMatlField<LocalTime>("RequestedDeliveryTime");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ExtCompGrpNumber</b>
     * </p>
     *
     * @return External Component Group Number
     */
    @SerializedName( "ExtCompGrpNumber" )
    @JsonProperty( "ExtCompGrpNumber" )
    @Nullable
    @ODataField( odataName = "ExtCompGrpNumber" )
    private String extCompGrpNumber;
    /**
     * Use with available fluent helpers to apply the <b>ExtCompGrpNumber</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<String> EXT_COMP_GRP_NUMBER =
        new JITCallCompMatlField<String>("ExtCompGrpNumber");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStsUpdtdDteTme</b>
     * </p>
     *
     * @return Transmitted External Status Updated On
     */
    @SerializedName( "TransmittedExtStsUpdtdDteTme" )
    @JsonProperty( "TransmittedExtStsUpdtdDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "TransmittedExtStsUpdtdDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime transmittedExtStsUpdtdDteTme;
    /**
     * Use with available fluent helpers to apply the <b>TransmittedExtStsUpdtdDteTme</b> field to query operations.
     *
     */
    public final static JITCallCompMatlField<ZonedDateTime> TRANSMITTED_EXT_STS_UPDTD_DTE_TME =
        new JITCallCompMatlField<ZonedDateTime>("TransmittedExtStsUpdtdDteTme");
    /**
     * Navigation property <b>to_JITCallRefTextMatTP</b> for <b>JITCallCompMatl</b> to multiple
     * <b>JITCallRefTextCompMatl</b>.
     *
     */
    @SerializedName( "to_JITCallRefTextMatTP" )
    @JsonProperty( "to_JITCallRefTextMatTP" )
    @ODataField( odataName = "to_JITCallRefTextMatTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JITCallRefTextCompMatl> toJITCallRefTextMatTP;
    /**
     * Use with available fluent helpers to apply the <b>to_JITCallRefTextMatTP</b> navigation property to query
     * operations.
     *
     */
    public final static JITCallCompMatlLink<JITCallRefTextCompMatl> TO_JIT_CALL_REF_TEXT_MAT_TP =
        new JITCallCompMatlLink<JITCallRefTextCompMatl>("to_JITCallRefTextMatTP");

    @Nonnull
    @Override
    public Class<JITCallCompMatl> getType()
    {
        return JITCallCompMatl.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @param internalJITCallNumber
     *            Call Number
     */
    public void setInternalJITCallNumber( @Nullable final String internalJITCallNumber )
    {
        rememberChangedField("InternalJITCallNumber", this.internalJITCallNumber);
        this.internalJITCallNumber = internalJITCallNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CompGrpNumber</b>
     * </p>
     *
     * @param compGrpNumber
     *            Component Group Number
     */
    public void setCompGrpNumber( @Nullable final String compGrpNumber )
    {
        rememberChangedField("CompGrpNumber", this.compGrpNumber);
        this.compGrpNumber = compGrpNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITCallItemNumber</b>
     * </p>
     *
     * @param jITCallItemNumber
     *            Call Item Number
     */
    public void setJITCallItemNumber( @Nullable final String jITCallItemNumber )
    {
        rememberChangedField("JITCallItemNumber", this.jITCallItemNumber);
        this.jITCallItemNumber = jITCallItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Customer Material
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExtJITCallItemNumber</b>
     * </p>
     *
     * @param extJITCallItemNumber
     *            External Call Item Number
     */
    public void setExtJITCallItemNumber( @Nullable final String extJITCallItemNumber )
    {
        rememberChangedField("ExtJITCallItemNumber", this.extJITCallItemNumber);
        this.extJITCallItemNumber = extJITCallItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Document
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Document Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDeliveredQuantity</b>
     * </p>
     *
     * @param actualDeliveredQuantity
     *            Delivered Quantity
     */
    public void setActualDeliveredQuantity( @Nullable final BigDecimal actualDeliveredQuantity )
    {
        rememberChangedField("ActualDeliveredQuantity", this.actualDeliveredQuantity);
        this.actualDeliveredQuantity = actualDeliveredQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Base Unit of Measure
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustSupplyArea</b>
     * </p>
     *
     * @param custSupplyArea
     *            Customer Supply Area
     */
    public void setCustSupplyArea( @Nullable final String custSupplyArea )
    {
        rememberChangedField("CustSupplyArea", this.custSupplyArea);
        this.custSupplyArea = custSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplyAreaDesc</b>
     * </p>
     *
     * @param supplyAreaDesc
     *            The supplyAreaDesc to set.
     */
    public void setSupplyAreaDesc( @Nullable final String supplyAreaDesc )
    {
        rememberChangedField("SupplyAreaDesc", this.supplyAreaDesc);
        this.supplyAreaDesc = supplyAreaDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustAssemblyLoc</b>
     * </p>
     *
     * @param custAssemblyLoc
     *            Assembly Location at Customer Site
     */
    public void setCustAssemblyLoc( @Nullable final String custAssemblyLoc )
    {
        rememberChangedField("CustAssemblyLoc", this.custAssemblyLoc);
        this.custAssemblyLoc = custAssemblyLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusAtSupplier</b>
     * </p>
     *
     * @param jITExtStatusAtSupplier
     *            JIT External Status at Supplier
     */
    public void setJITExtStatusAtSupplier( @Nullable final String jITExtStatusAtSupplier )
    {
        rememberChangedField("JITExtStatusAtSupplier", this.jITExtStatusAtSupplier);
        this.jITExtStatusAtSupplier = jITExtStatusAtSupplier;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusUpdtdOn</b>
     * </p>
     *
     * @param jITExtStatusUpdtdOn
     *            External Status Updated On
     */
    public void setJITExtStatusUpdtdOn( @Nullable final ZonedDateTime jITExtStatusUpdtdOn )
    {
        rememberChangedField("JITExtStatusUpdtdOn", this.jITExtStatusUpdtdOn);
        this.jITExtStatusUpdtdOn = jITExtStatusUpdtdOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JITIntProcessingStatus</b>
     * </p>
     *
     * @param jITIntProcessingStatus
     *            Internal Processing Status
     */
    public void setJITIntProcessingStatus( @Nullable final String jITIntProcessingStatus )
    {
        rememberChangedField("JITIntProcessingStatus", this.jITIntProcessingStatus);
        this.jITIntProcessingStatus = jITIntProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITIntStatusUpdtdOn</b>
     * </p>
     *
     * @param jITIntStatusUpdtdOn
     *            Internal Processing Status Updated On
     */
    public void setJITIntStatusUpdtdOn( @Nullable final ZonedDateTime jITIntStatusUpdtdOn )
    {
        rememberChangedField("JITIntStatusUpdtdOn", this.jITIntStatusUpdtdOn);
        this.jITIntStatusUpdtdOn = jITIntStatusUpdtdOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStatusByMfr</b>
     * </p>
     *
     * @param transmittedExtStatusByMfr
     *            Transmitted External Status by Manufacturer
     */
    public void setTransmittedExtStatusByMfr( @Nullable final String transmittedExtStatusByMfr )
    {
        rememberChangedField("TransmittedExtStatusByMfr", this.transmittedExtStatusByMfr);
        this.transmittedExtStatusByMfr = transmittedExtStatusByMfr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyControlID</b>
     * </p>
     *
     * @param supplyControlID
     *            Supply Control
     */
    public void setSupplyControlID( @Nullable final String supplyControlID )
    {
        rememberChangedField("SupplyControlID", this.supplyControlID);
        this.supplyControlID = supplyControlID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JITActionCtrl</b>
     * </p>
     *
     * @param jITActionCtrl
     *            Action Control
     */
    public void setJITActionCtrl( @Nullable final String jITActionCtrl )
    {
        rememberChangedField("JITActionCtrl", this.jITActionCtrl);
        this.jITActionCtrl = jITActionCtrl;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDateTime</b>
     * </p>
     *
     * @param requirementDateTime
     *            Requirement Date and Time
     */
    public void setRequirementDateTime( @Nullable final ZonedDateTime requirementDateTime )
    {
        rememberChangedField("RequirementDateTime", this.requirementDateTime);
        this.requirementDateTime = requirementDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlannedShippingDateTime</b>
     * </p>
     *
     * @param plannedShippingDateTime
     *            Planned Shipping Date Time
     */
    public void setPlannedShippingDateTime( @Nullable final ZonedDateTime plannedShippingDateTime )
    {
        rememberChangedField("PlannedShippingDateTime", this.plannedShippingDateTime);
        this.plannedShippingDateTime = plannedShippingDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCreationDate</b>
     * </p>
     *
     * @param deliveryCreationDate
     *            Delivery Creation Date
     */
    public void setDeliveryCreationDate( @Nullable final LocalDateTime deliveryCreationDate )
    {
        rememberChangedField("DeliveryCreationDate", this.deliveryCreationDate);
        this.deliveryCreationDate = deliveryCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAvailabilityDate</b>
     * </p>
     *
     * @param materialAvailabilityDate
     *            Material Staging/Availability Date
     */
    public void setMaterialAvailabilityDate( @Nullable final LocalDateTime materialAvailabilityDate )
    {
        rememberChangedField("MaterialAvailabilityDate", this.materialAvailabilityDate);
        this.materialAvailabilityDate = materialAvailabilityDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustCompGrpMatl</b>
     * </p>
     *
     * @param custCompGrpMatl
     *            Customer Components Group Material
     */
    public void setCustCompGrpMatl( @Nullable final String custCompGrpMatl )
    {
        rememberChangedField("CustCompGrpMatl", this.custCompGrpMatl);
        this.custCompGrpMatl = custCompGrpMatl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JITExtSequenceNumber</b>
     * </p>
     *
     * @param jITExtSequenceNumber
     *            External Sequence Number
     */
    public void setJITExtSequenceNumber( @Nullable final String jITExtSequenceNumber )
    {
        rememberChangedField("JITExtSequenceNumber", this.jITExtSequenceNumber);
        this.jITExtSequenceNumber = jITExtSequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CompGrpMatl</b>
     * </p>
     *
     * @param compGrpMatl
     *            Components Group Material
     */
    public void setCompGrpMatl( @Nullable final String compGrpMatl )
    {
        rememberChangedField("CompGrpMatl", this.compGrpMatl);
        this.compGrpMatl = compGrpMatl;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested delivery date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryTime</b>
     * </p>
     *
     * @param requestedDeliveryTime
     *            Requested delivery time
     */
    public void setRequestedDeliveryTime( @Nullable final LocalTime requestedDeliveryTime )
    {
        rememberChangedField("RequestedDeliveryTime", this.requestedDeliveryTime);
        this.requestedDeliveryTime = requestedDeliveryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ExtCompGrpNumber</b>
     * </p>
     *
     * @param extCompGrpNumber
     *            External Component Group Number
     */
    public void setExtCompGrpNumber( @Nullable final String extCompGrpNumber )
    {
        rememberChangedField("ExtCompGrpNumber", this.extCompGrpNumber);
        this.extCompGrpNumber = extCompGrpNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStsUpdtdDteTme</b>
     * </p>
     *
     * @param transmittedExtStsUpdtdDteTme
     *            Transmitted External Status Updated On
     */
    public void setTransmittedExtStsUpdtdDteTme( @Nullable final ZonedDateTime transmittedExtStsUpdtdDteTme )
    {
        rememberChangedField("TransmittedExtStsUpdtdDteTme", this.transmittedExtStsUpdtdDteTme);
        this.transmittedExtStsUpdtdDteTme = transmittedExtStsUpdtdDteTme;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_JITCallCompMatl";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InternalJITCallNumber", getInternalJITCallNumber());
        result.put("CompGrpNumber", getCompGrpNumber());
        result.put("JITCallItemNumber", getJITCallItemNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InternalJITCallNumber", getInternalJITCallNumber());
        values.put("CompGrpNumber", getCompGrpNumber());
        values.put("JITCallItemNumber", getJITCallItemNumber());
        values.put("ShipToParty", getShipToParty());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("ExtJITCallItemNumber", getExtJITCallItemNumber());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("ActualDeliveredQuantity", getActualDeliveredQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("ShippingPoint", getShippingPoint());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("CustSupplyArea", getCustSupplyArea());
        values.put("SupplyAreaDesc", getSupplyAreaDesc());
        values.put("CustAssemblyLoc", getCustAssemblyLoc());
        values.put("JITExtStatusAtSupplier", getJITExtStatusAtSupplier());
        values.put("JITExtStatusUpdtdOn", getJITExtStatusUpdtdOn());
        values.put("JITIntProcessingStatus", getJITIntProcessingStatus());
        values.put("JITIntStatusUpdtdOn", getJITIntStatusUpdtdOn());
        values.put("TransmittedExtStatusByMfr", getTransmittedExtStatusByMfr());
        values.put("SupplyControlID", getSupplyControlID());
        values.put("JITActionCtrl", getJITActionCtrl());
        values.put("RequirementDateTime", getRequirementDateTime());
        values.put("PlannedShippingDateTime", getPlannedShippingDateTime());
        values.put("DeliveryCreationDate", getDeliveryCreationDate());
        values.put("MaterialAvailabilityDate", getMaterialAvailabilityDate());
        values.put("CustCompGrpMatl", getCustCompGrpMatl());
        values.put("JITExtSequenceNumber", getJITExtSequenceNumber());
        values.put("CompGrpMatl", getCompGrpMatl());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("RequestedDeliveryTime", getRequestedDeliveryTime());
        values.put("ExtCompGrpNumber", getExtCompGrpNumber());
        values.put("TransmittedExtStsUpdtdDteTme", getTransmittedExtStsUpdtdDteTme());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalJITCallNumber") ) {
                final Object value = values.remove("InternalJITCallNumber");
                if( (value == null) || (!value.equals(getInternalJITCallNumber())) ) {
                    setInternalJITCallNumber(((String) value));
                }
            }
            if( values.containsKey("CompGrpNumber") ) {
                final Object value = values.remove("CompGrpNumber");
                if( (value == null) || (!value.equals(getCompGrpNumber())) ) {
                    setCompGrpNumber(((String) value));
                }
            }
            if( values.containsKey("JITCallItemNumber") ) {
                final Object value = values.remove("JITCallItemNumber");
                if( (value == null) || (!value.equals(getJITCallItemNumber())) ) {
                    setJITCallItemNumber(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("ExtJITCallItemNumber") ) {
                final Object value = values.remove("ExtJITCallItemNumber");
                if( (value == null) || (!value.equals(getExtJITCallItemNumber())) ) {
                    setExtJITCallItemNumber(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualDeliveredQuantity") ) {
                final Object value = values.remove("ActualDeliveredQuantity");
                if( (value == null) || (!value.equals(getActualDeliveredQuantity())) ) {
                    setActualDeliveredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("CustSupplyArea") ) {
                final Object value = values.remove("CustSupplyArea");
                if( (value == null) || (!value.equals(getCustSupplyArea())) ) {
                    setCustSupplyArea(((String) value));
                }
            }
            if( values.containsKey("SupplyAreaDesc") ) {
                final Object value = values.remove("SupplyAreaDesc");
                if( (value == null) || (!value.equals(getSupplyAreaDesc())) ) {
                    setSupplyAreaDesc(((String) value));
                }
            }
            if( values.containsKey("CustAssemblyLoc") ) {
                final Object value = values.remove("CustAssemblyLoc");
                if( (value == null) || (!value.equals(getCustAssemblyLoc())) ) {
                    setCustAssemblyLoc(((String) value));
                }
            }
            if( values.containsKey("JITExtStatusAtSupplier") ) {
                final Object value = values.remove("JITExtStatusAtSupplier");
                if( (value == null) || (!value.equals(getJITExtStatusAtSupplier())) ) {
                    setJITExtStatusAtSupplier(((String) value));
                }
            }
            if( values.containsKey("JITExtStatusUpdtdOn") ) {
                final Object value = values.remove("JITExtStatusUpdtdOn");
                if( (value == null) || (!value.equals(getJITExtStatusUpdtdOn())) ) {
                    setJITExtStatusUpdtdOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("JITIntProcessingStatus") ) {
                final Object value = values.remove("JITIntProcessingStatus");
                if( (value == null) || (!value.equals(getJITIntProcessingStatus())) ) {
                    setJITIntProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("JITIntStatusUpdtdOn") ) {
                final Object value = values.remove("JITIntStatusUpdtdOn");
                if( (value == null) || (!value.equals(getJITIntStatusUpdtdOn())) ) {
                    setJITIntStatusUpdtdOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("TransmittedExtStatusByMfr") ) {
                final Object value = values.remove("TransmittedExtStatusByMfr");
                if( (value == null) || (!value.equals(getTransmittedExtStatusByMfr())) ) {
                    setTransmittedExtStatusByMfr(((String) value));
                }
            }
            if( values.containsKey("SupplyControlID") ) {
                final Object value = values.remove("SupplyControlID");
                if( (value == null) || (!value.equals(getSupplyControlID())) ) {
                    setSupplyControlID(((String) value));
                }
            }
            if( values.containsKey("JITActionCtrl") ) {
                final Object value = values.remove("JITActionCtrl");
                if( (value == null) || (!value.equals(getJITActionCtrl())) ) {
                    setJITActionCtrl(((String) value));
                }
            }
            if( values.containsKey("RequirementDateTime") ) {
                final Object value = values.remove("RequirementDateTime");
                if( (value == null) || (!value.equals(getRequirementDateTime())) ) {
                    setRequirementDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlannedShippingDateTime") ) {
                final Object value = values.remove("PlannedShippingDateTime");
                if( (value == null) || (!value.equals(getPlannedShippingDateTime())) ) {
                    setPlannedShippingDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("DeliveryCreationDate") ) {
                final Object value = values.remove("DeliveryCreationDate");
                if( (value == null) || (!value.equals(getDeliveryCreationDate())) ) {
                    setDeliveryCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialAvailabilityDate") ) {
                final Object value = values.remove("MaterialAvailabilityDate");
                if( (value == null) || (!value.equals(getMaterialAvailabilityDate())) ) {
                    setMaterialAvailabilityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustCompGrpMatl") ) {
                final Object value = values.remove("CustCompGrpMatl");
                if( (value == null) || (!value.equals(getCustCompGrpMatl())) ) {
                    setCustCompGrpMatl(((String) value));
                }
            }
            if( values.containsKey("JITExtSequenceNumber") ) {
                final Object value = values.remove("JITExtSequenceNumber");
                if( (value == null) || (!value.equals(getJITExtSequenceNumber())) ) {
                    setJITExtSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("CompGrpMatl") ) {
                final Object value = values.remove("CompGrpMatl");
                if( (value == null) || (!value.equals(getCompGrpMatl())) ) {
                    setCompGrpMatl(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequestedDeliveryTime") ) {
                final Object value = values.remove("RequestedDeliveryTime");
                if( (value == null) || (!value.equals(getRequestedDeliveryTime())) ) {
                    setRequestedDeliveryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ExtCompGrpNumber") ) {
                final Object value = values.remove("ExtCompGrpNumber");
                if( (value == null) || (!value.equals(getExtCompGrpNumber())) ) {
                    setExtCompGrpNumber(((String) value));
                }
            }
            if( values.containsKey("TransmittedExtStsUpdtdDteTme") ) {
                final Object value = values.remove("TransmittedExtStsUpdtdDteTme");
                if( (value == null) || (!value.equals(getTransmittedExtStsUpdtdDteTme())) ) {
                    setTransmittedExtStsUpdtdDteTme(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_JITCallRefTextMatTP") ) {
                final Object value = (values).remove("to_JITCallRefTextMatTP");
                if( value instanceof Iterable ) {
                    if( toJITCallRefTextMatTP == null ) {
                        toJITCallRefTextMatTP = Lists.newArrayList();
                    } else {
                        toJITCallRefTextMatTP = Lists.newArrayList(toJITCallRefTextMatTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JITCallRefTextCompMatl entity;
                        if( toJITCallRefTextMatTP.size() > i ) {
                            entity = toJITCallRefTextMatTP.get(i);
                        } else {
                            entity = new JITCallRefTextCompMatl();
                            toJITCallRefTextMatTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> JITCallCompMatlField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new JITCallCompMatlField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> JITCallCompMatlField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new JITCallCompMatlField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toJITCallRefTextMatTP != null ) {
            (values).put("to_JITCallRefTextMatTP", toJITCallRefTextMatTP);
        }
        return values;
    }

    /**
     * Fetches the <b>JITCallRefTextCompMatl</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_JITCallRefTextMatTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>JITCallRefTextCompMatl</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JITCallRefTextCompMatl> fetchJITCallRefTextMatTP()
    {
        return fetchFieldAsList("to_JITCallRefTextMatTP", JITCallRefTextCompMatl.class);
    }

    /**
     * Retrieval of associated <b>JITCallRefTextCompMatl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_JITCallRefTextMatTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallRefTextMatTP</b> of a queried <b>JITCallCompMatl</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>JITCallRefTextCompMatl</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JITCallRefTextCompMatl> getJITCallRefTextMatTPOrFetch()
    {
        if( toJITCallRefTextMatTP == null ) {
            toJITCallRefTextMatTP = fetchJITCallRefTextMatTP();
        }
        return toJITCallRefTextMatTP;
    }

    /**
     * Retrieval of associated <b>JITCallRefTextCompMatl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_JITCallRefTextMatTP</b>.
     * <p>
     * If the navigation property for an entity <b>JITCallCompMatl</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_JITCallRefTextMatTP</b> is already loaded, the result
     *         will contain the <b>JITCallRefTextCompMatl</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JITCallRefTextCompMatl>> getJITCallRefTextMatTPIfPresent()
    {
        return Option.of(toJITCallRefTextMatTP);
    }

    /**
     * Overwrites the list of associated <b>JITCallRefTextCompMatl</b> entities for the loaded navigation property
     * <b>to_JITCallRefTextMatTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallRefTextMatTP</b> of a queried <b>JITCallCompMatl</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>JITCallRefTextCompMatl</b> entities.
     */
    public void setJITCallRefTextMatTP( @Nonnull final List<JITCallRefTextCompMatl> value )
    {
        if( toJITCallRefTextMatTP == null ) {
            toJITCallRefTextMatTP = Lists.newArrayList();
        }
        toJITCallRefTextMatTP.clear();
        toJITCallRefTextMatTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JITCallRefTextCompMatl</b> entities. This corresponds to the OData
     * navigation property <b>to_JITCallRefTextMatTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallRefTextMatTP</b> of a queried <b>JITCallCompMatl</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>JITCallRefTextCompMatl</b> entities.
     */
    public void addJITCallRefTextMatTP( JITCallRefTextCompMatl... entity )
    {
        if( toJITCallRefTextMatTP == null ) {
            toJITCallRefTextMatTP = Lists.newArrayList();
        }
        toJITCallRefTextMatTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of JITCallCompMatl instances.
     *
     */
    public final static class JITCallCompMatlBuilder
    {

        private List<JITCallRefTextCompMatl> toJITCallRefTextMatTP = Lists.newArrayList();

        private JITCallCompMatl.JITCallCompMatlBuilder toJITCallRefTextMatTP( final List<JITCallRefTextCompMatl> value )
        {
            toJITCallRefTextMatTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_JITCallRefTextMatTP</b> for <b>JITCallCompMatl</b> to multiple
         * <b>JITCallRefTextCompMatl</b>.
         *
         * @param value
         *            The JITCallRefTextCompMatls to build this JITCallCompMatl with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JITCallCompMatl.JITCallCompMatlBuilder jitCallRefTextMatTP( JITCallRefTextCompMatl... value )
        {
            return toJITCallRefTextMatTP(Lists.newArrayList(value));
        }

    }

}
