/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable.JITCallHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JITCallHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class JITCallHeader extends VdmEntity<JITCallHeader>
{

    /**
     * Selector for all available fields of JITCallHeader.
     *
     */
    public final static JITCallHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @return Call Number
     */
    @Key
    @SerializedName( "InternalJITCallNumber" )
    @JsonProperty( "InternalJITCallNumber" )
    @Nullable
    @ODataField( odataName = "InternalJITCallNumber" )
    private String internalJITCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternalJITCallNumber</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> INTERNAL_JIT_CALL_NUMBER =
        new JITCallHeaderField<String>("InternalJITCallNumber");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ExternalJITCallNumber</b>
     * </p>
     *
     * @return External Call Number
     */
    @SerializedName( "ExternalJITCallNumber" )
    @JsonProperty( "ExternalJITCallNumber" )
    @Nullable
    @ODataField( odataName = "ExternalJITCallNumber" )
    private String externalJITCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>ExternalJITCallNumber</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> EXTERNAL_JIT_CALL_NUMBER =
        new JITCallHeaderField<String>("ExternalJITCallNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JITCallType</b>
     * </p>
     *
     * @return Call Type
     */
    @SerializedName( "JITCallType" )
    @JsonProperty( "JITCallType" )
    @Nullable
    @ODataField( odataName = "JITCallType" )
    private String jITCallType;
    /**
     * Use with available fluent helpers to apply the <b>JITCallType</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> JIT_CALL_TYPE = new JITCallHeaderField<String>("JITCallType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-to Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> SHIP_TO_PARTY = new JITCallHeaderField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> SOLD_TO_PARTY = new JITCallHeaderField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPartnerDescription</b>
     * </p>
     *
     * @return Cust.-Specif. Descr. of Business Partner (Plant, Stor. Loc.)
     */
    @SerializedName( "CustomerPartnerDescription" )
    @JsonProperty( "CustomerPartnerDescription" )
    @Nullable
    @ODataField( odataName = "CustomerPartnerDescription" )
    private String customerPartnerDescription;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPartnerDescription</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> CUSTOMER_PARTNER_DESCRIPTION =
        new JITCallHeaderField<String>("CustomerPartnerDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActiveSupplier</b>
     * </p>
     *
     * @return Partner Description of Supplier
     */
    @SerializedName( "ActiveSupplier" )
    @JsonProperty( "ActiveSupplier" )
    @Nullable
    @ODataField( odataName = "ActiveSupplier" )
    private String activeSupplier;
    /**
     * Use with available fluent helpers to apply the <b>ActiveSupplier</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> ACTIVE_SUPPLIER = new JITCallHeaderField<String>("ActiveSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatlUsageIndicator</b>
     * </p>
     *
     * @return Usage Indicator
     */
    @SerializedName( "MatlUsageIndicator" )
    @JsonProperty( "MatlUsageIndicator" )
    @Nullable
    @ODataField( odataName = "MatlUsageIndicator" )
    private String matlUsageIndicator;
    /**
     * Use with available fluent helpers to apply the <b>MatlUsageIndicator</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> MATL_USAGE_INDICATOR =
        new JITCallHeaderField<String>("MatlUsageIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> SALES_ORGANIZATION =
        new JITCallHeaderField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> DISTRIBUTION_CHANNEL =
        new JITCallHeaderField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> DIVISION = new JITCallHeaderField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JITLifecycleStatus</b>
     * </p>
     *
     * @return Life Cycle Status
     */
    @SerializedName( "JITLifecycleStatus" )
    @JsonProperty( "JITLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "JITLifecycleStatus" )
    private String jITLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>JITLifecycleStatus</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> JIT_LIFECYCLE_STATUS =
        new JITCallHeaderField<String>("JITLifecycleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> CREATED_BY_USER = new JITCallHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> CREATION_DATE_TIME =
        new JITCallHeaderField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> LAST_CHANGED_BY_USER =
        new JITCallHeaderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new JITCallHeaderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JITExtSequenceNumber</b>
     * </p>
     *
     * @return External Sequence Number
     */
    @SerializedName( "JITExtSequenceNumber" )
    @JsonProperty( "JITExtSequenceNumber" )
    @Nullable
    @ODataField( odataName = "JITExtSequenceNumber" )
    private String jITExtSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>JITExtSequenceNumber</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> JIT_EXT_SEQUENCE_NUMBER =
        new JITCallHeaderField<String>("JITExtSequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>VehicleIdentificationNumber</b>
     * </p>
     *
     * @return Vehicle Identification Number (Vehicle Identification No.)
     */
    @SerializedName( "VehicleIdentificationNumber" )
    @JsonProperty( "VehicleIdentificationNumber" )
    @Nullable
    @ODataField( odataName = "VehicleIdentificationNumber" )
    private String vehicleIdentificationNumber;
    /**
     * Use with available fluent helpers to apply the <b>VehicleIdentificationNumber</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> VEHICLE_IDENTIFICATION_NUMBER =
        new JITCallHeaderField<String>("VehicleIdentificationNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>VehicleModel</b>
     * </p>
     *
     * @return Vehicle Model
     */
    @SerializedName( "VehicleModel" )
    @JsonProperty( "VehicleModel" )
    @Nullable
    @ODataField( odataName = "VehicleModel" )
    private String vehicleModel;
    /**
     * Use with available fluent helpers to apply the <b>VehicleModel</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> VEHICLE_MODEL = new JITCallHeaderField<String>("VehicleModel");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> PLANT = new JITCallHeaderField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusAtSupplier</b>
     * </p>
     *
     * @return JIT External Status at Supplier
     */
    @SerializedName( "JITExtStatusAtSupplier" )
    @JsonProperty( "JITExtStatusAtSupplier" )
    @Nullable
    @ODataField( odataName = "JITExtStatusAtSupplier" )
    private String jITExtStatusAtSupplier;
    /**
     * Use with available fluent helpers to apply the <b>JITExtStatusAtSupplier</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> JIT_EXT_STATUS_AT_SUPPLIER =
        new JITCallHeaderField<String>("JITExtStatusAtSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JITIntProcessingStatus</b>
     * </p>
     *
     * @return Internal Processing Status
     */
    @SerializedName( "JITIntProcessingStatus" )
    @JsonProperty( "JITIntProcessingStatus" )
    @Nullable
    @ODataField( odataName = "JITIntProcessingStatus" )
    private String jITIntProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>JITIntProcessingStatus</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> JIT_INT_PROCESSING_STATUS =
        new JITCallHeaderField<String>("JITIntProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CompGrpMatl</b>
     * </p>
     *
     * @return Components Group Material
     */
    @SerializedName( "CompGrpMatl" )
    @JsonProperty( "CompGrpMatl" )
    @Nullable
    @ODataField( odataName = "CompGrpMatl" )
    private String compGrpMatl;
    /**
     * Use with available fluent helpers to apply the <b>CompGrpMatl</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> COMP_GRP_MATL = new JITCallHeaderField<String>("CompGrpMatl");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> MATERIAL = new JITCallHeaderField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Customer Material
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> MATERIAL_BY_CUSTOMER =
        new JITCallHeaderField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCreationDate</b>
     * </p>
     *
     * @return Delivery Creation Date
     */
    @SerializedName( "DeliveryCreationDate" )
    @JsonProperty( "DeliveryCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryCreationDate</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<LocalDateTime> DELIVERY_CREATION_DATE =
        new JITCallHeaderField<LocalDateTime>("DeliveryCreationDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDateTime</b>
     * </p>
     *
     * @return Requirement Date and Time
     */
    @SerializedName( "RequirementDateTime" )
    @JsonProperty( "RequirementDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequirementDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requirementDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequirementDateTime</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> REQUIREMENT_DATE_TIME =
        new JITCallHeaderField<ZonedDateTime>("RequirementDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlannedShippingDateTime</b>
     * </p>
     *
     * @return Planned Shipping Date Time
     */
    @SerializedName( "PlannedShippingDateTime" )
    @JsonProperty( "PlannedShippingDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedShippingDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedShippingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedShippingDateTime</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> PLANNED_SHIPPING_DATE_TIME =
        new JITCallHeaderField<ZonedDateTime>("PlannedShippingDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAvailabilityDate</b>
     * </p>
     *
     * @return Material Staging/Availability Date
     */
    @SerializedName( "MaterialAvailabilityDate" )
    @JsonProperty( "MaterialAvailabilityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialAvailabilityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialAvailabilityDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialAvailabilityDate</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<LocalDateTime> MATERIAL_AVAILABILITY_DATE =
        new JITCallHeaderField<LocalDateTime>("MaterialAvailabilityDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusUpdtdOn</b>
     * </p>
     *
     * @return External Status Updated On
     */
    @SerializedName( "JITExtStatusUpdtdOn" )
    @JsonProperty( "JITExtStatusUpdtdOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "JITExtStatusUpdtdOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime jITExtStatusUpdtdOn;
    /**
     * Use with available fluent helpers to apply the <b>JITExtStatusUpdtdOn</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> JIT_EXT_STATUS_UPDTD_ON =
        new JITCallHeaderField<ZonedDateTime>("JITExtStatusUpdtdOn");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITIntStatusUpdtdOn</b>
     * </p>
     *
     * @return Internal Processing Status Updated On
     */
    @SerializedName( "JITIntStatusUpdtdOn" )
    @JsonProperty( "JITIntStatusUpdtdOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "JITIntStatusUpdtdOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime jITIntStatusUpdtdOn;
    /**
     * Use with available fluent helpers to apply the <b>JITIntStatusUpdtdOn</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> JIT_INT_STATUS_UPDTD_ON =
        new JITCallHeaderField<ZonedDateTime>("JITIntStatusUpdtdOn");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStatusByMfr</b>
     * </p>
     *
     * @return Transmitted External Status by Manufacturer
     */
    @SerializedName( "TransmittedExtStatusByMfr" )
    @JsonProperty( "TransmittedExtStatusByMfr" )
    @Nullable
    @ODataField( odataName = "TransmittedExtStatusByMfr" )
    private String transmittedExtStatusByMfr;
    /**
     * Use with available fluent helpers to apply the <b>TransmittedExtStatusByMfr</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<String> TRANSMITTED_EXT_STATUS_BY_MFR =
        new JITCallHeaderField<String>("TransmittedExtStatusByMfr");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStsUpdtdDteTme</b>
     * </p>
     *
     * @return Transmitted External Status Updated On
     */
    @SerializedName( "TransmittedExtStsUpdtdDteTme" )
    @JsonProperty( "TransmittedExtStsUpdtdDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "TransmittedExtStsUpdtdDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime transmittedExtStsUpdtdDteTme;
    /**
     * Use with available fluent helpers to apply the <b>TransmittedExtStsUpdtdDteTme</b> field to query operations.
     *
     */
    public final static JITCallHeaderField<ZonedDateTime> TRANSMITTED_EXT_STS_UPDTD_DTE_TME =
        new JITCallHeaderField<ZonedDateTime>("TransmittedExtStsUpdtdDteTme");
    /**
     * Navigation property <b>to_JITCallCompGrpDataTP</b> for <b>JITCallHeader</b> to multiple <b>JITCallCompGrp</b>.
     *
     */
    @SerializedName( "to_JITCallCompGrpDataTP" )
    @JsonProperty( "to_JITCallCompGrpDataTP" )
    @ODataField( odataName = "to_JITCallCompGrpDataTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JITCallCompGrp> toJITCallCompGrpDataTP;
    /**
     * Navigation property <b>to_JITCallRefTextHdrTP</b> for <b>JITCallHeader</b> to multiple <b>JITCallRefTextHdr</b>.
     *
     */
    @SerializedName( "to_JITCallRefTextHdrTP" )
    @JsonProperty( "to_JITCallRefTextHdrTP" )
    @ODataField( odataName = "to_JITCallRefTextHdrTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JITCallRefTextHdr> toJITCallRefTextHdrTP;
    /**
     * Use with available fluent helpers to apply the <b>to_JITCallCompGrpDataTP</b> navigation property to query
     * operations.
     *
     */
    public final static JITCallHeaderLink<JITCallCompGrp> TO_JIT_CALL_COMP_GRP_DATA_TP =
        new JITCallHeaderLink<JITCallCompGrp>("to_JITCallCompGrpDataTP");
    /**
     * Use with available fluent helpers to apply the <b>to_JITCallRefTextHdrTP</b> navigation property to query
     * operations.
     *
     */
    public final static JITCallHeaderLink<JITCallRefTextHdr> TO_JIT_CALL_REF_TEXT_HDR_TP =
        new JITCallHeaderLink<JITCallRefTextHdr>("to_JITCallRefTextHdrTP");

    @Nonnull
    @Override
    public Class<JITCallHeader> getType()
    {
        return JITCallHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @param internalJITCallNumber
     *            Call Number
     */
    public void setInternalJITCallNumber( @Nullable final String internalJITCallNumber )
    {
        rememberChangedField("InternalJITCallNumber", this.internalJITCallNumber);
        this.internalJITCallNumber = internalJITCallNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ExternalJITCallNumber</b>
     * </p>
     *
     * @param externalJITCallNumber
     *            External Call Number
     */
    public void setExternalJITCallNumber( @Nullable final String externalJITCallNumber )
    {
        rememberChangedField("ExternalJITCallNumber", this.externalJITCallNumber);
        this.externalJITCallNumber = externalJITCallNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JITCallType</b>
     * </p>
     *
     * @param jITCallType
     *            Call Type
     */
    public void setJITCallType( @Nullable final String jITCallType )
    {
        rememberChangedField("JITCallType", this.jITCallType);
        this.jITCallType = jITCallType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPartnerDescription</b>
     * </p>
     *
     * @param customerPartnerDescription
     *            Cust.-Specif. Descr. of Business Partner (Plant, Stor. Loc.)
     */
    public void setCustomerPartnerDescription( @Nullable final String customerPartnerDescription )
    {
        rememberChangedField("CustomerPartnerDescription", this.customerPartnerDescription);
        this.customerPartnerDescription = customerPartnerDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActiveSupplier</b>
     * </p>
     *
     * @param activeSupplier
     *            Partner Description of Supplier
     */
    public void setActiveSupplier( @Nullable final String activeSupplier )
    {
        rememberChangedField("ActiveSupplier", this.activeSupplier);
        this.activeSupplier = activeSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatlUsageIndicator</b>
     * </p>
     *
     * @param matlUsageIndicator
     *            Usage Indicator
     */
    public void setMatlUsageIndicator( @Nullable final String matlUsageIndicator )
    {
        rememberChangedField("MatlUsageIndicator", this.matlUsageIndicator);
        this.matlUsageIndicator = matlUsageIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JITLifecycleStatus</b>
     * </p>
     *
     * @param jITLifecycleStatus
     *            Life Cycle Status
     */
    public void setJITLifecycleStatus( @Nullable final String jITLifecycleStatus )
    {
        rememberChangedField("JITLifecycleStatus", this.jITLifecycleStatus);
        this.jITLifecycleStatus = jITLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            User Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JITExtSequenceNumber</b>
     * </p>
     *
     * @param jITExtSequenceNumber
     *            External Sequence Number
     */
    public void setJITExtSequenceNumber( @Nullable final String jITExtSequenceNumber )
    {
        rememberChangedField("JITExtSequenceNumber", this.jITExtSequenceNumber);
        this.jITExtSequenceNumber = jITExtSequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>VehicleIdentificationNumber</b>
     * </p>
     *
     * @param vehicleIdentificationNumber
     *            Vehicle Identification Number (Vehicle Identification No.)
     */
    public void setVehicleIdentificationNumber( @Nullable final String vehicleIdentificationNumber )
    {
        rememberChangedField("VehicleIdentificationNumber", this.vehicleIdentificationNumber);
        this.vehicleIdentificationNumber = vehicleIdentificationNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>VehicleModel</b>
     * </p>
     *
     * @param vehicleModel
     *            Vehicle Model
     */
    public void setVehicleModel( @Nullable final String vehicleModel )
    {
        rememberChangedField("VehicleModel", this.vehicleModel);
        this.vehicleModel = vehicleModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusAtSupplier</b>
     * </p>
     *
     * @param jITExtStatusAtSupplier
     *            JIT External Status at Supplier
     */
    public void setJITExtStatusAtSupplier( @Nullable final String jITExtStatusAtSupplier )
    {
        rememberChangedField("JITExtStatusAtSupplier", this.jITExtStatusAtSupplier);
        this.jITExtStatusAtSupplier = jITExtStatusAtSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JITIntProcessingStatus</b>
     * </p>
     *
     * @param jITIntProcessingStatus
     *            Internal Processing Status
     */
    public void setJITIntProcessingStatus( @Nullable final String jITIntProcessingStatus )
    {
        rememberChangedField("JITIntProcessingStatus", this.jITIntProcessingStatus);
        this.jITIntProcessingStatus = jITIntProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CompGrpMatl</b>
     * </p>
     *
     * @param compGrpMatl
     *            Components Group Material
     */
    public void setCompGrpMatl( @Nullable final String compGrpMatl )
    {
        rememberChangedField("CompGrpMatl", this.compGrpMatl);
        this.compGrpMatl = compGrpMatl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Customer Material
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryCreationDate</b>
     * </p>
     *
     * @param deliveryCreationDate
     *            Delivery Creation Date
     */
    public void setDeliveryCreationDate( @Nullable final LocalDateTime deliveryCreationDate )
    {
        rememberChangedField("DeliveryCreationDate", this.deliveryCreationDate);
        this.deliveryCreationDate = deliveryCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDateTime</b>
     * </p>
     *
     * @param requirementDateTime
     *            Requirement Date and Time
     */
    public void setRequirementDateTime( @Nullable final ZonedDateTime requirementDateTime )
    {
        rememberChangedField("RequirementDateTime", this.requirementDateTime);
        this.requirementDateTime = requirementDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlannedShippingDateTime</b>
     * </p>
     *
     * @param plannedShippingDateTime
     *            Planned Shipping Date Time
     */
    public void setPlannedShippingDateTime( @Nullable final ZonedDateTime plannedShippingDateTime )
    {
        rememberChangedField("PlannedShippingDateTime", this.plannedShippingDateTime);
        this.plannedShippingDateTime = plannedShippingDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAvailabilityDate</b>
     * </p>
     *
     * @param materialAvailabilityDate
     *            Material Staging/Availability Date
     */
    public void setMaterialAvailabilityDate( @Nullable final LocalDateTime materialAvailabilityDate )
    {
        rememberChangedField("MaterialAvailabilityDate", this.materialAvailabilityDate);
        this.materialAvailabilityDate = materialAvailabilityDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITExtStatusUpdtdOn</b>
     * </p>
     *
     * @param jITExtStatusUpdtdOn
     *            External Status Updated On
     */
    public void setJITExtStatusUpdtdOn( @Nullable final ZonedDateTime jITExtStatusUpdtdOn )
    {
        rememberChangedField("JITExtStatusUpdtdOn", this.jITExtStatusUpdtdOn);
        this.jITExtStatusUpdtdOn = jITExtStatusUpdtdOn;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>JITIntStatusUpdtdOn</b>
     * </p>
     *
     * @param jITIntStatusUpdtdOn
     *            Internal Processing Status Updated On
     */
    public void setJITIntStatusUpdtdOn( @Nullable final ZonedDateTime jITIntStatusUpdtdOn )
    {
        rememberChangedField("JITIntStatusUpdtdOn", this.jITIntStatusUpdtdOn);
        this.jITIntStatusUpdtdOn = jITIntStatusUpdtdOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStatusByMfr</b>
     * </p>
     *
     * @param transmittedExtStatusByMfr
     *            Transmitted External Status by Manufacturer
     */
    public void setTransmittedExtStatusByMfr( @Nullable final String transmittedExtStatusByMfr )
    {
        rememberChangedField("TransmittedExtStatusByMfr", this.transmittedExtStatusByMfr);
        this.transmittedExtStatusByMfr = transmittedExtStatusByMfr;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>TransmittedExtStsUpdtdDteTme</b>
     * </p>
     *
     * @param transmittedExtStsUpdtdDteTme
     *            Transmitted External Status Updated On
     */
    public void setTransmittedExtStsUpdtdDteTme( @Nullable final ZonedDateTime transmittedExtStsUpdtdDteTme )
    {
        rememberChangedField("TransmittedExtStsUpdtdDteTme", this.transmittedExtStsUpdtdDteTme);
        this.transmittedExtStsUpdtdDteTme = transmittedExtStsUpdtdDteTme;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_JITCallHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InternalJITCallNumber", getInternalJITCallNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InternalJITCallNumber", getInternalJITCallNumber());
        values.put("ExternalJITCallNumber", getExternalJITCallNumber());
        values.put("JITCallType", getJITCallType());
        values.put("ShipToParty", getShipToParty());
        values.put("SoldToParty", getSoldToParty());
        values.put("CustomerPartnerDescription", getCustomerPartnerDescription());
        values.put("ActiveSupplier", getActiveSupplier());
        values.put("MatlUsageIndicator", getMatlUsageIndicator());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("JITLifecycleStatus", getJITLifecycleStatus());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("JITExtSequenceNumber", getJITExtSequenceNumber());
        values.put("VehicleIdentificationNumber", getVehicleIdentificationNumber());
        values.put("VehicleModel", getVehicleModel());
        values.put("Plant", getPlant());
        values.put("JITExtStatusAtSupplier", getJITExtStatusAtSupplier());
        values.put("JITIntProcessingStatus", getJITIntProcessingStatus());
        values.put("CompGrpMatl", getCompGrpMatl());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("DeliveryCreationDate", getDeliveryCreationDate());
        values.put("RequirementDateTime", getRequirementDateTime());
        values.put("PlannedShippingDateTime", getPlannedShippingDateTime());
        values.put("MaterialAvailabilityDate", getMaterialAvailabilityDate());
        values.put("JITExtStatusUpdtdOn", getJITExtStatusUpdtdOn());
        values.put("JITIntStatusUpdtdOn", getJITIntStatusUpdtdOn());
        values.put("TransmittedExtStatusByMfr", getTransmittedExtStatusByMfr());
        values.put("TransmittedExtStsUpdtdDteTme", getTransmittedExtStsUpdtdDteTme());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalJITCallNumber") ) {
                final Object value = values.remove("InternalJITCallNumber");
                if( (value == null) || (!value.equals(getInternalJITCallNumber())) ) {
                    setInternalJITCallNumber(((String) value));
                }
            }
            if( values.containsKey("ExternalJITCallNumber") ) {
                final Object value = values.remove("ExternalJITCallNumber");
                if( (value == null) || (!value.equals(getExternalJITCallNumber())) ) {
                    setExternalJITCallNumber(((String) value));
                }
            }
            if( values.containsKey("JITCallType") ) {
                final Object value = values.remove("JITCallType");
                if( (value == null) || (!value.equals(getJITCallType())) ) {
                    setJITCallType(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("CustomerPartnerDescription") ) {
                final Object value = values.remove("CustomerPartnerDescription");
                if( (value == null) || (!value.equals(getCustomerPartnerDescription())) ) {
                    setCustomerPartnerDescription(((String) value));
                }
            }
            if( values.containsKey("ActiveSupplier") ) {
                final Object value = values.remove("ActiveSupplier");
                if( (value == null) || (!value.equals(getActiveSupplier())) ) {
                    setActiveSupplier(((String) value));
                }
            }
            if( values.containsKey("MatlUsageIndicator") ) {
                final Object value = values.remove("MatlUsageIndicator");
                if( (value == null) || (!value.equals(getMatlUsageIndicator())) ) {
                    setMatlUsageIndicator(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("JITLifecycleStatus") ) {
                final Object value = values.remove("JITLifecycleStatus");
                if( (value == null) || (!value.equals(getJITLifecycleStatus())) ) {
                    setJITLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("JITExtSequenceNumber") ) {
                final Object value = values.remove("JITExtSequenceNumber");
                if( (value == null) || (!value.equals(getJITExtSequenceNumber())) ) {
                    setJITExtSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("VehicleIdentificationNumber") ) {
                final Object value = values.remove("VehicleIdentificationNumber");
                if( (value == null) || (!value.equals(getVehicleIdentificationNumber())) ) {
                    setVehicleIdentificationNumber(((String) value));
                }
            }
            if( values.containsKey("VehicleModel") ) {
                final Object value = values.remove("VehicleModel");
                if( (value == null) || (!value.equals(getVehicleModel())) ) {
                    setVehicleModel(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("JITExtStatusAtSupplier") ) {
                final Object value = values.remove("JITExtStatusAtSupplier");
                if( (value == null) || (!value.equals(getJITExtStatusAtSupplier())) ) {
                    setJITExtStatusAtSupplier(((String) value));
                }
            }
            if( values.containsKey("JITIntProcessingStatus") ) {
                final Object value = values.remove("JITIntProcessingStatus");
                if( (value == null) || (!value.equals(getJITIntProcessingStatus())) ) {
                    setJITIntProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("CompGrpMatl") ) {
                final Object value = values.remove("CompGrpMatl");
                if( (value == null) || (!value.equals(getCompGrpMatl())) ) {
                    setCompGrpMatl(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("DeliveryCreationDate") ) {
                final Object value = values.remove("DeliveryCreationDate");
                if( (value == null) || (!value.equals(getDeliveryCreationDate())) ) {
                    setDeliveryCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequirementDateTime") ) {
                final Object value = values.remove("RequirementDateTime");
                if( (value == null) || (!value.equals(getRequirementDateTime())) ) {
                    setRequirementDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlannedShippingDateTime") ) {
                final Object value = values.remove("PlannedShippingDateTime");
                if( (value == null) || (!value.equals(getPlannedShippingDateTime())) ) {
                    setPlannedShippingDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaterialAvailabilityDate") ) {
                final Object value = values.remove("MaterialAvailabilityDate");
                if( (value == null) || (!value.equals(getMaterialAvailabilityDate())) ) {
                    setMaterialAvailabilityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JITExtStatusUpdtdOn") ) {
                final Object value = values.remove("JITExtStatusUpdtdOn");
                if( (value == null) || (!value.equals(getJITExtStatusUpdtdOn())) ) {
                    setJITExtStatusUpdtdOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("JITIntStatusUpdtdOn") ) {
                final Object value = values.remove("JITIntStatusUpdtdOn");
                if( (value == null) || (!value.equals(getJITIntStatusUpdtdOn())) ) {
                    setJITIntStatusUpdtdOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("TransmittedExtStatusByMfr") ) {
                final Object value = values.remove("TransmittedExtStatusByMfr");
                if( (value == null) || (!value.equals(getTransmittedExtStatusByMfr())) ) {
                    setTransmittedExtStatusByMfr(((String) value));
                }
            }
            if( values.containsKey("TransmittedExtStsUpdtdDteTme") ) {
                final Object value = values.remove("TransmittedExtStsUpdtdDteTme");
                if( (value == null) || (!value.equals(getTransmittedExtStsUpdtdDteTme())) ) {
                    setTransmittedExtStsUpdtdDteTme(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_JITCallCompGrpDataTP") ) {
                final Object value = (values).remove("to_JITCallCompGrpDataTP");
                if( value instanceof Iterable ) {
                    if( toJITCallCompGrpDataTP == null ) {
                        toJITCallCompGrpDataTP = Lists.newArrayList();
                    } else {
                        toJITCallCompGrpDataTP = Lists.newArrayList(toJITCallCompGrpDataTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JITCallCompGrp entity;
                        if( toJITCallCompGrpDataTP.size() > i ) {
                            entity = toJITCallCompGrpDataTP.get(i);
                        } else {
                            entity = new JITCallCompGrp();
                            toJITCallCompGrpDataTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_JITCallRefTextHdrTP") ) {
                final Object value = (values).remove("to_JITCallRefTextHdrTP");
                if( value instanceof Iterable ) {
                    if( toJITCallRefTextHdrTP == null ) {
                        toJITCallRefTextHdrTP = Lists.newArrayList();
                    } else {
                        toJITCallRefTextHdrTP = Lists.newArrayList(toJITCallRefTextHdrTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JITCallRefTextHdr entity;
                        if( toJITCallRefTextHdrTP.size() > i ) {
                            entity = toJITCallRefTextHdrTP.get(i);
                        } else {
                            entity = new JITCallRefTextHdr();
                            toJITCallRefTextHdrTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> JITCallHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new JITCallHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> JITCallHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new JITCallHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toJITCallCompGrpDataTP != null ) {
            (values).put("to_JITCallCompGrpDataTP", toJITCallCompGrpDataTP);
        }
        if( toJITCallRefTextHdrTP != null ) {
            (values).put("to_JITCallRefTextHdrTP", toJITCallRefTextHdrTP);
        }
        return values;
    }

    /**
     * Fetches the <b>JITCallCompGrp</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_JITCallCompGrpDataTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>JITCallCompGrp</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JITCallCompGrp> fetchJITCallCompGrpDataTP()
    {
        return fetchFieldAsList("to_JITCallCompGrpDataTP", JITCallCompGrp.class);
    }

    /**
     * Retrieval of associated <b>JITCallCompGrp</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_JITCallCompGrpDataTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallCompGrpDataTP</b> of a queried <b>JITCallHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>JITCallCompGrp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JITCallCompGrp> getJITCallCompGrpDataTPOrFetch()
    {
        if( toJITCallCompGrpDataTP == null ) {
            toJITCallCompGrpDataTP = fetchJITCallCompGrpDataTP();
        }
        return toJITCallCompGrpDataTP;
    }

    /**
     * Retrieval of associated <b>JITCallCompGrp</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_JITCallCompGrpDataTP</b>.
     * <p>
     * If the navigation property for an entity <b>JITCallHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_JITCallCompGrpDataTP</b> is already loaded, the result
     *         will contain the <b>JITCallCompGrp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JITCallCompGrp>> getJITCallCompGrpDataTPIfPresent()
    {
        return Option.of(toJITCallCompGrpDataTP);
    }

    /**
     * Overwrites the list of associated <b>JITCallCompGrp</b> entities for the loaded navigation property
     * <b>to_JITCallCompGrpDataTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallCompGrpDataTP</b> of a queried <b>JITCallHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>JITCallCompGrp</b> entities.
     */
    public void setJITCallCompGrpDataTP( @Nonnull final List<JITCallCompGrp> value )
    {
        if( toJITCallCompGrpDataTP == null ) {
            toJITCallCompGrpDataTP = Lists.newArrayList();
        }
        toJITCallCompGrpDataTP.clear();
        toJITCallCompGrpDataTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JITCallCompGrp</b> entities. This corresponds to the OData navigation
     * property <b>to_JITCallCompGrpDataTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallCompGrpDataTP</b> of a queried <b>JITCallHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>JITCallCompGrp</b> entities.
     */
    public void addJITCallCompGrpDataTP( JITCallCompGrp... entity )
    {
        if( toJITCallCompGrpDataTP == null ) {
            toJITCallCompGrpDataTP = Lists.newArrayList();
        }
        toJITCallCompGrpDataTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>JITCallRefTextHdr</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_JITCallRefTextHdrTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>JITCallRefTextHdr</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JITCallRefTextHdr> fetchJITCallRefTextHdrTP()
    {
        return fetchFieldAsList("to_JITCallRefTextHdrTP", JITCallRefTextHdr.class);
    }

    /**
     * Retrieval of associated <b>JITCallRefTextHdr</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_JITCallRefTextHdrTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallRefTextHdrTP</b> of a queried <b>JITCallHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>JITCallRefTextHdr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<JITCallRefTextHdr> getJITCallRefTextHdrTPOrFetch()
    {
        if( toJITCallRefTextHdrTP == null ) {
            toJITCallRefTextHdrTP = fetchJITCallRefTextHdrTP();
        }
        return toJITCallRefTextHdrTP;
    }

    /**
     * Retrieval of associated <b>JITCallRefTextHdr</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_JITCallRefTextHdrTP</b>.
     * <p>
     * If the navigation property for an entity <b>JITCallHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_JITCallRefTextHdrTP</b> is already loaded, the result
     *         will contain the <b>JITCallRefTextHdr</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JITCallRefTextHdr>> getJITCallRefTextHdrTPIfPresent()
    {
        return Option.of(toJITCallRefTextHdrTP);
    }

    /**
     * Overwrites the list of associated <b>JITCallRefTextHdr</b> entities for the loaded navigation property
     * <b>to_JITCallRefTextHdrTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallRefTextHdrTP</b> of a queried <b>JITCallHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>JITCallRefTextHdr</b> entities.
     */
    public void setJITCallRefTextHdrTP( @Nonnull final List<JITCallRefTextHdr> value )
    {
        if( toJITCallRefTextHdrTP == null ) {
            toJITCallRefTextHdrTP = Lists.newArrayList();
        }
        toJITCallRefTextHdrTP.clear();
        toJITCallRefTextHdrTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JITCallRefTextHdr</b> entities. This corresponds to the OData
     * navigation property <b>to_JITCallRefTextHdrTP</b>.
     * <p>
     * If the navigation property <b>to_JITCallRefTextHdrTP</b> of a queried <b>JITCallHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>JITCallRefTextHdr</b> entities.
     */
    public void addJITCallRefTextHdrTP( JITCallRefTextHdr... entity )
    {
        if( toJITCallRefTextHdrTP == null ) {
            toJITCallRefTextHdrTP = Lists.newArrayList();
        }
        toJITCallRefTextHdrTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of JITCallHeader instances.
     *
     */
    public final static class JITCallHeaderBuilder
    {

        private List<JITCallCompGrp> toJITCallCompGrpDataTP = Lists.newArrayList();
        private List<JITCallRefTextHdr> toJITCallRefTextHdrTP = Lists.newArrayList();

        private JITCallHeader.JITCallHeaderBuilder toJITCallCompGrpDataTP( final List<JITCallCompGrp> value )
        {
            toJITCallCompGrpDataTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_JITCallCompGrpDataTP</b> for <b>JITCallHeader</b> to multiple
         * <b>JITCallCompGrp</b>.
         *
         * @param value
         *            The JITCallCompGrps to build this JITCallHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JITCallHeader.JITCallHeaderBuilder jitCallCompGrpDataTP( JITCallCompGrp... value )
        {
            return toJITCallCompGrpDataTP(Lists.newArrayList(value));
        }

        private JITCallHeader.JITCallHeaderBuilder toJITCallRefTextHdrTP( final List<JITCallRefTextHdr> value )
        {
            toJITCallRefTextHdrTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_JITCallRefTextHdrTP</b> for <b>JITCallHeader</b> to multiple
         * <b>JITCallRefTextHdr</b>.
         *
         * @param value
         *            The JITCallRefTextHdrs to build this JITCallHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JITCallHeader.JITCallHeaderBuilder jitCallRefTextHdrTP( JITCallRefTextHdr... value )
        {
            return toJITCallRefTextHdrTP(Lists.newArrayList(value));
        }

    }

}
