/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable.JITCallRefTextCompMatlSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
 * JITCallRefTextCompMatl} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class JITCallRefTextCompMatlByKeyFluentHelper
    extends
    FluentHelperByKey<JITCallRefTextCompMatlByKeyFluentHelper, JITCallRefTextCompMatl, JITCallRefTextCompMatlSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code JITCallRefTextCompMatl}
     * @param compGrpNumber
     *            Component Group Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param jITCallItemNumber
     *            Call Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param jITRefType
     *            Type of Reference Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code JITCallRefTextCompMatl}
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public JITCallRefTextCompMatlByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITCallItemNumber,
        final String jITRefType )
    {
        super(servicePath, entityCollection);
        this.key.put("InternalJITCallNumber", internalJITCallNumber);
        this.key.put("CompGrpNumber", compGrpNumber);
        this.key.put("JITCallItemNumber", jITCallItemNumber);
        this.key.put("JITRefType", jITRefType);
    }

    @Override
    @Nonnull
    protected Class<JITCallRefTextCompMatl> getEntityClass()
    {
        return JITCallRefTextCompMatl.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
