/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallRefTextHdrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable.JITCallRefTextHdrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Header Reference Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JITCallRefTextHdrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class JITCallRefTextHdr extends VdmEntity<JITCallRefTextHdr>
{

    /**
     * Selector for all available fields of JITCallRefTextHdr.
     *
     */
    public final static JITCallRefTextHdrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @return Call Number
     */
    @Key
    @SerializedName( "InternalJITCallNumber" )
    @JsonProperty( "InternalJITCallNumber" )
    @Nullable
    @ODataField( odataName = "InternalJITCallNumber" )
    private String internalJITCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternalJITCallNumber</b> field to query operations.
     *
     */
    public final static JITCallRefTextHdrField<String> INTERNAL_JIT_CALL_NUMBER =
        new JITCallRefTextHdrField<String>("InternalJITCallNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITRefType</b>
     * </p>
     *
     * @return Type of Reference Number
     */
    @Key
    @SerializedName( "JITRefType" )
    @JsonProperty( "JITRefType" )
    @Nullable
    @ODataField( odataName = "JITRefType" )
    private String jITRefType;
    /**
     * Use with available fluent helpers to apply the <b>JITRefType</b> field to query operations.
     *
     */
    public final static JITCallRefTextHdrField<String> JIT_REF_TYPE = new JITCallRefTextHdrField<String>("JITRefType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JITRefText</b>
     * </p>
     *
     * @return Reference Number / Reference Text for JIT Call
     */
    @SerializedName( "JITRefText" )
    @JsonProperty( "JITRefText" )
    @Nullable
    @ODataField( odataName = "JITRefText" )
    private String jITRefText;
    /**
     * Use with available fluent helpers to apply the <b>JITRefText</b> field to query operations.
     *
     */
    public final static JITCallRefTextHdrField<String> JIT_REF_TEXT = new JITCallRefTextHdrField<String>("JITRefText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-to Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static JITCallRefTextHdrField<String> SHIP_TO_PARTY =
        new JITCallRefTextHdrField<String>("ShipToParty");

    @Nonnull
    @Override
    public Class<JITCallRefTextHdr> getType()
    {
        return JITCallRefTextHdr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @param internalJITCallNumber
     *            Call Number
     */
    public void setInternalJITCallNumber( @Nullable final String internalJITCallNumber )
    {
        rememberChangedField("InternalJITCallNumber", this.internalJITCallNumber);
        this.internalJITCallNumber = internalJITCallNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITRefType</b>
     * </p>
     *
     * @param jITRefType
     *            Type of Reference Number
     */
    public void setJITRefType( @Nullable final String jITRefType )
    {
        rememberChangedField("JITRefType", this.jITRefType);
        this.jITRefType = jITRefType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JITRefText</b>
     * </p>
     *
     * @param jITRefText
     *            Reference Number / Reference Text for JIT Call
     */
    public void setJITRefText( @Nullable final String jITRefText )
    {
        rememberChangedField("JITRefText", this.jITRefText);
        this.jITRefText = jITRefText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_JITCallRefTextHdr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InternalJITCallNumber", getInternalJITCallNumber());
        result.put("JITRefType", getJITRefType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InternalJITCallNumber", getInternalJITCallNumber());
        values.put("JITRefType", getJITRefType());
        values.put("JITRefText", getJITRefText());
        values.put("ShipToParty", getShipToParty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalJITCallNumber") ) {
                final Object value = values.remove("InternalJITCallNumber");
                if( (value == null) || (!value.equals(getInternalJITCallNumber())) ) {
                    setInternalJITCallNumber(((String) value));
                }
            }
            if( values.containsKey("JITRefType") ) {
                final Object value = values.remove("JITRefType");
                if( (value == null) || (!value.equals(getJITRefType())) ) {
                    setJITRefType(((String) value));
                }
            }
            if( values.containsKey("JITRefText") ) {
                final Object value = values.remove("JITRefText");
                if( (value == null) || (!value.equals(getJITRefText())) ) {
                    setJITRefText(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> JITCallRefTextHdrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new JITCallRefTextHdrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> JITCallRefTextHdrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new JITCallRefTextHdrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService.DEFAULT_SERVICE_PATH);
    }

}
