/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link JustInTimeCallServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService JustInTimeCallService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultJustInTimeCallServiceBatch
    extends
    BatchFluentHelperBasic<JustInTimeCallServiceBatch, JustInTimeCallServiceBatchChangeSet>
    implements
    JustInTimeCallServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultJustInTimeCallServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultJustInTimeCallServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultJustInTimeCallServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultJustInTimeCallServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultJustInTimeCallServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultJustInTimeCallServiceBatchChangeSet(this, service);
    }

}
