/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr;

/**
 * Implementation of the {@link JustInTimeCallServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService JustInTimeCallService}.
 *
 */
public class DefaultJustInTimeCallServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<JustInTimeCallServiceBatch, JustInTimeCallServiceBatchChangeSet>
    implements
    JustInTimeCallServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService service;

    @SuppressWarnings( "deprecation" )
    DefaultJustInTimeCallServiceBatchChangeSet(
        @Nonnull final DefaultJustInTimeCallServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultJustInTimeCallServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet createJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp )
    {
        return addRequestCreate(service::createJITCallCompGrp, jITCallCompGrp);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet updateJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp )
    {
        return addRequestUpdate(service::updateJITCallCompGrp, jITCallCompGrp);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet createJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl )
    {
        return addRequestCreate(service::createJITCallCompMatl, jITCallCompMatl);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet updateJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl )
    {
        return addRequestUpdate(service::updateJITCallCompMatl, jITCallCompMatl);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet deleteJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl )
    {
        return addRequestDelete(service::deleteJITCallCompMatl, jITCallCompMatl);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet createJITCallHeader( @Nonnull final JITCallHeader jITCallHeader )
    {
        return addRequestCreate(service::createJITCallHeader, jITCallHeader);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet updateJITCallHeader( @Nonnull final JITCallHeader jITCallHeader )
    {
        return addRequestUpdate(service::updateJITCallHeader, jITCallHeader);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet createJITCallRefTextCompGrp(
        @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp )
    {
        return addRequestCreate(service::createJITCallRefTextCompGrp, jITCallRefTextCompGrp);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet updateJITCallRefTextCompGrp(
        @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp )
    {
        return addRequestUpdate(service::updateJITCallRefTextCompGrp, jITCallRefTextCompGrp);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet deleteJITCallRefTextCompGrp(
        @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp )
    {
        return addRequestDelete(service::deleteJITCallRefTextCompGrp, jITCallRefTextCompGrp);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet createJITCallRefTextCompMatl(
        @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl )
    {
        return addRequestCreate(service::createJITCallRefTextCompMatl, jITCallRefTextCompMatl);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet updateJITCallRefTextCompMatl(
        @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl )
    {
        return addRequestUpdate(service::updateJITCallRefTextCompMatl, jITCallRefTextCompMatl);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet deleteJITCallRefTextCompMatl(
        @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl )
    {
        return addRequestDelete(service::deleteJITCallRefTextCompMatl, jITCallRefTextCompMatl);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet createJITCallRefTextHdr(
        @Nonnull final JITCallRefTextHdr jITCallRefTextHdr )
    {
        return addRequestCreate(service::createJITCallRefTextHdr, jITCallRefTextHdr);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet updateJITCallRefTextHdr(
        @Nonnull final JITCallRefTextHdr jITCallRefTextHdr )
    {
        return addRequestUpdate(service::updateJITCallRefTextHdr, jITCallRefTextHdr);
    }

    @Nonnull
    @Override
    public JustInTimeCallServiceBatchChangeSet deleteJITCallRefTextHdr(
        @Nonnull final JITCallRefTextHdr jITCallRefTextHdr )
    {
        return addRequestDelete(service::deleteJITCallRefTextHdr, jITCallRefTextHdr);
    }

}
