/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.JustInTimeCallService JustInTimeCallService}.
 *
 */
public interface JustInTimeCallServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<JustInTimeCallServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<JustInTimeCallServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     * JITCallCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     *            JITCallCompGrp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet createJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     * JITCallCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     *            JITCallCompGrp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet updateJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *            JITCallCompMatl} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet createJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *            JITCallCompMatl} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet updateJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity in the S/4HANA system.
     *
     * @param jITCallCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *            JITCallCompMatl} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet deleteJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader
     * JITCallHeader} entity and save it to the S/4HANA system.
     *
     * @param jITCallHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet createJITCallHeader( @Nonnull final JITCallHeader jITCallHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader
     * JITCallHeader} entity and save it to the S/4HANA system.
     *
     * @param jITCallHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet updateJITCallHeader( @Nonnull final JITCallHeader jITCallHeader );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *            JITCallRefTextCompGrp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet
        createJITCallRefTextCompGrp( @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *            JITCallRefTextCompGrp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet
        updateJITCallRefTextCompGrp( @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity in the S/4HANA system.
     *
     * @param jITCallRefTextCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *            JITCallRefTextCompGrp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet
        deleteJITCallRefTextCompGrp( @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *            JITCallRefTextCompMatl} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet
        createJITCallRefTextCompMatl( @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *            JITCallRefTextCompMatl} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet
        updateJITCallRefTextCompMatl( @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity in the S/4HANA system.
     *
     * @param jITCallRefTextCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *            JITCallRefTextCompMatl} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet
        deleteJITCallRefTextCompMatl( @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextHdr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *            JITCallRefTextHdr} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet createJITCallRefTextHdr( @Nonnull final JITCallRefTextHdr jITCallRefTextHdr );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextHdr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *            JITCallRefTextHdr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet updateJITCallRefTextHdr( @Nonnull final JITCallRefTextHdr jITCallRefTextHdr );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity in the S/4HANA system.
     *
     * @param jITCallRefTextHdr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *            JITCallRefTextHdr} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    JustInTimeCallServiceBatchChangeSet deleteJITCallRefTextHdr( @Nonnull final JITCallRefTextHdr jITCallRefTextHdr );

}
