/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallCompGrpField
 * JITCallCompGrpField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallCompGrpLink
 * JITCallCompGrpLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#INTERNAL_JIT_CALL_NUMBER
 * INTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#COMP_GRP_NUMBER
 * COMP_GRP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#EXTERNAL_JIT_CALL_NUMBER
 * EXTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#EXT_COMP_GRP_NUMBER
 * EXT_COMP_GRP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#COMP_GRP_MATL
 * COMP_GRP_MATL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#CUST_COMP_GRP_MATL
 * CUST_COMP_GRP_MATL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#JIT_EXT_SEQUENCE_NUMBER
 * JIT_EXT_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#TRANSMITTED_EXT_STATUS_BY_MFR
 * TRANSMITTED_EXT_STATUS_BY_MFR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#JIT_EXT_STATUS_AT_SUPPLIER
 * JIT_EXT_STATUS_AT_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#JIT_EXT_STATUS_UPDTD_ON
 * JIT_EXT_STATUS_UPDTD_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#JIT_INT_PROCESSING_STATUS
 * JIT_INT_PROCESSING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#JIT_INT_STATUS_UPDTD_ON
 * JIT_INT_STATUS_UPDTD_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#REQUIREMENT_DATE_TIME
 * REQUIREMENT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#CUST_SUPPLY_AREA
 * CUST_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#SUPPLY_AREA_DESC
 * SUPPLY_AREA_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#SUPPLY_CONTROL_ID
 * SUPPLY_CONTROL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#JIT_ACTION_CTRL
 * JIT_ACTION_CTRL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#CUST_ASSEMBLY_LOC
 * CUST_ASSEMBLY_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#PLANNED_SHIPPING_DATE_TIME
 * PLANNED_SHIPPING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#ACTUAL_SHIPPING_DATE_TIME
 * ACTUAL_SHIPPING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#MATERIAL_AVAILABILITY_DATE
 * MATERIAL_AVAILABILITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#REQUESTED_DELIVERY_DATE
 * REQUESTED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#REQUESTED_DELIVERY_TIME
 * REQUESTED_DELIVERY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#REQUESTED_DELIVERY_DATE_TIME
 * REQUESTED_DELIVERY_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#WAREHOUSE_NUMBER
 * WAREHOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#DELIVERY_CREATION_DATE
 * DELIVERY_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#DELIVERY_STATUS
 * DELIVERY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#PICKING_STATUS
 * PICKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#GOODS_MOVEMENT_STATUS
 * GOODS_MOVEMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#TO_JIT_CALL_COMP_MATL_DATA_TP
 * TO_JIT_CALL_COMP_MATL_DATA_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp#TO_JIT_CALL_REF_TEXT_COMP_GRP_TP
 * TO_JIT_CALL_REF_TEXT_COMP_GRP_TP}</li>
 * </ul>
 *
 */
public interface JITCallCompGrpSelectable extends EntitySelectable<JITCallCompGrp>
{

}
