/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl JITCallCompMatl}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallCompMatlField
 * JITCallCompMatlField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallCompMatlLink
 * JITCallCompMatlLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#INTERNAL_JIT_CALL_NUMBER
 * INTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#COMP_GRP_NUMBER
 * COMP_GRP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_CALL_ITEM_NUMBER
 * JIT_CALL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#EXT_JIT_CALL_ITEM_NUMBER
 * EXT_JIT_CALL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#ACTUAL_DELIVERED_QUANTITY
 * ACTUAL_DELIVERED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#CUST_SUPPLY_AREA
 * CUST_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#SUPPLY_AREA_DESC
 * SUPPLY_AREA_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#CUST_ASSEMBLY_LOC
 * CUST_ASSEMBLY_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_EXT_STATUS_AT_SUPPLIER
 * JIT_EXT_STATUS_AT_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_EXT_STATUS_UPDTD_ON
 * JIT_EXT_STATUS_UPDTD_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_INT_PROCESSING_STATUS
 * JIT_INT_PROCESSING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_INT_STATUS_UPDTD_ON
 * JIT_INT_STATUS_UPDTD_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#TRANSMITTED_EXT_STATUS_BY_MFR
 * TRANSMITTED_EXT_STATUS_BY_MFR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#SUPPLY_CONTROL_ID
 * SUPPLY_CONTROL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_ACTION_CTRL
 * JIT_ACTION_CTRL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#REQUIREMENT_DATE_TIME
 * REQUIREMENT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#PLANNED_SHIPPING_DATE_TIME
 * PLANNED_SHIPPING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#DELIVERY_CREATION_DATE
 * DELIVERY_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#MATERIAL_AVAILABILITY_DATE
 * MATERIAL_AVAILABILITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#CUST_COMP_GRP_MATL
 * CUST_COMP_GRP_MATL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#JIT_EXT_SEQUENCE_NUMBER
 * JIT_EXT_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#COMP_GRP_MATL
 * COMP_GRP_MATL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#REQUESTED_DELIVERY_DATE
 * REQUESTED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#REQUESTED_DELIVERY_TIME
 * REQUESTED_DELIVERY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#EXT_COMP_GRP_NUMBER
 * EXT_COMP_GRP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#TRANSMITTED_EXT_STS_UPDTD_DTE_TME
 * TRANSMITTED_EXT_STS_UPDTD_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl#TO_JIT_CALL_REF_TEXT_MAT_TP
 * TO_JIT_CALL_REF_TEXT_MAT_TP}</li>
 * </ul>
 *
 */
public interface JITCallCompMatlSelectable extends EntitySelectable<JITCallCompMatl>
{

}
