/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallHeaderField
 * JITCallHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallHeaderLink JITCallHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#INTERNAL_JIT_CALL_NUMBER
 * INTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#EXTERNAL_JIT_CALL_NUMBER
 * EXTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_CALL_TYPE
 * JIT_CALL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#CUSTOMER_PARTNER_DESCRIPTION
 * CUSTOMER_PARTNER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#ACTIVE_SUPPLIER
 * ACTIVE_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#MATL_USAGE_INDICATOR
 * MATL_USAGE_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#DIVISION DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_LIFECYCLE_STATUS
 * JIT_LIFECYCLE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_EXT_SEQUENCE_NUMBER
 * JIT_EXT_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#VEHICLE_IDENTIFICATION_NUMBER
 * VEHICLE_IDENTIFICATION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#VEHICLE_MODEL
 * VEHICLE_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_EXT_STATUS_AT_SUPPLIER
 * JIT_EXT_STATUS_AT_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_INT_PROCESSING_STATUS
 * JIT_INT_PROCESSING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#COMP_GRP_MATL
 * COMP_GRP_MATL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#DELIVERY_CREATION_DATE
 * DELIVERY_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#REQUIREMENT_DATE_TIME
 * REQUIREMENT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#PLANNED_SHIPPING_DATE_TIME
 * PLANNED_SHIPPING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#MATERIAL_AVAILABILITY_DATE
 * MATERIAL_AVAILABILITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_EXT_STATUS_UPDTD_ON
 * JIT_EXT_STATUS_UPDTD_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#JIT_INT_STATUS_UPDTD_ON
 * JIT_INT_STATUS_UPDTD_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#TRANSMITTED_EXT_STATUS_BY_MFR
 * TRANSMITTED_EXT_STATUS_BY_MFR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#TRANSMITTED_EXT_STS_UPDTD_DTE_TME
 * TRANSMITTED_EXT_STS_UPDTD_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#TO_JIT_CALL_COMP_GRP_DATA_TP
 * TO_JIT_CALL_COMP_GRP_DATA_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader#TO_JIT_CALL_REF_TEXT_HDR_TP
 * TO_JIT_CALL_REF_TEXT_HDR_TP}</li>
 * </ul>
 *
 */
public interface JITCallHeaderSelectable extends EntitySelectable<JITCallHeader>
{

}
