/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
 * JITCallRefTextCompMatl}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallRefTextCompMatlField
 * JITCallRefTextCompMatlField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallRefTextCompMatlLink
 * JITCallRefTextCompMatlLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#INTERNAL_JIT_CALL_NUMBER
 * INTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#COMP_GRP_NUMBER
 * COMP_GRP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#JIT_CALL_ITEM_NUMBER
 * JIT_CALL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#JIT_REF_TYPE
 * JIT_REF_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#JIT_REF_TEXT
 * JIT_REF_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl#JIT_REFERENCE_TYPE_LEVEL
 * JIT_REFERENCE_TYPE_LEVEL}</li>
 * </ul>
 *
 */
public interface JITCallRefTextCompMatlSelectable extends EntitySelectable<JITCallRefTextCompMatl>
{

}
