/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr JITCallRefTextHdr}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.field.JITCallRefTextHdrField
 * JITCallRefTextHdrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.link.JITCallRefTextHdrLink
 * JITCallRefTextHdrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr#INTERNAL_JIT_CALL_NUMBER
 * INTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr#JIT_REF_TYPE
 * JIT_REF_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr#JIT_REF_TEXT
 * JIT_REF_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * </ul>
 *
 */
public interface JITCallRefTextHdrSelectable extends EntitySelectable<JITCallRefTextHdr>
{

}
