/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanContainerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanContainerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanContainerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable.KanbanContainerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Kanban Containers
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_KanbanContainerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class KanbanContainer extends VdmEntity<KanbanContainer>
{

    /**
     * Selector for all available fields of KanbanContainer.
     *
     */
    public final static KanbanContainerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @return Kanban Container
     */
    @Key
    @SerializedName( "KanbanContainer" )
    @JsonProperty( "KanbanContainer" )
    @Nullable
    @ODataField( odataName = "KanbanContainer" )
    private String kanbanContainer;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainer</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> KANBAN_CONTAINER =
        new KanbanContainerField<String>("KanbanContainer");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @return Kanban Control Cycle
     */
    @SerializedName( "KanbanControlCycle" )
    @JsonProperty( "KanbanControlCycle" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycle" )
    private String kanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycle</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> KANBAN_CONTROL_CYCLE =
        new KanbanContainerField<String>("KanbanControlCycle");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycleItem</b>
     * </p>
     *
     * @return Kanban Control Cycle Item
     */
    @SerializedName( "KanbanControlCycleItem" )
    @JsonProperty( "KanbanControlCycleItem" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycleItem" )
    private String kanbanControlCycleItem;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycleItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> KANBAN_CONTROL_CYCLE_ITEM =
        new KanbanContainerField<String>("KanbanControlCycleItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PLANT = new KanbanContainerField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PRODUCTION_SUPPLY_AREA =
        new KanbanContainerField<String>("ProductionSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerStatus</b>
     * </p>
     *
     * @return Kanban Container Status
     */
    @SerializedName( "KanbanContainerStatus" )
    @JsonProperty( "KanbanContainerStatus" )
    @Nullable
    @ODataField( odataName = "KanbanContainerStatus" )
    private String kanbanContainerStatus;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerStatus</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> KANBAN_CONTAINER_STATUS =
        new KanbanContainerField<String>("KanbanContainerStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLocked</b>
     * </p>
     *
     * @return Lock Indicator
     */
    @SerializedName( "IsLocked" )
    @JsonProperty( "IsLocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLocked" )
    private Boolean isLocked;
    /**
     * Use with available fluent helpers to apply the <b>IsLocked</b> field to query operations.
     *
     */
    public final static KanbanContainerField<Boolean> IS_LOCKED = new KanbanContainerField<Boolean>("IsLocked");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static KanbanContainerField<LocalDateTime> LAST_CHANGE_DATE =
        new KanbanContainerField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time of Last Change
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static KanbanContainerField<LocalTime> LAST_CHANGE_TIME =
        new KanbanContainerField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @return Planned Order
     */
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrder</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PLANNED_ORDER = new KanbanContainerField<String>("PlannedOrder");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> ORDER_ID = new KanbanContainerField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PURCHASING_DOCUMENT =
        new KanbanContainerField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PURCHASING_DOCUMENT_ITEM =
        new KanbanContainerField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> SALES_DOCUMENT = new KanbanContainerField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> SALES_DOCUMENT_ITEM =
        new KanbanContainerField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveMfgConfirmation</b>
     * </p>
     *
     * @return Repetitive Manufacturing Confirmation ID
     */
    @SerializedName( "RepetitiveMfgConfirmation" )
    @JsonProperty( "RepetitiveMfgConfirmation" )
    @Nullable
    @ODataField( odataName = "RepetitiveMfgConfirmation" )
    private String repetitiveMfgConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>RepetitiveMfgConfirmation</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> REPETITIVE_MFG_CONFIRMATION =
        new KanbanContainerField<String>("RepetitiveMfgConfirmation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Reservation
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> RESERVATION = new KanbanContainerField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> RESERVATION_ITEM =
        new KanbanContainerField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> MATERIAL_DOCUMENT =
        new KanbanContainerField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> MATERIAL_DOCUMENT_YEAR =
        new KanbanContainerField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Material Document Item
     */
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> MATERIAL_DOCUMENT_ITEM =
        new KanbanContainerField<String>("MaterialDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> BASE_UNIT = new KanbanContainerField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @return Actual Quantity in Base Unit
     */
    @SerializedName( "ActualQuantityInBaseUnit" )
    @JsonProperty( "ActualQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ActualQuantityInBaseUnit" )
    private BigDecimal actualQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static KanbanContainerField<BigDecimal> ACTUAL_QUANTITY_IN_BASE_UNIT =
        new KanbanContainerField<BigDecimal>("ActualQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityInBaseUnit</b>
     * </p>
     *
     * @return Requested Quantity in Base Unit
     */
    @SerializedName( "RequestedQuantityInBaseUnit" )
    @JsonProperty( "RequestedQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityInBaseUnit" )
    private BigDecimal requestedQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static KanbanContainerField<BigDecimal> REQUESTED_QUANTITY_IN_BASE_UNIT =
        new KanbanContainerField<BigDecimal>("RequestedQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PreviousLastChangeDate</b>
     * </p>
     *
     * @return Date of Last Status Change to Full or Emtpy
     */
    @SerializedName( "PreviousLastChangeDate" )
    @JsonProperty( "PreviousLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PreviousLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime previousLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>PreviousLastChangeDate</b> field to query operations.
     *
     */
    public final static KanbanContainerField<LocalDateTime> PREVIOUS_LAST_CHANGE_DATE =
        new KanbanContainerField<LocalDateTime>("PreviousLastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PreviousLastChangeTime</b>
     * </p>
     *
     * @return Time of Last Status Change to Full or Emtpy
     */
    @SerializedName( "PreviousLastChangeTime" )
    @JsonProperty( "PreviousLastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PreviousLastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime previousLastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>PreviousLastChangeTime</b> field to query operations.
     *
     */
    public final static KanbanContainerField<LocalTime> PREVIOUS_LAST_CHANGE_TIME =
        new KanbanContainerField<LocalTime>("PreviousLastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransferRequirementNumber</b>
     * </p>
     *
     * @return Transfer Requirement
     */
    @SerializedName( "TransferRequirementNumber" )
    @JsonProperty( "TransferRequirementNumber" )
    @Nullable
    @ODataField( odataName = "TransferRequirementNumber" )
    private String transferRequirementNumber;
    /**
     * Use with available fluent helpers to apply the <b>TransferRequirementNumber</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> TRANSFER_REQUIREMENT_NUMBER =
        new KanbanContainerField<String>("TransferRequirementNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransferRequirementItem</b>
     * </p>
     *
     * @return Transfer Requirement Item
     */
    @SerializedName( "TransferRequirementItem" )
    @JsonProperty( "TransferRequirementItem" )
    @Nullable
    @ODataField( odataName = "TransferRequirementItem" )
    private String transferRequirementItem;
    /**
     * Use with available fluent helpers to apply the <b>TransferRequirementItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> TRANSFER_REQUIREMENT_ITEM =
        new KanbanContainerField<String>("TransferRequirementItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static KanbanContainerField<Boolean> IS_DELETED = new KanbanContainerField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PreviousKanbanContainerStatus</b>
     * </p>
     *
     * @return Previous Kanban Container Status
     */
    @SerializedName( "PreviousKanbanContainerStatus" )
    @JsonProperty( "PreviousKanbanContainerStatus" )
    @Nullable
    @ODataField( odataName = "PreviousKanbanContainerStatus" )
    private String previousKanbanContainerStatus;
    /**
     * Use with available fluent helpers to apply the <b>PreviousKanbanContainerStatus</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PREVIOUS_KANBAN_CONTAINER_STATUS =
        new KanbanContainerField<String>("PreviousKanbanContainerStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @return JIT Call
     */
    @SerializedName( "InternalJITCallNumber" )
    @JsonProperty( "InternalJITCallNumber" )
    @Nullable
    @ODataField( odataName = "InternalJITCallNumber" )
    private String internalJITCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternalJITCallNumber</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> INTERNAL_JIT_CALL_NUMBER =
        new KanbanContainerField<String>("InternalJITCallNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITCallItemNumber</b>
     * </p>
     *
     * @return JIT Call Item
     */
    @SerializedName( "JITCallItemNumber" )
    @JsonProperty( "JITCallItemNumber" )
    @Nullable
    @ODataField( odataName = "JITCallItemNumber" )
    private String jITCallItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>JITCallItemNumber</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> JIT_CALL_ITEM_NUMBER =
        new KanbanContainerField<String>("JITCallItemNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedReceiptDateTime</b>
     * </p>
     *
     * @return Date and Time of Planned Receipt
     */
    @SerializedName( "PlannedReceiptDateTime" )
    @JsonProperty( "PlannedReceiptDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedReceiptDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedReceiptDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedReceiptDateTime</b> field to query operations.
     *
     */
    public final static KanbanContainerField<ZonedDateTime> PLANNED_RECEIPT_DATE_TIME =
        new KanbanContainerField<ZonedDateTime>("PlannedReceiptDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangedPackgInstrnDataIsAvail</b>
     * </p>
     *
     * @return Indicator for Changed Packing Instruction Data
     */
    @SerializedName( "ChangedPackgInstrnDataIsAvail" )
    @JsonProperty( "ChangedPackgInstrnDataIsAvail" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChangedPackgInstrnDataIsAvail" )
    private Boolean changedPackgInstrnDataIsAvail;
    /**
     * Use with available fluent helpers to apply the <b>ChangedPackgInstrnDataIsAvail</b> field to query operations.
     *
     */
    public final static KanbanContainerField<Boolean> CHANGED_PACKG_INSTRN_DATA_IS_AVAIL =
        new KanbanContainerField<Boolean>("ChangedPackgInstrnDataIsAvail");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequentialNmbrOfSuplrConf</b>
     * </p>
     *
     * @return Sequential Number of Supplier Confirmation
     */
    @SerializedName( "SequentialNmbrOfSuplrConf" )
    @JsonProperty( "SequentialNmbrOfSuplrConf" )
    @Nullable
    @ODataField( odataName = "SequentialNmbrOfSuplrConf" )
    private String sequentialNmbrOfSuplrConf;
    /**
     * Use with available fluent helpers to apply the <b>SequentialNmbrOfSuplrConf</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> SEQUENTIAL_NMBR_OF_SUPLR_CONF =
        new KanbanContainerField<String>("SequentialNmbrOfSuplrConf");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BackflushReportingPoint</b>
     * </p>
     *
     * @return Reporting Point
     */
    @SerializedName( "BackflushReportingPoint" )
    @JsonProperty( "BackflushReportingPoint" )
    @Nullable
    @ODataField( odataName = "BackflushReportingPoint" )
    private String backflushReportingPoint;
    /**
     * Use with available fluent helpers to apply the <b>BackflushReportingPoint</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> BACKFLUSH_REPORTING_POINT =
        new KanbanContainerField<String>("BackflushReportingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PURCHASING_DOCUMENT_CATEGORY =
        new KanbanContainerField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> WAREHOUSE = new KanbanContainerField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @return Warehouse Task
     */
    @SerializedName( "WarehouseTask" )
    @JsonProperty( "WarehouseTask" )
    @Nullable
    @ODataField( odataName = "WarehouseTask" )
    private String warehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTask</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> WAREHOUSE_TASK = new KanbanContainerField<String>("WarehouseTask");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WhseGoodsMovementDocument</b>
     * </p>
     *
     * @return Warehouse Goods Movement Document
     */
    @SerializedName( "WhseGoodsMovementDocument" )
    @JsonProperty( "WhseGoodsMovementDocument" )
    @Nullable
    @ODataField( odataName = "WhseGoodsMovementDocument" )
    private String whseGoodsMovementDocument;
    /**
     * Use with available fluent helpers to apply the <b>WhseGoodsMovementDocument</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> WHSE_GOODS_MOVEMENT_DOCUMENT =
        new KanbanContainerField<String>("WhseGoodsMovementDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WhseGoodsMovementDocumentItem</b>
     * </p>
     *
     * @return Warehouse Goods Movement Document Item
     */
    @SerializedName( "WhseGoodsMovementDocumentItem" )
    @JsonProperty( "WhseGoodsMovementDocumentItem" )
    @Nullable
    @ODataField( odataName = "WhseGoodsMovementDocumentItem" )
    private String whseGoodsMovementDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>WhseGoodsMovementDocumentItem</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> WHSE_GOODS_MOVEMENT_DOCUMENT_ITEM =
        new KanbanContainerField<String>("WhseGoodsMovementDocumentItem");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static KanbanContainerField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new KanbanContainerField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 64
     * <p>
     * Original property name from the Odata EDM: <b>PlantTimeZone</b>
     * </p>
     *
     * @return Time Zone
     */
    @SerializedName( "PlantTimeZone" )
    @JsonProperty( "PlantTimeZone" )
    @Nullable
    @ODataField( odataName = "PlantTimeZone" )
    private String plantTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>PlantTimeZone</b> field to query operations.
     *
     */
    public final static KanbanContainerField<String> PLANT_TIME_ZONE =
        new KanbanContainerField<String>("PlantTimeZone");
    /**
     * Navigation property <b>to_KanbanCtnDetailedQty</b> for <b>KanbanContainer</b> to multiple
     * <b>KanbanCtnDetailedQty</b>.
     *
     */
    @SerializedName( "to_KanbanCtnDetailedQty" )
    @JsonProperty( "to_KanbanCtnDetailedQty" )
    @ODataField( odataName = "to_KanbanCtnDetailedQty" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<KanbanCtnDetailedQty> toKanbanCtnDetailedQty;
    /**
     * Navigation property <b>to_KanbanDelivery</b> for <b>KanbanContainer</b> to single <b>KanbanDelivery</b>.
     *
     */
    @SerializedName( "to_KanbanDelivery" )
    @JsonProperty( "to_KanbanDelivery" )
    @ODataField( odataName = "to_KanbanDelivery" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private KanbanDelivery toKanbanDelivery;
    /**
     * Navigation property <b>to_KanbanControlCycle</b> for <b>KanbanContainer</b> to single <b>KanbanControlCycle</b>.
     *
     */
    @SerializedName( "to_KanbanControlCycle" )
    @JsonProperty( "to_KanbanControlCycle" )
    @ODataField( odataName = "to_KanbanControlCycle" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private KanbanControlCycle toKanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanCtnDetailedQty</b> navigation property to query
     * operations.
     *
     */
    public final static KanbanContainerLink<KanbanCtnDetailedQty> TO_KANBAN_CTN_DETAILED_QTY =
        new KanbanContainerLink<KanbanCtnDetailedQty>("to_KanbanCtnDetailedQty");
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanDelivery</b> navigation property to query operations.
     *
     */
    public final static KanbanContainerOneToOneLink<KanbanDelivery> TO_KANBAN_DELIVERY =
        new KanbanContainerOneToOneLink<KanbanDelivery>("to_KanbanDelivery");
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanControlCycle</b> navigation property to query
     * operations.
     *
     */
    public final static KanbanContainerOneToOneLink<KanbanControlCycle> TO_KANBAN_CONTROL_CYCLE =
        new KanbanContainerOneToOneLink<KanbanControlCycle>("to_KanbanControlCycle");

    @Nonnull
    @Override
    public Class<KanbanContainer> getType()
    {
        return KanbanContainer.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @param kanbanContainer
     *            Kanban Container
     */
    public void setKanbanContainer( @Nullable final String kanbanContainer )
    {
        rememberChangedField("KanbanContainer", this.kanbanContainer);
        this.kanbanContainer = kanbanContainer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     */
    public void setKanbanControlCycle( @Nullable final String kanbanControlCycle )
    {
        rememberChangedField("KanbanControlCycle", this.kanbanControlCycle);
        this.kanbanControlCycle = kanbanControlCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycleItem</b>
     * </p>
     *
     * @param kanbanControlCycleItem
     *            Kanban Control Cycle Item
     */
    public void setKanbanControlCycleItem( @Nullable final String kanbanControlCycleItem )
    {
        rememberChangedField("KanbanControlCycleItem", this.kanbanControlCycleItem);
        this.kanbanControlCycleItem = kanbanControlCycleItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerStatus</b>
     * </p>
     *
     * @param kanbanContainerStatus
     *            Kanban Container Status
     */
    public void setKanbanContainerStatus( @Nullable final String kanbanContainerStatus )
    {
        rememberChangedField("KanbanContainerStatus", this.kanbanContainerStatus);
        this.kanbanContainerStatus = kanbanContainerStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLocked</b>
     * </p>
     *
     * @param isLocked
     *            Lock Indicator
     */
    public void setIsLocked( @Nullable final Boolean isLocked )
    {
        rememberChangedField("IsLocked", this.isLocked);
        this.isLocked = isLocked;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date of Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time of Last Change
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveMfgConfirmation</b>
     * </p>
     *
     * @param repetitiveMfgConfirmation
     *            Repetitive Manufacturing Confirmation ID
     */
    public void setRepetitiveMfgConfirmation( @Nullable final String repetitiveMfgConfirmation )
    {
        rememberChangedField("RepetitiveMfgConfirmation", this.repetitiveMfgConfirmation);
        this.repetitiveMfgConfirmation = repetitiveMfgConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Reservation
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @param actualQuantityInBaseUnit
     *            Actual Quantity in Base Unit
     */
    public void setActualQuantityInBaseUnit( @Nullable final BigDecimal actualQuantityInBaseUnit )
    {
        rememberChangedField("ActualQuantityInBaseUnit", this.actualQuantityInBaseUnit);
        this.actualQuantityInBaseUnit = actualQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityInBaseUnit</b>
     * </p>
     *
     * @param requestedQuantityInBaseUnit
     *            Requested Quantity in Base Unit
     */
    public void setRequestedQuantityInBaseUnit( @Nullable final BigDecimal requestedQuantityInBaseUnit )
    {
        rememberChangedField("RequestedQuantityInBaseUnit", this.requestedQuantityInBaseUnit);
        this.requestedQuantityInBaseUnit = requestedQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PreviousLastChangeDate</b>
     * </p>
     *
     * @param previousLastChangeDate
     *            Date of Last Status Change to Full or Emtpy
     */
    public void setPreviousLastChangeDate( @Nullable final LocalDateTime previousLastChangeDate )
    {
        rememberChangedField("PreviousLastChangeDate", this.previousLastChangeDate);
        this.previousLastChangeDate = previousLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PreviousLastChangeTime</b>
     * </p>
     *
     * @param previousLastChangeTime
     *            Time of Last Status Change to Full or Emtpy
     */
    public void setPreviousLastChangeTime( @Nullable final LocalTime previousLastChangeTime )
    {
        rememberChangedField("PreviousLastChangeTime", this.previousLastChangeTime);
        this.previousLastChangeTime = previousLastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransferRequirementNumber</b>
     * </p>
     *
     * @param transferRequirementNumber
     *            Transfer Requirement
     */
    public void setTransferRequirementNumber( @Nullable final String transferRequirementNumber )
    {
        rememberChangedField("TransferRequirementNumber", this.transferRequirementNumber);
        this.transferRequirementNumber = transferRequirementNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransferRequirementItem</b>
     * </p>
     *
     * @param transferRequirementItem
     *            Transfer Requirement Item
     */
    public void setTransferRequirementItem( @Nullable final String transferRequirementItem )
    {
        rememberChangedField("TransferRequirementItem", this.transferRequirementItem);
        this.transferRequirementItem = transferRequirementItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PreviousKanbanContainerStatus</b>
     * </p>
     *
     * @param previousKanbanContainerStatus
     *            Previous Kanban Container Status
     */
    public void setPreviousKanbanContainerStatus( @Nullable final String previousKanbanContainerStatus )
    {
        rememberChangedField("PreviousKanbanContainerStatus", this.previousKanbanContainerStatus);
        this.previousKanbanContainerStatus = previousKanbanContainerStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @param internalJITCallNumber
     *            JIT Call
     */
    public void setInternalJITCallNumber( @Nullable final String internalJITCallNumber )
    {
        rememberChangedField("InternalJITCallNumber", this.internalJITCallNumber);
        this.internalJITCallNumber = internalJITCallNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITCallItemNumber</b>
     * </p>
     *
     * @param jITCallItemNumber
     *            JIT Call Item
     */
    public void setJITCallItemNumber( @Nullable final String jITCallItemNumber )
    {
        rememberChangedField("JITCallItemNumber", this.jITCallItemNumber);
        this.jITCallItemNumber = jITCallItemNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedReceiptDateTime</b>
     * </p>
     *
     * @param plannedReceiptDateTime
     *            Date and Time of Planned Receipt
     */
    public void setPlannedReceiptDateTime( @Nullable final ZonedDateTime plannedReceiptDateTime )
    {
        rememberChangedField("PlannedReceiptDateTime", this.plannedReceiptDateTime);
        this.plannedReceiptDateTime = plannedReceiptDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangedPackgInstrnDataIsAvail</b>
     * </p>
     *
     * @param changedPackgInstrnDataIsAvail
     *            Indicator for Changed Packing Instruction Data
     */
    public void setChangedPackgInstrnDataIsAvail( @Nullable final Boolean changedPackgInstrnDataIsAvail )
    {
        rememberChangedField("ChangedPackgInstrnDataIsAvail", this.changedPackgInstrnDataIsAvail);
        this.changedPackgInstrnDataIsAvail = changedPackgInstrnDataIsAvail;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequentialNmbrOfSuplrConf</b>
     * </p>
     *
     * @param sequentialNmbrOfSuplrConf
     *            Sequential Number of Supplier Confirmation
     */
    public void setSequentialNmbrOfSuplrConf( @Nullable final String sequentialNmbrOfSuplrConf )
    {
        rememberChangedField("SequentialNmbrOfSuplrConf", this.sequentialNmbrOfSuplrConf);
        this.sequentialNmbrOfSuplrConf = sequentialNmbrOfSuplrConf;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BackflushReportingPoint</b>
     * </p>
     *
     * @param backflushReportingPoint
     *            Reporting Point
     */
    public void setBackflushReportingPoint( @Nullable final String backflushReportingPoint )
    {
        rememberChangedField("BackflushReportingPoint", this.backflushReportingPoint);
        this.backflushReportingPoint = backflushReportingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @param warehouseTask
     *            Warehouse Task
     */
    public void setWarehouseTask( @Nullable final String warehouseTask )
    {
        rememberChangedField("WarehouseTask", this.warehouseTask);
        this.warehouseTask = warehouseTask;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WhseGoodsMovementDocument</b>
     * </p>
     *
     * @param whseGoodsMovementDocument
     *            Warehouse Goods Movement Document
     */
    public void setWhseGoodsMovementDocument( @Nullable final String whseGoodsMovementDocument )
    {
        rememberChangedField("WhseGoodsMovementDocument", this.whseGoodsMovementDocument);
        this.whseGoodsMovementDocument = whseGoodsMovementDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WhseGoodsMovementDocumentItem</b>
     * </p>
     *
     * @param whseGoodsMovementDocumentItem
     *            Warehouse Goods Movement Document Item
     */
    public void setWhseGoodsMovementDocumentItem( @Nullable final String whseGoodsMovementDocumentItem )
    {
        rememberChangedField("WhseGoodsMovementDocumentItem", this.whseGoodsMovementDocumentItem);
        this.whseGoodsMovementDocumentItem = whseGoodsMovementDocumentItem;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 64
     * <p>
     * Original property name from the Odata EDM: <b>PlantTimeZone</b>
     * </p>
     *
     * @param plantTimeZone
     *            Time Zone
     */
    public void setPlantTimeZone( @Nullable final String plantTimeZone )
    {
        rememberChangedField("PlantTimeZone", this.plantTimeZone);
        this.plantTimeZone = plantTimeZone;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_KanbanContainer";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("KanbanContainer", getKanbanContainer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("KanbanContainer", getKanbanContainer());
        values.put("KanbanControlCycle", getKanbanControlCycle());
        values.put("KanbanControlCycleItem", getKanbanControlCycleItem());
        values.put("Plant", getPlant());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("KanbanContainerStatus", getKanbanContainerStatus());
        values.put("IsLocked", getIsLocked());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("PlannedOrder", getPlannedOrder());
        values.put("OrderID", getOrderID());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("RepetitiveMfgConfirmation", getRepetitiveMfgConfirmation());
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("BaseUnit", getBaseUnit());
        values.put("ActualQuantityInBaseUnit", getActualQuantityInBaseUnit());
        values.put("RequestedQuantityInBaseUnit", getRequestedQuantityInBaseUnit());
        values.put("PreviousLastChangeDate", getPreviousLastChangeDate());
        values.put("PreviousLastChangeTime", getPreviousLastChangeTime());
        values.put("TransferRequirementNumber", getTransferRequirementNumber());
        values.put("TransferRequirementItem", getTransferRequirementItem());
        values.put("IsDeleted", getIsDeleted());
        values.put("PreviousKanbanContainerStatus", getPreviousKanbanContainerStatus());
        values.put("InternalJITCallNumber", getInternalJITCallNumber());
        values.put("JITCallItemNumber", getJITCallItemNumber());
        values.put("PlannedReceiptDateTime", getPlannedReceiptDateTime());
        values.put("ChangedPackgInstrnDataIsAvail", getChangedPackgInstrnDataIsAvail());
        values.put("SequentialNmbrOfSuplrConf", getSequentialNmbrOfSuplrConf());
        values.put("BackflushReportingPoint", getBackflushReportingPoint());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseTask", getWarehouseTask());
        values.put("WhseGoodsMovementDocument", getWhseGoodsMovementDocument());
        values.put("WhseGoodsMovementDocumentItem", getWhseGoodsMovementDocumentItem());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("PlantTimeZone", getPlantTimeZone());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("KanbanContainer") ) {
                final Object value = values.remove("KanbanContainer");
                if( (value == null) || (!value.equals(getKanbanContainer())) ) {
                    setKanbanContainer(((String) value));
                }
            }
            if( values.containsKey("KanbanControlCycle") ) {
                final Object value = values.remove("KanbanControlCycle");
                if( (value == null) || (!value.equals(getKanbanControlCycle())) ) {
                    setKanbanControlCycle(((String) value));
                }
            }
            if( values.containsKey("KanbanControlCycleItem") ) {
                final Object value = values.remove("KanbanControlCycleItem");
                if( (value == null) || (!value.equals(getKanbanControlCycleItem())) ) {
                    setKanbanControlCycleItem(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerStatus") ) {
                final Object value = values.remove("KanbanContainerStatus");
                if( (value == null) || (!value.equals(getKanbanContainerStatus())) ) {
                    setKanbanContainerStatus(((String) value));
                }
            }
            if( values.containsKey("IsLocked") ) {
                final Object value = values.remove("IsLocked");
                if( (value == null) || (!value.equals(getIsLocked())) ) {
                    setIsLocked(((Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("RepetitiveMfgConfirmation") ) {
                final Object value = values.remove("RepetitiveMfgConfirmation");
                if( (value == null) || (!value.equals(getRepetitiveMfgConfirmation())) ) {
                    setRepetitiveMfgConfirmation(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ActualQuantityInBaseUnit") ) {
                final Object value = values.remove("ActualQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getActualQuantityInBaseUnit())) ) {
                    setActualQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityInBaseUnit") ) {
                final Object value = values.remove("RequestedQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityInBaseUnit())) ) {
                    setRequestedQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("PreviousLastChangeDate") ) {
                final Object value = values.remove("PreviousLastChangeDate");
                if( (value == null) || (!value.equals(getPreviousLastChangeDate())) ) {
                    setPreviousLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PreviousLastChangeTime") ) {
                final Object value = values.remove("PreviousLastChangeTime");
                if( (value == null) || (!value.equals(getPreviousLastChangeTime())) ) {
                    setPreviousLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TransferRequirementNumber") ) {
                final Object value = values.remove("TransferRequirementNumber");
                if( (value == null) || (!value.equals(getTransferRequirementNumber())) ) {
                    setTransferRequirementNumber(((String) value));
                }
            }
            if( values.containsKey("TransferRequirementItem") ) {
                final Object value = values.remove("TransferRequirementItem");
                if( (value == null) || (!value.equals(getTransferRequirementItem())) ) {
                    setTransferRequirementItem(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("PreviousKanbanContainerStatus") ) {
                final Object value = values.remove("PreviousKanbanContainerStatus");
                if( (value == null) || (!value.equals(getPreviousKanbanContainerStatus())) ) {
                    setPreviousKanbanContainerStatus(((String) value));
                }
            }
            if( values.containsKey("InternalJITCallNumber") ) {
                final Object value = values.remove("InternalJITCallNumber");
                if( (value == null) || (!value.equals(getInternalJITCallNumber())) ) {
                    setInternalJITCallNumber(((String) value));
                }
            }
            if( values.containsKey("JITCallItemNumber") ) {
                final Object value = values.remove("JITCallItemNumber");
                if( (value == null) || (!value.equals(getJITCallItemNumber())) ) {
                    setJITCallItemNumber(((String) value));
                }
            }
            if( values.containsKey("PlannedReceiptDateTime") ) {
                final Object value = values.remove("PlannedReceiptDateTime");
                if( (value == null) || (!value.equals(getPlannedReceiptDateTime())) ) {
                    setPlannedReceiptDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ChangedPackgInstrnDataIsAvail") ) {
                final Object value = values.remove("ChangedPackgInstrnDataIsAvail");
                if( (value == null) || (!value.equals(getChangedPackgInstrnDataIsAvail())) ) {
                    setChangedPackgInstrnDataIsAvail(((Boolean) value));
                }
            }
            if( values.containsKey("SequentialNmbrOfSuplrConf") ) {
                final Object value = values.remove("SequentialNmbrOfSuplrConf");
                if( (value == null) || (!value.equals(getSequentialNmbrOfSuplrConf())) ) {
                    setSequentialNmbrOfSuplrConf(((String) value));
                }
            }
            if( values.containsKey("BackflushReportingPoint") ) {
                final Object value = values.remove("BackflushReportingPoint");
                if( (value == null) || (!value.equals(getBackflushReportingPoint())) ) {
                    setBackflushReportingPoint(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseTask") ) {
                final Object value = values.remove("WarehouseTask");
                if( (value == null) || (!value.equals(getWarehouseTask())) ) {
                    setWarehouseTask(((String) value));
                }
            }
            if( values.containsKey("WhseGoodsMovementDocument") ) {
                final Object value = values.remove("WhseGoodsMovementDocument");
                if( (value == null) || (!value.equals(getWhseGoodsMovementDocument())) ) {
                    setWhseGoodsMovementDocument(((String) value));
                }
            }
            if( values.containsKey("WhseGoodsMovementDocumentItem") ) {
                final Object value = values.remove("WhseGoodsMovementDocumentItem");
                if( (value == null) || (!value.equals(getWhseGoodsMovementDocumentItem())) ) {
                    setWhseGoodsMovementDocumentItem(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlantTimeZone") ) {
                final Object value = values.remove("PlantTimeZone");
                if( (value == null) || (!value.equals(getPlantTimeZone())) ) {
                    setPlantTimeZone(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_KanbanCtnDetailedQty") ) {
                final Object value = (values).remove("to_KanbanCtnDetailedQty");
                if( value instanceof Iterable ) {
                    if( toKanbanCtnDetailedQty == null ) {
                        toKanbanCtnDetailedQty = Lists.newArrayList();
                    } else {
                        toKanbanCtnDetailedQty = Lists.newArrayList(toKanbanCtnDetailedQty);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        KanbanCtnDetailedQty entity;
                        if( toKanbanCtnDetailedQty.size() > i ) {
                            entity = toKanbanCtnDetailedQty.get(i);
                        } else {
                            entity = new KanbanCtnDetailedQty();
                            toKanbanCtnDetailedQty.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_KanbanDelivery") ) {
                final Object value = (values).remove("to_KanbanDelivery");
                if( value instanceof Map ) {
                    if( toKanbanDelivery == null ) {
                        toKanbanDelivery = new KanbanDelivery();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toKanbanDelivery.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_KanbanControlCycle") ) {
                final Object value = (values).remove("to_KanbanControlCycle");
                if( value instanceof Map ) {
                    if( toKanbanControlCycle == null ) {
                        toKanbanControlCycle = new KanbanControlCycle();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toKanbanControlCycle.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> KanbanContainerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new KanbanContainerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> KanbanContainerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new KanbanContainerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toKanbanCtnDetailedQty != null ) {
            (values).put("to_KanbanCtnDetailedQty", toKanbanCtnDetailedQty);
        }
        if( toKanbanDelivery != null ) {
            (values).put("to_KanbanDelivery", toKanbanDelivery);
        }
        if( toKanbanControlCycle != null ) {
            (values).put("to_KanbanControlCycle", toKanbanControlCycle);
        }
        return values;
    }

    /**
     * Fetches the <b>KanbanCtnDetailedQty</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_KanbanCtnDetailedQty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>KanbanCtnDetailedQty</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<KanbanCtnDetailedQty> fetchKanbanCtnDetailedQty()
    {
        return fetchFieldAsList("to_KanbanCtnDetailedQty", KanbanCtnDetailedQty.class);
    }

    /**
     * Retrieval of associated <b>KanbanCtnDetailedQty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_KanbanCtnDetailedQty</b>.
     * <p>
     * If the navigation property <b>to_KanbanCtnDetailedQty</b> of a queried <b>KanbanContainer</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanCtnDetailedQty</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<KanbanCtnDetailedQty> getKanbanCtnDetailedQtyOrFetch()
    {
        if( toKanbanCtnDetailedQty == null ) {
            toKanbanCtnDetailedQty = fetchKanbanCtnDetailedQty();
        }
        return toKanbanCtnDetailedQty;
    }

    /**
     * Retrieval of associated <b>KanbanCtnDetailedQty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_KanbanCtnDetailedQty</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanContainer</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanCtnDetailedQty</b> is already loaded, the result
     *         will contain the <b>KanbanCtnDetailedQty</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<KanbanCtnDetailedQty>> getKanbanCtnDetailedQtyIfPresent()
    {
        return Option.of(toKanbanCtnDetailedQty);
    }

    /**
     * Overwrites the list of associated <b>KanbanCtnDetailedQty</b> entities for the loaded navigation property
     * <b>to_KanbanCtnDetailedQty</b>.
     * <p>
     * If the navigation property <b>to_KanbanCtnDetailedQty</b> of a queried <b>KanbanContainer</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>KanbanCtnDetailedQty</b> entities.
     */
    public void setKanbanCtnDetailedQty( @Nonnull final List<KanbanCtnDetailedQty> value )
    {
        if( toKanbanCtnDetailedQty == null ) {
            toKanbanCtnDetailedQty = Lists.newArrayList();
        }
        toKanbanCtnDetailedQty.clear();
        toKanbanCtnDetailedQty.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>KanbanCtnDetailedQty</b> entities. This corresponds to the OData
     * navigation property <b>to_KanbanCtnDetailedQty</b>.
     * <p>
     * If the navigation property <b>to_KanbanCtnDetailedQty</b> of a queried <b>KanbanContainer</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>KanbanCtnDetailedQty</b> entities.
     */
    public void addKanbanCtnDetailedQty( KanbanCtnDetailedQty... entity )
    {
        if( toKanbanCtnDetailedQty == null ) {
            toKanbanCtnDetailedQty = Lists.newArrayList();
        }
        toKanbanCtnDetailedQty.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>KanbanDelivery</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_KanbanDelivery</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>KanbanDelivery</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanDelivery fetchKanbanDelivery()
    {
        return fetchFieldAsSingle("to_KanbanDelivery", KanbanDelivery.class);
    }

    /**
     * Retrieval of associated <b>KanbanDelivery</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanDelivery</b>.
     * <p>
     * If the navigation property <b>to_KanbanDelivery</b> of a queried <b>KanbanContainer</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanDelivery</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanDelivery getKanbanDeliveryOrFetch()
    {
        if( toKanbanDelivery == null ) {
            toKanbanDelivery = fetchKanbanDelivery();
        }
        return toKanbanDelivery;
    }

    /**
     * Retrieval of associated <b>KanbanDelivery</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanDelivery</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanContainer</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanDelivery</b> is already loaded, the result will
     *         contain the <b>KanbanDelivery</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<KanbanDelivery> getKanbanDeliveryIfPresent()
    {
        return Option.of(toKanbanDelivery);
    }

    /**
     * Overwrites the associated <b>KanbanDelivery</b> entity for the loaded navigation property
     * <b>to_KanbanDelivery</b>.
     *
     * @param value
     *            New <b>KanbanDelivery</b> entity.
     */
    public void setKanbanDelivery( final KanbanDelivery value )
    {
        toKanbanDelivery = value;
    }

    /**
     * Fetches the <b>KanbanControlCycle</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_KanbanControlCycle</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>KanbanControlCycle</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanControlCycle fetchKanbanControlCycle()
    {
        return fetchFieldAsSingle("to_KanbanControlCycle", KanbanControlCycle.class);
    }

    /**
     * Retrieval of associated <b>KanbanControlCycle</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanControlCycle</b>.
     * <p>
     * If the navigation property <b>to_KanbanControlCycle</b> of a queried <b>KanbanContainer</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanControlCycle</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanControlCycle getKanbanControlCycleOrFetch()
    {
        if( toKanbanControlCycle == null ) {
            toKanbanControlCycle = fetchKanbanControlCycle();
        }
        return toKanbanControlCycle;
    }

    /**
     * Retrieval of associated <b>KanbanControlCycle</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanControlCycle</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanContainer</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanControlCycle</b> is already loaded, the result
     *         will contain the <b>KanbanControlCycle</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<KanbanControlCycle> getKanbanControlCycleIfPresent()
    {
        return Option.of(toKanbanControlCycle);
    }

    /**
     * Overwrites the associated <b>KanbanControlCycle</b> entity for the loaded navigation property
     * <b>to_KanbanControlCycle</b>.
     *
     * @param value
     *            New <b>KanbanControlCycle</b> entity.
     */
    public void setKanbanControlCycle( final KanbanControlCycle value )
    {
        toKanbanControlCycle = value;
    }

    /**
     * Helper class to allow for fluent creation of KanbanContainer instances.
     *
     */
    public final static class KanbanContainerBuilder
    {

        private List<KanbanCtnDetailedQty> toKanbanCtnDetailedQty = Lists.newArrayList();
        private KanbanDelivery toKanbanDelivery;
        private KanbanControlCycle toKanbanControlCycle;
        private String kanbanControlCycle = null;

        private KanbanContainer.KanbanContainerBuilder toKanbanCtnDetailedQty( final List<KanbanCtnDetailedQty> value )
        {
            toKanbanCtnDetailedQty.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_KanbanCtnDetailedQty</b> for <b>KanbanContainer</b> to multiple
         * <b>KanbanCtnDetailedQty</b>.
         *
         * @param value
         *            The KanbanCtnDetailedQtys to build this KanbanContainer with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanContainer.KanbanContainerBuilder kanbanCtnDetailedQty( KanbanCtnDetailedQty... value )
        {
            return toKanbanCtnDetailedQty(Lists.newArrayList(value));
        }

        private KanbanContainer.KanbanContainerBuilder toKanbanDelivery( final KanbanDelivery value )
        {
            toKanbanDelivery = value;
            return this;
        }

        /**
         * Navigation property <b>to_KanbanDelivery</b> for <b>KanbanContainer</b> to single <b>KanbanDelivery</b>.
         *
         * @param value
         *            The KanbanDelivery to build this KanbanContainer with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanContainer.KanbanContainerBuilder kanbanDelivery( final KanbanDelivery value )
        {
            return toKanbanDelivery(value);
        }

        private KanbanContainer.KanbanContainerBuilder toKanbanControlCycle( final KanbanControlCycle value )
        {
            toKanbanControlCycle = value;
            return this;
        }

        /**
         * Navigation property <b>to_KanbanControlCycle</b> for <b>KanbanContainer</b> to single
         * <b>KanbanControlCycle</b>.
         *
         * @param value
         *            The KanbanControlCycle to build this KanbanContainer with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanContainer.KanbanContainerBuilder kanbanControlCycle( final KanbanControlCycle value )
        {
            return toKanbanControlCycle(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 7
         * <p>
         * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
         * </p>
         *
         * @param value
         *            The kanbanControlCycle to build this KanbanContainer with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanContainer.KanbanContainerBuilder kanbanControlCycle( final String value )
        {
            kanbanControlCycle = value;
            return this;
        }

    }

}
