/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanContainerDeliveryAddrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable.KanbanContainerDeliveryAddrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Kanban Container Delivery Addresses
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_KanbanContainerDeliveryAddrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class KanbanContainerDeliveryAddr extends VdmEntity<KanbanContainerDeliveryAddr>
{

    /**
     * Selector for all available fields of KanbanContainerDeliveryAddr.
     *
     */
    public final static KanbanContainerDeliveryAddrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @return Kanban Control Cycle
     */
    @Key
    @SerializedName( "KanbanControlCycle" )
    @JsonProperty( "KanbanControlCycle" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycle" )
    private String kanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycle</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> KANBAN_CONTROL_CYCLE =
        new KanbanContainerDeliveryAddrField<String>("KanbanControlCycle");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> PLANT =
        new KanbanContainerDeliveryAddrField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerDeliveryAddress</b>
     * </p>
     *
     * @return Kanban Delivery Address
     */
    @SerializedName( "KanbanContainerDeliveryAddress" )
    @JsonProperty( "KanbanContainerDeliveryAddress" )
    @Nullable
    @ODataField( odataName = "KanbanContainerDeliveryAddress" )
    private String kanbanContainerDeliveryAddress;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerDeliveryAddress</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> KANBAN_CONTAINER_DELIVERY_ADDRESS =
        new KanbanContainerDeliveryAddrField<String>("KanbanContainerDeliveryAddress");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPartnerName1" )
    @JsonProperty( "BusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName1" )
    private String businessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName1</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> BUSINESS_PARTNER_NAME1 =
        new KanbanContainerDeliveryAddrField<String>("BusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BusinessPartnerName2" )
    @JsonProperty( "BusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName2" )
    private String businessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName2</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> BUSINESS_PARTNER_NAME2 =
        new KanbanContainerDeliveryAddrField<String>("BusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @return Building (Number or Code)
     */
    @SerializedName( "Building" )
    @JsonProperty( "Building" )
    @Nullable
    @ODataField( odataName = "Building" )
    private String building;
    /**
     * Use with available fluent helpers to apply the <b>Building</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> BUILDING =
        new KanbanContainerDeliveryAddrField<String>("Building");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> STREET_NAME =
        new KanbanContainerDeliveryAddrField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @return Street 5
     */
    @SerializedName( "AdditionalStreetSuffixName" )
    @JsonProperty( "AdditionalStreetSuffixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetSuffixName" )
    private String additionalStreetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetSuffixName</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> ADDITIONAL_STREET_SUFFIX_NAME =
        new KanbanContainerDeliveryAddrField<String>("AdditionalStreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> CITY_NAME =
        new KanbanContainerDeliveryAddrField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> POSTAL_CODE =
        new KanbanContainerDeliveryAddrField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<String> COUNTRY =
        new KanbanContainerDeliveryAddrField<String>("Country");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static KanbanContainerDeliveryAddrField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new KanbanContainerDeliveryAddrField<ZonedDateTime>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<KanbanContainerDeliveryAddr> getType()
    {
        return KanbanContainerDeliveryAddr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     */
    public void setKanbanControlCycle( @Nullable final String kanbanControlCycle )
    {
        rememberChangedField("KanbanControlCycle", this.kanbanControlCycle);
        this.kanbanControlCycle = kanbanControlCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerDeliveryAddress</b>
     * </p>
     *
     * @param kanbanContainerDeliveryAddress
     *            Kanban Delivery Address
     */
    public void setKanbanContainerDeliveryAddress( @Nullable final String kanbanContainerDeliveryAddress )
    {
        rememberChangedField("KanbanContainerDeliveryAddress", this.kanbanContainerDeliveryAddress);
        this.kanbanContainerDeliveryAddress = kanbanContainerDeliveryAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @param businessPartnerName1
     *            Name 1
     */
    public void setBusinessPartnerName1( @Nullable final String businessPartnerName1 )
    {
        rememberChangedField("BusinessPartnerName1", this.businessPartnerName1);
        this.businessPartnerName1 = businessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @param businessPartnerName2
     *            Name 2
     */
    public void setBusinessPartnerName2( @Nullable final String businessPartnerName2 )
    {
        rememberChangedField("BusinessPartnerName2", this.businessPartnerName2);
        this.businessPartnerName2 = businessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @param building
     *            Building (Number or Code)
     */
    public void setBuilding( @Nullable final String building )
    {
        rememberChangedField("Building", this.building);
        this.building = building;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @param additionalStreetSuffixName
     *            Street 5
     */
    public void setAdditionalStreetSuffixName( @Nullable final String additionalStreetSuffixName )
    {
        rememberChangedField("AdditionalStreetSuffixName", this.additionalStreetSuffixName);
        this.additionalStreetSuffixName = additionalStreetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_KanbanContainerDeliveryAddr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("KanbanControlCycle", getKanbanControlCycle());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("KanbanControlCycle", getKanbanControlCycle());
        values.put("Plant", getPlant());
        values.put("KanbanContainerDeliveryAddress", getKanbanContainerDeliveryAddress());
        values.put("BusinessPartnerName1", getBusinessPartnerName1());
        values.put("BusinessPartnerName2", getBusinessPartnerName2());
        values.put("Building", getBuilding());
        values.put("StreetName", getStreetName());
        values.put("AdditionalStreetSuffixName", getAdditionalStreetSuffixName());
        values.put("CityName", getCityName());
        values.put("PostalCode", getPostalCode());
        values.put("Country", getCountry());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("KanbanControlCycle") ) {
                final Object value = values.remove("KanbanControlCycle");
                if( (value == null) || (!value.equals(getKanbanControlCycle())) ) {
                    setKanbanControlCycle(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerDeliveryAddress") ) {
                final Object value = values.remove("KanbanContainerDeliveryAddress");
                if( (value == null) || (!value.equals(getKanbanContainerDeliveryAddress())) ) {
                    setKanbanContainerDeliveryAddress(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName1") ) {
                final Object value = values.remove("BusinessPartnerName1");
                if( (value == null) || (!value.equals(getBusinessPartnerName1())) ) {
                    setBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName2") ) {
                final Object value = values.remove("BusinessPartnerName2");
                if( (value == null) || (!value.equals(getBusinessPartnerName2())) ) {
                    setBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("Building") ) {
                final Object value = values.remove("Building");
                if( (value == null) || (!value.equals(getBuilding())) ) {
                    setBuilding(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetSuffixName") ) {
                final Object value = values.remove("AdditionalStreetSuffixName");
                if( (value == null) || (!value.equals(getAdditionalStreetSuffixName())) ) {
                    setAdditionalStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> KanbanContainerDeliveryAddrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new KanbanContainerDeliveryAddrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> KanbanContainerDeliveryAddrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new KanbanContainerDeliveryAddrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH);
    }

}
