/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable.KanbanContainerDeliveryAddrSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddr
 * KanbanContainerDeliveryAddr} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class KanbanContainerDeliveryAddrByKeyFluentHelper
    extends
    FluentHelperByKey<KanbanContainerDeliveryAddrByKeyFluentHelper, KanbanContainerDeliveryAddr, KanbanContainerDeliveryAddrSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddr
     * KanbanContainerDeliveryAddr} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code KanbanContainerDeliveryAddr}
     * @param servicePath
     *            Service path to be used to fetch a single {@code KanbanContainerDeliveryAddr}
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     */
    public KanbanContainerDeliveryAddrByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String kanbanControlCycle )
    {
        super(servicePath, entityCollection);
        this.key.put("KanbanControlCycle", kanbanControlCycle);
    }

    @Override
    @Nonnull
    protected Class<KanbanContainerDeliveryAddr> getEntityClass()
    {
        return KanbanContainerDeliveryAddr.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
