/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanControlCycleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanControlCycleLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanControlCycleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable.KanbanControlCycleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Kanban Control Cycles
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_KanbanControlCycleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class KanbanControlCycle extends VdmEntity<KanbanControlCycle>
{

    /**
     * Selector for all available fields of KanbanControlCycle.
     *
     */
    public final static KanbanControlCycleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @return Kanban Control Cycle
     */
    @Key
    @SerializedName( "KanbanControlCycle" )
    @JsonProperty( "KanbanControlCycle" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycle" )
    private String kanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycle</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTROL_CYCLE =
        new KanbanControlCycleField<String>("KanbanControlCycle");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycleCategory</b>
     * </p>
     *
     * @return Kanban Control Cycle Category
     */
    @SerializedName( "KanbanControlCycleCategory" )
    @JsonProperty( "KanbanControlCycleCategory" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycleCategory" )
    private String kanbanControlCycleCategory;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycleCategory</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTROL_CYCLE_CATEGORY =
        new KanbanControlCycleField<String>("KanbanControlCycleCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PRODUCT = new KanbanControlCycleField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PLANT = new KanbanControlCycleField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PRODUCTION_VERSION =
        new KanbanControlCycleField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PRODUCTION_SUPPLY_AREA =
        new KanbanControlCycleField<String>("ProductionSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplySourceResponsiblePerson</b>
     * </p>
     *
     * @return Person Responsible for Supply Source
     */
    @SerializedName( "SupplySourceResponsiblePerson" )
    @JsonProperty( "SupplySourceResponsiblePerson" )
    @Nullable
    @ODataField( odataName = "SupplySourceResponsiblePerson" )
    private String supplySourceResponsiblePerson;
    /**
     * Use with available fluent helpers to apply the <b>SupplySourceResponsiblePerson</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SUPPLY_SOURCE_RESPONSIBLE_PERSON =
        new KanbanControlCycleField<String>("SupplySourceResponsiblePerson");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> STORAGE_LOCATION =
        new KanbanControlCycleField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>StoringPositionName</b>
     * </p>
     *
     * @return Storing Position
     */
    @SerializedName( "StoringPositionName" )
    @JsonProperty( "StoringPositionName" )
    @Nullable
    @ODataField( odataName = "StoringPositionName" )
    private String storingPositionName;
    /**
     * Use with available fluent helpers to apply the <b>StoringPositionName</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> STORING_POSITION_NAME =
        new KanbanControlCycleField<String>("StoringPositionName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerDeliveryAddress</b>
     * </p>
     *
     * @return Kanban Delivery Address
     */
    @SerializedName( "KanbanContainerDeliveryAddress" )
    @JsonProperty( "KanbanContainerDeliveryAddress" )
    @Nullable
    @ODataField( odataName = "KanbanContainerDeliveryAddress" )
    private String kanbanContainerDeliveryAddress;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerDeliveryAddress</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTAINER_DELIVERY_ADDRESS =
        new KanbanControlCycleField<String>("KanbanContainerDeliveryAddress");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductCostCollector</b>
     * </p>
     *
     * @return Product Cost Collector
     */
    @SerializedName( "ProductCostCollector" )
    @JsonProperty( "ProductCostCollector" )
    @Nullable
    @ODataField( odataName = "ProductCostCollector" )
    private String productCostCollector;
    /**
     * Use with available fluent helpers to apply the <b>ProductCostCollector</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PRODUCT_COST_COLLECTOR =
        new KanbanControlCycleField<String>("ProductCostCollector");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SUPPLIER = new KanbanControlCycleField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PURCHASING_ORGANIZATION =
        new KanbanControlCycleField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreement</b>
     * </p>
     *
     * @return Agreement Number
     */
    @SerializedName( "PurchaseOutlineAgreement" )
    @JsonProperty( "PurchaseOutlineAgreement" )
    @Nullable
    @ODataField( odataName = "PurchaseOutlineAgreement" )
    private String purchaseOutlineAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOutlineAgreement</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PURCHASE_OUTLINE_AGREEMENT =
        new KanbanControlCycleField<String>("PurchaseOutlineAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreementItem</b>
     * </p>
     *
     * @return Agreement Item
     */
    @SerializedName( "PurchaseOutlineAgreementItem" )
    @JsonProperty( "PurchaseOutlineAgreementItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOutlineAgreementItem" )
    private String purchaseOutlineAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOutlineAgreementItem</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PURCHASE_OUTLINE_AGREEMENT_ITEM =
        new KanbanControlCycleField<String>("PurchaseOutlineAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> WAREHOUSE = new KanbanControlCycleField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> STORAGE_TYPE =
        new KanbanControlCycleField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> STORAGE_BIN = new KanbanControlCycleField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> BASE_UNIT = new KanbanControlCycleField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerQuantityInBsUnt</b>
     * </p>
     *
     * @return Kanban Container Quantity
     */
    @SerializedName( "KanbanContainerQuantityInBsUnt" )
    @JsonProperty( "KanbanContainerQuantityInBsUnt" )
    @Nullable
    @ODataField( odataName = "KanbanContainerQuantityInBsUnt" )
    private BigDecimal kanbanContainerQuantityInBsUnt;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerQuantityInBsUnt</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CONTAINER_QUANTITY_IN_BS_UNT =
        new KanbanControlCycleField<BigDecimal>("KanbanContainerQuantityInBsUnt");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfKanbanContainers</b>
     * </p>
     *
     * @return Number of Kanban Containers
     */
    @SerializedName( "NumberOfKanbanContainers" )
    @JsonProperty( "NumberOfKanbanContainers" )
    @Nullable
    @ODataField( odataName = "NumberOfKanbanContainers" )
    private String numberOfKanbanContainers;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfKanbanContainers</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> NUMBER_OF_KANBAN_CONTAINERS =
        new KanbanControlCycleField<String>("NumberOfKanbanContainers");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaxNrOfEmptyKanbanContainers</b>
     * </p>
     *
     * @return Maximum Number of Empty Kanban Containers
     */
    @SerializedName( "MaxNrOfEmptyKanbanContainers" )
    @JsonProperty( "MaxNrOfEmptyKanbanContainers" )
    @Nullable
    @ODataField( odataName = "MaxNrOfEmptyKanbanContainers" )
    private String maxNrOfEmptyKanbanContainers;
    /**
     * Use with available fluent helpers to apply the <b>MaxNrOfEmptyKanbanContainers</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> MAX_NR_OF_EMPTY_KANBAN_CONTAINERS =
        new KanbanControlCycleField<String>("MaxNrOfEmptyKanbanContainers");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InHouseProductionReplnmtStrgy</b>
     * </p>
     *
     * @return Replenishment Strategy for In-House Production
     */
    @SerializedName( "InHouseProductionReplnmtStrgy" )
    @JsonProperty( "InHouseProductionReplnmtStrgy" )
    @Nullable
    @ODataField( odataName = "InHouseProductionReplnmtStrgy" )
    private String inHouseProductionReplnmtStrgy;
    /**
     * Use with available fluent helpers to apply the <b>InHouseProductionReplnmtStrgy</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> IN_HOUSE_PRODUCTION_REPLNMT_STRGY =
        new KanbanControlCycleField<String>("InHouseProductionReplnmtStrgy");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialStaging</b>
     * </p>
     *
     * @return Material Staging for Production Supply
     */
    @SerializedName( "MaterialStaging" )
    @JsonProperty( "MaterialStaging" )
    @Nullable
    @ODataField( odataName = "MaterialStaging" )
    private String materialStaging;
    /**
     * Use with available fluent helpers to apply the <b>MaterialStaging</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> MATERIAL_STAGING =
        new KanbanControlCycleField<String>("MaterialStaging");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DestinationBinIsDynamic</b>
     * </p>
     *
     * @return Dynamic Destination Bin
     */
    @SerializedName( "DestinationBinIsDynamic" )
    @JsonProperty( "DestinationBinIsDynamic" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DestinationBinIsDynamic" )
    private Boolean destinationBinIsDynamic;
    /**
     * Use with available fluent helpers to apply the <b>DestinationBinIsDynamic</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<Boolean> DESTINATION_BIN_IS_DYNAMIC =
        new KanbanControlCycleField<Boolean>("DestinationBinIsDynamic");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExtProcurementReplnmtStrgy</b>
     * </p>
     *
     * @return Replenishment Strategy for External Procurement
     */
    @SerializedName( "ExtProcurementReplnmtStrgy" )
    @JsonProperty( "ExtProcurementReplnmtStrgy" )
    @Nullable
    @ODataField( odataName = "ExtProcurementReplnmtStrgy" )
    private String extProcurementReplnmtStrgy;
    /**
     * Use with available fluent helpers to apply the <b>ExtProcurementReplnmtStrgy</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> EXT_PROCUREMENT_REPLNMT_STRGY =
        new KanbanControlCycleField<String>("ExtProcurementReplnmtStrgy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StockTransferReplnmtStrategy</b>
     * </p>
     *
     * @return Replenishment Strategy for Stock Transfer
     */
    @SerializedName( "StockTransferReplnmtStrategy" )
    @JsonProperty( "StockTransferReplnmtStrategy" )
    @Nullable
    @ODataField( odataName = "StockTransferReplnmtStrategy" )
    private String stockTransferReplnmtStrategy;
    /**
     * Use with available fluent helpers to apply the <b>StockTransferReplnmtStrategy</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> STOCK_TRANSFER_REPLNMT_STRATEGY =
        new KanbanControlCycleField<String>("StockTransferReplnmtStrategy");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReplnmtIsCtrldBySupplySource</b>
     * </p>
     *
     * @return Independent Supply Source
     */
    @SerializedName( "ReplnmtIsCtrldBySupplySource" )
    @JsonProperty( "ReplnmtIsCtrldBySupplySource" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReplnmtIsCtrldBySupplySource" )
    private Boolean replnmtIsCtrldBySupplySource;
    /**
     * Use with available fluent helpers to apply the <b>ReplnmtIsCtrldBySupplySource</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<Boolean> REPLNMT_IS_CTRLD_BY_SUPPLY_SOURCE =
        new KanbanControlCycleField<Boolean>("ReplnmtIsCtrldBySupplySource");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerPackggProduct</b>
     * </p>
     *
     * @return Packaging Product for Kanban Container
     */
    @SerializedName( "KanbanContainerPackggProduct" )
    @JsonProperty( "KanbanContainerPackggProduct" )
    @Nullable
    @ODataField( odataName = "KanbanContainerPackggProduct" )
    private String kanbanContainerPackggProduct;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerPackggProduct</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTAINER_PACKGG_PRODUCT =
        new KanbanControlCycleField<String>("KanbanContainerPackggProduct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SeparateGRIsNeededIfSetToFull</b>
     * </p>
     *
     * @return Separate Goods Receipt
     */
    @SerializedName( "SeparateGRIsNeededIfSetToFull" )
    @JsonProperty( "SeparateGRIsNeededIfSetToFull" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SeparateGRIsNeededIfSetToFull" )
    private Boolean separateGRIsNeededIfSetToFull;
    /**
     * Use with available fluent helpers to apply the <b>SeparateGRIsNeededIfSetToFull</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<Boolean> SEPARATE_GR_IS_NEEDED_IF_SET_TO_FULL =
        new KanbanControlCycleField<Boolean>("SeparateGRIsNeededIfSetToFull");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> COST_CENTER = new KanbanControlCycleField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplySourcePlant</b>
     * </p>
     *
     * @return Plant of Supply Source
     */
    @SerializedName( "SupplySourcePlant" )
    @JsonProperty( "SupplySourcePlant" )
    @Nullable
    @ODataField( odataName = "SupplySourcePlant" )
    private String supplySourcePlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplySourcePlant</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SUPPLY_SOURCE_PLANT =
        new KanbanControlCycleField<String>("SupplySourcePlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerStatusSequence</b>
     * </p>
     *
     * @return Status Sequence of Kanban Container
     */
    @SerializedName( "KanbanContainerStatusSequence" )
    @JsonProperty( "KanbanContainerStatusSequence" )
    @Nullable
    @ODataField( odataName = "KanbanContainerStatusSequence" )
    private String kanbanContainerStatusSequence;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerStatusSequence</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTAINER_STATUS_SEQUENCE =
        new KanbanControlCycleField<String>("KanbanContainerStatusSequence");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnReplnmtTriggerLogic</b>
     * </p>
     *
     * @return Replenishment Trigger Logic
     */
    @SerializedName( "KanbanCtnReplnmtTriggerLogic" )
    @JsonProperty( "KanbanCtnReplnmtTriggerLogic" )
    @Nullable
    @ODataField( odataName = "KanbanCtnReplnmtTriggerLogic" )
    private String kanbanCtnReplnmtTriggerLogic;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnReplnmtTriggerLogic</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CTN_REPLNMT_TRIGGER_LOGIC =
        new KanbanControlCycleField<String>("KanbanCtnReplnmtTriggerLogic");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KnbnCtnReplnmtTrggrQtyInBsUnt</b>
     * </p>
     *
     * @return Trigger Quantity
     */
    @SerializedName( "KnbnCtnReplnmtTrggrQtyInBsUnt" )
    @JsonProperty( "KnbnCtnReplnmtTrggrQtyInBsUnt" )
    @Nullable
    @ODataField( odataName = "KnbnCtnReplnmtTrggrQtyInBsUnt" )
    private BigDecimal knbnCtnReplnmtTrggrQtyInBsUnt;
    /**
     * Use with available fluent helpers to apply the <b>KnbnCtnReplnmtTrggrQtyInBsUnt</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KNBN_CTN_REPLNMT_TRGGR_QTY_IN_BS_UNT =
        new KanbanControlCycleField<BigDecimal>("KnbnCtnReplnmtTrggrQtyInBsUnt");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Kanban Container
     */
    @SerializedName( "KanbanContainerCalculationType" )
    @JsonProperty( "KanbanContainerCalculationType" )
    @Nullable
    @ODataField( odataName = "KanbanContainerCalculationType" )
    private String kanbanContainerCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerCalculationType</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTAINER_CALCULATION_TYPE =
        new KanbanControlCycleField<String>("KanbanContainerCalculationType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnCalcSafetyFactor</b>
     * </p>
     *
     * @return Safety Factor for Kanban Container Calculation
     */
    @SerializedName( "KanbanCtnCalcSafetyFactor" )
    @JsonProperty( "KanbanCtnCalcSafetyFactor" )
    @Nullable
    @ODataField( odataName = "KanbanCtnCalcSafetyFactor" )
    private BigDecimal kanbanCtnCalcSafetyFactor;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnCalcSafetyFactor</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_CALC_SAFETY_FACTOR =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnCalcSafetyFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnCalculationConstant</b>
     * </p>
     *
     * @return Constant for Kanban Container Calculation
     */
    @SerializedName( "KanbanCtnCalculationConstant" )
    @JsonProperty( "KanbanCtnCalculationConstant" )
    @Nullable
    @ODataField( odataName = "KanbanCtnCalculationConstant" )
    private Short kanbanCtnCalculationConstant;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnCalculationConstant</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<Short> KANBAN_CTN_CALCULATION_CONSTANT =
        new KanbanControlCycleField<Short>("KanbanCtnCalculationConstant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnRoundingQtyInBsUnt</b>
     * </p>
     *
     * @return Rounding Quantity
     */
    @SerializedName( "KanbanCtnRoundingQtyInBsUnt" )
    @JsonProperty( "KanbanCtnRoundingQtyInBsUnt" )
    @Nullable
    @ODataField( odataName = "KanbanCtnRoundingQtyInBsUnt" )
    private BigDecimal kanbanCtnRoundingQtyInBsUnt;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnRoundingQtyInBsUnt</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_ROUNDING_QTY_IN_BS_UNT =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnRoundingQtyInBsUnt");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedKanbanContainerQtyInBsUnt</b>
     * </p>
     *
     * @return Fixed Kanban Container Quantity
     */
    @SerializedName( "FixedKanbanContainerQtyInBsUnt" )
    @JsonProperty( "FixedKanbanContainerQtyInBsUnt" )
    @Nullable
    @ODataField( odataName = "FixedKanbanContainerQtyInBsUnt" )
    private BigDecimal fixedKanbanContainerQtyInBsUnt;
    /**
     * Use with available fluent helpers to apply the <b>FixedKanbanContainerQtyInBsUnt</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> FIXED_KANBAN_CONTAINER_QTY_IN_BS_UNT =
        new KanbanControlCycleField<BigDecimal>("FixedKanbanContainerQtyInBsUnt");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerCalcProfile</b>
     * </p>
     *
     * @return Kanban Container Calculation Profile
     */
    @SerializedName( "KanbanContainerCalcProfile" )
    @JsonProperty( "KanbanContainerCalcProfile" )
    @Nullable
    @ODataField( odataName = "KanbanContainerCalcProfile" )
    private String kanbanContainerCalcProfile;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainerCalcProfile</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CONTAINER_CALC_PROFILE =
        new KanbanControlCycleField<String>("KanbanContainerCalcProfile");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReplnmtLeadTimeInWorkdays</b>
     * </p>
     *
     * @return Replenishment Lead Time in Workdays
     */
    @SerializedName( "ReplnmtLeadTimeInWorkdays" )
    @JsonProperty( "ReplnmtLeadTimeInWorkdays" )
    @Nullable
    @ODataField( odataName = "ReplnmtLeadTimeInWorkdays" )
    private BigDecimal replnmtLeadTimeInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>ReplnmtLeadTimeInWorkdays</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> REPLNMT_LEAD_TIME_IN_WORKDAYS =
        new KanbanControlCycleField<BigDecimal>("ReplnmtLeadTimeInWorkdays");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReplnmtLeadTimeInMinutes</b>
     * </p>
     *
     * @return Replenishment Lead Time in Minutes
     */
    @SerializedName( "ReplnmtLeadTimeInMinutes" )
    @JsonProperty( "ReplnmtLeadTimeInMinutes" )
    @Nullable
    @ODataField( odataName = "ReplnmtLeadTimeInMinutes" )
    private BigDecimal replnmtLeadTimeInMinutes;
    /**
     * Use with available fluent helpers to apply the <b>ReplnmtLeadTimeInMinutes</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> REPLNMT_LEAD_TIME_IN_MINUTES =
        new KanbanControlCycleField<BigDecimal>("ReplnmtLeadTimeInMinutes");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @return Sales Scheduling Agreement
     */
    @SerializedName( "SalesSchedulingAgreement" )
    @JsonProperty( "SalesSchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreement" )
    private String salesSchedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreement</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SALES_SCHEDULING_AGREEMENT =
        new KanbanControlCycleField<String>("SalesSchedulingAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @return Sales Scheduling Agreement Item
     */
    @SerializedName( "SalesSchedulingAgreementItem" )
    @JsonProperty( "SalesSchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreementItem" )
    private String salesSchedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SALES_SCHEDULING_AGREEMENT_ITEM =
        new KanbanControlCycleField<String>("SalesSchedulingAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceProductionSupplyArea</b>
     * </p>
     *
     * @return Source Production Supply Area for Kanban Stock Transfers
     */
    @SerializedName( "SourceProductionSupplyArea" )
    @JsonProperty( "SourceProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "SourceProductionSupplyArea" )
    private String sourceProductionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SourceProductionSupplyArea</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SOURCE_PRODUCTION_SUPPLY_AREA =
        new KanbanControlCycleField<String>("SourceProductionSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITCallProfile</b>
     * </p>
     *
     * @return JIT Call Profile
     */
    @SerializedName( "JITCallProfile" )
    @JsonProperty( "JITCallProfile" )
    @Nullable
    @ODataField( odataName = "JITCallProfile" )
    private String jITCallProfile;
    /**
     * Use with available fluent helpers to apply the <b>JITCallProfile</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> JIT_CALL_PROFILE =
        new KanbanControlCycleField<String>("JITCallProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstruction</b>
     * </p>
     *
     * @return Packing Instruction
     */
    @SerializedName( "PackingInstruction" )
    @JsonProperty( "PackingInstruction" )
    @Nullable
    @ODataField( odataName = "PackingInstruction" )
    private UUID packingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstruction</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<UUID> PACKING_INSTRUCTION =
        new KanbanControlCycleField<UUID>("PackingInstruction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfLoadCarriers</b>
     * </p>
     *
     * @return Number of Load Carriers
     */
    @SerializedName( "NumberOfLoadCarriers" )
    @JsonProperty( "NumberOfLoadCarriers" )
    @Nullable
    @ODataField( odataName = "NumberOfLoadCarriers" )
    private String numberOfLoadCarriers;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfLoadCarriers</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> NUMBER_OF_LOAD_CARRIERS =
        new KanbanControlCycleField<String>("NumberOfLoadCarriers");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BackflushReportingPoint</b>
     * </p>
     *
     * @return Reporting Point
     */
    @SerializedName( "BackflushReportingPoint" )
    @JsonProperty( "BackflushReportingPoint" )
    @Nullable
    @ODataField( odataName = "BackflushReportingPoint" )
    private String backflushReportingPoint;
    /**
     * Use with available fluent helpers to apply the <b>BackflushReportingPoint</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> BACKFLUSH_REPORTING_POINT =
        new KanbanControlCycleField<String>("BackflushReportingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtrlCycleLifeCycleStatus</b>
     * </p>
     *
     * @return Lifecycle Status of Kanban Control Cycle
     */
    @SerializedName( "KanbanCtrlCycleLifeCycleStatus" )
    @JsonProperty( "KanbanCtrlCycleLifeCycleStatus" )
    @Nullable
    @ODataField( odataName = "KanbanCtrlCycleLifeCycleStatus" )
    private String kanbanCtrlCycleLifeCycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtrlCycleLifeCycleStatus</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CTRL_CYCLE_LIFE_CYCLE_STATUS =
        new KanbanControlCycleField<String>("KanbanCtrlCycleLifeCycleStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date of Kanban Control Cycle
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<LocalDateTime> CREATION_DATE =
        new KanbanControlCycleField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseDate</b>
     * </p>
     *
     * @return Release Date of Kanban Control Cycle
     */
    @SerializedName( "ReleaseDate" )
    @JsonProperty( "ReleaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ReleaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime releaseDate;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseDate</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<LocalDateTime> RELEASE_DATE =
        new KanbanControlCycleField<LocalDateTime>("ReleaseDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LockDate</b>
     * </p>
     *
     * @return Control Cycle Lock Date
     */
    @SerializedName( "LockDate" )
    @JsonProperty( "LockDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LockDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lockDate;
    /**
     * Use with available fluent helpers to apply the <b>LockDate</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<LocalDateTime> LOCK_DATE =
        new KanbanControlCycleField<LocalDateTime>("LockDate");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInWorkdays</b>
     * </p>
     *
     * @return Pull Interval in Workdays
     */
    @SerializedName( "PullIntervalInWorkdays" )
    @JsonProperty( "PullIntervalInWorkdays" )
    @Nullable
    @ODataField( odataName = "PullIntervalInWorkdays" )
    private BigDecimal pullIntervalInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>PullIntervalInWorkdays</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> PULL_INTERVAL_IN_WORKDAYS =
        new KanbanControlCycleField<BigDecimal>("PullIntervalInWorkdays");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInMinutes</b>
     * </p>
     *
     * @return Pull Interval in Minutes
     */
    @SerializedName( "PullIntervalInMinutes" )
    @JsonProperty( "PullIntervalInMinutes" )
    @Nullable
    @ODataField( odataName = "PullIntervalInMinutes" )
    private BigDecimal pullIntervalInMinutes;
    /**
     * Use with available fluent helpers to apply the <b>PullIntervalInMinutes</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> PULL_INTERVAL_IN_MINUTES =
        new KanbanControlCycleField<BigDecimal>("PullIntervalInMinutes");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnRefillTimeInDays</b>
     * </p>
     *
     * @return Refill Time in Days
     */
    @SerializedName( "KanbanCtnRefillTimeInDays" )
    @JsonProperty( "KanbanCtnRefillTimeInDays" )
    @Nullable
    @ODataField( odataName = "KanbanCtnRefillTimeInDays" )
    private BigDecimal kanbanCtnRefillTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnRefillTimeInDays</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_REFILL_TIME_IN_DAYS =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnRefillTimeInDays");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnRefillTmeInMinutes</b>
     * </p>
     *
     * @return Refill Time in Minutes
     */
    @SerializedName( "KanbanCtnRefillTmeInMinutes" )
    @JsonProperty( "KanbanCtnRefillTmeInMinutes" )
    @Nullable
    @ODataField( odataName = "KanbanCtnRefillTmeInMinutes" )
    private BigDecimal kanbanCtnRefillTmeInMinutes;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnRefillTmeInMinutes</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_REFILL_TME_IN_MINUTES =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnRefillTmeInMinutes");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnWaitTimeInDays</b>
     * </p>
     *
     * @return Wait Time in Days
     */
    @SerializedName( "KanbanCtnWaitTimeInDays" )
    @JsonProperty( "KanbanCtnWaitTimeInDays" )
    @Nullable
    @ODataField( odataName = "KanbanCtnWaitTimeInDays" )
    private BigDecimal kanbanCtnWaitTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnWaitTimeInDays</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_WAIT_TIME_IN_DAYS =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnWaitTimeInDays");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnWaitTimeInMinutes</b>
     * </p>
     *
     * @return Wait Time in Minutes
     */
    @SerializedName( "KanbanCtnWaitTimeInMinutes" )
    @JsonProperty( "KanbanCtnWaitTimeInMinutes" )
    @Nullable
    @ODataField( odataName = "KanbanCtnWaitTimeInMinutes" )
    private BigDecimal kanbanCtnWaitTimeInMinutes;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnWaitTimeInMinutes</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_WAIT_TIME_IN_MINUTES =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnWaitTimeInMinutes");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnTransportTimeInDays</b>
     * </p>
     *
     * @return Transportation Time in Days
     */
    @SerializedName( "KanbanCtnTransportTimeInDays" )
    @JsonProperty( "KanbanCtnTransportTimeInDays" )
    @Nullable
    @ODataField( odataName = "KanbanCtnTransportTimeInDays" )
    private BigDecimal kanbanCtnTransportTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnTransportTimeInDays</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_TRANSPORT_TIME_IN_DAYS =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnTransportTimeInDays");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnTransportTmeInMinutes</b>
     * </p>
     *
     * @return Transportation Time in Minutes
     */
    @SerializedName( "KanbanCtnTransportTmeInMinutes" )
    @JsonProperty( "KanbanCtnTransportTmeInMinutes" )
    @Nullable
    @ODataField( odataName = "KanbanCtnTransportTmeInMinutes" )
    private BigDecimal kanbanCtnTransportTmeInMinutes;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtnTransportTmeInMinutes</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KANBAN_CTN_TRANSPORT_TME_IN_MINUTES =
        new KanbanControlCycleField<BigDecimal>("KanbanCtnTransportTmeInMinutes");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KnbnCtnCalcRqmtBufferInPercent</b>
     * </p>
     *
     * @return Requirement Buffer in Percent
     */
    @SerializedName( "KnbnCtnCalcRqmtBufferInPercent" )
    @JsonProperty( "KnbnCtnCalcRqmtBufferInPercent" )
    @Nullable
    @ODataField( odataName = "KnbnCtnCalcRqmtBufferInPercent" )
    private BigDecimal knbnCtnCalcRqmtBufferInPercent;
    /**
     * Use with available fluent helpers to apply the <b>KnbnCtnCalcRqmtBufferInPercent</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KNBN_CTN_CALC_RQMT_BUFFER_IN_PERCENT =
        new KanbanControlCycleField<BigDecimal>("KnbnCtnCalcRqmtBufferInPercent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KnbnCtnCalcSupplySrceBufInPct</b>
     * </p>
     *
     * @return Supply Source Buffer in Percent
     */
    @SerializedName( "KnbnCtnCalcSupplySrceBufInPct" )
    @JsonProperty( "KnbnCtnCalcSupplySrceBufInPct" )
    @Nullable
    @ODataField( odataName = "KnbnCtnCalcSupplySrceBufInPct" )
    private BigDecimal knbnCtnCalcSupplySrceBufInPct;
    /**
     * Use with available fluent helpers to apply the <b>KnbnCtnCalcSupplySrceBufInPct</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<BigDecimal> KNBN_CTN_CALC_SUPPLY_SRCE_BUF_IN_PCT =
        new KanbanControlCycleField<BigDecimal>("KnbnCtnCalcSupplySrceBufInPct");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NrOfKanbanCtnsFlaggedToUnlock</b>
     * </p>
     *
     * @return Number of Kanban Containers to be Unlocked
     */
    @SerializedName( "NrOfKanbanCtnsFlaggedToUnlock" )
    @JsonProperty( "NrOfKanbanCtnsFlaggedToUnlock" )
    @Nullable
    @ODataField( odataName = "NrOfKanbanCtnsFlaggedToUnlock" )
    private String nrOfKanbanCtnsFlaggedToUnlock;
    /**
     * Use with available fluent helpers to apply the <b>NrOfKanbanCtnsFlaggedToUnlock</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> NR_OF_KANBAN_CTNS_FLAGGED_TO_UNLOCK =
        new KanbanControlCycleField<String>("NrOfKanbanCtnsFlaggedToUnlock");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NrOfWaitingKnbnCtnsBfrReplnmt</b>
     * </p>
     *
     * @return Trigger Point for Waiting Kanbans
     */
    @SerializedName( "NrOfWaitingKnbnCtnsBfrReplnmt" )
    @JsonProperty( "NrOfWaitingKnbnCtnsBfrReplnmt" )
    @Nullable
    @ODataField( odataName = "NrOfWaitingKnbnCtnsBfrReplnmt" )
    private String nrOfWaitingKnbnCtnsBfrReplnmt;
    /**
     * Use with available fluent helpers to apply the <b>NrOfWaitingKnbnCtnsBfrReplnmt</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> NR_OF_WAITING_KNBN_CTNS_BFR_REPLNMT =
        new KanbanControlCycleField<String>("NrOfWaitingKnbnCtnsBfrReplnmt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtrlCycReplnmtTriggerGrp</b>
     * </p>
     *
     * @return Trigger Group
     */
    @SerializedName( "KanbanCtrlCycReplnmtTriggerGrp" )
    @JsonProperty( "KanbanCtrlCycReplnmtTriggerGrp" )
    @Nullable
    @ODataField( odataName = "KanbanCtrlCycReplnmtTriggerGrp" )
    private String kanbanCtrlCycReplnmtTriggerGrp;
    /**
     * Use with available fluent helpers to apply the <b>KanbanCtrlCycReplnmtTriggerGrp</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> KANBAN_CTRL_CYC_REPLNMT_TRIGGER_GRP =
        new KanbanControlCycleField<String>("KanbanCtrlCycReplnmtTriggerGrp");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PlanningWorkCenter</b>
     * </p>
     *
     * @return Work Center for Consideration of Capacity
     */
    @SerializedName( "PlanningWorkCenter" )
    @JsonProperty( "PlanningWorkCenter" )
    @Nullable
    @ODataField( odataName = "PlanningWorkCenter" )
    private String planningWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>PlanningWorkCenter</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> PLANNING_WORK_CENTER =
        new KanbanControlCycleField<String>("PlanningWorkCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductionOrdersAreCombined</b>
     * </p>
     *
     * @return Production Orders Are Combined
     */
    @SerializedName( "ProductionOrdersAreCombined" )
    @JsonProperty( "ProductionOrdersAreCombined" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductionOrdersAreCombined" )
    private Boolean productionOrdersAreCombined;
    /**
     * Use with available fluent helpers to apply the <b>ProductionOrdersAreCombined</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<Boolean> PRODUCTION_ORDERS_ARE_COMBINED =
        new KanbanControlCycleField<Boolean>("ProductionOrdersAreCombined");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageBin</b>
     * </p>
     *
     * @return Destination Storage Bin
     */
    @SerializedName( "DestinationStorageBin" )
    @JsonProperty( "DestinationStorageBin" )
    @Nullable
    @ODataField( odataName = "DestinationStorageBin" )
    private String destinationStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>DestinationStorageBin</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> DESTINATION_STORAGE_BIN =
        new KanbanControlCycleField<String>("DestinationStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageBin</b>
     * </p>
     *
     * @return Source Storage Bin
     */
    @SerializedName( "SourceStorageBin" )
    @JsonProperty( "SourceStorageBin" )
    @Nullable
    @ODataField( odataName = "SourceStorageBin" )
    private String sourceStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>SourceStorageBin</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> SOURCE_STORAGE_BIN =
        new KanbanControlCycleField<String>("SourceStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @return Warehouse Process Type
     */
    @SerializedName( "WarehouseProcessType" )
    @JsonProperty( "WarehouseProcessType" )
    @Nullable
    @ODataField( odataName = "WarehouseProcessType" )
    private String warehouseProcessType;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseProcessType</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<String> WAREHOUSE_PROCESS_TYPE =
        new KanbanControlCycleField<String>("WarehouseProcessType");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static KanbanControlCycleField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new KanbanControlCycleField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_KanbanContainer</b> for <b>KanbanControlCycle</b> to multiple <b>KanbanContainer</b>.
     *
     */
    @SerializedName( "to_KanbanContainer" )
    @JsonProperty( "to_KanbanContainer" )
    @ODataField( odataName = "to_KanbanContainer" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<KanbanContainer> toKanbanContainer;
    /**
     * Navigation property <b>to_KanbanContDeliveryAddr</b> for <b>KanbanControlCycle</b> to single
     * <b>KanbanContainerDeliveryAddr</b>.
     *
     */
    @SerializedName( "to_KanbanContDeliveryAddr" )
    @JsonProperty( "to_KanbanContDeliveryAddr" )
    @ODataField( odataName = "to_KanbanContDeliveryAddr" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private KanbanContainerDeliveryAddr toKanbanContDeliveryAddr;
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanContainer</b> navigation property to query operations.
     *
     */
    public final static KanbanControlCycleLink<KanbanContainer> TO_KANBAN_CONTAINER =
        new KanbanControlCycleLink<KanbanContainer>("to_KanbanContainer");
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanContDeliveryAddr</b> navigation property to query
     * operations.
     *
     */
    public final static KanbanControlCycleOneToOneLink<KanbanContainerDeliveryAddr> TO_KANBAN_CONT_DELIVERY_ADDR =
        new KanbanControlCycleOneToOneLink<KanbanContainerDeliveryAddr>("to_KanbanContDeliveryAddr");

    @Nonnull
    @Override
    public Class<KanbanControlCycle> getType()
    {
        return KanbanControlCycle.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     */
    public void setKanbanControlCycle( @Nullable final String kanbanControlCycle )
    {
        rememberChangedField("KanbanControlCycle", this.kanbanControlCycle);
        this.kanbanControlCycle = kanbanControlCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycleCategory</b>
     * </p>
     *
     * @param kanbanControlCycleCategory
     *            Kanban Control Cycle Category
     */
    public void setKanbanControlCycleCategory( @Nullable final String kanbanControlCycleCategory )
    {
        rememberChangedField("KanbanControlCycleCategory", this.kanbanControlCycleCategory);
        this.kanbanControlCycleCategory = kanbanControlCycleCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplySourceResponsiblePerson</b>
     * </p>
     *
     * @param supplySourceResponsiblePerson
     *            Person Responsible for Supply Source
     */
    public void setSupplySourceResponsiblePerson( @Nullable final String supplySourceResponsiblePerson )
    {
        rememberChangedField("SupplySourceResponsiblePerson", this.supplySourceResponsiblePerson);
        this.supplySourceResponsiblePerson = supplySourceResponsiblePerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>StoringPositionName</b>
     * </p>
     *
     * @param storingPositionName
     *            Storing Position
     */
    public void setStoringPositionName( @Nullable final String storingPositionName )
    {
        rememberChangedField("StoringPositionName", this.storingPositionName);
        this.storingPositionName = storingPositionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerDeliveryAddress</b>
     * </p>
     *
     * @param kanbanContainerDeliveryAddress
     *            Kanban Delivery Address
     */
    public void setKanbanContainerDeliveryAddress( @Nullable final String kanbanContainerDeliveryAddress )
    {
        rememberChangedField("KanbanContainerDeliveryAddress", this.kanbanContainerDeliveryAddress);
        this.kanbanContainerDeliveryAddress = kanbanContainerDeliveryAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductCostCollector</b>
     * </p>
     *
     * @param productCostCollector
     *            Product Cost Collector
     */
    public void setProductCostCollector( @Nullable final String productCostCollector )
    {
        rememberChangedField("ProductCostCollector", this.productCostCollector);
        this.productCostCollector = productCostCollector;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreement</b>
     * </p>
     *
     * @param purchaseOutlineAgreement
     *            Agreement Number
     */
    public void setPurchaseOutlineAgreement( @Nullable final String purchaseOutlineAgreement )
    {
        rememberChangedField("PurchaseOutlineAgreement", this.purchaseOutlineAgreement);
        this.purchaseOutlineAgreement = purchaseOutlineAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreementItem</b>
     * </p>
     *
     * @param purchaseOutlineAgreementItem
     *            Agreement Item
     */
    public void setPurchaseOutlineAgreementItem( @Nullable final String purchaseOutlineAgreementItem )
    {
        rememberChangedField("PurchaseOutlineAgreementItem", this.purchaseOutlineAgreementItem);
        this.purchaseOutlineAgreementItem = purchaseOutlineAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerQuantityInBsUnt</b>
     * </p>
     *
     * @param kanbanContainerQuantityInBsUnt
     *            Kanban Container Quantity
     */
    public void setKanbanContainerQuantityInBsUnt( @Nullable final BigDecimal kanbanContainerQuantityInBsUnt )
    {
        rememberChangedField("KanbanContainerQuantityInBsUnt", this.kanbanContainerQuantityInBsUnt);
        this.kanbanContainerQuantityInBsUnt = kanbanContainerQuantityInBsUnt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfKanbanContainers</b>
     * </p>
     *
     * @param numberOfKanbanContainers
     *            Number of Kanban Containers
     */
    public void setNumberOfKanbanContainers( @Nullable final String numberOfKanbanContainers )
    {
        rememberChangedField("NumberOfKanbanContainers", this.numberOfKanbanContainers);
        this.numberOfKanbanContainers = numberOfKanbanContainers;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaxNrOfEmptyKanbanContainers</b>
     * </p>
     *
     * @param maxNrOfEmptyKanbanContainers
     *            Maximum Number of Empty Kanban Containers
     */
    public void setMaxNrOfEmptyKanbanContainers( @Nullable final String maxNrOfEmptyKanbanContainers )
    {
        rememberChangedField("MaxNrOfEmptyKanbanContainers", this.maxNrOfEmptyKanbanContainers);
        this.maxNrOfEmptyKanbanContainers = maxNrOfEmptyKanbanContainers;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InHouseProductionReplnmtStrgy</b>
     * </p>
     *
     * @param inHouseProductionReplnmtStrgy
     *            Replenishment Strategy for In-House Production
     */
    public void setInHouseProductionReplnmtStrgy( @Nullable final String inHouseProductionReplnmtStrgy )
    {
        rememberChangedField("InHouseProductionReplnmtStrgy", this.inHouseProductionReplnmtStrgy);
        this.inHouseProductionReplnmtStrgy = inHouseProductionReplnmtStrgy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialStaging</b>
     * </p>
     *
     * @param materialStaging
     *            Material Staging for Production Supply
     */
    public void setMaterialStaging( @Nullable final String materialStaging )
    {
        rememberChangedField("MaterialStaging", this.materialStaging);
        this.materialStaging = materialStaging;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DestinationBinIsDynamic</b>
     * </p>
     *
     * @param destinationBinIsDynamic
     *            Dynamic Destination Bin
     */
    public void setDestinationBinIsDynamic( @Nullable final Boolean destinationBinIsDynamic )
    {
        rememberChangedField("DestinationBinIsDynamic", this.destinationBinIsDynamic);
        this.destinationBinIsDynamic = destinationBinIsDynamic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExtProcurementReplnmtStrgy</b>
     * </p>
     *
     * @param extProcurementReplnmtStrgy
     *            Replenishment Strategy for External Procurement
     */
    public void setExtProcurementReplnmtStrgy( @Nullable final String extProcurementReplnmtStrgy )
    {
        rememberChangedField("ExtProcurementReplnmtStrgy", this.extProcurementReplnmtStrgy);
        this.extProcurementReplnmtStrgy = extProcurementReplnmtStrgy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StockTransferReplnmtStrategy</b>
     * </p>
     *
     * @param stockTransferReplnmtStrategy
     *            Replenishment Strategy for Stock Transfer
     */
    public void setStockTransferReplnmtStrategy( @Nullable final String stockTransferReplnmtStrategy )
    {
        rememberChangedField("StockTransferReplnmtStrategy", this.stockTransferReplnmtStrategy);
        this.stockTransferReplnmtStrategy = stockTransferReplnmtStrategy;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReplnmtIsCtrldBySupplySource</b>
     * </p>
     *
     * @param replnmtIsCtrldBySupplySource
     *            Independent Supply Source
     */
    public void setReplnmtIsCtrldBySupplySource( @Nullable final Boolean replnmtIsCtrldBySupplySource )
    {
        rememberChangedField("ReplnmtIsCtrldBySupplySource", this.replnmtIsCtrldBySupplySource);
        this.replnmtIsCtrldBySupplySource = replnmtIsCtrldBySupplySource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerPackggProduct</b>
     * </p>
     *
     * @param kanbanContainerPackggProduct
     *            Packaging Product for Kanban Container
     */
    public void setKanbanContainerPackggProduct( @Nullable final String kanbanContainerPackggProduct )
    {
        rememberChangedField("KanbanContainerPackggProduct", this.kanbanContainerPackggProduct);
        this.kanbanContainerPackggProduct = kanbanContainerPackggProduct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SeparateGRIsNeededIfSetToFull</b>
     * </p>
     *
     * @param separateGRIsNeededIfSetToFull
     *            Separate Goods Receipt
     */
    public void setSeparateGRIsNeededIfSetToFull( @Nullable final Boolean separateGRIsNeededIfSetToFull )
    {
        rememberChangedField("SeparateGRIsNeededIfSetToFull", this.separateGRIsNeededIfSetToFull);
        this.separateGRIsNeededIfSetToFull = separateGRIsNeededIfSetToFull;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplySourcePlant</b>
     * </p>
     *
     * @param supplySourcePlant
     *            Plant of Supply Source
     */
    public void setSupplySourcePlant( @Nullable final String supplySourcePlant )
    {
        rememberChangedField("SupplySourcePlant", this.supplySourcePlant);
        this.supplySourcePlant = supplySourcePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerStatusSequence</b>
     * </p>
     *
     * @param kanbanContainerStatusSequence
     *            Status Sequence of Kanban Container
     */
    public void setKanbanContainerStatusSequence( @Nullable final String kanbanContainerStatusSequence )
    {
        rememberChangedField("KanbanContainerStatusSequence", this.kanbanContainerStatusSequence);
        this.kanbanContainerStatusSequence = kanbanContainerStatusSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnReplnmtTriggerLogic</b>
     * </p>
     *
     * @param kanbanCtnReplnmtTriggerLogic
     *            Replenishment Trigger Logic
     */
    public void setKanbanCtnReplnmtTriggerLogic( @Nullable final String kanbanCtnReplnmtTriggerLogic )
    {
        rememberChangedField("KanbanCtnReplnmtTriggerLogic", this.kanbanCtnReplnmtTriggerLogic);
        this.kanbanCtnReplnmtTriggerLogic = kanbanCtnReplnmtTriggerLogic;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KnbnCtnReplnmtTrggrQtyInBsUnt</b>
     * </p>
     *
     * @param knbnCtnReplnmtTrggrQtyInBsUnt
     *            Trigger Quantity
     */
    public void setKnbnCtnReplnmtTrggrQtyInBsUnt( @Nullable final BigDecimal knbnCtnReplnmtTrggrQtyInBsUnt )
    {
        rememberChangedField("KnbnCtnReplnmtTrggrQtyInBsUnt", this.knbnCtnReplnmtTrggrQtyInBsUnt);
        this.knbnCtnReplnmtTrggrQtyInBsUnt = knbnCtnReplnmtTrggrQtyInBsUnt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerCalculationType</b>
     * </p>
     *
     * @param kanbanContainerCalculationType
     *            Calculation Type for Kanban Container
     */
    public void setKanbanContainerCalculationType( @Nullable final String kanbanContainerCalculationType )
    {
        rememberChangedField("KanbanContainerCalculationType", this.kanbanContainerCalculationType);
        this.kanbanContainerCalculationType = kanbanContainerCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnCalcSafetyFactor</b>
     * </p>
     *
     * @param kanbanCtnCalcSafetyFactor
     *            Safety Factor for Kanban Container Calculation
     */
    public void setKanbanCtnCalcSafetyFactor( @Nullable final BigDecimal kanbanCtnCalcSafetyFactor )
    {
        rememberChangedField("KanbanCtnCalcSafetyFactor", this.kanbanCtnCalcSafetyFactor);
        this.kanbanCtnCalcSafetyFactor = kanbanCtnCalcSafetyFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnCalculationConstant</b>
     * </p>
     *
     * @param kanbanCtnCalculationConstant
     *            Constant for Kanban Container Calculation
     */
    public void setKanbanCtnCalculationConstant( @Nullable final Short kanbanCtnCalculationConstant )
    {
        rememberChangedField("KanbanCtnCalculationConstant", this.kanbanCtnCalculationConstant);
        this.kanbanCtnCalculationConstant = kanbanCtnCalculationConstant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnRoundingQtyInBsUnt</b>
     * </p>
     *
     * @param kanbanCtnRoundingQtyInBsUnt
     *            Rounding Quantity
     */
    public void setKanbanCtnRoundingQtyInBsUnt( @Nullable final BigDecimal kanbanCtnRoundingQtyInBsUnt )
    {
        rememberChangedField("KanbanCtnRoundingQtyInBsUnt", this.kanbanCtnRoundingQtyInBsUnt);
        this.kanbanCtnRoundingQtyInBsUnt = kanbanCtnRoundingQtyInBsUnt;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedKanbanContainerQtyInBsUnt</b>
     * </p>
     *
     * @param fixedKanbanContainerQtyInBsUnt
     *            Fixed Kanban Container Quantity
     */
    public void setFixedKanbanContainerQtyInBsUnt( @Nullable final BigDecimal fixedKanbanContainerQtyInBsUnt )
    {
        rememberChangedField("FixedKanbanContainerQtyInBsUnt", this.fixedKanbanContainerQtyInBsUnt);
        this.fixedKanbanContainerQtyInBsUnt = fixedKanbanContainerQtyInBsUnt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainerCalcProfile</b>
     * </p>
     *
     * @param kanbanContainerCalcProfile
     *            Kanban Container Calculation Profile
     */
    public void setKanbanContainerCalcProfile( @Nullable final String kanbanContainerCalcProfile )
    {
        rememberChangedField("KanbanContainerCalcProfile", this.kanbanContainerCalcProfile);
        this.kanbanContainerCalcProfile = kanbanContainerCalcProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReplnmtLeadTimeInWorkdays</b>
     * </p>
     *
     * @param replnmtLeadTimeInWorkdays
     *            Replenishment Lead Time in Workdays
     */
    public void setReplnmtLeadTimeInWorkdays( @Nullable final BigDecimal replnmtLeadTimeInWorkdays )
    {
        rememberChangedField("ReplnmtLeadTimeInWorkdays", this.replnmtLeadTimeInWorkdays);
        this.replnmtLeadTimeInWorkdays = replnmtLeadTimeInWorkdays;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReplnmtLeadTimeInMinutes</b>
     * </p>
     *
     * @param replnmtLeadTimeInMinutes
     *            Replenishment Lead Time in Minutes
     */
    public void setReplnmtLeadTimeInMinutes( @Nullable final BigDecimal replnmtLeadTimeInMinutes )
    {
        rememberChangedField("ReplnmtLeadTimeInMinutes", this.replnmtLeadTimeInMinutes);
        this.replnmtLeadTimeInMinutes = replnmtLeadTimeInMinutes;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     */
    public void setSalesSchedulingAgreement( @Nullable final String salesSchedulingAgreement )
    {
        rememberChangedField("SalesSchedulingAgreement", this.salesSchedulingAgreement);
        this.salesSchedulingAgreement = salesSchedulingAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     */
    public void setSalesSchedulingAgreementItem( @Nullable final String salesSchedulingAgreementItem )
    {
        rememberChangedField("SalesSchedulingAgreementItem", this.salesSchedulingAgreementItem);
        this.salesSchedulingAgreementItem = salesSchedulingAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceProductionSupplyArea</b>
     * </p>
     *
     * @param sourceProductionSupplyArea
     *            Source Production Supply Area for Kanban Stock Transfers
     */
    public void setSourceProductionSupplyArea( @Nullable final String sourceProductionSupplyArea )
    {
        rememberChangedField("SourceProductionSupplyArea", this.sourceProductionSupplyArea);
        this.sourceProductionSupplyArea = sourceProductionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JITCallProfile</b>
     * </p>
     *
     * @param jITCallProfile
     *            JIT Call Profile
     */
    public void setJITCallProfile( @Nullable final String jITCallProfile )
    {
        rememberChangedField("JITCallProfile", this.jITCallProfile);
        this.jITCallProfile = jITCallProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstruction</b>
     * </p>
     *
     * @param packingInstruction
     *            Packing Instruction
     */
    public void setPackingInstruction( @Nullable final UUID packingInstruction )
    {
        rememberChangedField("PackingInstruction", this.packingInstruction);
        this.packingInstruction = packingInstruction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfLoadCarriers</b>
     * </p>
     *
     * @param numberOfLoadCarriers
     *            Number of Load Carriers
     */
    public void setNumberOfLoadCarriers( @Nullable final String numberOfLoadCarriers )
    {
        rememberChangedField("NumberOfLoadCarriers", this.numberOfLoadCarriers);
        this.numberOfLoadCarriers = numberOfLoadCarriers;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BackflushReportingPoint</b>
     * </p>
     *
     * @param backflushReportingPoint
     *            Reporting Point
     */
    public void setBackflushReportingPoint( @Nullable final String backflushReportingPoint )
    {
        rememberChangedField("BackflushReportingPoint", this.backflushReportingPoint);
        this.backflushReportingPoint = backflushReportingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtrlCycleLifeCycleStatus</b>
     * </p>
     *
     * @param kanbanCtrlCycleLifeCycleStatus
     *            Lifecycle Status of Kanban Control Cycle
     */
    public void setKanbanCtrlCycleLifeCycleStatus( @Nullable final String kanbanCtrlCycleLifeCycleStatus )
    {
        rememberChangedField("KanbanCtrlCycleLifeCycleStatus", this.kanbanCtrlCycleLifeCycleStatus);
        this.kanbanCtrlCycleLifeCycleStatus = kanbanCtrlCycleLifeCycleStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date of Kanban Control Cycle
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseDate</b>
     * </p>
     *
     * @param releaseDate
     *            Release Date of Kanban Control Cycle
     */
    public void setReleaseDate( @Nullable final LocalDateTime releaseDate )
    {
        rememberChangedField("ReleaseDate", this.releaseDate);
        this.releaseDate = releaseDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LockDate</b>
     * </p>
     *
     * @param lockDate
     *            Control Cycle Lock Date
     */
    public void setLockDate( @Nullable final LocalDateTime lockDate )
    {
        rememberChangedField("LockDate", this.lockDate);
        this.lockDate = lockDate;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInWorkdays</b>
     * </p>
     *
     * @param pullIntervalInWorkdays
     *            Pull Interval in Workdays
     */
    public void setPullIntervalInWorkdays( @Nullable final BigDecimal pullIntervalInWorkdays )
    {
        rememberChangedField("PullIntervalInWorkdays", this.pullIntervalInWorkdays);
        this.pullIntervalInWorkdays = pullIntervalInWorkdays;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PullIntervalInMinutes</b>
     * </p>
     *
     * @param pullIntervalInMinutes
     *            Pull Interval in Minutes
     */
    public void setPullIntervalInMinutes( @Nullable final BigDecimal pullIntervalInMinutes )
    {
        rememberChangedField("PullIntervalInMinutes", this.pullIntervalInMinutes);
        this.pullIntervalInMinutes = pullIntervalInMinutes;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnRefillTimeInDays</b>
     * </p>
     *
     * @param kanbanCtnRefillTimeInDays
     *            Refill Time in Days
     */
    public void setKanbanCtnRefillTimeInDays( @Nullable final BigDecimal kanbanCtnRefillTimeInDays )
    {
        rememberChangedField("KanbanCtnRefillTimeInDays", this.kanbanCtnRefillTimeInDays);
        this.kanbanCtnRefillTimeInDays = kanbanCtnRefillTimeInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnRefillTmeInMinutes</b>
     * </p>
     *
     * @param kanbanCtnRefillTmeInMinutes
     *            Refill Time in Minutes
     */
    public void setKanbanCtnRefillTmeInMinutes( @Nullable final BigDecimal kanbanCtnRefillTmeInMinutes )
    {
        rememberChangedField("KanbanCtnRefillTmeInMinutes", this.kanbanCtnRefillTmeInMinutes);
        this.kanbanCtnRefillTmeInMinutes = kanbanCtnRefillTmeInMinutes;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnWaitTimeInDays</b>
     * </p>
     *
     * @param kanbanCtnWaitTimeInDays
     *            Wait Time in Days
     */
    public void setKanbanCtnWaitTimeInDays( @Nullable final BigDecimal kanbanCtnWaitTimeInDays )
    {
        rememberChangedField("KanbanCtnWaitTimeInDays", this.kanbanCtnWaitTimeInDays);
        this.kanbanCtnWaitTimeInDays = kanbanCtnWaitTimeInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnWaitTimeInMinutes</b>
     * </p>
     *
     * @param kanbanCtnWaitTimeInMinutes
     *            Wait Time in Minutes
     */
    public void setKanbanCtnWaitTimeInMinutes( @Nullable final BigDecimal kanbanCtnWaitTimeInMinutes )
    {
        rememberChangedField("KanbanCtnWaitTimeInMinutes", this.kanbanCtnWaitTimeInMinutes);
        this.kanbanCtnWaitTimeInMinutes = kanbanCtnWaitTimeInMinutes;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnTransportTimeInDays</b>
     * </p>
     *
     * @param kanbanCtnTransportTimeInDays
     *            Transportation Time in Days
     */
    public void setKanbanCtnTransportTimeInDays( @Nullable final BigDecimal kanbanCtnTransportTimeInDays )
    {
        rememberChangedField("KanbanCtnTransportTimeInDays", this.kanbanCtnTransportTimeInDays);
        this.kanbanCtnTransportTimeInDays = kanbanCtnTransportTimeInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtnTransportTmeInMinutes</b>
     * </p>
     *
     * @param kanbanCtnTransportTmeInMinutes
     *            Transportation Time in Minutes
     */
    public void setKanbanCtnTransportTmeInMinutes( @Nullable final BigDecimal kanbanCtnTransportTmeInMinutes )
    {
        rememberChangedField("KanbanCtnTransportTmeInMinutes", this.kanbanCtnTransportTmeInMinutes);
        this.kanbanCtnTransportTmeInMinutes = kanbanCtnTransportTmeInMinutes;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KnbnCtnCalcRqmtBufferInPercent</b>
     * </p>
     *
     * @param knbnCtnCalcRqmtBufferInPercent
     *            Requirement Buffer in Percent
     */
    public void setKnbnCtnCalcRqmtBufferInPercent( @Nullable final BigDecimal knbnCtnCalcRqmtBufferInPercent )
    {
        rememberChangedField("KnbnCtnCalcRqmtBufferInPercent", this.knbnCtnCalcRqmtBufferInPercent);
        this.knbnCtnCalcRqmtBufferInPercent = knbnCtnCalcRqmtBufferInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>KnbnCtnCalcSupplySrceBufInPct</b>
     * </p>
     *
     * @param knbnCtnCalcSupplySrceBufInPct
     *            Supply Source Buffer in Percent
     */
    public void setKnbnCtnCalcSupplySrceBufInPct( @Nullable final BigDecimal knbnCtnCalcSupplySrceBufInPct )
    {
        rememberChangedField("KnbnCtnCalcSupplySrceBufInPct", this.knbnCtnCalcSupplySrceBufInPct);
        this.knbnCtnCalcSupplySrceBufInPct = knbnCtnCalcSupplySrceBufInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NrOfKanbanCtnsFlaggedToUnlock</b>
     * </p>
     *
     * @param nrOfKanbanCtnsFlaggedToUnlock
     *            Number of Kanban Containers to be Unlocked
     */
    public void setNrOfKanbanCtnsFlaggedToUnlock( @Nullable final String nrOfKanbanCtnsFlaggedToUnlock )
    {
        rememberChangedField("NrOfKanbanCtnsFlaggedToUnlock", this.nrOfKanbanCtnsFlaggedToUnlock);
        this.nrOfKanbanCtnsFlaggedToUnlock = nrOfKanbanCtnsFlaggedToUnlock;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NrOfWaitingKnbnCtnsBfrReplnmt</b>
     * </p>
     *
     * @param nrOfWaitingKnbnCtnsBfrReplnmt
     *            Trigger Point for Waiting Kanbans
     */
    public void setNrOfWaitingKnbnCtnsBfrReplnmt( @Nullable final String nrOfWaitingKnbnCtnsBfrReplnmt )
    {
        rememberChangedField("NrOfWaitingKnbnCtnsBfrReplnmt", this.nrOfWaitingKnbnCtnsBfrReplnmt);
        this.nrOfWaitingKnbnCtnsBfrReplnmt = nrOfWaitingKnbnCtnsBfrReplnmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanCtrlCycReplnmtTriggerGrp</b>
     * </p>
     *
     * @param kanbanCtrlCycReplnmtTriggerGrp
     *            Trigger Group
     */
    public void setKanbanCtrlCycReplnmtTriggerGrp( @Nullable final String kanbanCtrlCycReplnmtTriggerGrp )
    {
        rememberChangedField("KanbanCtrlCycReplnmtTriggerGrp", this.kanbanCtrlCycReplnmtTriggerGrp);
        this.kanbanCtrlCycReplnmtTriggerGrp = kanbanCtrlCycReplnmtTriggerGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PlanningWorkCenter</b>
     * </p>
     *
     * @param planningWorkCenter
     *            Work Center for Consideration of Capacity
     */
    public void setPlanningWorkCenter( @Nullable final String planningWorkCenter )
    {
        rememberChangedField("PlanningWorkCenter", this.planningWorkCenter);
        this.planningWorkCenter = planningWorkCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductionOrdersAreCombined</b>
     * </p>
     *
     * @param productionOrdersAreCombined
     *            Production Orders Are Combined
     */
    public void setProductionOrdersAreCombined( @Nullable final Boolean productionOrdersAreCombined )
    {
        rememberChangedField("ProductionOrdersAreCombined", this.productionOrdersAreCombined);
        this.productionOrdersAreCombined = productionOrdersAreCombined;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageBin</b>
     * </p>
     *
     * @param destinationStorageBin
     *            Destination Storage Bin
     */
    public void setDestinationStorageBin( @Nullable final String destinationStorageBin )
    {
        rememberChangedField("DestinationStorageBin", this.destinationStorageBin);
        this.destinationStorageBin = destinationStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageBin</b>
     * </p>
     *
     * @param sourceStorageBin
     *            Source Storage Bin
     */
    public void setSourceStorageBin( @Nullable final String sourceStorageBin )
    {
        rememberChangedField("SourceStorageBin", this.sourceStorageBin);
        this.sourceStorageBin = sourceStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @param warehouseProcessType
     *            Warehouse Process Type
     */
    public void setWarehouseProcessType( @Nullable final String warehouseProcessType )
    {
        rememberChangedField("WarehouseProcessType", this.warehouseProcessType);
        this.warehouseProcessType = warehouseProcessType;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_KanbanControlCycle";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("KanbanControlCycle", getKanbanControlCycle());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("KanbanControlCycle", getKanbanControlCycle());
        values.put("KanbanControlCycleCategory", getKanbanControlCycleCategory());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("ProductionVersion", getProductionVersion());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("SupplySourceResponsiblePerson", getSupplySourceResponsiblePerson());
        values.put("StorageLocation", getStorageLocation());
        values.put("StoringPositionName", getStoringPositionName());
        values.put("KanbanContainerDeliveryAddress", getKanbanContainerDeliveryAddress());
        values.put("ProductCostCollector", getProductCostCollector());
        values.put("Supplier", getSupplier());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchaseOutlineAgreement", getPurchaseOutlineAgreement());
        values.put("PurchaseOutlineAgreementItem", getPurchaseOutlineAgreementItem());
        values.put("Warehouse", getWarehouse());
        values.put("StorageType", getStorageType());
        values.put("StorageBin", getStorageBin());
        values.put("BaseUnit", getBaseUnit());
        values.put("KanbanContainerQuantityInBsUnt", getKanbanContainerQuantityInBsUnt());
        values.put("NumberOfKanbanContainers", getNumberOfKanbanContainers());
        values.put("MaxNrOfEmptyKanbanContainers", getMaxNrOfEmptyKanbanContainers());
        values.put("InHouseProductionReplnmtStrgy", getInHouseProductionReplnmtStrgy());
        values.put("MaterialStaging", getMaterialStaging());
        values.put("DestinationBinIsDynamic", getDestinationBinIsDynamic());
        values.put("ExtProcurementReplnmtStrgy", getExtProcurementReplnmtStrgy());
        values.put("StockTransferReplnmtStrategy", getStockTransferReplnmtStrategy());
        values.put("ReplnmtIsCtrldBySupplySource", getReplnmtIsCtrldBySupplySource());
        values.put("KanbanContainerPackggProduct", getKanbanContainerPackggProduct());
        values.put("SeparateGRIsNeededIfSetToFull", getSeparateGRIsNeededIfSetToFull());
        values.put("CostCenter", getCostCenter());
        values.put("SupplySourcePlant", getSupplySourcePlant());
        values.put("KanbanContainerStatusSequence", getKanbanContainerStatusSequence());
        values.put("KanbanCtnReplnmtTriggerLogic", getKanbanCtnReplnmtTriggerLogic());
        values.put("KnbnCtnReplnmtTrggrQtyInBsUnt", getKnbnCtnReplnmtTrggrQtyInBsUnt());
        values.put("KanbanContainerCalculationType", getKanbanContainerCalculationType());
        values.put("KanbanCtnCalcSafetyFactor", getKanbanCtnCalcSafetyFactor());
        values.put("KanbanCtnCalculationConstant", getKanbanCtnCalculationConstant());
        values.put("KanbanCtnRoundingQtyInBsUnt", getKanbanCtnRoundingQtyInBsUnt());
        values.put("FixedKanbanContainerQtyInBsUnt", getFixedKanbanContainerQtyInBsUnt());
        values.put("KanbanContainerCalcProfile", getKanbanContainerCalcProfile());
        values.put("ReplnmtLeadTimeInWorkdays", getReplnmtLeadTimeInWorkdays());
        values.put("ReplnmtLeadTimeInMinutes", getReplnmtLeadTimeInMinutes());
        values.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        values.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        values.put("SourceProductionSupplyArea", getSourceProductionSupplyArea());
        values.put("JITCallProfile", getJITCallProfile());
        values.put("PackingInstruction", getPackingInstruction());
        values.put("NumberOfLoadCarriers", getNumberOfLoadCarriers());
        values.put("BackflushReportingPoint", getBackflushReportingPoint());
        values.put("KanbanCtrlCycleLifeCycleStatus", getKanbanCtrlCycleLifeCycleStatus());
        values.put("CreationDate", getCreationDate());
        values.put("ReleaseDate", getReleaseDate());
        values.put("LockDate", getLockDate());
        values.put("PullIntervalInWorkdays", getPullIntervalInWorkdays());
        values.put("PullIntervalInMinutes", getPullIntervalInMinutes());
        values.put("KanbanCtnRefillTimeInDays", getKanbanCtnRefillTimeInDays());
        values.put("KanbanCtnRefillTmeInMinutes", getKanbanCtnRefillTmeInMinutes());
        values.put("KanbanCtnWaitTimeInDays", getKanbanCtnWaitTimeInDays());
        values.put("KanbanCtnWaitTimeInMinutes", getKanbanCtnWaitTimeInMinutes());
        values.put("KanbanCtnTransportTimeInDays", getKanbanCtnTransportTimeInDays());
        values.put("KanbanCtnTransportTmeInMinutes", getKanbanCtnTransportTmeInMinutes());
        values.put("KnbnCtnCalcRqmtBufferInPercent", getKnbnCtnCalcRqmtBufferInPercent());
        values.put("KnbnCtnCalcSupplySrceBufInPct", getKnbnCtnCalcSupplySrceBufInPct());
        values.put("NrOfKanbanCtnsFlaggedToUnlock", getNrOfKanbanCtnsFlaggedToUnlock());
        values.put("NrOfWaitingKnbnCtnsBfrReplnmt", getNrOfWaitingKnbnCtnsBfrReplnmt());
        values.put("KanbanCtrlCycReplnmtTriggerGrp", getKanbanCtrlCycReplnmtTriggerGrp());
        values.put("PlanningWorkCenter", getPlanningWorkCenter());
        values.put("ProductionOrdersAreCombined", getProductionOrdersAreCombined());
        values.put("DestinationStorageBin", getDestinationStorageBin());
        values.put("SourceStorageBin", getSourceStorageBin());
        values.put("WarehouseProcessType", getWarehouseProcessType());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("KanbanControlCycle") ) {
                final Object value = values.remove("KanbanControlCycle");
                if( (value == null) || (!value.equals(getKanbanControlCycle())) ) {
                    setKanbanControlCycle(((String) value));
                }
            }
            if( values.containsKey("KanbanControlCycleCategory") ) {
                final Object value = values.remove("KanbanControlCycleCategory");
                if( (value == null) || (!value.equals(getKanbanControlCycleCategory())) ) {
                    setKanbanControlCycleCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("SupplySourceResponsiblePerson") ) {
                final Object value = values.remove("SupplySourceResponsiblePerson");
                if( (value == null) || (!value.equals(getSupplySourceResponsiblePerson())) ) {
                    setSupplySourceResponsiblePerson(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("StoringPositionName") ) {
                final Object value = values.remove("StoringPositionName");
                if( (value == null) || (!value.equals(getStoringPositionName())) ) {
                    setStoringPositionName(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerDeliveryAddress") ) {
                final Object value = values.remove("KanbanContainerDeliveryAddress");
                if( (value == null) || (!value.equals(getKanbanContainerDeliveryAddress())) ) {
                    setKanbanContainerDeliveryAddress(((String) value));
                }
            }
            if( values.containsKey("ProductCostCollector") ) {
                final Object value = values.remove("ProductCostCollector");
                if( (value == null) || (!value.equals(getProductCostCollector())) ) {
                    setProductCostCollector(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchaseOutlineAgreement") ) {
                final Object value = values.remove("PurchaseOutlineAgreement");
                if( (value == null) || (!value.equals(getPurchaseOutlineAgreement())) ) {
                    setPurchaseOutlineAgreement(((String) value));
                }
            }
            if( values.containsKey("PurchaseOutlineAgreementItem") ) {
                final Object value = values.remove("PurchaseOutlineAgreementItem");
                if( (value == null) || (!value.equals(getPurchaseOutlineAgreementItem())) ) {
                    setPurchaseOutlineAgreementItem(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerQuantityInBsUnt") ) {
                final Object value = values.remove("KanbanContainerQuantityInBsUnt");
                if( (value == null) || (!value.equals(getKanbanContainerQuantityInBsUnt())) ) {
                    setKanbanContainerQuantityInBsUnt(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfKanbanContainers") ) {
                final Object value = values.remove("NumberOfKanbanContainers");
                if( (value == null) || (!value.equals(getNumberOfKanbanContainers())) ) {
                    setNumberOfKanbanContainers(((String) value));
                }
            }
            if( values.containsKey("MaxNrOfEmptyKanbanContainers") ) {
                final Object value = values.remove("MaxNrOfEmptyKanbanContainers");
                if( (value == null) || (!value.equals(getMaxNrOfEmptyKanbanContainers())) ) {
                    setMaxNrOfEmptyKanbanContainers(((String) value));
                }
            }
            if( values.containsKey("InHouseProductionReplnmtStrgy") ) {
                final Object value = values.remove("InHouseProductionReplnmtStrgy");
                if( (value == null) || (!value.equals(getInHouseProductionReplnmtStrgy())) ) {
                    setInHouseProductionReplnmtStrgy(((String) value));
                }
            }
            if( values.containsKey("MaterialStaging") ) {
                final Object value = values.remove("MaterialStaging");
                if( (value == null) || (!value.equals(getMaterialStaging())) ) {
                    setMaterialStaging(((String) value));
                }
            }
            if( values.containsKey("DestinationBinIsDynamic") ) {
                final Object value = values.remove("DestinationBinIsDynamic");
                if( (value == null) || (!value.equals(getDestinationBinIsDynamic())) ) {
                    setDestinationBinIsDynamic(((Boolean) value));
                }
            }
            if( values.containsKey("ExtProcurementReplnmtStrgy") ) {
                final Object value = values.remove("ExtProcurementReplnmtStrgy");
                if( (value == null) || (!value.equals(getExtProcurementReplnmtStrgy())) ) {
                    setExtProcurementReplnmtStrgy(((String) value));
                }
            }
            if( values.containsKey("StockTransferReplnmtStrategy") ) {
                final Object value = values.remove("StockTransferReplnmtStrategy");
                if( (value == null) || (!value.equals(getStockTransferReplnmtStrategy())) ) {
                    setStockTransferReplnmtStrategy(((String) value));
                }
            }
            if( values.containsKey("ReplnmtIsCtrldBySupplySource") ) {
                final Object value = values.remove("ReplnmtIsCtrldBySupplySource");
                if( (value == null) || (!value.equals(getReplnmtIsCtrldBySupplySource())) ) {
                    setReplnmtIsCtrldBySupplySource(((Boolean) value));
                }
            }
            if( values.containsKey("KanbanContainerPackggProduct") ) {
                final Object value = values.remove("KanbanContainerPackggProduct");
                if( (value == null) || (!value.equals(getKanbanContainerPackggProduct())) ) {
                    setKanbanContainerPackggProduct(((String) value));
                }
            }
            if( values.containsKey("SeparateGRIsNeededIfSetToFull") ) {
                final Object value = values.remove("SeparateGRIsNeededIfSetToFull");
                if( (value == null) || (!value.equals(getSeparateGRIsNeededIfSetToFull())) ) {
                    setSeparateGRIsNeededIfSetToFull(((Boolean) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("SupplySourcePlant") ) {
                final Object value = values.remove("SupplySourcePlant");
                if( (value == null) || (!value.equals(getSupplySourcePlant())) ) {
                    setSupplySourcePlant(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerStatusSequence") ) {
                final Object value = values.remove("KanbanContainerStatusSequence");
                if( (value == null) || (!value.equals(getKanbanContainerStatusSequence())) ) {
                    setKanbanContainerStatusSequence(((String) value));
                }
            }
            if( values.containsKey("KanbanCtnReplnmtTriggerLogic") ) {
                final Object value = values.remove("KanbanCtnReplnmtTriggerLogic");
                if( (value == null) || (!value.equals(getKanbanCtnReplnmtTriggerLogic())) ) {
                    setKanbanCtnReplnmtTriggerLogic(((String) value));
                }
            }
            if( values.containsKey("KnbnCtnReplnmtTrggrQtyInBsUnt") ) {
                final Object value = values.remove("KnbnCtnReplnmtTrggrQtyInBsUnt");
                if( (value == null) || (!value.equals(getKnbnCtnReplnmtTrggrQtyInBsUnt())) ) {
                    setKnbnCtnReplnmtTrggrQtyInBsUnt(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanContainerCalculationType") ) {
                final Object value = values.remove("KanbanContainerCalculationType");
                if( (value == null) || (!value.equals(getKanbanContainerCalculationType())) ) {
                    setKanbanContainerCalculationType(((String) value));
                }
            }
            if( values.containsKey("KanbanCtnCalcSafetyFactor") ) {
                final Object value = values.remove("KanbanCtnCalcSafetyFactor");
                if( (value == null) || (!value.equals(getKanbanCtnCalcSafetyFactor())) ) {
                    setKanbanCtnCalcSafetyFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnCalculationConstant") ) {
                final Object value = values.remove("KanbanCtnCalculationConstant");
                if( (value == null) || (!value.equals(getKanbanCtnCalculationConstant())) ) {
                    setKanbanCtnCalculationConstant(((Short) value));
                }
            }
            if( values.containsKey("KanbanCtnRoundingQtyInBsUnt") ) {
                final Object value = values.remove("KanbanCtnRoundingQtyInBsUnt");
                if( (value == null) || (!value.equals(getKanbanCtnRoundingQtyInBsUnt())) ) {
                    setKanbanCtnRoundingQtyInBsUnt(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedKanbanContainerQtyInBsUnt") ) {
                final Object value = values.remove("FixedKanbanContainerQtyInBsUnt");
                if( (value == null) || (!value.equals(getFixedKanbanContainerQtyInBsUnt())) ) {
                    setFixedKanbanContainerQtyInBsUnt(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanContainerCalcProfile") ) {
                final Object value = values.remove("KanbanContainerCalcProfile");
                if( (value == null) || (!value.equals(getKanbanContainerCalcProfile())) ) {
                    setKanbanContainerCalcProfile(((String) value));
                }
            }
            if( values.containsKey("ReplnmtLeadTimeInWorkdays") ) {
                final Object value = values.remove("ReplnmtLeadTimeInWorkdays");
                if( (value == null) || (!value.equals(getReplnmtLeadTimeInWorkdays())) ) {
                    setReplnmtLeadTimeInWorkdays(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReplnmtLeadTimeInMinutes") ) {
                final Object value = values.remove("ReplnmtLeadTimeInMinutes");
                if( (value == null) || (!value.equals(getReplnmtLeadTimeInMinutes())) ) {
                    setReplnmtLeadTimeInMinutes(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesSchedulingAgreement") ) {
                final Object value = values.remove("SalesSchedulingAgreement");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreement())) ) {
                    setSalesSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SalesSchedulingAgreementItem") ) {
                final Object value = values.remove("SalesSchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreementItem())) ) {
                    setSalesSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("SourceProductionSupplyArea") ) {
                final Object value = values.remove("SourceProductionSupplyArea");
                if( (value == null) || (!value.equals(getSourceProductionSupplyArea())) ) {
                    setSourceProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("JITCallProfile") ) {
                final Object value = values.remove("JITCallProfile");
                if( (value == null) || (!value.equals(getJITCallProfile())) ) {
                    setJITCallProfile(((String) value));
                }
            }
            if( values.containsKey("PackingInstruction") ) {
                final Object value = values.remove("PackingInstruction");
                if( (value == null) || (!value.equals(getPackingInstruction())) ) {
                    setPackingInstruction(((UUID) value));
                }
            }
            if( values.containsKey("NumberOfLoadCarriers") ) {
                final Object value = values.remove("NumberOfLoadCarriers");
                if( (value == null) || (!value.equals(getNumberOfLoadCarriers())) ) {
                    setNumberOfLoadCarriers(((String) value));
                }
            }
            if( values.containsKey("BackflushReportingPoint") ) {
                final Object value = values.remove("BackflushReportingPoint");
                if( (value == null) || (!value.equals(getBackflushReportingPoint())) ) {
                    setBackflushReportingPoint(((String) value));
                }
            }
            if( values.containsKey("KanbanCtrlCycleLifeCycleStatus") ) {
                final Object value = values.remove("KanbanCtrlCycleLifeCycleStatus");
                if( (value == null) || (!value.equals(getKanbanCtrlCycleLifeCycleStatus())) ) {
                    setKanbanCtrlCycleLifeCycleStatus(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ReleaseDate") ) {
                final Object value = values.remove("ReleaseDate");
                if( (value == null) || (!value.equals(getReleaseDate())) ) {
                    setReleaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LockDate") ) {
                final Object value = values.remove("LockDate");
                if( (value == null) || (!value.equals(getLockDate())) ) {
                    setLockDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PullIntervalInWorkdays") ) {
                final Object value = values.remove("PullIntervalInWorkdays");
                if( (value == null) || (!value.equals(getPullIntervalInWorkdays())) ) {
                    setPullIntervalInWorkdays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PullIntervalInMinutes") ) {
                final Object value = values.remove("PullIntervalInMinutes");
                if( (value == null) || (!value.equals(getPullIntervalInMinutes())) ) {
                    setPullIntervalInMinutes(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnRefillTimeInDays") ) {
                final Object value = values.remove("KanbanCtnRefillTimeInDays");
                if( (value == null) || (!value.equals(getKanbanCtnRefillTimeInDays())) ) {
                    setKanbanCtnRefillTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnRefillTmeInMinutes") ) {
                final Object value = values.remove("KanbanCtnRefillTmeInMinutes");
                if( (value == null) || (!value.equals(getKanbanCtnRefillTmeInMinutes())) ) {
                    setKanbanCtnRefillTmeInMinutes(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnWaitTimeInDays") ) {
                final Object value = values.remove("KanbanCtnWaitTimeInDays");
                if( (value == null) || (!value.equals(getKanbanCtnWaitTimeInDays())) ) {
                    setKanbanCtnWaitTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnWaitTimeInMinutes") ) {
                final Object value = values.remove("KanbanCtnWaitTimeInMinutes");
                if( (value == null) || (!value.equals(getKanbanCtnWaitTimeInMinutes())) ) {
                    setKanbanCtnWaitTimeInMinutes(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnTransportTimeInDays") ) {
                final Object value = values.remove("KanbanCtnTransportTimeInDays");
                if( (value == null) || (!value.equals(getKanbanCtnTransportTimeInDays())) ) {
                    setKanbanCtnTransportTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("KanbanCtnTransportTmeInMinutes") ) {
                final Object value = values.remove("KanbanCtnTransportTmeInMinutes");
                if( (value == null) || (!value.equals(getKanbanCtnTransportTmeInMinutes())) ) {
                    setKanbanCtnTransportTmeInMinutes(((BigDecimal) value));
                }
            }
            if( values.containsKey("KnbnCtnCalcRqmtBufferInPercent") ) {
                final Object value = values.remove("KnbnCtnCalcRqmtBufferInPercent");
                if( (value == null) || (!value.equals(getKnbnCtnCalcRqmtBufferInPercent())) ) {
                    setKnbnCtnCalcRqmtBufferInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("KnbnCtnCalcSupplySrceBufInPct") ) {
                final Object value = values.remove("KnbnCtnCalcSupplySrceBufInPct");
                if( (value == null) || (!value.equals(getKnbnCtnCalcSupplySrceBufInPct())) ) {
                    setKnbnCtnCalcSupplySrceBufInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("NrOfKanbanCtnsFlaggedToUnlock") ) {
                final Object value = values.remove("NrOfKanbanCtnsFlaggedToUnlock");
                if( (value == null) || (!value.equals(getNrOfKanbanCtnsFlaggedToUnlock())) ) {
                    setNrOfKanbanCtnsFlaggedToUnlock(((String) value));
                }
            }
            if( values.containsKey("NrOfWaitingKnbnCtnsBfrReplnmt") ) {
                final Object value = values.remove("NrOfWaitingKnbnCtnsBfrReplnmt");
                if( (value == null) || (!value.equals(getNrOfWaitingKnbnCtnsBfrReplnmt())) ) {
                    setNrOfWaitingKnbnCtnsBfrReplnmt(((String) value));
                }
            }
            if( values.containsKey("KanbanCtrlCycReplnmtTriggerGrp") ) {
                final Object value = values.remove("KanbanCtrlCycReplnmtTriggerGrp");
                if( (value == null) || (!value.equals(getKanbanCtrlCycReplnmtTriggerGrp())) ) {
                    setKanbanCtrlCycReplnmtTriggerGrp(((String) value));
                }
            }
            if( values.containsKey("PlanningWorkCenter") ) {
                final Object value = values.remove("PlanningWorkCenter");
                if( (value == null) || (!value.equals(getPlanningWorkCenter())) ) {
                    setPlanningWorkCenter(((String) value));
                }
            }
            if( values.containsKey("ProductionOrdersAreCombined") ) {
                final Object value = values.remove("ProductionOrdersAreCombined");
                if( (value == null) || (!value.equals(getProductionOrdersAreCombined())) ) {
                    setProductionOrdersAreCombined(((Boolean) value));
                }
            }
            if( values.containsKey("DestinationStorageBin") ) {
                final Object value = values.remove("DestinationStorageBin");
                if( (value == null) || (!value.equals(getDestinationStorageBin())) ) {
                    setDestinationStorageBin(((String) value));
                }
            }
            if( values.containsKey("SourceStorageBin") ) {
                final Object value = values.remove("SourceStorageBin");
                if( (value == null) || (!value.equals(getSourceStorageBin())) ) {
                    setSourceStorageBin(((String) value));
                }
            }
            if( values.containsKey("WarehouseProcessType") ) {
                final Object value = values.remove("WarehouseProcessType");
                if( (value == null) || (!value.equals(getWarehouseProcessType())) ) {
                    setWarehouseProcessType(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_KanbanContainer") ) {
                final Object value = (values).remove("to_KanbanContainer");
                if( value instanceof Iterable ) {
                    if( toKanbanContainer == null ) {
                        toKanbanContainer = Lists.newArrayList();
                    } else {
                        toKanbanContainer = Lists.newArrayList(toKanbanContainer);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        KanbanContainer entity;
                        if( toKanbanContainer.size() > i ) {
                            entity = toKanbanContainer.get(i);
                        } else {
                            entity = new KanbanContainer();
                            toKanbanContainer.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_KanbanContDeliveryAddr") ) {
                final Object value = (values).remove("to_KanbanContDeliveryAddr");
                if( value instanceof Map ) {
                    if( toKanbanContDeliveryAddr == null ) {
                        toKanbanContDeliveryAddr = new KanbanContainerDeliveryAddr();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toKanbanContDeliveryAddr.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> KanbanControlCycleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new KanbanControlCycleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> KanbanControlCycleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new KanbanControlCycleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toKanbanContainer != null ) {
            (values).put("to_KanbanContainer", toKanbanContainer);
        }
        if( toKanbanContDeliveryAddr != null ) {
            (values).put("to_KanbanContDeliveryAddr", toKanbanContDeliveryAddr);
        }
        return values;
    }

    /**
     * Fetches the <b>KanbanContainer</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_KanbanContainer</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>KanbanContainer</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<KanbanContainer> fetchKanbanContainer()
    {
        return fetchFieldAsList("to_KanbanContainer", KanbanContainer.class);
    }

    /**
     * Retrieval of associated <b>KanbanContainer</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_KanbanContainer</b>.
     * <p>
     * If the navigation property <b>to_KanbanContainer</b> of a queried <b>KanbanControlCycle</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanContainer</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<KanbanContainer> getKanbanContainerOrFetch()
    {
        if( toKanbanContainer == null ) {
            toKanbanContainer = fetchKanbanContainer();
        }
        return toKanbanContainer;
    }

    /**
     * Retrieval of associated <b>KanbanContainer</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_KanbanContainer</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanControlCycle</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanContainer</b> is already loaded, the result will
     *         contain the <b>KanbanContainer</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<KanbanContainer>> getKanbanContainerIfPresent()
    {
        return Option.of(toKanbanContainer);
    }

    /**
     * Overwrites the list of associated <b>KanbanContainer</b> entities for the loaded navigation property
     * <b>to_KanbanContainer</b>.
     * <p>
     * If the navigation property <b>to_KanbanContainer</b> of a queried <b>KanbanControlCycle</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>KanbanContainer</b> entities.
     */
    public void setKanbanContainer( @Nonnull final List<KanbanContainer> value )
    {
        if( toKanbanContainer == null ) {
            toKanbanContainer = Lists.newArrayList();
        }
        toKanbanContainer.clear();
        toKanbanContainer.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>KanbanContainer</b> entities. This corresponds to the OData navigation
     * property <b>to_KanbanContainer</b>.
     * <p>
     * If the navigation property <b>to_KanbanContainer</b> of a queried <b>KanbanControlCycle</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>KanbanContainer</b> entities.
     */
    public void addKanbanContainer( KanbanContainer... entity )
    {
        if( toKanbanContainer == null ) {
            toKanbanContainer = Lists.newArrayList();
        }
        toKanbanContainer.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>KanbanContainerDeliveryAddr</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_KanbanContDeliveryAddr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>KanbanContainerDeliveryAddr</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanContainerDeliveryAddr fetchKanbanContDeliveryAddr()
    {
        return fetchFieldAsSingle("to_KanbanContDeliveryAddr", KanbanContainerDeliveryAddr.class);
    }

    /**
     * Retrieval of associated <b>KanbanContainerDeliveryAddr</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_KanbanContDeliveryAddr</b>.
     * <p>
     * If the navigation property <b>to_KanbanContDeliveryAddr</b> of a queried <b>KanbanControlCycle</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanContainerDeliveryAddr</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanContainerDeliveryAddr getKanbanContDeliveryAddrOrFetch()
    {
        if( toKanbanContDeliveryAddr == null ) {
            toKanbanContDeliveryAddr = fetchKanbanContDeliveryAddr();
        }
        return toKanbanContDeliveryAddr;
    }

    /**
     * Retrieval of associated <b>KanbanContainerDeliveryAddr</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_KanbanContDeliveryAddr</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanControlCycle</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanContDeliveryAddr</b> is already loaded, the result
     *         will contain the <b>KanbanContainerDeliveryAddr</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<KanbanContainerDeliveryAddr> getKanbanContDeliveryAddrIfPresent()
    {
        return Option.of(toKanbanContDeliveryAddr);
    }

    /**
     * Overwrites the associated <b>KanbanContainerDeliveryAddr</b> entity for the loaded navigation property
     * <b>to_KanbanContDeliveryAddr</b>.
     *
     * @param value
     *            New <b>KanbanContainerDeliveryAddr</b> entity.
     */
    public void setKanbanContDeliveryAddr( final KanbanContainerDeliveryAddr value )
    {
        toKanbanContDeliveryAddr = value;
    }

    /**
     * Helper class to allow for fluent creation of KanbanControlCycle instances.
     *
     */
    public final static class KanbanControlCycleBuilder
    {

        private List<KanbanContainer> toKanbanContainer = Lists.newArrayList();
        private KanbanContainerDeliveryAddr toKanbanContDeliveryAddr;

        private KanbanControlCycle.KanbanControlCycleBuilder toKanbanContainer( final List<KanbanContainer> value )
        {
            toKanbanContainer.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_KanbanContainer</b> for <b>KanbanControlCycle</b> to multiple
         * <b>KanbanContainer</b>.
         *
         * @param value
         *            The KanbanContainers to build this KanbanControlCycle with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanControlCycle.KanbanControlCycleBuilder kanbanContainer( KanbanContainer... value )
        {
            return toKanbanContainer(Lists.newArrayList(value));
        }

        private KanbanControlCycle.KanbanControlCycleBuilder toKanbanContDeliveryAddr(
            final KanbanContainerDeliveryAddr value )
        {
            toKanbanContDeliveryAddr = value;
            return this;
        }

        /**
         * Navigation property <b>to_KanbanContDeliveryAddr</b> for <b>KanbanControlCycle</b> to single
         * <b>KanbanContainerDeliveryAddr</b>.
         *
         * @param value
         *            The KanbanContainerDeliveryAddr to build this KanbanControlCycle with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanControlCycle.KanbanControlCycleBuilder kanbanContDeliveryAddr(
            final KanbanContainerDeliveryAddr value )
        {
            return toKanbanContDeliveryAddr(value);
        }

    }

}
