/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanCtnDetailedQtyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable.KanbanCtnDetailedQtySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Kanban Container Detailed Quantities
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_KanbanCtnDetailedQtyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class KanbanCtnDetailedQty extends VdmEntity<KanbanCtnDetailedQty>
{

    /**
     * Selector for all available fields of KanbanCtnDetailedQty.
     *
     */
    public final static KanbanCtnDetailedQtySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @return Kanban Identification Number
     */
    @Key
    @SerializedName( "KanbanContainer" )
    @JsonProperty( "KanbanContainer" )
    @Nullable
    @ODataField( odataName = "KanbanContainer" )
    private String kanbanContainer;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainer</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<String> KANBAN_CONTAINER =
        new KanbanCtnDetailedQtyField<String>("KanbanContainer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @Key
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<String> BATCH = new KanbanCtnDetailedQtyField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<String> BASE_UNIT = new KanbanCtnDetailedQtyField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @return Actual Quantity
     */
    @SerializedName( "ActualQuantityInBaseUnit" )
    @JsonProperty( "ActualQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ActualQuantityInBaseUnit" )
    private BigDecimal actualQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<BigDecimal> ACTUAL_QUANTITY_IN_BASE_UNIT =
        new KanbanCtnDetailedQtyField<BigDecimal>("ActualQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<String> PLANT = new KanbanCtnDetailedQtyField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new KanbanCtnDetailedQtyField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @return Kanban Control Cycle
     */
    @SerializedName( "KanbanControlCycle" )
    @JsonProperty( "KanbanControlCycle" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycle" )
    private String kanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycle</b> field to query operations.
     *
     */
    public final static KanbanCtnDetailedQtyField<String> KANBAN_CONTROL_CYCLE =
        new KanbanCtnDetailedQtyField<String>("KanbanControlCycle");

    @Nonnull
    @Override
    public Class<KanbanCtnDetailedQty> getType()
    {
        return KanbanCtnDetailedQty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @param kanbanContainer
     *            Kanban Identification Number
     */
    public void setKanbanContainer( @Nullable final String kanbanContainer )
    {
        rememberChangedField("KanbanContainer", this.kanbanContainer);
        this.kanbanContainer = kanbanContainer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @param actualQuantityInBaseUnit
     *            Actual Quantity
     */
    public void setActualQuantityInBaseUnit( @Nullable final BigDecimal actualQuantityInBaseUnit )
    {
        rememberChangedField("ActualQuantityInBaseUnit", this.actualQuantityInBaseUnit);
        this.actualQuantityInBaseUnit = actualQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     */
    public void setKanbanControlCycle( @Nullable final String kanbanControlCycle )
    {
        rememberChangedField("KanbanControlCycle", this.kanbanControlCycle);
        this.kanbanControlCycle = kanbanControlCycle;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_KanbanCtnDetailedQty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("KanbanContainer", getKanbanContainer());
        result.put("Batch", getBatch());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("KanbanContainer", getKanbanContainer());
        values.put("Batch", getBatch());
        values.put("BaseUnit", getBaseUnit());
        values.put("ActualQuantityInBaseUnit", getActualQuantityInBaseUnit());
        values.put("Plant", getPlant());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("KanbanControlCycle", getKanbanControlCycle());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("KanbanContainer") ) {
                final Object value = values.remove("KanbanContainer");
                if( (value == null) || (!value.equals(getKanbanContainer())) ) {
                    setKanbanContainer(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ActualQuantityInBaseUnit") ) {
                final Object value = values.remove("ActualQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getActualQuantityInBaseUnit())) ) {
                    setActualQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("KanbanControlCycle") ) {
                final Object value = values.remove("KanbanControlCycle");
                if( (value == null) || (!value.equals(getKanbanControlCycle())) ) {
                    setKanbanControlCycle(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> KanbanCtnDetailedQtyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new KanbanCtnDetailedQtyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> KanbanCtnDetailedQtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new KanbanCtnDetailedQtyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH);
    }

}
