/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanDeliveryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanDeliveryOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable.KanbanDeliverySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Kanban Deliveries
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_KanbanDeliveryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class KanbanDelivery extends VdmEntity<KanbanDelivery>
{

    /**
     * Selector for all available fields of KanbanDelivery.
     *
     */
    public final static KanbanDeliverySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @return Kanban Identification Number
     */
    @Key
    @SerializedName( "KanbanContainer" )
    @JsonProperty( "KanbanContainer" )
    @Nullable
    @ODataField( odataName = "KanbanContainer" )
    private String kanbanContainer;
    /**
     * Use with available fluent helpers to apply the <b>KanbanContainer</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> KANBAN_CONTAINER =
        new KanbanDeliveryField<String>("KanbanContainer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> SOLD_TO_PARTY = new KanbanDeliveryField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReferenceNumber</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "CustomerReferenceNumber" )
    @JsonProperty( "CustomerReferenceNumber" )
    @Nullable
    @ODataField( odataName = "CustomerReferenceNumber" )
    private String customerReferenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReferenceNumber</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> CUSTOMER_REFERENCE_NUMBER =
        new KanbanDeliveryField<String>("CustomerReferenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> DELIVERY_DOCUMENT =
        new KanbanDeliveryField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @return Delivery Item
     */
    @SerializedName( "DeliveryDocumentItem" )
    @JsonProperty( "DeliveryDocumentItem" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItem" )
    private String deliveryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItem</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> DELIVERY_DOCUMENT_ITEM =
        new KanbanDeliveryField<String>("DeliveryDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> PLANT = new KanbanDeliveryField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new KanbanDeliveryField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @return Kanban Control Cycle
     */
    @SerializedName( "KanbanControlCycle" )
    @JsonProperty( "KanbanControlCycle" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycle" )
    private String kanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>KanbanControlCycle</b> field to query operations.
     *
     */
    public final static KanbanDeliveryField<String> KANBAN_CONTROL_CYCLE =
        new KanbanDeliveryField<String>("KanbanControlCycle");
    /**
     * Navigation property <b>to_KanbanContainer</b> for <b>KanbanDelivery</b> to single <b>KanbanContainer</b>.
     *
     */
    @SerializedName( "to_KanbanContainer" )
    @JsonProperty( "to_KanbanContainer" )
    @ODataField( odataName = "to_KanbanContainer" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private KanbanContainer toKanbanContainer;
    /**
     * Navigation property <b>to_KanbanControlCycle</b> for <b>KanbanDelivery</b> to single <b>KanbanControlCycle</b>.
     *
     */
    @SerializedName( "to_KanbanControlCycle" )
    @JsonProperty( "to_KanbanControlCycle" )
    @ODataField( odataName = "to_KanbanControlCycle" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private KanbanControlCycle toKanbanControlCycle;
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanContainer</b> navigation property to query operations.
     *
     */
    public final static KanbanDeliveryOneToOneLink<KanbanContainer> TO_KANBAN_CONTAINER =
        new KanbanDeliveryOneToOneLink<KanbanContainer>("to_KanbanContainer");
    /**
     * Use with available fluent helpers to apply the <b>to_KanbanControlCycle</b> navigation property to query
     * operations.
     *
     */
    public final static KanbanDeliveryOneToOneLink<KanbanControlCycle> TO_KANBAN_CONTROL_CYCLE =
        new KanbanDeliveryOneToOneLink<KanbanControlCycle>("to_KanbanControlCycle");

    @Nonnull
    @Override
    public Class<KanbanDelivery> getType()
    {
        return KanbanDelivery.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @param kanbanContainer
     *            Kanban Identification Number
     */
    public void setKanbanContainer( @Nullable final String kanbanContainer )
    {
        rememberChangedField("KanbanContainer", this.kanbanContainer);
        this.kanbanContainer = kanbanContainer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReferenceNumber</b>
     * </p>
     *
     * @param customerReferenceNumber
     *            Customer Reference
     */
    public void setCustomerReferenceNumber( @Nullable final String customerReferenceNumber )
    {
        rememberChangedField("CustomerReferenceNumber", this.customerReferenceNumber);
        this.customerReferenceNumber = customerReferenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *            Delivery Item
     */
    public void setDeliveryDocumentItem( @Nullable final String deliveryDocumentItem )
    {
        rememberChangedField("DeliveryDocumentItem", this.deliveryDocumentItem);
        this.deliveryDocumentItem = deliveryDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     */
    public void setKanbanControlCycle( @Nullable final String kanbanControlCycle )
    {
        rememberChangedField("KanbanControlCycle", this.kanbanControlCycle);
        this.kanbanControlCycle = kanbanControlCycle;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_KanbanDelivery";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("KanbanContainer", getKanbanContainer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("KanbanContainer", getKanbanContainer());
        values.put("SoldToParty", getSoldToParty());
        values.put("CustomerReferenceNumber", getCustomerReferenceNumber());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        values.put("Plant", getPlant());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("KanbanControlCycle", getKanbanControlCycle());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("KanbanContainer") ) {
                final Object value = values.remove("KanbanContainer");
                if( (value == null) || (!value.equals(getKanbanContainer())) ) {
                    setKanbanContainer(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("CustomerReferenceNumber") ) {
                final Object value = values.remove("CustomerReferenceNumber");
                if( (value == null) || (!value.equals(getCustomerReferenceNumber())) ) {
                    setCustomerReferenceNumber(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItem") ) {
                final Object value = values.remove("DeliveryDocumentItem");
                if( (value == null) || (!value.equals(getDeliveryDocumentItem())) ) {
                    setDeliveryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("KanbanControlCycle") ) {
                final Object value = values.remove("KanbanControlCycle");
                if( (value == null) || (!value.equals(getKanbanControlCycle())) ) {
                    setKanbanControlCycle(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_KanbanContainer") ) {
                final Object value = (values).remove("to_KanbanContainer");
                if( value instanceof Map ) {
                    if( toKanbanContainer == null ) {
                        toKanbanContainer = new KanbanContainer();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toKanbanContainer.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_KanbanControlCycle") ) {
                final Object value = (values).remove("to_KanbanControlCycle");
                if( value instanceof Map ) {
                    if( toKanbanControlCycle == null ) {
                        toKanbanControlCycle = new KanbanControlCycle();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toKanbanControlCycle.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> KanbanDeliveryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new KanbanDeliveryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> KanbanDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new KanbanDeliveryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toKanbanContainer != null ) {
            (values).put("to_KanbanContainer", toKanbanContainer);
        }
        if( toKanbanControlCycle != null ) {
            (values).put("to_KanbanControlCycle", toKanbanControlCycle);
        }
        return values;
    }

    /**
     * Fetches the <b>KanbanContainer</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_KanbanContainer</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>KanbanContainer</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanContainer fetchKanbanContainer()
    {
        return fetchFieldAsSingle("to_KanbanContainer", KanbanContainer.class);
    }

    /**
     * Retrieval of associated <b>KanbanContainer</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanContainer</b>.
     * <p>
     * If the navigation property <b>to_KanbanContainer</b> of a queried <b>KanbanDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanContainer</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanContainer getKanbanContainerOrFetch()
    {
        if( toKanbanContainer == null ) {
            toKanbanContainer = fetchKanbanContainer();
        }
        return toKanbanContainer;
    }

    /**
     * Retrieval of associated <b>KanbanContainer</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanContainer</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanDelivery</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanContainer</b> is already loaded, the result will
     *         contain the <b>KanbanContainer</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<KanbanContainer> getKanbanContainerIfPresent()
    {
        return Option.of(toKanbanContainer);
    }

    /**
     * Overwrites the associated <b>KanbanContainer</b> entity for the loaded navigation property
     * <b>to_KanbanContainer</b>.
     *
     * @param value
     *            New <b>KanbanContainer</b> entity.
     */
    public void setKanbanContainer( final KanbanContainer value )
    {
        toKanbanContainer = value;
    }

    /**
     * Fetches the <b>KanbanControlCycle</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_KanbanControlCycle</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>KanbanControlCycle</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanControlCycle fetchKanbanControlCycle()
    {
        return fetchFieldAsSingle("to_KanbanControlCycle", KanbanControlCycle.class);
    }

    /**
     * Retrieval of associated <b>KanbanControlCycle</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanControlCycle</b>.
     * <p>
     * If the navigation property <b>to_KanbanControlCycle</b> of a queried <b>KanbanDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>KanbanControlCycle</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public KanbanControlCycle getKanbanControlCycleOrFetch()
    {
        if( toKanbanControlCycle == null ) {
            toKanbanControlCycle = fetchKanbanControlCycle();
        }
        return toKanbanControlCycle;
    }

    /**
     * Retrieval of associated <b>KanbanControlCycle</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_KanbanControlCycle</b>.
     * <p>
     * If the navigation property for an entity <b>KanbanDelivery</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_KanbanControlCycle</b> is already loaded, the result
     *         will contain the <b>KanbanControlCycle</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<KanbanControlCycle> getKanbanControlCycleIfPresent()
    {
        return Option.of(toKanbanControlCycle);
    }

    /**
     * Overwrites the associated <b>KanbanControlCycle</b> entity for the loaded navigation property
     * <b>to_KanbanControlCycle</b>.
     *
     * @param value
     *            New <b>KanbanControlCycle</b> entity.
     */
    public void setKanbanControlCycle( final KanbanControlCycle value )
    {
        toKanbanControlCycle = value;
    }

    /**
     * Helper class to allow for fluent creation of KanbanDelivery instances.
     *
     */
    public final static class KanbanDeliveryBuilder
    {

        private KanbanContainer toKanbanContainer;
        private String kanbanContainer = null;
        private KanbanControlCycle toKanbanControlCycle;
        private String kanbanControlCycle = null;

        private KanbanDelivery.KanbanDeliveryBuilder toKanbanContainer( final KanbanContainer value )
        {
            toKanbanContainer = value;
            return this;
        }

        /**
         * Navigation property <b>to_KanbanContainer</b> for <b>KanbanDelivery</b> to single <b>KanbanContainer</b>.
         *
         * @param value
         *            The KanbanContainer to build this KanbanDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanDelivery.KanbanDeliveryBuilder kanbanContainer( final KanbanContainer value )
        {
            return toKanbanContainer(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>KanbanContainer</b>
         * </p>
         *
         * @param value
         *            The kanbanContainer to build this KanbanDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanDelivery.KanbanDeliveryBuilder kanbanContainer( final String value )
        {
            kanbanContainer = value;
            return this;
        }

        private KanbanDelivery.KanbanDeliveryBuilder toKanbanControlCycle( final KanbanControlCycle value )
        {
            toKanbanControlCycle = value;
            return this;
        }

        /**
         * Navigation property <b>to_KanbanControlCycle</b> for <b>KanbanDelivery</b> to single
         * <b>KanbanControlCycle</b>.
         *
         * @param value
         *            The KanbanControlCycle to build this KanbanDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanDelivery.KanbanDeliveryBuilder kanbanControlCycle( final KanbanControlCycle value )
        {
            return toKanbanControlCycle(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 7
         * <p>
         * Original property name from the Odata EDM: <b>KanbanControlCycle</b>
         * </p>
         *
         * @param value
         *            The kanbanControlCycle to build this KanbanDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public KanbanDelivery.KanbanDeliveryBuilder kanbanControlCycle( final String value )
        {
            kanbanControlCycle = value;
            return this;
        }

    }

}
