/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.math.BigDecimal;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>SetKanbanContainerStatus</b> OData function import.
 *
 */
public class SetKanbanContainerStatusFluentHelper
    extends
    SingleValuedFluentHelperFunction<SetKanbanContainerStatusFluentHelper, KanbanContainer, KanbanContainer>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>SetKanbanContainerStatus</b> OData function import with
     * the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param actualQuantityInUnitOfEntry
     *            Actual Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualQuantityInUnitOfEntry</b>
     *            </p>
     * @param deliveryNote
     *            Delivery note
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryNote</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param kanbanContainerStatus
     *            Kanban Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanContainerStatus</b>
     *            </p>
     * @param batch
     *            Batch
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Batch</b>
     *            </p>
     * @param kanbanCtnStatusChangeDateTime
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanCtnStatusChangeDateTime</b>
     *            </p>
     * @param kanbanContainer
     *            Kanban ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanContainer</b>
     *            </p>
     * @param unitOfEntry
     *            Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfEntry</b>
     *            </p>
     */
    public SetKanbanContainerStatusFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String kanbanContainer,
        @Nullable final String kanbanContainerStatus,
        @Nullable final BigDecimal actualQuantityInUnitOfEntry,
        @Nullable final String unitOfEntry,
        @Nullable final String batch,
        @Nullable final ZonedDateTime kanbanCtnStatusChangeDateTime,
        @Nullable final String deliveryNote )
    {
        super(servicePath);
        values.put("KanbanContainer", kanbanContainer);
        if( kanbanContainerStatus != null ) {
            values.put("KanbanContainerStatus", kanbanContainerStatus);
        }
        if( actualQuantityInUnitOfEntry != null ) {
            values.put("ActualQuantityInUnitOfEntry", actualQuantityInUnitOfEntry);
        }
        if( unitOfEntry != null ) {
            values.put("UnitOfEntry", unitOfEntry);
        }
        if( batch != null ) {
            values.put("Batch", batch);
        }
        if( kanbanCtnStatusChangeDateTime != null ) {
            values.put("KanbanCtnStatusChangeDateTime", kanbanCtnStatusChangeDateTime);
        }
        if( deliveryNote != null ) {
            values.put("DeliveryNote", deliveryNote);
        }
    }

    @Override
    @Nonnull
    protected Class<KanbanContainer> getEntityClass()
    {
        return KanbanContainer.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "SetKanbanContainerStatus";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public KanbanContainer executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
