/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>WithdrawQuantityFromControlCycle</b> OData function import.
 *
 */
public class WithdrawQuantityFromControlCycleFluentHelper
    extends
    CollectionValuedFluentHelperFunction<WithdrawQuantityFromControlCycleFluentHelper, WithdrawnKanbanContainer, List<WithdrawnKanbanContainer>>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>WithdrawQuantityFromControlCycle</b> OData function
     * import with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param kanbanCtrlCycWthdrwlQtyInBsUnt
     *            Withdrawal quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanCtrlCycWthdrwlQtyInBsUnt</b>
     *            </p>
     * @param kanbanControlCycle
     *            Control Cycle
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanControlCycle</b>
     *            </p>
     */
    public WithdrawQuantityFromControlCycleFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String kanbanControlCycle,
        @Nonnull final BigDecimal kanbanCtrlCycWthdrwlQtyInBsUnt )
    {
        super(servicePath);
        values.put("KanbanControlCycle", kanbanControlCycle);
        values.put("KanbanCtrlCycWthdrwlQtyInBsUnt", kanbanCtrlCycWthdrwlQtyInBsUnt);
    }

    @Override
    @Nonnull
    protected Class<WithdrawnKanbanContainer> getEntityClass()
    {
        return WithdrawnKanbanContainer.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "WithdrawQuantityFromControlCycle";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nonnull
    public List<WithdrawnKanbanContainer> executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeMultiple(destination);
    }

}
