/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>WithdrawnKanbanContainer</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WithdrawnKanbanContainer extends VdmComplex<WithdrawnKanbanContainer>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @param kanbanContainer
     *
     * @return Kanban Container
     */
    @SerializedName( "KanbanContainer" )
    @JsonProperty( "KanbanContainer" )
    @Nullable
    @ODataField( odataName = "KanbanContainer" )
    private String kanbanContainer;
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *
     * @return Kanban Control Cycle
     */
    @SerializedName( "KanbanControlCycle" )
    @JsonProperty( "KanbanControlCycle" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycle" )
    private String kanbanControlCycle;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>KanbanControlCycleItem</b>
     * </p>
     *
     * @param kanbanControlCycleItem
     *
     * @return Kanban Control Cycle Item
     */
    @SerializedName( "KanbanControlCycleItem" )
    @JsonProperty( "KanbanControlCycleItem" )
    @Nullable
    @ODataField( odataName = "KanbanControlCycleItem" )
    private String kanbanControlCycleItem;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *
     * @return Production Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>KanbanContainerStatus</b>
     * </p>
     *
     * @param kanbanContainerStatus
     *
     * @return Kanban Container Status
     */
    @SerializedName( "KanbanContainerStatus" )
    @JsonProperty( "KanbanContainerStatus" )
    @Nullable
    @ODataField( odataName = "KanbanContainerStatus" )
    private String kanbanContainerStatus;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsLocked</b>
     * </p>
     *
     * @param isLocked
     *
     * @return Lock Indicator
     */
    @SerializedName( "IsLocked" )
    @JsonProperty( "IsLocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLocked" )
    private Boolean isLocked;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *
     * @return Date of Last Change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *
     * @return Time of Last Change
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *
     * @return Planned Order
     */
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *
     * @return Order
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>RepetitiveMfgConfirmation</b>
     * </p>
     *
     * @param repetitiveMfgConfirmation
     *
     * @return Repetitive Manufacturing Confirmation
     */
    @SerializedName( "RepetitiveMfgConfirmation" )
    @JsonProperty( "RepetitiveMfgConfirmation" )
    @Nullable
    @ODataField( odataName = "RepetitiveMfgConfirmation" )
    private String repetitiveMfgConfirmation;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *
     * @return Reservation
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *
     * @return Reservation Item
     */
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *
     * @return Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *
     * @return Material Document Item
     */
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @param actualQuantityInBaseUnit
     *
     * @return Actual Quantity in Base Unit
     */
    @SerializedName( "ActualQuantityInBaseUnit" )
    @JsonProperty( "ActualQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ActualQuantityInBaseUnit" )
    private BigDecimal actualQuantityInBaseUnit;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>RequestedQuantityInBaseUnit</b>
     * </p>
     *
     * @param requestedQuantityInBaseUnit
     *
     * @return Requested Quantity in Base Unit
     */
    @SerializedName( "RequestedQuantityInBaseUnit" )
    @JsonProperty( "RequestedQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityInBaseUnit" )
    private BigDecimal requestedQuantityInBaseUnit;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PreviousLastChangeDate</b>
     * </p>
     *
     * @param previousLastChangeDate
     *
     * @return Date of Last Status Change to Full or Emtpy
     */
    @SerializedName( "PreviousLastChangeDate" )
    @JsonProperty( "PreviousLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PreviousLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime previousLastChangeDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PreviousLastChangeTime</b>
     * </p>
     *
     * @param previousLastChangeTime
     *
     * @return Time of Last Status Change to Full or Emtpy
     */
    @SerializedName( "PreviousLastChangeTime" )
    @JsonProperty( "PreviousLastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PreviousLastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime previousLastChangeTime;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>TransferRequirementNumber</b>
     * </p>
     *
     * @param transferRequirementNumber
     *
     * @return Transfer Requirement
     */
    @SerializedName( "TransferRequirementNumber" )
    @JsonProperty( "TransferRequirementNumber" )
    @Nullable
    @ODataField( odataName = "TransferRequirementNumber" )
    private String transferRequirementNumber;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TransferRequirementItem</b>
     * </p>
     *
     * @param transferRequirementItem
     *
     * @return Transfer Requirement Item
     */
    @SerializedName( "TransferRequirementItem" )
    @JsonProperty( "TransferRequirementItem" )
    @Nullable
    @ODataField( odataName = "TransferRequirementItem" )
    private String transferRequirementItem;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>PreviousKanbanContainerStatus</b>
     * </p>
     *
     * @param previousKanbanContainerStatus
     *
     * @return Previous Kanban Container Status
     */
    @SerializedName( "PreviousKanbanContainerStatus" )
    @JsonProperty( "PreviousKanbanContainerStatus" )
    @Nullable
    @ODataField( odataName = "PreviousKanbanContainerStatus" )
    private String previousKanbanContainerStatus;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @param internalJITCallNumber
     *
     * @return JIT Call
     */
    @SerializedName( "InternalJITCallNumber" )
    @JsonProperty( "InternalJITCallNumber" )
    @Nullable
    @ODataField( odataName = "InternalJITCallNumber" )
    private String internalJITCallNumber;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>JITCallItemNumber</b>
     * </p>
     *
     * @param jITCallItemNumber
     *
     * @return JIT Call Item
     */
    @SerializedName( "JITCallItemNumber" )
    @JsonProperty( "JITCallItemNumber" )
    @Nullable
    @ODataField( odataName = "JITCallItemNumber" )
    private String jITCallItemNumber;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PlannedReceiptDateTime</b>
     * </p>
     *
     * @param plannedReceiptDateTime
     *
     * @return Date and Time of Planned Receipt
     */
    @SerializedName( "PlannedReceiptDateTime" )
    @JsonProperty( "PlannedReceiptDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedReceiptDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedReceiptDateTime;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>ChangedPackgInstrnDataIsAvail</b>
     * </p>
     *
     * @param changedPackgInstrnDataIsAvail
     *
     * @return Indicator for Changed Packing Instruction Data
     */
    @SerializedName( "ChangedPackgInstrnDataIsAvail" )
    @JsonProperty( "ChangedPackgInstrnDataIsAvail" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChangedPackgInstrnDataIsAvail" )
    private Boolean changedPackgInstrnDataIsAvail;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>SequentialNmbrOfSuplrConf</b>
     * </p>
     *
     * @param sequentialNmbrOfSuplrConf
     *
     * @return Sequential Number of Supplier Confirmation
     */
    @SerializedName( "SequentialNmbrOfSuplrConf" )
    @JsonProperty( "SequentialNmbrOfSuplrConf" )
    @Nullable
    @ODataField( odataName = "SequentialNmbrOfSuplrConf" )
    private String sequentialNmbrOfSuplrConf;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>BackflushReportingPoint</b>
     * </p>
     *
     * @param backflushReportingPoint
     *
     * @return Reporting Point
     */
    @SerializedName( "BackflushReportingPoint" )
    @JsonProperty( "BackflushReportingPoint" )
    @Nullable
    @ODataField( odataName = "BackflushReportingPoint" )
    private String backflushReportingPoint;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *
     * @return Warehouse
     */
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @param warehouseTask
     *
     * @return Warehouse Task
     */
    @SerializedName( "WarehouseTask" )
    @JsonProperty( "WarehouseTask" )
    @Nullable
    @ODataField( odataName = "WarehouseTask" )
    private String warehouseTask;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>WhseGoodsMovementDocument</b>
     * </p>
     *
     * @param whseGoodsMovementDocument
     *
     * @return Warehouse Goods Movement Document
     */
    @SerializedName( "WhseGoodsMovementDocument" )
    @JsonProperty( "WhseGoodsMovementDocument" )
    @Nullable
    @ODataField( odataName = "WhseGoodsMovementDocument" )
    private String whseGoodsMovementDocument;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>WhseGoodsMovementDocumentItem</b>
     * </p>
     *
     * @param whseGoodsMovementDocumentItem
     *
     * @return Warehouse Goods Movement Document Item
     */
    @SerializedName( "WhseGoodsMovementDocumentItem" )
    @JsonProperty( "WhseGoodsMovementDocumentItem" )
    @Nullable
    @ODataField( odataName = "WhseGoodsMovementDocumentItem" )
    private String whseGoodsMovementDocumentItem;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PlantTimeZone</b>
     * </p>
     *
     * @param plantTimeZone
     *
     * @return Time Zone
     */
    @SerializedName( "PlantTimeZone" )
    @JsonProperty( "PlantTimeZone" )
    @Nullable
    @ODataField( odataName = "PlantTimeZone" )
    private String plantTimeZone;
    /**
     * Constraints: Not nullable, Maximum length: 65
     * <p>
     * Original property from the Odata EDM: <b>KanbanContainerETag</b>
     * </p>
     *
     * @param kanbanContainerETag
     *
     */
    @SerializedName( "KanbanContainerETag" )
    @JsonProperty( "KanbanContainerETag" )
    @Nullable
    @ODataField( odataName = "KanbanContainerETag" )
    private String kanbanContainerETag;

    @Nonnull
    @Override
    public Class<WithdrawnKanbanContainer> getType()
    {
        return WithdrawnKanbanContainer.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("KanbanContainer", getKanbanContainer());
        values.put("KanbanControlCycle", getKanbanControlCycle());
        values.put("KanbanControlCycleItem", getKanbanControlCycleItem());
        values.put("Plant", getPlant());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("KanbanContainerStatus", getKanbanContainerStatus());
        values.put("IsLocked", getIsLocked());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("PlannedOrder", getPlannedOrder());
        values.put("OrderID", getOrderID());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("RepetitiveMfgConfirmation", getRepetitiveMfgConfirmation());
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("BaseUnit", getBaseUnit());
        values.put("ActualQuantityInBaseUnit", getActualQuantityInBaseUnit());
        values.put("RequestedQuantityInBaseUnit", getRequestedQuantityInBaseUnit());
        values.put("PreviousLastChangeDate", getPreviousLastChangeDate());
        values.put("PreviousLastChangeTime", getPreviousLastChangeTime());
        values.put("TransferRequirementNumber", getTransferRequirementNumber());
        values.put("TransferRequirementItem", getTransferRequirementItem());
        values.put("IsDeleted", getIsDeleted());
        values.put("PreviousKanbanContainerStatus", getPreviousKanbanContainerStatus());
        values.put("InternalJITCallNumber", getInternalJITCallNumber());
        values.put("JITCallItemNumber", getJITCallItemNumber());
        values.put("PlannedReceiptDateTime", getPlannedReceiptDateTime());
        values.put("ChangedPackgInstrnDataIsAvail", getChangedPackgInstrnDataIsAvail());
        values.put("SequentialNmbrOfSuplrConf", getSequentialNmbrOfSuplrConf());
        values.put("BackflushReportingPoint", getBackflushReportingPoint());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseTask", getWarehouseTask());
        values.put("WhseGoodsMovementDocument", getWhseGoodsMovementDocument());
        values.put("WhseGoodsMovementDocumentItem", getWhseGoodsMovementDocumentItem());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("PlantTimeZone", getPlantTimeZone());
        values.put("KanbanContainerETag", getKanbanContainerETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("KanbanContainer") ) {
                final Object value = values.remove("KanbanContainer");
                if( (value == null) || (!value.equals(getKanbanContainer())) ) {
                    setKanbanContainer(((String) value));
                }
            }
            if( values.containsKey("KanbanControlCycle") ) {
                final Object value = values.remove("KanbanControlCycle");
                if( (value == null) || (!value.equals(getKanbanControlCycle())) ) {
                    setKanbanControlCycle(((String) value));
                }
            }
            if( values.containsKey("KanbanControlCycleItem") ) {
                final Object value = values.remove("KanbanControlCycleItem");
                if( (value == null) || (!value.equals(getKanbanControlCycleItem())) ) {
                    setKanbanControlCycleItem(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerStatus") ) {
                final Object value = values.remove("KanbanContainerStatus");
                if( (value == null) || (!value.equals(getKanbanContainerStatus())) ) {
                    setKanbanContainerStatus(((String) value));
                }
            }
            if( values.containsKey("IsLocked") ) {
                final Object value = values.remove("IsLocked");
                if( (value == null) || (!value.equals(getIsLocked())) ) {
                    setIsLocked(((Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("RepetitiveMfgConfirmation") ) {
                final Object value = values.remove("RepetitiveMfgConfirmation");
                if( (value == null) || (!value.equals(getRepetitiveMfgConfirmation())) ) {
                    setRepetitiveMfgConfirmation(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ActualQuantityInBaseUnit") ) {
                final Object value = values.remove("ActualQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getActualQuantityInBaseUnit())) ) {
                    setActualQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityInBaseUnit") ) {
                final Object value = values.remove("RequestedQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityInBaseUnit())) ) {
                    setRequestedQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("PreviousLastChangeDate") ) {
                final Object value = values.remove("PreviousLastChangeDate");
                if( (value == null) || (!value.equals(getPreviousLastChangeDate())) ) {
                    setPreviousLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PreviousLastChangeTime") ) {
                final Object value = values.remove("PreviousLastChangeTime");
                if( (value == null) || (!value.equals(getPreviousLastChangeTime())) ) {
                    setPreviousLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TransferRequirementNumber") ) {
                final Object value = values.remove("TransferRequirementNumber");
                if( (value == null) || (!value.equals(getTransferRequirementNumber())) ) {
                    setTransferRequirementNumber(((String) value));
                }
            }
            if( values.containsKey("TransferRequirementItem") ) {
                final Object value = values.remove("TransferRequirementItem");
                if( (value == null) || (!value.equals(getTransferRequirementItem())) ) {
                    setTransferRequirementItem(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("PreviousKanbanContainerStatus") ) {
                final Object value = values.remove("PreviousKanbanContainerStatus");
                if( (value == null) || (!value.equals(getPreviousKanbanContainerStatus())) ) {
                    setPreviousKanbanContainerStatus(((String) value));
                }
            }
            if( values.containsKey("InternalJITCallNumber") ) {
                final Object value = values.remove("InternalJITCallNumber");
                if( (value == null) || (!value.equals(getInternalJITCallNumber())) ) {
                    setInternalJITCallNumber(((String) value));
                }
            }
            if( values.containsKey("JITCallItemNumber") ) {
                final Object value = values.remove("JITCallItemNumber");
                if( (value == null) || (!value.equals(getJITCallItemNumber())) ) {
                    setJITCallItemNumber(((String) value));
                }
            }
            if( values.containsKey("PlannedReceiptDateTime") ) {
                final Object value = values.remove("PlannedReceiptDateTime");
                if( (value == null) || (!value.equals(getPlannedReceiptDateTime())) ) {
                    setPlannedReceiptDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ChangedPackgInstrnDataIsAvail") ) {
                final Object value = values.remove("ChangedPackgInstrnDataIsAvail");
                if( (value == null) || (!value.equals(getChangedPackgInstrnDataIsAvail())) ) {
                    setChangedPackgInstrnDataIsAvail(((Boolean) value));
                }
            }
            if( values.containsKey("SequentialNmbrOfSuplrConf") ) {
                final Object value = values.remove("SequentialNmbrOfSuplrConf");
                if( (value == null) || (!value.equals(getSequentialNmbrOfSuplrConf())) ) {
                    setSequentialNmbrOfSuplrConf(((String) value));
                }
            }
            if( values.containsKey("BackflushReportingPoint") ) {
                final Object value = values.remove("BackflushReportingPoint");
                if( (value == null) || (!value.equals(getBackflushReportingPoint())) ) {
                    setBackflushReportingPoint(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseTask") ) {
                final Object value = values.remove("WarehouseTask");
                if( (value == null) || (!value.equals(getWarehouseTask())) ) {
                    setWarehouseTask(((String) value));
                }
            }
            if( values.containsKey("WhseGoodsMovementDocument") ) {
                final Object value = values.remove("WhseGoodsMovementDocument");
                if( (value == null) || (!value.equals(getWhseGoodsMovementDocument())) ) {
                    setWhseGoodsMovementDocument(((String) value));
                }
            }
            if( values.containsKey("WhseGoodsMovementDocumentItem") ) {
                final Object value = values.remove("WhseGoodsMovementDocumentItem");
                if( (value == null) || (!value.equals(getWhseGoodsMovementDocumentItem())) ) {
                    setWhseGoodsMovementDocumentItem(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlantTimeZone") ) {
                final Object value = values.remove("PlantTimeZone");
                if( (value == null) || (!value.equals(getPlantTimeZone())) ) {
                    setPlantTimeZone(((String) value));
                }
            }
            if( values.containsKey("KanbanContainerETag") ) {
                final Object value = values.remove("KanbanContainerETag");
                if( (value == null) || (!value.equals(getKanbanContainerETag())) ) {
                    setKanbanContainerETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>KanbanContainer</b>
     * </p>
     *
     * @param kanbanContainer
     *            Kanban Container
     */
    public void setKanbanContainer( @Nullable final String kanbanContainer )
    {
        rememberChangedField("KanbanContainer", this.kanbanContainer);
        this.kanbanContainer = kanbanContainer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property from the Odata EDM: <b>KanbanControlCycle</b>
     * </p>
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     */
    public void setKanbanControlCycle( @Nullable final String kanbanControlCycle )
    {
        rememberChangedField("KanbanControlCycle", this.kanbanControlCycle);
        this.kanbanControlCycle = kanbanControlCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>KanbanControlCycleItem</b>
     * </p>
     *
     * @param kanbanControlCycleItem
     *            Kanban Control Cycle Item
     */
    public void setKanbanControlCycleItem( @Nullable final String kanbanControlCycleItem )
    {
        rememberChangedField("KanbanControlCycleItem", this.kanbanControlCycleItem);
        this.kanbanControlCycleItem = kanbanControlCycleItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>KanbanContainerStatus</b>
     * </p>
     *
     * @param kanbanContainerStatus
     *            Kanban Container Status
     */
    public void setKanbanContainerStatus( @Nullable final String kanbanContainerStatus )
    {
        rememberChangedField("KanbanContainerStatus", this.kanbanContainerStatus);
        this.kanbanContainerStatus = kanbanContainerStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsLocked</b>
     * </p>
     *
     * @param isLocked
     *            Lock Indicator
     */
    public void setIsLocked( @Nullable final Boolean isLocked )
    {
        rememberChangedField("IsLocked", this.isLocked);
        this.isLocked = isLocked;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date of Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time of Last Change
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>RepetitiveMfgConfirmation</b>
     * </p>
     *
     * @param repetitiveMfgConfirmation
     *            Repetitive Manufacturing Confirmation
     */
    public void setRepetitiveMfgConfirmation( @Nullable final String repetitiveMfgConfirmation )
    {
        rememberChangedField("RepetitiveMfgConfirmation", this.repetitiveMfgConfirmation);
        this.repetitiveMfgConfirmation = repetitiveMfgConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Reservation
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @param actualQuantityInBaseUnit
     *            Actual Quantity in Base Unit
     */
    public void setActualQuantityInBaseUnit( @Nullable final BigDecimal actualQuantityInBaseUnit )
    {
        rememberChangedField("ActualQuantityInBaseUnit", this.actualQuantityInBaseUnit);
        this.actualQuantityInBaseUnit = actualQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>RequestedQuantityInBaseUnit</b>
     * </p>
     *
     * @param requestedQuantityInBaseUnit
     *            Requested Quantity in Base Unit
     */
    public void setRequestedQuantityInBaseUnit( @Nullable final BigDecimal requestedQuantityInBaseUnit )
    {
        rememberChangedField("RequestedQuantityInBaseUnit", this.requestedQuantityInBaseUnit);
        this.requestedQuantityInBaseUnit = requestedQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PreviousLastChangeDate</b>
     * </p>
     *
     * @param previousLastChangeDate
     *            Date of Last Status Change to Full or Emtpy
     */
    public void setPreviousLastChangeDate( @Nullable final LocalDateTime previousLastChangeDate )
    {
        rememberChangedField("PreviousLastChangeDate", this.previousLastChangeDate);
        this.previousLastChangeDate = previousLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PreviousLastChangeTime</b>
     * </p>
     *
     * @param previousLastChangeTime
     *            Time of Last Status Change to Full or Emtpy
     */
    public void setPreviousLastChangeTime( @Nullable final LocalTime previousLastChangeTime )
    {
        rememberChangedField("PreviousLastChangeTime", this.previousLastChangeTime);
        this.previousLastChangeTime = previousLastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>TransferRequirementNumber</b>
     * </p>
     *
     * @param transferRequirementNumber
     *            Transfer Requirement
     */
    public void setTransferRequirementNumber( @Nullable final String transferRequirementNumber )
    {
        rememberChangedField("TransferRequirementNumber", this.transferRequirementNumber);
        this.transferRequirementNumber = transferRequirementNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>TransferRequirementItem</b>
     * </p>
     *
     * @param transferRequirementItem
     *            Transfer Requirement Item
     */
    public void setTransferRequirementItem( @Nullable final String transferRequirementItem )
    {
        rememberChangedField("TransferRequirementItem", this.transferRequirementItem);
        this.transferRequirementItem = transferRequirementItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>PreviousKanbanContainerStatus</b>
     * </p>
     *
     * @param previousKanbanContainerStatus
     *            Previous Kanban Container Status
     */
    public void setPreviousKanbanContainerStatus( @Nullable final String previousKanbanContainerStatus )
    {
        rememberChangedField("PreviousKanbanContainerStatus", this.previousKanbanContainerStatus);
        this.previousKanbanContainerStatus = previousKanbanContainerStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>InternalJITCallNumber</b>
     * </p>
     *
     * @param internalJITCallNumber
     *            JIT Call
     */
    public void setInternalJITCallNumber( @Nullable final String internalJITCallNumber )
    {
        rememberChangedField("InternalJITCallNumber", this.internalJITCallNumber);
        this.internalJITCallNumber = internalJITCallNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>JITCallItemNumber</b>
     * </p>
     *
     * @param jITCallItemNumber
     *            JIT Call Item
     */
    public void setJITCallItemNumber( @Nullable final String jITCallItemNumber )
    {
        rememberChangedField("JITCallItemNumber", this.jITCallItemNumber);
        this.jITCallItemNumber = jITCallItemNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PlannedReceiptDateTime</b>
     * </p>
     *
     * @param plannedReceiptDateTime
     *            Date and Time of Planned Receipt
     */
    public void setPlannedReceiptDateTime( @Nullable final ZonedDateTime plannedReceiptDateTime )
    {
        rememberChangedField("PlannedReceiptDateTime", this.plannedReceiptDateTime);
        this.plannedReceiptDateTime = plannedReceiptDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>ChangedPackgInstrnDataIsAvail</b>
     * </p>
     *
     * @param changedPackgInstrnDataIsAvail
     *            Indicator for Changed Packing Instruction Data
     */
    public void setChangedPackgInstrnDataIsAvail( @Nullable final Boolean changedPackgInstrnDataIsAvail )
    {
        rememberChangedField("ChangedPackgInstrnDataIsAvail", this.changedPackgInstrnDataIsAvail);
        this.changedPackgInstrnDataIsAvail = changedPackgInstrnDataIsAvail;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>SequentialNmbrOfSuplrConf</b>
     * </p>
     *
     * @param sequentialNmbrOfSuplrConf
     *            Sequential Number of Supplier Confirmation
     */
    public void setSequentialNmbrOfSuplrConf( @Nullable final String sequentialNmbrOfSuplrConf )
    {
        rememberChangedField("SequentialNmbrOfSuplrConf", this.sequentialNmbrOfSuplrConf);
        this.sequentialNmbrOfSuplrConf = sequentialNmbrOfSuplrConf;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>BackflushReportingPoint</b>
     * </p>
     *
     * @param backflushReportingPoint
     *            Reporting Point
     */
    public void setBackflushReportingPoint( @Nullable final String backflushReportingPoint )
    {
        rememberChangedField("BackflushReportingPoint", this.backflushReportingPoint);
        this.backflushReportingPoint = backflushReportingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @param warehouseTask
     *            Warehouse Task
     */
    public void setWarehouseTask( @Nullable final String warehouseTask )
    {
        rememberChangedField("WarehouseTask", this.warehouseTask);
        this.warehouseTask = warehouseTask;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>WhseGoodsMovementDocument</b>
     * </p>
     *
     * @param whseGoodsMovementDocument
     *            Warehouse Goods Movement Document
     */
    public void setWhseGoodsMovementDocument( @Nullable final String whseGoodsMovementDocument )
    {
        rememberChangedField("WhseGoodsMovementDocument", this.whseGoodsMovementDocument);
        this.whseGoodsMovementDocument = whseGoodsMovementDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>WhseGoodsMovementDocumentItem</b>
     * </p>
     *
     * @param whseGoodsMovementDocumentItem
     *            Warehouse Goods Movement Document Item
     */
    public void setWhseGoodsMovementDocumentItem( @Nullable final String whseGoodsMovementDocumentItem )
    {
        rememberChangedField("WhseGoodsMovementDocumentItem", this.whseGoodsMovementDocumentItem);
        this.whseGoodsMovementDocumentItem = whseGoodsMovementDocumentItem;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PlantTimeZone</b>
     * </p>
     *
     * @param plantTimeZone
     *            Time Zone
     */
    public void setPlantTimeZone( @Nullable final String plantTimeZone )
    {
        rememberChangedField("PlantTimeZone", this.plantTimeZone);
        this.plantTimeZone = plantTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 65
     * <p>
     * Original property from the Odata EDM: <b>KanbanContainerETag</b>
     * </p>
     *
     * @param kanbanContainerETag
     *            The kanbanContainerETag to set.
     */
    public void setKanbanContainerETag( @Nullable final String kanbanContainerETag )
    {
        rememberChangedField("KanbanContainerETag", this.kanbanContainerETag);
        this.kanbanContainerETag = kanbanContainerETag;
    }

}
